/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class LatencyDistribution {
    public static final int BUCKET_COUNT = 31;
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final String[] LATENCY_KEYS = new String[31];
    private static final AtomicLongFieldUpdater<LatencyDistribution> COUNT;
    private static final AtomicLongFieldUpdater<LatencyDistribution> TOTAL_MICROS;
    private static final VarHandle MAX_MICROS;
    private final AtomicLongArray buckets = new AtomicLongArray(31);
    private volatile long count;
    private volatile long maxMicros;
    private volatile long totalMicros;

    public int bucketCount() {
        return 31;
    }

    public long bucket(int bucket) {
        return this.buckets.get(bucket);
    }

    static int bucketMaxUs(int bucket) {
        return LatencyDistribution.bucketMinUs(bucket + 1) - 1;
    }

    static int bucketMinUs(int bucket) {
        return bucket == 0 ? 0 : 1 << bucket;
    }

    public long count() {
        return this.count;
    }

    public long maxMicros() {
        return this.maxMicros;
    }

    public long totalMicros() {
        return this.totalMicros;
    }

    public long avgMicros() {
        return this.count == 0L ? 0L : this.totalMicros / this.count;
    }

    public void done(long startNanos) {
        this.recordNanos(System.nanoTime() - startNanos);
    }

    public void recordNanos(long durationNanos) {
        long d;
        if (durationNanos < 0L) {
            durationNanos = 0L;
        }
        int durationMicros = (d = TimeUnit.NANOSECONDS.toMicros(durationNanos)) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)d;
        COUNT.incrementAndGet(this);
        TOTAL_MICROS.addAndGet(this, durationMicros);
        ConcurrencyUtil.setMax(this, MAX_MICROS, durationMicros);
        try {
            this.buckets.incrementAndGet(LatencyDistribution.usToBucketIndex(durationMicros));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("duration nanos:" + durationNanos, e);
        }
    }

    static int usToBucketIndex(int us) {
        return Math.max(0, 31 - Integer.numberOfLeadingZeros(us));
    }

    static {
        for (int k = 0; k < 31; ++k) {
            LatencyDistribution.LATENCY_KEYS[k] = LatencyDistribution.bucketMinUs(k) + ".." + LatencyDistribution.bucketMaxUs(k) + "us";
        }
        COUNT = AtomicLongFieldUpdater.newUpdater(LatencyDistribution.class, "count");
        TOTAL_MICROS = AtomicLongFieldUpdater.newUpdater(LatencyDistribution.class, "totalMicros");
        MAX_MICROS = ReflectionUtil.findVarHandle("maxMicros", Long.TYPE);
    }
}

