/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class InvokeAndReduceOnMembers<T, R> {
    private static final int TRY_COUNT = 10;
    private static final int TRY_PAUSE_MILLIS = 300;
    private final Collection<Member> members;
    private final OperationService operationService;
    private final Supplier<Operation> operationSupplier;
    private final Function<Map<Member, T>, R> reduceFunction;
    private final BiFunction<T, Throwable, T> mapFunction;

    public InvokeAndReduceOnMembers(Collection<Member> members, Supplier<Operation> operationSupplier, OperationService operationService, BiFunction<T, Throwable, T> mapFunction, Function<Map<Member, T>, R> reduceFunction) {
        this.members = members;
        this.operationService = operationService;
        this.operationSupplier = operationSupplier;
        this.reduceFunction = reduceFunction;
        this.mapFunction = mapFunction;
    }

    CompletableFuture<R> invokeAsync() {
        if (this.members.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ResultCollector collector = new ResultCollector(this.members, this.reduceFunction, this.mapFunction);
        for (Member target : this.members) {
            Address address = target.getAddress();
            Operation operation = this.operationSupplier.get();
            this.operationService.createInvocationBuilder(operation.getServiceName(), operation, address).setTryCount(10).setTryPauseMillis(300L).setResultDeserialized(false).invoke().whenCompleteAsync((r, t) -> collector.accept(target, (Object)r, (Throwable)t), ConcurrencyUtil.CALLER_RUNS);
        }
        return collector.future;
    }

    private static class ResultCollector<T, R> {
        private final CompletableFuture<R> future = new CompletableFuture();
        private final AtomicInteger pendingResponses = new AtomicInteger();
        private final Map<Member, T> results;
        private final Function<Map<Member, T>, R> reduce;
        private final BiFunction<T, Throwable, T> map;

        private ResultCollector(Collection<Member> targets, Function<Map<Member, T>, R> reduce, BiFunction<T, Throwable, T> map) {
            this.pendingResponses.set(targets.size());
            this.results = Collections.synchronizedMap(new HashMap(targets.size()));
            this.reduce = reduce;
            this.map = map;
        }

        public void accept(Member target, T result, Throwable throwable) {
            T mappedResult;
            try {
                mappedResult = this.map.apply(result, throwable);
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
                return;
            }
            if (this.results.putIfAbsent(target, mappedResult) != null) {
                this.future.completeExceptionally(new IllegalArgumentException("Duplicate response from -> " + String.valueOf(target)));
                return;
            }
            if (this.pendingResponses.decrementAndGet() > 0) {
                return;
            }
            try {
                this.future.complete(this.reduce.apply(this.results));
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }
}

