/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.time.Instant;
import java.util.Map;

public class FrequentLogSuppressor {
    private final Map<String, LoggedException> errors;
    private final int logPeriod;
    private final int threshold;
    private final ILogger logger;

    public FrequentLogSuppressor(int logPeriod, int threshold, ILogger logger) {
        this.logPeriod = logPeriod;
        this.threshold = threshold;
        this.logger = logger;
        this.errors = new ConcurrentReferenceHashMap<String, LoggedException>();
    }

    FrequentLogSuppressor(int frequentLogPeriod, int threshold, ILogger logger, Map<String, LoggedException> errors) {
        this.logPeriod = frequentLogPeriod;
        this.threshold = threshold;
        this.logger = logger;
        this.errors = errors;
    }

    public void runSuppressed(Throwable e, Runnable logAction) {
        this.errors.compute(ExceptionUtil.toString(e), (key, record) -> {
            if (record == null) {
                logAction.run();
                return new LoggedException();
            }
            record.inc();
            if (record.total < this.threshold) {
                record.resetLastLog();
                logAction.run();
            } else if (record.total == this.threshold) {
                this.logger.warning("Frequent log operation detected, future occurrences will be suppressed and only logged every " + this.logPeriod + " seconds");
                record.resetLastLog();
                logAction.run();
            } else if (record.lastLogTime.plusSeconds(this.logPeriod).isBefore(Instant.now())) {
                this.logger.warning("The following suppressed log had " + record.sinceLastLog + " occurrences since last log, " + record.total + " in total");
                logAction.run();
                record.resetLastLog();
            }
            return record;
        });
    }

    private static class LoggedException {
        int total = 1;
        int sinceLastLog = 0;
        Instant lastLogTime = Instant.now();

        LoggedException() {
        }

        void inc() {
            ++this.total;
            ++this.sinceLastLog;
        }

        public void resetLastLog() {
            this.lastLogTime = Instant.now();
            this.sinceLastLog = 0;
        }
    }
}

