/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.internal.tpcengine.nio.NioHandler;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.nio.NioReactorBuilder;
import com.hazelcast.internal.tpcengine.nio.SelectorOptimizer;
import com.hazelcast.internal.tpcengine.util.CloseUtil;
import com.hazelcast.internal.tpcengine.util.NanoClock;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class NioEventloop
extends Eventloop {
    final Selector selector = SelectorOptimizer.newSelector();

    NioEventloop(NioReactor reactor, NioReactorBuilder builder) {
        super(reactor, builder);
    }

    @Override
    protected void run() throws Exception {
        NanoClock nanoClock0 = this.nanoClock;
        boolean spin0 = this.spin;
        Selector selector0 = this.selector;
        AtomicBoolean wakeupNeeded0 = this.wakeupNeeded;
        MpmcArrayQueue externalTaskQueue0 = this.externalTaskQueue;
        Scheduler scheduler0 = this.scheduler;
        boolean moreWork = false;
        do {
            int keyCount;
            if (spin0 || moreWork) {
                keyCount = selector0.selectNow();
            } else {
                wakeupNeeded0.set(true);
                if (externalTaskQueue0.isEmpty()) {
                    long timeoutMillis;
                    keyCount = this.earliestDeadlineNanos == -1L ? selector0.select() : ((timeoutMillis = TimeUnit.NANOSECONDS.toMillis(this.earliestDeadlineNanos - nanoClock0.nanoTime())) <= 0L ? selector0.selectNow() : selector0.select(timeoutMillis));
                    nanoClock0.update();
                } else {
                    keyCount = selector0.selectNow();
                }
                wakeupNeeded0.set(false);
            }
            if (keyCount > 0) {
                Iterator<SelectionKey> it = selector0.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    NioHandler handler = (NioHandler)key.attachment();
                    try {
                        handler.handle();
                    }
                    catch (Exception e) {
                        handler.close(null, e);
                    }
                }
            }
            moreWork = this.runExternalTasks();
            moreWork |= scheduler0.tick();
            moreWork |= this.runScheduledTasks();
            moreWork |= this.runLocalTasks();
        } while (!this.stop);
    }

    @Override
    protected void destroy() {
        for (SelectionKey key : this.selector.keys()) {
            NioHandler handler = (NioHandler)key.attachment();
            if (handler == null) {
                key.cancel();
                continue;
            }
            try {
                handler.close(String.valueOf(this.reactor) + " is terminating.", null);
            }
            catch (Exception e) {
                this.logger.fine(e);
            }
        }
        CloseUtil.closeQuietly(this.selector);
    }
}

