/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.ReactorBuilder;
import com.hazelcast.internal.tpcengine.ReactorType;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.internal.tpcengine.TpcEngine;
import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerLocator;
import com.hazelcast.internal.tpcengine.net.AcceptRequest;
import com.hazelcast.internal.tpcengine.net.AsyncServerSocketBuilder;
import com.hazelcast.internal.tpcengine.net.AsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.util.CircularQueue;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.ThreadAffinity;
import com.hazelcast.internal.util.ThreadAffinityHelper;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.VarHandle;
import java.util.BitSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Reactor
implements Executor {
    private static final VarHandle STATE = ReflectionUtil.findVarHandle("state", State.class);
    protected final ConcurrentMap<?, ?> context = new ConcurrentHashMap();
    protected final TpcLogger logger = TpcLoggerLocator.getLogger(this.getClass());
    protected final MpmcArrayQueue externalTaskQueue;
    protected final Eventloop eventloop;
    protected final CircularQueue localTaskQueue;
    protected final boolean spin;
    protected final Thread eventloopThread;
    protected final String name;
    protected final AtomicBoolean wakeupNeeded;
    private final TpcEngine engine;
    private final ReactorType type;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final Scheduler scheduler;
    protected volatile State state = State.NEW;

    protected Reactor(ReactorBuilder builder) {
        this.type = builder.type;
        this.spin = builder.spin;
        this.engine = builder.engine;
        CompletableFuture<Eventloop> eventloopFuture = new CompletableFuture<Eventloop>();
        this.eventloopThread = builder.threadFactory.newThread(new StartEventloopTask(eventloopFuture, builder));
        if (builder.threadNameSupplier != null) {
            this.eventloopThread.setName(builder.threadNameSupplier.get());
        }
        this.name = builder.reactorNameSupplier.get();
        this.eventloopThread.start();
        this.eventloop = eventloopFuture.join();
        this.externalTaskQueue = this.eventloop.externalTaskQueue;
        this.localTaskQueue = this.eventloop.localTaskQueue;
        this.wakeupNeeded = this.eventloop.wakeupNeeded;
        this.scheduler = this.eventloop.scheduler;
    }

    public final ConcurrentMap<?, ?> context() {
        return this.context;
    }

    public final String name() {
        return this.name;
    }

    public final ReactorType type() {
        return this.type;
    }

    public final Scheduler scheduler() {
        return this.scheduler;
    }

    public final Eventloop eventloop() {
        return this.eventloop;
    }

    public final Thread eventloopThread() {
        return this.eventloopThread;
    }

    public final State state() {
        return this.state;
    }

    protected abstract Eventloop newEventloop(ReactorBuilder var1);

    public abstract AsyncSocketBuilder newAsyncSocketBuilder();

    public abstract AsyncSocketBuilder newAsyncSocketBuilder(AcceptRequest var1);

    public abstract AsyncServerSocketBuilder newAsyncServerSocketBuilder();

    protected void verifyRunning() {
        State state0 = this.state;
        if (State.RUNNING != state0) {
            throw new IllegalStateException("Reactor not in RUNNING state, but " + String.valueOf((Object)state0));
        }
    }

    public Reactor start() {
        if (!STATE.compareAndSet(this, State.NEW, State.RUNNING)) {
            throw new IllegalStateException("Can't start reactor, invalid state:" + String.valueOf((Object)this.state));
        }
        this.startLatch.countDown();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public final void shutdown() {
        block4: while (true) {
            oldState = this.state;
            switch (1.$SwitchMap$com$hazelcast$internal$tpcengine$Reactor$State[oldState.ordinal()]) {
                case 1: {
                    if (!Reactor.STATE.compareAndSet(this, oldState, State.TERMINATED)) continue block4;
                    this.startLatch.countDown();
                    return;
                }
                case 2: {
                    if (Reactor.STATE.compareAndSet(this, oldState, State.SHUTDOWN)) ** break;
                    continue block4;
                    this.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$shutdown$0(), ()V)((Reactor)this));
                    return;
                }
            }
            break;
        }
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.terminationLatch.await(timeout, unit)) {
            this.logger.warning("Termination latch timed out.");
        }
        return this.state == State.TERMINATED;
    }

    public abstract void wakeup();

    public final <E> CompletableFuture<E> submit(Callable<E> callable) {
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> {
            try {
                future.complete(callable.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        if (!this.offer(task)) {
            future.completeExceptionally(new RejectedExecutionException("Task " + callable.toString() + " rejected from " + String.valueOf(this)));
        }
        return future;
    }

    public final CompletableFuture<Void> submit(Runnable cmd) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable task = () -> {
            try {
                cmd.run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        if (!this.offer(task)) {
            future.completeExceptionally(new RejectedExecutionException("Task " + cmd.toString() + " rejected from " + String.valueOf(this)));
        }
        return future;
    }

    @Override
    public void execute(Runnable command) {
        if (!this.offer(command)) {
            throw new RejectedExecutionException("Task " + command.toString() + " rejected from " + String.valueOf(this));
        }
    }

    public final boolean offer(Runnable task) {
        return this.offer((Object)task);
    }

    public final boolean offer(Object task) {
        if (Thread.currentThread() == this.eventloopThread) {
            return this.localTaskQueue.offer(task);
        }
        if (this.externalTaskQueue.offer(task)) {
            this.wakeup();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    private /* synthetic */ void lambda$shutdown$0() {
        this.eventloop.stop = true;
    }

    public static enum State {
        NEW,
        RUNNING,
        SHUTDOWN,
        TERMINATED;

    }

    private final class StartEventloopTask
    implements Runnable {
        private final CompletableFuture<Eventloop> future;
        private final ReactorBuilder builder;

        private StartEventloopTask(CompletableFuture<Eventloop> future, ReactorBuilder builder) {
            this.future = future;
            this.builder = builder;
        }

        @Override
        public void run() {
            try {
                try {
                    this.configureThreadAffinity();
                    Eventloop eventloop0 = Reactor.this.newEventloop(this.builder);
                    this.future.complete(eventloop0);
                    Reactor.this.startLatch.await();
                    try {
                        if (Reactor.this.state == State.RUNNING) {
                            eventloop0.run();
                        }
                    }
                    finally {
                        eventloop0.destroy();
                    }
                }
                catch (Throwable e) {
                    this.future.completeExceptionally(e);
                    Reactor.this.logger.severe(e);
                }
                finally {
                    Reactor.this.state = State.TERMINATED;
                    Reactor.this.terminationLatch.countDown();
                    if (Reactor.this.engine != null) {
                        Reactor.this.engine.notifyReactorTerminated();
                    }
                    if (Reactor.this.logger.isInfoEnabled()) {
                        Reactor.this.logger.info(Thread.currentThread().getName() + " terminated");
                    }
                }
            }
            catch (Throwable e) {
                Reactor.this.logger.severe(e);
            }
        }

        private void configureThreadAffinity() {
            BitSet allowedCpus;
            ThreadAffinity threadAffinity = this.builder.threadAffinity;
            BitSet bitSet = allowedCpus = threadAffinity == null ? null : threadAffinity.nextAllowedCpus();
            if (allowedCpus != null) {
                ThreadAffinityHelper.setAffinity(allowedCpus);
                BitSet actualCpus = ThreadAffinityHelper.getAffinity();
                if (!actualCpus.equals(allowedCpus)) {
                    Reactor.this.logger.warning(Thread.currentThread().getName() + " affinity was not applied successfully. Expected CPUs:" + String.valueOf(allowedCpus) + ". Actual CPUs:" + String.valueOf(actualCpus));
                } else if (Reactor.this.logger.isFineEnabled()) {
                    Reactor.this.logger.fine(Thread.currentThread().getName() + " has affinity for CPUs:" + String.valueOf(allowedCpus));
                }
            }
        }
    }
}

