/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.FieldType;
import javax.annotation.Nonnull;

public final class FieldTypeToFieldKind {
    private FieldTypeToFieldKind() {
    }

    @Nonnull
    public static FieldKind toFieldKind(@Nonnull FieldType fieldType) {
        switch (fieldType) {
            case PORTABLE: {
                return FieldKind.PORTABLE;
            }
            case BYTE: {
                return FieldKind.INT8;
            }
            case BOOLEAN: {
                return FieldKind.BOOLEAN;
            }
            case CHAR: {
                return FieldKind.CHAR;
            }
            case SHORT: {
                return FieldKind.INT16;
            }
            case INT: {
                return FieldKind.INT32;
            }
            case LONG: {
                return FieldKind.INT64;
            }
            case FLOAT: {
                return FieldKind.FLOAT32;
            }
            case DOUBLE: {
                return FieldKind.FLOAT64;
            }
            case UTF: {
                return FieldKind.STRING;
            }
            case PORTABLE_ARRAY: {
                return FieldKind.ARRAY_OF_PORTABLE;
            }
            case BYTE_ARRAY: {
                return FieldKind.ARRAY_OF_INT8;
            }
            case BOOLEAN_ARRAY: {
                return FieldKind.ARRAY_OF_BOOLEAN;
            }
            case CHAR_ARRAY: {
                return FieldKind.ARRAY_OF_CHAR;
            }
            case SHORT_ARRAY: {
                return FieldKind.ARRAY_OF_INT16;
            }
            case INT_ARRAY: {
                return FieldKind.ARRAY_OF_INT32;
            }
            case LONG_ARRAY: {
                return FieldKind.ARRAY_OF_INT64;
            }
            case FLOAT_ARRAY: {
                return FieldKind.ARRAY_OF_FLOAT32;
            }
            case DOUBLE_ARRAY: {
                return FieldKind.ARRAY_OF_FLOAT64;
            }
            case UTF_ARRAY: {
                return FieldKind.ARRAY_OF_STRING;
            }
            case DECIMAL: {
                return FieldKind.DECIMAL;
            }
            case DECIMAL_ARRAY: {
                return FieldKind.ARRAY_OF_DECIMAL;
            }
            case TIME: {
                return FieldKind.TIME;
            }
            case TIME_ARRAY: {
                return FieldKind.ARRAY_OF_TIME;
            }
            case DATE: {
                return FieldKind.DATE;
            }
            case DATE_ARRAY: {
                return FieldKind.ARRAY_OF_DATE;
            }
            case TIMESTAMP: {
                return FieldKind.TIMESTAMP;
            }
            case TIMESTAMP_ARRAY: {
                return FieldKind.ARRAY_OF_TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return FieldKind.TIMESTAMP_WITH_TIMEZONE;
            }
            case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                return FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE;
            }
        }
        throw new IllegalStateException("There is no corresponding field kind for given field type : " + String.valueOf((Object)fieldType));
    }
}

