/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.serialization.impl.portable.FieldDefinitionImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.PortableId;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class ClassDefinitionImpl
implements ClassDefinition,
DataSerializable {
    private PortableId portableId;
    private Map<String, FieldDefinition> fieldDefinitionsMap;

    private ClassDefinitionImpl() {
    }

    public ClassDefinitionImpl(PortableId portableId) {
        this.portableId = portableId;
        this.fieldDefinitionsMap = new LinkedHashMap<String, FieldDefinition>();
    }

    public void addFieldDef(FieldDefinitionImpl fd) {
        this.fieldDefinitionsMap.put(fd.getName(), fd);
    }

    @Override
    public FieldDefinition getField(String name) {
        return this.fieldDefinitionsMap.get(name);
    }

    @Override
    public FieldDefinition getField(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldDefinitionsMap.size()) {
            throw new IndexOutOfBoundsException("Index: " + fieldIndex + ", Size: " + this.fieldDefinitionsMap.size());
        }
        for (FieldDefinition fieldDefinition : this.fieldDefinitionsMap.values()) {
            if (fieldIndex != fieldDefinition.getIndex()) continue;
            return fieldDefinition;
        }
        throw new IndexOutOfBoundsException("Index: " + fieldIndex + ", Size: " + this.fieldDefinitionsMap.size());
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fieldDefinitionsMap.containsKey(fieldName);
    }

    @Override
    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fieldDefinitionsMap.keySet());
    }

    @Override
    public FieldType getFieldType(String fieldName) {
        FieldDefinition fd = this.getField(fieldName);
        if (fd != null) {
            return fd.getType();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldName);
    }

    @Override
    public int getFieldClassId(String fieldName) {
        FieldDefinition fd = this.getField(fieldName);
        if (fd != null) {
            return fd.getClassId();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fieldDefinitionsMap.size();
    }

    @Override
    public final int getFactoryId() {
        return this.portableId.getFactoryId();
    }

    @Override
    public final int getClassId() {
        return this.portableId.getClassId();
    }

    @Override
    public final int getVersion() {
        return this.portableId.getVersion();
    }

    @Override
    public PortableId getPortableId() {
        return this.portableId;
    }

    void setVersionIfNotSet(int version) {
        this.portableId.setVersionIfNotSet(version);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.portableId.writeData(out);
        out.writeObject(this.fieldDefinitionsMap);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.portableId = new PortableId();
        this.portableId.readData(in);
        this.fieldDefinitionsMap = (Map)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDefinitionImpl that = (ClassDefinitionImpl)o;
        return this.portableId.equals(that.portableId) && this.fieldDefinitionsMap.equals(that.fieldDefinitionsMap);
    }

    public int hashCode() {
        return this.portableId.hashCode();
    }

    public String toString() {
        return "ClassDefinition{factoryId=" + this.portableId.getFactoryId() + ", classId=" + this.portableId.getClassId() + ", version=" + this.portableId.getVersion() + ", fieldDefinitions=" + String.valueOf(this.fieldDefinitionsMap.values()) + "}";
    }
}

