/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.defaultserializers;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.ClassNameFilter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.StreamSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class JavaDefaultSerializers {
    private JavaDefaultSerializers() {
    }

    private static final class ExtendedGZipOutputStream
    extends GZIPOutputStream {
        private ExtendedGZipOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        private void closeDeflater() {
            this.def.end();
        }
    }

    private static final class ExtendedGZipInputStream
    extends GZIPInputStream {
        private static final int GZIP_TRAILER_SIZE = 8;

        private ExtendedGZipInputStream(InputStream in) throws IOException {
            super(in);
            assert (in instanceof BufferObjectDataInput) : "Unexpected input: " + String.valueOf(in);
        }

        private void pushBackUnconsumedBytes() {
            int remaining = this.inf.getRemaining();
            BufferObjectDataInput bufferedInput = (BufferObjectDataInput)((Object)this.in);
            int position = bufferedInput.position();
            int rewindBack = Math.max(0, remaining - 8);
            int newPosition = position - rewindBack;
            bufferedInput.position(newPosition);
        }

        private void closeInflater() {
            this.inf.end();
        }
    }

    public static final class ByteBufferSerializer
    implements ByteArraySerializer<ByteBuffer> {
        @Override
        public int getTypeId() {
            return -102;
        }

        @Override
        public byte[] write(ByteBuffer buffer) throws IOException {
            if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.limit() == buffer.capacity()) {
                return buffer.array();
            }
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }

        @Override
        public ByteBuffer read(byte[] buffer) throws IOException {
            return ByteBuffer.wrap(buffer);
        }
    }

    public static final class HazelcastJsonValueSerializer
    implements StreamSerializer<HazelcastJsonValue> {
        @Override
        public int getTypeId() {
            return -130;
        }

        @Override
        public void write(ObjectDataOutput out, HazelcastJsonValue object) throws IOException {
            out.writeString(object.toString());
        }

        @Override
        public HazelcastJsonValue read(ObjectDataInput in) throws IOException {
            return new HazelcastJsonValue(in.readString());
        }
    }

    public static final class EnumSerializer
    implements StreamSerializer<Enum> {
        @Override
        public int getTypeId() {
            return -25;
        }

        @Override
        public void write(ObjectDataOutput out, Enum obj) throws IOException {
            String name = obj.getDeclaringClass().getName();
            out.writeString(name);
            out.writeString(obj.name());
        }

        @Override
        public Enum read(ObjectDataInput in) throws IOException {
            Class clazz;
            String clazzName = in.readString();
            try {
                clazz = ClassLoaderUtil.loadClass(in.getClassLoader(), clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException("Failed to deserialize enum: " + clazzName, e);
            }
            String name = in.readString();
            return Enum.valueOf(clazz, name);
        }
    }

    public static final class OptionalSerializer
    implements StreamSerializer<Optional> {
        @Override
        public int getTypeId() {
            return -50;
        }

        @Override
        public Optional read(ObjectDataInput in) throws IOException {
            boolean present = in.readBoolean();
            if (present) {
                return Optional.of(in.readObject());
            }
            return Optional.empty();
        }

        @Override
        public void write(ObjectDataOutput out, Optional obj) throws IOException {
            if (obj.isPresent()) {
                out.writeBoolean(true);
                out.writeObject(obj.get());
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static final class ClassSerializer
    implements StreamSerializer<Class> {
        private final boolean isCompatibility;

        public ClassSerializer(boolean isCompatibility) {
            this.isCompatibility = isCompatibility;
        }

        @Override
        public int getTypeId() {
            return this.isCompatibility ? -21 : -24;
        }

        @Override
        public Class read(ObjectDataInput in) throws IOException {
            try {
                return ClassLoaderUtil.loadClass(in.getClassLoader(), in.readString());
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException(e);
            }
        }

        @Override
        public void write(ObjectDataOutput out, Class obj) throws IOException {
            out.writeString(obj.getName());
        }
    }

    public static final class OffsetDateTimeSerializer
    implements StreamSerializer<OffsetDateTime> {
        @Override
        public int getTypeId() {
            return -54;
        }

        @Override
        public OffsetDateTime read(ObjectDataInput in) throws IOException {
            return IOUtil.readOffsetDateTime(in);
        }

        @Override
        public void write(ObjectDataOutput out, OffsetDateTime value) throws IOException {
            IOUtil.writeOffsetDateTime(out, value);
        }
    }

    public static final class LocalDateTimeSerializer
    implements StreamSerializer<LocalDateTime> {
        @Override
        public int getTypeId() {
            return -53;
        }

        @Override
        public LocalDateTime read(ObjectDataInput in) throws IOException {
            return IOUtil.readLocalDateTime(in);
        }

        @Override
        public void write(ObjectDataOutput out, LocalDateTime value) throws IOException {
            IOUtil.writeLocalDateTime(out, value);
        }
    }

    public static final class LocalTimeSerializer
    implements StreamSerializer<LocalTime> {
        @Override
        public int getTypeId() {
            return -52;
        }

        @Override
        public LocalTime read(ObjectDataInput in) throws IOException {
            return IOUtil.readLocalTime(in);
        }

        @Override
        public void write(ObjectDataOutput out, LocalTime value) throws IOException {
            IOUtil.writeLocalTime(out, value);
        }
    }

    public static final class LocalDateSerializer
    implements StreamSerializer<LocalDate> {
        @Override
        public int getTypeId() {
            return -51;
        }

        @Override
        public LocalDate read(ObjectDataInput in) throws IOException {
            return IOUtil.readLocalDate(in);
        }

        @Override
        public void write(ObjectDataOutput out, LocalDate value) throws IOException {
            IOUtil.writeLocalDate(out, value);
        }
    }

    public static final class DateSerializer
    implements StreamSerializer<Date> {
        private final boolean isCompatibility;

        public DateSerializer(boolean isCompatibility) {
            this.isCompatibility = isCompatibility;
        }

        @Override
        public int getTypeId() {
            return this.isCompatibility ? -22 : -25;
        }

        @Override
        public Date read(ObjectDataInput in) throws IOException {
            return new Date(in.readLong());
        }

        @Override
        public void write(ObjectDataOutput out, Date obj) throws IOException {
            out.writeLong(obj.getTime());
        }
    }

    public static final class BigDecimalSerializer
    implements StreamSerializer<BigDecimal> {
        final BigIntegerSerializer bigIntegerSerializer;
        final boolean isCompatibility;

        public BigDecimalSerializer(boolean isCompatibility) {
            this.bigIntegerSerializer = new BigIntegerSerializer(isCompatibility);
            this.isCompatibility = isCompatibility;
        }

        @Override
        public int getTypeId() {
            return this.isCompatibility ? -24 : -27;
        }

        @Override
        public BigDecimal read(ObjectDataInput in) throws IOException {
            return IOUtil.readBigDecimal(in);
        }

        @Override
        public void write(ObjectDataOutput out, BigDecimal value) throws IOException {
            IOUtil.writeBigDecimal(out, value);
        }
    }

    public static final class BigIntegerSerializer
    implements StreamSerializer<BigInteger> {
        private final boolean isCompatibility;

        public BigIntegerSerializer(boolean isCompatibility) {
            this.isCompatibility = isCompatibility;
        }

        @Override
        public int getTypeId() {
            return this.isCompatibility ? -23 : -26;
        }

        @Override
        public BigInteger read(ObjectDataInput in) throws IOException {
            return IOUtil.readBigInteger(in);
        }

        @Override
        public void write(ObjectDataOutput out, BigInteger value) throws IOException {
            IOUtil.writeBigInteger(out, value);
        }
    }

    public static final class ExternalizableSerializer
    implements StreamSerializer<Externalizable> {
        private final boolean gzipEnabled;
        private final ClassNameFilter classFilter;

        public ExternalizableSerializer(boolean gzipEnabled, ClassNameFilter classFilter) {
            this.gzipEnabled = gzipEnabled;
            this.classFilter = classFilter;
        }

        @Override
        public int getTypeId() {
            return -101;
        }

        @Override
        public Externalizable read(ObjectDataInput in) throws IOException {
            String className = in.readString();
            try {
                if (this.gzipEnabled) {
                    return this.readGzipped((InputStream)((Object)in), className, in.getClassLoader());
                }
                return this.read((InputStream)((Object)in), className, in.getClassLoader());
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Problem while reading Externalizable class: " + className + ", exception: " + String.valueOf(e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Externalizable readGzipped(InputStream in, String className, ClassLoader classLoader) throws Exception {
            ExtendedGZipInputStream gzip = new ExtendedGZipInputStream(in);
            try {
                Externalizable external = this.read(gzip, className, classLoader);
                gzip.pushBackUnconsumedBytes();
                Externalizable externalizable = external;
                return externalizable;
            }
            finally {
                gzip.closeInflater();
            }
        }

        private Externalizable read(InputStream in, String className, ClassLoader classLoader) throws Exception {
            if (this.classFilter != null) {
                this.classFilter.filter(className);
            }
            Externalizable ds = (Externalizable)ClassLoaderUtil.newInstance(classLoader, className);
            ObjectInputStream objectInputStream = IOUtil.newObjectInputStream(classLoader, this.classFilter, in);
            ds.readExternal(objectInputStream);
            return ds;
        }

        @Override
        public void write(ObjectDataOutput out, Externalizable obj) throws IOException {
            out.writeString(obj.getClass().getName());
            if (this.gzipEnabled) {
                this.writeGzipped((OutputStream)((Object)out), obj);
            } else {
                this.write((OutputStream)((Object)out), obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeGzipped(OutputStream out, Externalizable obj) throws IOException {
            ExtendedGZipOutputStream gzip = new ExtendedGZipOutputStream(out);
            try {
                this.write(gzip, obj);
                gzip.finish();
            }
            finally {
                gzip.closeDeflater();
            }
        }

        private void write(OutputStream outputStream, Externalizable obj) throws IOException {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            obj.writeExternal(objectOutputStream);
            objectOutputStream.flush();
        }
    }

    public static final class JavaSerializer
    implements StreamSerializer<Object> {
        private final boolean shared;
        private final boolean gzipEnabled;
        private final ClassNameFilter classFilter;

        public JavaSerializer(boolean shared, boolean gzipEnabled, ClassNameFilter classFilter) {
            this.shared = shared;
            this.gzipEnabled = gzipEnabled;
            this.classFilter = classFilter;
        }

        @Override
        public int getTypeId() {
            return -100;
        }

        @Override
        public Object read(ObjectDataInput in) throws IOException {
            if (this.gzipEnabled) {
                return this.readGzipped((InputStream)((Object)in), in.getClassLoader());
            }
            return this.read((InputStream)((Object)in), in.getClassLoader());
        }

        private Object read(InputStream in, ClassLoader classLoader) throws IOException {
            try {
                ObjectInputStream objectInputStream = IOUtil.newObjectInputStream(classLoader, this.classFilter, in);
                if (this.shared) {
                    return objectInputStream.readObject();
                }
                return objectInputStream.readUnshared();
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readGzipped(InputStream in, ClassLoader classLoader) throws IOException {
            ExtendedGZipInputStream gzip = new ExtendedGZipInputStream(in);
            try {
                Object obj = this.read(gzip, classLoader);
                gzip.pushBackUnconsumedBytes();
                Object object = obj;
                return object;
            }
            finally {
                gzip.closeInflater();
            }
        }

        @Override
        @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
        public void write(ObjectDataOutput out, Object obj) throws IOException {
            if (this.gzipEnabled) {
                this.writeGzipped((OutputStream)((Object)out), obj);
            } else {
                this.write((OutputStream)((Object)out), obj);
            }
        }

        private void write(OutputStream out, Object obj) throws IOException {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
            if (this.shared) {
                objectOutputStream.writeObject(obj);
            } else {
                objectOutputStream.writeUnshared(obj);
            }
            objectOutputStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeGzipped(OutputStream out, Object obj) throws IOException {
            ExtendedGZipOutputStream gzip = new ExtendedGZipOutputStream(out);
            try {
                this.write(gzip, obj);
                gzip.finish();
            }
            finally {
                gzip.closeDeflater();
            }
        }
    }
}

