/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplication;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;

public class SendSchemaReplicationsOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private Collection<SchemaReplication> replications;

    public SendSchemaReplicationsOperation() {
    }

    public SendSchemaReplicationsOperation(Collection<SchemaReplication> replications) {
        this.replications = replications;
    }

    @Override
    public void run() {
        MemberSchemaService schemaService = (MemberSchemaService)this.getService();
        schemaService.replayReplications(this.replications);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.replications, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.replications = SerializationUtil.readCollection(in);
    }

    @Override
    public String getServiceName() {
        return "schema-service";
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

