/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecordCloner;
import com.hazelcast.internal.serialization.impl.compact.DeserializedSchemaBoundGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeserializedGenericRecord
extends CompactGenericRecord {
    private static final String METHOD_PREFIX_FOR_ERROR_MESSAGES = "get";
    private final SortedMap<String, Object> objects;
    private final Schema schema;

    public DeserializedGenericRecord(Schema schema, SortedMap<String, Object> objects) {
        this.schema = schema;
        this.objects = objects;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilder() {
        return new DeserializedSchemaBoundGenericRecordBuilder(this.schema);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder newBuilderWithClone() {
        return new DeserializedGenericRecordCloner(this.schema, new TreeMap<String, Object>(this.objects));
    }

    @Override
    @Nonnull
    public FieldKind getFieldKind(@Nonnull String fieldName) {
        FieldDescriptor field = this.schema.getField(fieldName);
        if (field == null) {
            return FieldKind.NOT_AVAILABLE;
        }
        return field.getKind();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.objects.containsKey(fieldName);
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.objects.keySet();
    }

    @Override
    public boolean getBoolean(@Nonnull String fieldName) {
        return (Boolean)this.getNonNull(fieldName, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN, "Boolean");
    }

    @Override
    public byte getInt8(@Nonnull String fieldName) {
        return (Byte)this.getNonNull(fieldName, FieldKind.INT8, FieldKind.NULLABLE_INT8, "Int8");
    }

    @Override
    public char getChar(@Nonnull String fieldName) {
        throw new UnsupportedOperationException("Compact format does not support reading a char field");
    }

    @Override
    public double getFloat64(@Nonnull String fieldName) {
        return (Double)this.getNonNull(fieldName, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64, "Float64");
    }

    @Override
    public float getFloat32(@Nonnull String fieldName) {
        return ((Float)this.getNonNull(fieldName, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32, "Float32")).floatValue();
    }

    @Override
    public int getInt32(@Nonnull String fieldName) {
        return (Integer)this.getNonNull(fieldName, FieldKind.INT32, FieldKind.NULLABLE_INT32, "Int32");
    }

    @Override
    public long getInt64(@Nonnull String fieldName) {
        return (Long)this.getNonNull(fieldName, FieldKind.INT64, FieldKind.NULLABLE_INT64, "Int64");
    }

    @Override
    public short getInt16(@Nonnull String fieldName) {
        return (Short)this.getNonNull(fieldName, FieldKind.INT16, FieldKind.NULLABLE_INT16, "Int16");
    }

    @Override
    @Nullable
    public String getString(@Nonnull String fieldName) {
        return (String)this.get(fieldName, FieldKind.STRING);
    }

    @Override
    @Nullable
    public BigDecimal getDecimal(@Nonnull String fieldName) {
        return (BigDecimal)this.get(fieldName, FieldKind.DECIMAL);
    }

    @Override
    @Nullable
    public LocalTime getTime(@Nonnull String fieldName) {
        return (LocalTime)this.get(fieldName, FieldKind.TIME);
    }

    @Override
    @Nullable
    public LocalDate getDate(@Nonnull String fieldName) {
        return (LocalDate)this.get(fieldName, FieldKind.DATE);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime)this.get(fieldName, FieldKind.TIMESTAMP);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime)this.get(fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.get(fieldName, FieldKind.COMPACT);
    }

    @Override
    @Nullable
    public boolean[] getArrayOfBoolean(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_BOOLEAN) {
            Boolean[] array = (Boolean[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            boolean[] result = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Boolean");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (boolean[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public byte[] getArrayOfInt8(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_INT8) {
            Byte[] array = (Byte[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            byte[] result = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Int8");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (byte[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public char[] getArrayOfChar(@Nonnull String fieldName) {
        throw new UnsupportedOperationException("Compact format does not support reading an array of chars field");
    }

    @Override
    @Nullable
    public double[] getArrayOfFloat64(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_FLOAT64) {
            Double[] array = (Double[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            double[] result = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Float64");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (double[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public float[] getArrayOfFloat32(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_FLOAT32) {
            Float[] array = (Float[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            float[] result = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Float32");
                }
                result[i] = array[i].floatValue();
            }
            return result;
        }
        return (float[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public int[] getArrayOfInt32(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_INT32) {
            Integer[] array = (Integer[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            int[] result = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Int32");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (int[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public long[] getArrayOfInt64(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_INT64) {
            Long[] array = (Long[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            long[] result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Int64");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (long[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public short[] getArrayOfInt16(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16);
        if (fieldKind == FieldKind.ARRAY_OF_NULLABLE_INT16) {
            Short[] array = (Short[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            short[] result = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw CompactUtil.exceptionForUnexpectedNullValueInArray(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, "Int16");
                }
                result[i] = array[i];
            }
            return result;
        }
        return (short[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public String[] getArrayOfString(@Nonnull String fieldName) {
        return (String[])this.get(fieldName, FieldKind.ARRAY_OF_STRING);
    }

    @Override
    @Nullable
    public BigDecimal[] getArrayOfDecimal(@Nonnull String fieldName) {
        return (BigDecimal[])this.get(fieldName, FieldKind.ARRAY_OF_DECIMAL);
    }

    @Override
    @Nullable
    public LocalTime[] getArrayOfTime(@Nonnull String fieldName) {
        return (LocalTime[])this.get(fieldName, FieldKind.ARRAY_OF_TIME);
    }

    @Override
    @Nullable
    public LocalDate[] getArrayOfDate(@Nonnull String fieldName) {
        return (LocalDate[])this.get(fieldName, FieldKind.ARRAY_OF_DATE);
    }

    @Override
    @Nullable
    public LocalDateTime[] getArrayOfTimestamp(@Nonnull String fieldName) {
        return (LocalDateTime[])this.get(fieldName, FieldKind.ARRAY_OF_TIMESTAMP);
    }

    @Override
    @Nullable
    public OffsetDateTime[] getArrayOfTimestampWithTimezone(@Nonnull String fieldName) {
        return (OffsetDateTime[])this.get(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nullable
    public GenericRecord[] getArrayOfGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord[])this.get(fieldName, FieldKind.ARRAY_OF_COMPACT);
    }

    @Override
    @Nullable
    public Boolean getNullableBoolean(@Nonnull String fieldName) {
        return (Boolean)this.get(fieldName, FieldKind.BOOLEAN, FieldKind.NULLABLE_BOOLEAN);
    }

    @Override
    @Nullable
    public Byte getNullableInt8(@Nonnull String fieldName) {
        return (Byte)this.get(fieldName, FieldKind.INT8, FieldKind.NULLABLE_INT8);
    }

    @Override
    @Nullable
    public Double getNullableFloat64(@Nonnull String fieldName) {
        return (Double)this.get(fieldName, FieldKind.FLOAT64, FieldKind.NULLABLE_FLOAT64);
    }

    @Override
    @Nullable
    public Float getNullableFloat32(@Nonnull String fieldName) {
        return (Float)this.get(fieldName, FieldKind.FLOAT32, FieldKind.NULLABLE_FLOAT32);
    }

    @Override
    @Nullable
    public Integer getNullableInt32(@Nonnull String fieldName) {
        return (Integer)this.get(fieldName, FieldKind.INT32, FieldKind.NULLABLE_INT32);
    }

    @Override
    @Nullable
    public Long getNullableInt64(@Nonnull String fieldName) {
        return (Long)this.get(fieldName, FieldKind.INT64, FieldKind.NULLABLE_INT64);
    }

    @Override
    @Nullable
    public Short getNullableInt16(@Nonnull String fieldName) {
        return (Short)this.get(fieldName, FieldKind.INT16, FieldKind.NULLABLE_INT16);
    }

    @Override
    @Nullable
    public Boolean[] getArrayOfNullableBoolean(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_BOOLEAN, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN);
        if (fieldKind == FieldKind.ARRAY_OF_BOOLEAN) {
            boolean[] array = (boolean[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Boolean[] result = new Boolean[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Boolean[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Byte[] getArrayOfNullableInt8(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT8, FieldKind.ARRAY_OF_NULLABLE_INT8);
        if (fieldKind == FieldKind.ARRAY_OF_INT8) {
            byte[] array = (byte[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Byte[] result = new Byte[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Byte[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Double[] getArrayOfNullableFloat64(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_FLOAT64, FieldKind.ARRAY_OF_NULLABLE_FLOAT64);
        if (fieldKind == FieldKind.ARRAY_OF_FLOAT64) {
            double[] array = (double[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Double[] result = new Double[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Double[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Float[] getArrayOfNullableFloat32(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_FLOAT32, FieldKind.ARRAY_OF_NULLABLE_FLOAT32);
        if (fieldKind == FieldKind.ARRAY_OF_FLOAT32) {
            float[] array = (float[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Float[] result = new Float[array.length];
            Arrays.setAll(result, i -> Float.valueOf(array[i]));
            return result;
        }
        return (Float[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Integer[] getArrayOfNullableInt32(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT32, FieldKind.ARRAY_OF_NULLABLE_INT32);
        if (fieldKind == FieldKind.ARRAY_OF_INT32) {
            int[] array = (int[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Integer[] result = new Integer[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Integer[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Long[] getArrayOfNullableInt64(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT64, FieldKind.ARRAY_OF_NULLABLE_INT64);
        if (fieldKind == FieldKind.ARRAY_OF_INT64) {
            long[] array = (long[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Long[] result = new Long[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Long[])this.objects.get(fieldName);
    }

    @Override
    @Nullable
    public Short[] getArrayOfNullableInt16(@Nonnull String fieldName) {
        FieldKind fieldKind = this.check(fieldName, FieldKind.ARRAY_OF_INT16, FieldKind.ARRAY_OF_NULLABLE_INT16);
        if (fieldKind == FieldKind.ARRAY_OF_INT16) {
            short[] array = (short[])this.objects.get(fieldName);
            if (array == null) {
                return null;
            }
            Short[] result = new Short[array.length];
            Arrays.setAll(result, i -> array[i]);
            return result;
        }
        return (Short[])this.objects.get(fieldName);
    }

    private <T> T get(@Nonnull String fieldName, @Nonnull FieldKind primitiveFieldKind, @Nonnull FieldKind nullableFieldKind) {
        this.check(fieldName, primitiveFieldKind, nullableFieldKind);
        return (T)this.objects.get(fieldName);
    }

    private <T> T getNonNull(@Nonnull String fieldName, @Nonnull FieldKind primitiveFieldKind, @Nonnull FieldKind nullableFieldKind, String methodSuffix) {
        this.check(fieldName, primitiveFieldKind, nullableFieldKind);
        Object t = this.objects.get(fieldName);
        if (t == null) {
            throw CompactUtil.exceptionForUnexpectedNullValue(fieldName, METHOD_PREFIX_FOR_ERROR_MESSAGES, methodSuffix);
        }
        return (T)t;
    }

    private <T> T get(@Nonnull String fieldName, @Nonnull FieldKind fieldKind) {
        this.check(fieldName, fieldKind);
        return (T)this.objects.get(fieldName);
    }

    private FieldKind check(@Nonnull String fieldName, FieldKind ... kinds) {
        FieldDescriptor fd = this.schema.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + " for " + String.valueOf(this.schema));
        }
        boolean valid = false;
        FieldKind fieldKind = fd.getKind();
        for (FieldKind kind : kinds) {
            valid |= fieldKind == kind;
        }
        if (!valid) {
            throw new HazelcastSerializationException("Invalid field kind: '" + fieldName + " for " + String.valueOf(this.schema) + ", valid field kinds : " + Arrays.toString((Object[])kinds) + ", found : " + String.valueOf((Object)fieldKind));
        }
        return fieldKind;
    }

    @Override
    protected Object getClassIdentifier() {
        return this.schema.getTypeName();
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord)this.get(fieldName, FieldKind.COMPACT);
    }

    @Override
    @Nullable
    public InternalGenericRecord[] getArrayOfInternalGenericRecord(@Nonnull String fieldName) {
        return (InternalGenericRecord[])this.get(fieldName, FieldKind.ARRAY_OF_COMPACT);
    }

    @Override
    @Nullable
    public Boolean getBooleanFromArray(@Nonnull String fieldName, int index) {
        boolean[] array = this.getArrayOfBoolean(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Byte getInt8FromArray(@Nonnull String fieldName, int index) {
        byte[] array = this.getArrayOfInt8(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Character getCharFromArray(@Nonnull String fieldName, int index) {
        throw new UnsupportedOperationException("Compact format does not support reading a char field");
    }

    @Override
    @Nullable
    public Double getFloat64FromArray(@Nonnull String fieldName, int index) {
        double[] array = this.getArrayOfFloat64(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Float getFloat32FromArray(@Nonnull String fieldName, int index) {
        float[] array = this.getArrayOfFloat32(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return Float.valueOf(array[index]);
    }

    @Override
    @Nullable
    public Integer getInt32FromArray(@Nonnull String fieldName, int index) {
        int[] array = this.getArrayOfInt32(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Long getInt64FromArray(@Nonnull String fieldName, int index) {
        long[] array = this.getArrayOfInt64(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public Short getInt16FromArray(@Nonnull String fieldName, int index) {
        short[] array = this.getArrayOfInt16(fieldName);
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Override
    @Nullable
    public String getStringFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfString(fieldName), index);
    }

    @Override
    @Nullable
    public GenericRecord getGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfGenericRecord(fieldName), index);
    }

    @Override
    @Nullable
    public InternalGenericRecord getInternalGenericRecordFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfInternalGenericRecord(fieldName), index);
    }

    @Nullable
    public Object getObjectFromArray(@Nonnull String fieldName, int index) {
        return this.getGenericRecordFromArray(fieldName, index);
    }

    @Override
    @Nullable
    public <T> T[] getArrayOfObject(@Nonnull String fieldName, Class<T> componentType) {
        return this.getArrayOfGenericRecord(fieldName);
    }

    @Nullable
    public Object getObject(@Nonnull String fieldName) {
        return this.getGenericRecord(fieldName);
    }

    @Override
    @Nullable
    public BigDecimal getDecimalFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfDecimal(fieldName), index);
    }

    @Override
    @Nullable
    public LocalTime getTimeFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTime(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDate getDateFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfDate(fieldName), index);
    }

    @Override
    @Nullable
    public LocalDateTime getTimestampFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTimestamp(fieldName), index);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimestampWithTimezoneFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfTimestampWithTimezone(fieldName), index);
    }

    @Override
    @Nullable
    public Boolean getNullableBooleanFromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableBoolean(fieldName), index);
    }

    @Override
    @Nullable
    public Byte getNullableInt8FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableInt8(fieldName), index);
    }

    @Override
    @Nullable
    public Short getNullableInt16FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableInt16(fieldName), index);
    }

    @Override
    @Nullable
    public Integer getNullableInt32FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableInt32(fieldName), index);
    }

    @Override
    @Nullable
    public Long getNullableInt64FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableInt64(fieldName), index);
    }

    @Override
    @Nullable
    public Float getNullableFloat32FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableFloat32(fieldName), index);
    }

    @Override
    @Nullable
    public Double getNullableFloat64FromArray(@Nonnull String fieldName, int index) {
        return this.getFromArray(this.getArrayOfNullableFloat64(fieldName), index);
    }

    private <T> T getFromArray(T[] array, int index) {
        if (array == null || array.length <= index) {
            return null;
        }
        return array[index];
    }
}

