/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.membergroup;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.properties.ValidationException;
import com.hazelcast.internal.partition.membergroup.BackupSafeMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import com.hazelcast.spi.partitiongroup.PartitionGroupStrategy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SPIAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    private final DiscoveryService discoveryService;

    public SPIAwareMemberGroupFactory(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Set<MemberGroup> memberGroups = SetUtil.createHashSet(allMembers.size());
        try {
            DefaultDiscoveryService defaultDiscoveryService = (DefaultDiscoveryService)this.discoveryService;
            if (!defaultDiscoveryService.getDiscoveryStrategies().iterator().hasNext()) {
                throw new RuntimeException("Could not load any Discovery Strategy, please check service definitions under META_INF.services folder. ");
            }
            Iterator<DiscoveryStrategy> iterator = defaultDiscoveryService.getDiscoveryStrategies().iterator();
            if (iterator.hasNext()) {
                DiscoveryStrategy discoveryStrategy = iterator.next();
                PartitionGroupStrategy groupStrategy = discoveryStrategy.getPartitionGroupStrategy(allMembers);
                if (groupStrategy == null) {
                    groupStrategy = discoveryStrategy.getPartitionGroupStrategy();
                }
                Preconditions.checkNotNull(groupStrategy);
                for (MemberGroup group : groupStrategy.getMemberGroups()) {
                    memberGroups.add(group);
                }
                return memberGroups;
            }
        }
        catch (ValidationException e) {
            throw new InvalidConfigurationException("Invalid configuration", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure discovery strategies", e);
        }
        return memberGroups;
    }
}

