/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.impl.PartitionReplicaFragmentVersions;
import com.hazelcast.internal.services.ServiceNamespace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

final class PartitionReplicaVersions {
    private final int partitionId;
    private final Map<ServiceNamespace, PartitionReplicaFragmentVersions> fragmentVersionsMap = new HashMap<ServiceNamespace, PartitionReplicaFragmentVersions>();
    private final Function<? super ServiceNamespace, ? extends PartitionReplicaFragmentVersions> createFragmentVersionsFunction;

    PartitionReplicaVersions(int partitionId) {
        this.partitionId = partitionId;
        this.createFragmentVersionsFunction = namespace -> new PartitionReplicaFragmentVersions(partitionId, (ServiceNamespace)namespace);
    }

    long[] incrementAndGet(ServiceNamespace namespace, int backupCount) {
        return this.getFragmentVersions(namespace).incrementAndGet(backupCount);
    }

    long[] get(ServiceNamespace namespace) {
        return this.getFragmentVersions(namespace).get();
    }

    boolean isStale(ServiceNamespace namespace, long[] newVersions, int replicaIndex) {
        return this.getFragmentVersions(namespace).isStale(newVersions, replicaIndex);
    }

    boolean update(ServiceNamespace namespace, long[] newVersions, int replicaIndex) {
        return this.getFragmentVersions(namespace).update(newVersions, replicaIndex);
    }

    void set(ServiceNamespace namespace, long[] newVersions, int fromReplica) {
        this.getFragmentVersions(namespace).set(newVersions, fromReplica);
    }

    boolean isDirty(ServiceNamespace namespace) {
        return this.getFragmentVersions(namespace).isDirty();
    }

    void markAsSyncRequired(ServiceNamespace namespace, int replicaIndex) {
        this.getFragmentVersions(namespace).markAsSyncRequired(replicaIndex);
    }

    void clear(ServiceNamespace namespace) {
        this.getFragmentVersions(namespace).clear();
    }

    private PartitionReplicaFragmentVersions getFragmentVersions(ServiceNamespace namespace) {
        return this.fragmentVersionsMap.computeIfAbsent(namespace, this.createFragmentVersionsFunction);
    }

    void retainNamespaces(Collection<ServiceNamespace> namespaces) {
        this.fragmentVersionsMap.keySet().retainAll(namespaces);
    }

    Collection<ServiceNamespace> getNamespaces() {
        return Collections.unmodifiableCollection(this.fragmentVersionsMap.keySet());
    }

    public String toString() {
        return "PartitionReplicaVersions{partitionId=" + this.partitionId + ", fragmentVersions=" + String.valueOf(this.fragmentVersionsMap) + "}";
    }
}

