/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitionLostEvent;
import java.io.IOException;

public class PartitionLostEventImpl
implements PartitionLostEvent,
IPartitionLostEvent,
IdentifiedDataSerializable {
    private int partitionId;
    private int lostBackupCount;
    private Address eventSource;

    public PartitionLostEventImpl() {
    }

    public PartitionLostEventImpl(int partitionId, int lostBackupCount, Address eventSource) {
        this.partitionId = partitionId;
        this.lostBackupCount = lostBackupCount;
        this.eventSource = eventSource;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int getLostBackupCount() {
        return this.lostBackupCount;
    }

    @Override
    public boolean allReplicasInPartitionLost() {
        return this.getLostBackupCount() == 6;
    }

    @Override
    public int getLostReplicaIndex() {
        return this.lostBackupCount;
    }

    @Override
    public Address getEventSource() {
        return this.eventSource;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        out.writeInt(this.lostBackupCount);
        out.writeObject(this.eventSource);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.lostBackupCount = in.readInt();
        this.eventSource = (Address)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }

    public String toString() {
        return this.getClass().getName() + "{partitionId=" + this.partitionId + ", lostBackupCount=" + this.lostBackupCount + ", eventSource=" + String.valueOf(this.eventSource) + "}";
    }
}

