/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.lang.invoke.VarHandle;

public class LocalRecordStoreStatsImpl
implements LocalRecordStoreStats,
IdentifiedDataSerializable,
Versioned {
    private static final VarHandle HITS = ReflectionUtil.findVarHandle("hits", Long.TYPE);
    private static final VarHandle EVICTION_COUNT = ReflectionUtil.findVarHandle("evictionCount", Long.TYPE);
    private static final VarHandle EXPIRATION_COUNT = ReflectionUtil.findVarHandle("expirationCount", Long.TYPE);
    private static final VarHandle LAST_ACCESS_TIME = ReflectionUtil.findVarHandle("lastAccessTime", Long.TYPE);
    private static final VarHandle LAST_UPDATE_TIME = ReflectionUtil.findVarHandle("lastUpdateTime", Long.TYPE);
    private volatile long hits;
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;
    private volatile long evictionCount;
    private volatile long expirationCount;

    public void copyFrom(LocalRecordStoreStats stats) {
        this.hits = stats.getHits();
        this.lastAccessTime = stats.getLastAccessTime();
        this.lastUpdateTime = stats.getLastUpdateTime();
        this.evictionCount = stats.getEvictionCount();
        this.expirationCount = stats.getExpirationCount();
    }

    @Override
    public long getEvictionCount() {
        return this.evictionCount;
    }

    @Override
    public long getExpirationCount() {
        return this.expirationCount;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastAccessTime(long time) {
        LAST_ACCESS_TIME.setOpaque(this, Math.max(this.lastAccessTime, time));
    }

    @Override
    public void setLastUpdateTime(long time) {
        LAST_UPDATE_TIME.setOpaque(this, Math.max(this.lastUpdateTime, time));
    }

    @Override
    public void increaseEvictions() {
        EVICTION_COUNT.setOpaque(this, this.evictionCount + 1L);
    }

    @Override
    public void increaseExpirations() {
        EXPIRATION_COUNT.setOpaque(this, this.expirationCount + 1L);
    }

    @Override
    public void increaseHits() {
        HITS.setOpaque(this, this.hits + 1L);
    }

    public void reset() {
        this.hits = 0L;
        this.lastAccessTime = 0L;
        this.lastUpdateTime = 0L;
        this.evictionCount = 0L;
        this.expirationCount = 0L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastUpdateTime);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeLong(this.evictionCount);
            out.writeLong(this.expirationCount);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastUpdateTime = in.readLong();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.evictionCount = in.readLong();
            this.expirationCount = in.readLong();
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 154;
    }
}

