/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.CachedProbe;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeType;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.counters.Counter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class MethodProbe
implements ProbeFunction {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    final MethodHandle methodHandle;
    final Supplier<?> staticAccessor;
    final Function<Object, ?> nonStaticAccessor;
    final boolean isMethodStatic;
    final CachedProbe probe;
    final ProbeType type;
    final SourceMetadata sourceMetadata;
    final String probeName;

    MethodProbe(Method method, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
        try {
            method.setAccessible(true);
            MethodHandle unreflected = LOOKUP.unreflect(method);
            this.isMethodStatic = Modifier.isStatic(method.getModifiers());
            if (type.isPrimitive()) {
                MethodType methodType = unreflected.type().changeReturnType(type.getMapsTo());
                if (!this.isMethodStatic) {
                    methodType = methodType.changeParameterType(0, Object.class);
                }
                this.methodHandle = unreflected.asType(methodType);
                this.staticAccessor = null;
                this.nonStaticAccessor = null;
            } else {
                this.methodHandle = null;
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), LOOKUP);
                MethodType methodReturnType = MethodType.methodType(method.getReturnType());
                MethodType dynamicMethodType = unreflected.type();
                if (this.isMethodStatic) {
                    MethodHandle implementation = privateLookup.findStatic(method.getDeclaringClass().getClass(), method.getName(), methodReturnType);
                    this.staticAccessor = LambdaMetafactory.metafactory(privateLookup, "get", MethodType.methodType(Supplier.class), MethodType.methodType(Object.class, new Class[0]), implementation, dynamicMethodType).getTarget().invokeExact();
                    this.nonStaticAccessor = null;
                } else {
                    MethodHandle implementation = privateLookup.findVirtual(method.getDeclaringClass(), method.getName(), methodReturnType);
                    this.staticAccessor = null;
                    this.nonStaticAccessor = LambdaMetafactory.metafactory(privateLookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), implementation, dynamicMethodType).getTarget().invokeExact();
                }
            }
            this.probe = new CachedProbe(probe);
            this.type = type;
            this.sourceMetadata = sourceMetadata;
            this.probeName = probe.name();
            assert (this.probeName != null);
            assert (this.probeName.length() > 0);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    void register(MetricsRegistryImpl metricsRegistry, Object source, String namePrefix) {
        MetricDescriptorImpl descriptor = metricsRegistry.newMetricDescriptor().withPrefix(namePrefix).withMetric(this.getProbeName());
        metricsRegistry.registerInternal(source, descriptor, this.probe.level(), this);
    }

    void register(MetricsRegistryImpl metricsRegistry, MetricDescriptor descriptor, Object source) {
        metricsRegistry.registerStaticProbe(source, descriptor, this.getProbeName(), this.probe.level(), this.probe.unit(), this);
    }

    String getProbeName() {
        return this.probeName;
    }

    static <S> MethodProbe createMethodProbe(Method method, Probe probe, SourceMetadata sourceMetadata) {
        ProbeType type = ProbeType.getType(method.getReturnType());
        if (type == null) {
            throw new IllegalArgumentException(String.format("@Probe method '%s.%s() has an unsupported return type'", method.getDeclaringClass().getName(), method.getName()));
        }
        if (method.getParameterCount() != 0) {
            throw new IllegalArgumentException(String.format("@Probe method '%s.%s' can't have arguments", method.getDeclaringClass().getName(), method.getName()));
        }
        if (type.getMapsTo() == Double.TYPE) {
            return new DoubleMethodProbe(method, probe, type, sourceMetadata);
        }
        if (type.getMapsTo() == Long.TYPE) {
            return new LongMethodProbe(method, probe, type, sourceMetadata);
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected <T> T invoke(Object source) {
        return (T)(this.isMethodStatic ? this.staticAccessor.get() : this.nonStaticAccessor.apply(source));
    }

    static class DoubleMethodProbe<S>
    extends MethodProbe
    implements DoubleProbeFunction<S> {
        DoubleMethodProbe(Method method, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
            super(method, probe, type, sourceMetadata);
        }

        @Override
        public double get(S source) throws Exception {
            try {
                switch (this.type) {
                    case TYPE_DOUBLE_PRIMITIVE: {
                        return this.isMethodStatic ? this.methodHandle.invokeExact() : this.methodHandle.invokeExact(source);
                    }
                    case TYPE_DOUBLE_NUMBER: {
                        Number result = (Number)this.invoke(source);
                        return result == null ? 0.0 : result.doubleValue();
                    }
                }
                throw new IllegalStateException("Unrecognized type: " + String.valueOf((Object)this.type));
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw ExceptionUtil.sneakyThrow(t);
            }
        }
    }

    static class LongMethodProbe<S>
    extends MethodProbe
    implements LongProbeFunction<S> {
        LongMethodProbe(Method method, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
            super(method, probe, type, sourceMetadata);
        }

        @Override
        public long get(S source) throws Exception {
            try {
                switch (this.type) {
                    case TYPE_LONG_PRIMITIVE: {
                        return this.isMethodStatic ? this.methodHandle.invokeExact() : this.methodHandle.invokeExact(source);
                    }
                    case TYPE_LONG_NUMBER: {
                        Number longNumber = (Number)this.invoke(source);
                        return longNumber == null ? 0L : longNumber.longValue();
                    }
                    case TYPE_MAP: {
                        Map map = (Map)this.invoke(source);
                        return map == null ? 0L : (long)map.size();
                    }
                    case TYPE_COLLECTION: {
                        Collection collection = (Collection)this.invoke(source);
                        return collection == null ? 0L : (long)collection.size();
                    }
                    case TYPE_COUNTER: {
                        Counter counter = (Counter)this.invoke(source);
                        return counter == null ? 0L : counter.get();
                    }
                    case TYPE_SEMAPHORE: {
                        Semaphore semaphore = (Semaphore)this.invoke(source);
                        return semaphore == null ? 0L : (long)semaphore.availablePermits();
                    }
                }
                throw new IllegalStateException("Unrecognized type: " + String.valueOf((Object)this.type));
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw ExceptionUtil.sneakyThrow(t);
            }
        }
    }
}

