/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.CachedProbe;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeType;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.counters.Counter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Semaphore;

abstract class FieldProbe
implements ProbeFunction {
    final CachedProbe probe;
    final Field field;
    final ProbeType type;
    final SourceMetadata sourceMetadata;
    final String probeName;

    FieldProbe(Field field, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
        this.field = field;
        this.probe = new CachedProbe(probe);
        this.type = type;
        this.sourceMetadata = sourceMetadata;
        this.probeName = probe.name();
        assert (this.probeName != null);
        assert (this.probeName.length() > 0);
        field.setAccessible(true);
    }

    void register(MetricsRegistryImpl metricsRegistry, Object source, String namePrefix) {
        MetricDescriptorImpl descriptor = metricsRegistry.newMetricDescriptor().withPrefix(namePrefix).withMetric(this.getProbeName());
        metricsRegistry.registerInternal(source, descriptor, this.probe.level(), this);
    }

    void register(MetricsRegistryImpl metricsRegistry, MetricDescriptor descriptor, Object source) {
        metricsRegistry.registerStaticProbe(source, descriptor, this.getProbeName(), this.probe.level(), this.probe.unit(), this);
    }

    String getProbeName() {
        return this.probeName;
    }

    static <S> FieldProbe createFieldProbe(Field field, Probe probe, SourceMetadata sourceMetadata) {
        ProbeType type = ProbeType.getType(field.getType());
        if (type == null) {
            throw new IllegalArgumentException(String.format("@Probe field '%s' is of an unhandled type", field));
        }
        if (type.getMapsTo() == Double.TYPE) {
            return new DoubleFieldProbe(field, probe, type, sourceMetadata);
        }
        if (type.getMapsTo() == Long.TYPE) {
            return new LongFieldProbe(field, probe, type, sourceMetadata);
        }
        throw new IllegalArgumentException(type.toString());
    }

    static class DoubleFieldProbe<S>
    extends FieldProbe
    implements DoubleProbeFunction<S> {
        DoubleFieldProbe(Field field, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
            super(field, probe, type, sourceMetadata);
        }

        @Override
        public double get(S source) throws Exception {
            switch (this.type) {
                case TYPE_DOUBLE_PRIMITIVE: {
                    return this.field.getDouble(source);
                }
                case TYPE_DOUBLE_NUMBER: {
                    Number doubleNumber = (Number)this.field.get(source);
                    return doubleNumber == null ? 0.0 : doubleNumber.doubleValue();
                }
            }
            throw new IllegalStateException("Unhandled type:" + String.valueOf((Object)this.type));
        }
    }

    static class LongFieldProbe<S>
    extends FieldProbe
    implements LongProbeFunction<S> {
        LongFieldProbe(Field field, Probe probe, ProbeType type, SourceMetadata sourceMetadata) {
            super(field, probe, type, sourceMetadata);
        }

        @Override
        public long get(S source) throws Exception {
            switch (this.type) {
                case TYPE_LONG_PRIMITIVE: {
                    return this.field.getLong(source);
                }
                case TYPE_LONG_NUMBER: {
                    Number longNumber = (Number)this.field.get(source);
                    return longNumber == null ? 0L : longNumber.longValue();
                }
                case TYPE_MAP: {
                    Map map = (Map)this.field.get(source);
                    return map == null ? 0L : (long)map.size();
                }
                case TYPE_COLLECTION: {
                    Collection collection = (Collection)this.field.get(source);
                    return collection == null ? 0L : (long)collection.size();
                }
                case TYPE_COUNTER: {
                    Counter counter = (Counter)this.field.get(source);
                    return counter == null ? 0L : counter.get();
                }
                case TYPE_SEMAPHORE: {
                    Semaphore semaphore = (Semaphore)this.field.get(source);
                    return semaphore == null ? 0L : (long)semaphore.availablePermits();
                }
            }
            throw new IllegalStateException("Unhandled type:" + String.valueOf((Object)this.type));
        }
    }
}

