/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.json.internal.JsonSerializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class ClientEndPointDTO
implements JsonSerializable {
    public UUID uuid;
    public String address;
    public String clientType;
    public String clientVersion;
    public boolean enterprise;
    public boolean statsEnabled;
    public String name;
    public long clusterConnectionTimestamp;
    public RoutingMode routingMode;
    public Set<String> labels;
    public String ipAddress;
    public String canonicalHostName;
    public boolean cpDirectToLeader;

    public ClientEndPointDTO() {
    }

    public ClientEndPointDTO(ClientEndpoint clientEndpoint) {
        this.uuid = clientEndpoint.getUuid();
        this.clientType = clientEndpoint.getClientType();
        this.clientVersion = clientEndpoint.getClientVersion();
        this.enterprise = clientEndpoint.isEnterprise();
        this.statsEnabled = clientEndpoint.getClientStatistics() != null;
        this.name = clientEndpoint.getName();
        this.clusterConnectionTimestamp = clientEndpoint.getConnectionStartTime();
        this.routingMode = clientEndpoint.getRoutingMode();
        this.labels = clientEndpoint.getLabels();
        InetSocketAddress socketAddress = clientEndpoint.getSocketAddress();
        this.address = socketAddress.getHostName() + ":" + socketAddress.getPort();
        InetAddress address = socketAddress.getAddress();
        this.ipAddress = address != null ? address.getHostAddress() : null;
        this.canonicalHostName = address != null ? address.getCanonicalHostName() : null;
        this.cpDirectToLeader = clientEndpoint.isCpDirectToLeaderEnabled();
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = Json.object();
        root.add("uuid", this.uuid.toString());
        root.add("address", this.address);
        root.add("clientType", this.clientType);
        root.add("clientVersion", this.clientVersion);
        root.add("enterprise", this.enterprise);
        root.add("statsEnabled", this.statsEnabled);
        root.add("name", this.name);
        JsonArray labelsObject = Json.array();
        for (String label : this.labels) {
            labelsObject.add(label);
        }
        root.add("clusterConnectionTimestamp", this.clusterConnectionTimestamp);
        root.add("routingMode", this.routingMode.getId());
        root.add("labels", labelsObject);
        root.add("ipAddress", this.ipAddress);
        root.add("canonicalHostName", this.canonicalHostName);
        root.add("cpDirectToLeader", this.cpDirectToLeader);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.uuid = UUID.fromString(JsonUtil.getString(json, "uuid"));
        this.address = JsonUtil.getString(json, "address");
        this.clientType = JsonUtil.getString(json, "clientType");
        this.clientVersion = JsonUtil.getString(json, "clientVersion");
        this.enterprise = JsonUtil.getBoolean(json, "enterprise");
        this.statsEnabled = JsonUtil.getBoolean(json, "statsEnabled");
        this.routingMode = RoutingMode.getById(JsonUtil.getInt(json, "routingMode", -1));
        this.name = JsonUtil.getString(json, "name");
        this.clusterConnectionTimestamp = JsonUtil.getLong(json, "clusterConnectionTimestamp");
        JsonArray labelsArray = JsonUtil.getArray(json, "labels");
        this.labels = new HashSet<String>();
        for (JsonValue labelValue : labelsArray) {
            this.labels.add(labelValue.asString());
        }
        this.ipAddress = JsonUtil.getString(json, "ipAddress", null);
        this.canonicalHostName = JsonUtil.getString(json, "canonicalHostName", null);
        this.cpDirectToLeader = JsonUtil.getBoolean(json, "cpDirectToLeader", false);
    }
}

