/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import com.hazelcast.internal.iteration.IterationResult;
import com.hazelcast.internal.iteration.IteratorWithCursor;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class IteratorWithCursorManager<T> {
    private final NodeEngine nodeEngine;
    private final ConcurrentHashMap<UUID, IteratorWithCursor<T>> iterators = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, UUID> cursorToIteratorId = new ConcurrentHashMap();

    public IteratorWithCursorManager(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public void createIterator(Iterator<T> items, UUID iteratorId) {
        if (!this.iterators.containsKey(iteratorId)) {
            this.iterators.put(iteratorId, new IteratorWithCursor<T>(items, iteratorId));
            this.cursorToIteratorId.put(iteratorId, iteratorId);
        }
    }

    public IterationResult<T> iterate(UUID cursorId, int maxCount) {
        UUID iteratorId = this.cursorToIteratorId.get(cursorId);
        if (iteratorId == null) {
            throw new IllegalStateException("There is no iteration with cursor id " + String.valueOf(cursorId) + " on member " + String.valueOf(this.nodeEngine.getThisAddress()) + ".");
        }
        IteratorWithCursor<T> paginator = this.iterators.get(iteratorId);
        if (paginator == null) {
            throw new IllegalStateException("There is no iteration with cursor id " + String.valueOf(cursorId) + " on member " + String.valueOf(this.nodeEngine.getThisAddress()) + ".");
        }
        IterationResult<T> result = paginator.iterate(cursorId, maxCount);
        if (result.getCursorIdToForget() != null) {
            this.cursorToIteratorId.remove(result.getCursorIdToForget());
        }
        this.cursorToIteratorId.put(result.getCursorId(), iteratorId);
        return result;
    }

    public void cleanupIterator(UUID iteratorId) {
        if (!this.iterators.containsKey(iteratorId)) {
            return;
        }
        this.iterators.remove(iteratorId);
        this.cursorToIteratorId.values().remove(iteratorId);
    }

    ConcurrentHashMap<UUID, UUID> getCursorToIteratorId() {
        return this.cursorToIteratorId;
    }

    public ConcurrentHashMap<UUID, IteratorWithCursor<T>> getIterators() {
        return this.iterators;
    }

    public ConcurrentHashMap.KeySetView<UUID, IteratorWithCursor<T>> getKeySet() {
        return this.iterators.keySet();
    }

    public IteratorWithCursor<T> getIterator(UUID iteratorId) {
        return this.iterators.get(iteratorId);
    }
}

