/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.BTreeIndexConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemcacheProtocolConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeNamespacesConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.DynamicConfigXmlGenerator;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.memory.Capacity;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.Dump;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.DumpSettings;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.common.FlowStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class DynamicConfigYamlGenerator {
    private static final int INDENT = 2;
    private static final boolean DEFAULT_MASK_SENSITIVE_FIELDS = false;
    private static volatile boolean maskSensitiveFields = false;

    public String generate(Config config, boolean maskSensitiveFields) {
        DynamicConfigYamlGenerator.maskSensitiveFields = maskSensitiveFields;
        LinkedHashMap<String, LinkedHashMap<String, Object>> document = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        document.put("hazelcast", root);
        root.put("cluster-name", config.getClusterName());
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : config.getProperties().entrySet()) {
            propertiesMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        root.put("properties", propertiesMap);
        DynamicConfigYamlGenerator.licenseKeyYamlGenerator(root, config);
        DynamicConfigYamlGenerator.mapYamlGenerator(root, config);
        DynamicConfigYamlGenerator.cacheYamlGenerator(root, config);
        DynamicConfigYamlGenerator.queueYamlGenerator(root, config);
        DynamicConfigYamlGenerator.listYamlGenerator(root, config);
        DynamicConfigYamlGenerator.setYamlGenerator(root, config);
        DynamicConfigYamlGenerator.multiMapYamlGenerator(root, config);
        DynamicConfigYamlGenerator.replicatedMapYamlGenerator(root, config);
        DynamicConfigYamlGenerator.ringbufferYamlGenerator(root, config);
        DynamicConfigYamlGenerator.topicYamlGenerator(root, config);
        DynamicConfigYamlGenerator.reliableTopicYamlGenerator(root, config);
        DynamicConfigYamlGenerator.executorYamlGenerator(root, config);
        DynamicConfigYamlGenerator.durableExecutorYamlGenerator(root, config);
        DynamicConfigYamlGenerator.scheduledExecutorYamlGenerator(root, config);
        DynamicConfigYamlGenerator.cardinalityEstimatorYamlGenerator(root, config);
        DynamicConfigYamlGenerator.flakeIdGeneratorYamlGenerator(root, config);
        DynamicConfigYamlGenerator.pnCounterYamlGenerator(root, config);
        DynamicConfigYamlGenerator.wanReplicationYamlGenerator(root, config);
        this.networkConfigYamlGenerator(root, config);
        this.advancedNetworkConfigYamlGenerator(root, config);
        DynamicConfigYamlGenerator.dataConnectionYamlGenerator(root, config);
        DynamicConfigYamlGenerator.namespacesConfigGenerator(root, config);
        DynamicConfigYamlGenerator.metricsConfigGenerator(root, config);
        DynamicConfigYamlGenerator.splitBrainProtectionConfigsGenerator(root, config);
        DynamicConfigYamlGenerator.vectorCollectionYamlGenerator(root, config);
        DynamicConfigYamlGenerator.maskSensitiveFields = false;
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndicatorIndent(0).setIndent(2).build();
        Dump dump = new Dump(dumpSettings);
        return dump.dumpToString(document);
    }

    public static void licenseKeyYamlGenerator(Map<String, Object> parent, Config config) {
        DynamicConfigYamlGenerator.addNonNullToMap(parent, ConfigSections.LICENSE_KEY.getName(), DynamicConfigYamlGenerator.getOrMaskValue(config.getLicenseKey()));
    }

    public static void mapYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getMapConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (MapConfig subConfigAsObject : config.getMapConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            String cacheDeserializedValues = subConfigAsObject.getCacheDeserializedValues() != null ? subConfigAsObject.getCacheDeserializedValues().name().replace('_', '-') : null;
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "in-memory-format", subConfigAsObject.getInMemoryFormat().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "per-entry-stats-enabled", subConfigAsObject.isPerEntryStatsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-deserialized-values", cacheDeserializedValues);
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "time-to-live-seconds", subConfigAsObject.getTimeToLiveSeconds());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "max-idle-seconds", subConfigAsObject.getMaxIdleSeconds());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "read-backup-data", subConfigAsObject.isReadBackupData());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "metadata-policy", subConfigAsObject.getMetadataPolicy().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "eviction", DynamicConfigYamlGenerator.getEvictionConfigAsMap(subConfigAsObject.getEvictionConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merkle-tree", DynamicConfigYamlGenerator.getMerkleTreeConfigAsMap(subConfigAsObject.getMerkleTreeConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "event-journal", DynamicConfigYamlGenerator.getEventJournalConfigAsMap(subConfigAsObject.getEventJournalConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "data-persistence", DynamicConfigYamlGenerator.getDataPersistenceConfigAsMap(subConfigAsObject.getDataPersistenceConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "map-store", DynamicConfigYamlGenerator.getMapStoreConfigAsMap(subConfigAsObject.getMapStoreConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "near-cache", DynamicConfigYamlGenerator.getNearCacheConfigAsMap(subConfigAsObject.getNearCacheConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "wan-replication-ref", DynamicConfigYamlGenerator.getWanReplicationRefAsMap(subConfigAsObject.getWanReplicationRef(), true));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "near-cache", DynamicConfigYamlGenerator.getNearCacheConfigAsMap(subConfigAsObject.getNearCacheConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "indexes", DynamicConfigYamlGenerator.getIndexConfigsAsList(subConfigAsObject.getIndexConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "attributes", DynamicConfigYamlGenerator.getAttributeConfigsAsMap(subConfigAsObject.getAttributeConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "entry-listeners", DynamicConfigYamlGenerator.getEntryListenerConfigsAsList(subConfigAsObject.getEntryListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "partition-lost-listeners", DynamicConfigYamlGenerator.getListenerConfigsAsList(subConfigAsObject.getPartitionLostListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "partition-strategy", DynamicConfigYamlGenerator.getPartitioningStrategyAsString(subConfigAsObject.getPartitioningStrategyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "query-caches", DynamicConfigYamlGenerator.getQueryCacheConfigsAsMap(subConfigAsObject.getQueryCacheConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "tiered-store", DynamicConfigYamlGenerator.getTieredStoreConfigAsMap(subConfigAsObject.getTieredStoreConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "partition-attributes", DynamicConfigYamlGenerator.getPartitioningAttributesAsList(subConfigAsObject.getPartitioningAttributeConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("map", child);
    }

    public static void cacheYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getCacheConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (CacheSimpleConfig subConfigAsObject : config.getCacheConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "key-type", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getKeyType()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "value-type", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getValueType()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "management-enabled", subConfigAsObject.isManagementEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "read-through", subConfigAsObject.isReadThrough());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "write-through", subConfigAsObject.isWriteThrough());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-loader-factory", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getCacheLoaderFactory()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-writer-factory", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getCacheWriterFactory()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-loader", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getCacheLoader()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-writer", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", subConfigAsObject.getCacheWriter()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "expiry-policy-factory", DynamicConfigYamlGenerator.getExpiryPolicyFactoryConfigAsMap(subConfigAsObject.getExpiryPolicyFactoryConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "cache-entry-listeners", DynamicConfigYamlGenerator.getCacheSimpleEntryListenerConfigsAsList(subConfigAsObject.getCacheEntryListeners()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "in-memory-format", subConfigAsObject.getInMemoryFormat().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "eviction", DynamicConfigYamlGenerator.getEvictionConfigAsMap(subConfigAsObject.getEvictionConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "wan-replication-ref", DynamicConfigYamlGenerator.getWanReplicationRefAsMap(subConfigAsObject.getWanReplicationRef(), false));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "partition-lost-listeners", DynamicConfigYamlGenerator.getListenerConfigsAsList(subConfigAsObject.getPartitionLostListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "event-journal", DynamicConfigYamlGenerator.getEventJournalConfigAsMap(subConfigAsObject.getEventJournalConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "data-persistence", DynamicConfigYamlGenerator.getDataPersistenceConfigAsMap(subConfigAsObject.getDataPersistenceConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merkle-tree", DynamicConfigYamlGenerator.getMerkleTreeConfigAsMap(subConfigAsObject.getMerkleTreeConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "disable-per-entry-invalidation-events", subConfigAsObject.isDisablePerEntryInvalidationEvents());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("cache", child);
    }

    public static void queueYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getQueueConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (QueueConfig subConfigAsObject : config.getQueueConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "priority-comparator-class-name", subConfigAsObject.getPriorityComparatorClassName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "max-size", subConfigAsObject.getMaxSize());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "empty-queue-ttl", subConfigAsObject.getEmptyQueueTtl());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "item-listeners", DynamicConfigYamlGenerator.getItemListenerConfigsAsList(subConfigAsObject.getItemListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "queue-store", DynamicConfigYamlGenerator.getQueueStoreConfigAsMap(subConfigAsObject.getQueueStoreConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("queue", child);
    }

    public static void listYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getListConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap<String, Map<String, Object>> child = new LinkedHashMap<String, Map<String, Object>>();
        for (ListConfig subConfigAsObject : config.getListConfigs().values()) {
            child.put(subConfigAsObject.getName(), DynamicConfigYamlGenerator.getCollectionConfigAsMap(subConfigAsObject));
        }
        parent.put("list", child);
    }

    public static void setYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getSetConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap<String, Map<String, Object>> child = new LinkedHashMap<String, Map<String, Object>>();
        for (SetConfig subConfigAsObject : config.getSetConfigs().values()) {
            child.put(subConfigAsObject.getName(), DynamicConfigYamlGenerator.getCollectionConfigAsMap(subConfigAsObject));
        }
        parent.put("set", child);
    }

    public static void multiMapYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getMultiMapConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (MultiMapConfig subConfigAsObject : config.getMultiMapConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "binary", subConfigAsObject.isBinary());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "value-collection-type", subConfigAsObject.getValueCollectionType().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "entry-listeners", DynamicConfigYamlGenerator.getEntryListenerConfigsAsList(subConfigAsObject.getEntryListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("multimap", child);
    }

    public static void replicatedMapYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getReplicatedMapConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (ReplicatedMapConfig subConfigAsObject : config.getReplicatedMapConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "in-memory-format", subConfigAsObject.getInMemoryFormat().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-fillup", subConfigAsObject.isAsyncFillup());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "entry-listeners", DynamicConfigYamlGenerator.getEntryListenerConfigsAsList(subConfigAsObject.getListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("replicatedmap", child);
    }

    public static void ringbufferYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getRingbufferConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (RingbufferConfig subConfigAsObject : config.getRingbufferConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "capacity", subConfigAsObject.getCapacity());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "time-to-live-seconds", subConfigAsObject.getTimeToLiveSeconds());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "in-memory-format", subConfigAsObject.getInMemoryFormat().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "ringbuffer-store", DynamicConfigYamlGenerator.getRingbufferStoreConfigAsMap(subConfigAsObject.getRingbufferStoreConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("ringbuffer", child);
    }

    public static void topicYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getTopicConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (TopicConfig subConfigAsObject : config.getTopicConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "global-ordering-enabled", subConfigAsObject.isGlobalOrderingEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "message-listeners", DynamicConfigYamlGenerator.getListenerConfigsAsList(subConfigAsObject.getMessageListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "multi-threading-enabled", subConfigAsObject.isMultiThreadingEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("topic", child);
    }

    public static void reliableTopicYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getReliableTopicConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (ReliableTopicConfig subConfigAsObject : config.getReliableTopicConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "read-batch-size", subConfigAsObject.getReadBatchSize());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "topic-overload-policy", subConfigAsObject.getTopicOverloadPolicy().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "message-listeners", DynamicConfigYamlGenerator.getListenerConfigsAsList(subConfigAsObject.getMessageListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("reliable-topic", child);
    }

    public static void executorYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getExecutorConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (ExecutorConfig subConfigAsObject : config.getExecutorConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "pool-size", subConfigAsObject.getPoolSize());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "queue-capacity", subConfigAsObject.getQueueCapacity());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("executor-service", child);
    }

    public static void durableExecutorYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getDurableExecutorConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (DurableExecutorConfig subConfigAsObject : config.getDurableExecutorConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "pool-size", subConfigAsObject.getPoolSize());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "durability", subConfigAsObject.getDurability());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "capacity", subConfigAsObject.getCapacity());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("durable-executor-service", child);
    }

    public static void scheduledExecutorYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getScheduledExecutorConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (ScheduledExecutorConfig subConfigAsObject : config.getScheduledExecutorConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "pool-size", subConfigAsObject.getPoolSize());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "durability", subConfigAsObject.getDurability());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "capacity", subConfigAsObject.getCapacity());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "capacity-policy", subConfigAsObject.getCapacityPolicy().name());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", subConfigAsObject.getUserCodeNamespace());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("scheduled-executor-service", child);
    }

    public static void cardinalityEstimatorYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getCardinalityEstimatorConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (CardinalityEstimatorConfig subConfigAsObject : config.getCardinalityEstimatorConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", subConfigAsObject.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", subConfigAsObject.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(subConfigAsObject.getMergePolicyConfig()));
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("cardinality-estimator", child);
    }

    public static void flakeIdGeneratorYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getFlakeIdGeneratorConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (FlakeIdGeneratorConfig subConfigAsObject : config.getFlakeIdGeneratorConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "prefetch-count", subConfigAsObject.getPrefetchCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "prefetch-validity-millis", subConfigAsObject.getPrefetchValidityMillis());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "epoch-start", subConfigAsObject.getEpochStart());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "node-id-offset", subConfigAsObject.getNodeIdOffset());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "bits-sequence", subConfigAsObject.getBitsSequence());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "bits-node-id", subConfigAsObject.getBitsNodeId());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "allowed-future-millis", subConfigAsObject.getAllowedFutureMillis());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("flake-id-generator", child);
    }

    public static void pnCounterYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getPNCounterConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (PNCounterConfig subConfigAsObject : config.getPNCounterConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "replica-count", subConfigAsObject.getReplicaCount());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", subConfigAsObject.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", subConfigAsObject.isStatisticsEnabled());
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("pn-counter", child);
    }

    public static void dataConnectionYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getDataConnectionConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (DataConnectionConfig dataConnectionConfig : config.getDataConnectionConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "type", dataConnectionConfig.getType());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "shared", dataConnectionConfig.isShared());
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(dataConnectionConfig.getProperties()));
            child.put(dataConnectionConfig.getName(), subConfigAsMap);
        }
        parent.put("data-connection", child);
    }

    public static void wanReplicationYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getWanReplicationConfigs().isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        for (WanReplicationConfig subConfigAsObject : config.getWanReplicationConfigs().values()) {
            LinkedHashMap subConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "batch-publisher", DynamicConfigYamlGenerator.getWanBatchPublisherConfigsAsMap(subConfigAsObject.getBatchPublisherConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "custom-publisher", DynamicConfigYamlGenerator.getWanCustomPublisherConfigsAsMap(subConfigAsObject.getCustomPublisherConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "consumer", DynamicConfigYamlGenerator.getWanConsumerConfigsAsMap(subConfigAsObject.getConsumerConfig()));
            child.put(subConfigAsObject.getName(), subConfigAsMap);
        }
        parent.put("wan-replication", child);
    }

    private void networkConfigYamlGenerator(Map<String, Object> parent, Config config) {
        if (config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        NetworkConfig netCfg = config.getNetworkConfig();
        DynamicConfigYamlGenerator.addNonNullToMap(child, "public-address", netCfg.getPublicAddress());
        LinkedHashMap portCfg = new LinkedHashMap();
        DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "port", netCfg.getPort());
        DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "port-count", netCfg.getPortCount());
        DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "auto-increment", netCfg.isPortAutoIncrement());
        child.put("port", portCfg);
        DynamicConfigYamlGenerator.addNonNullToMap(child, "reuse-address", netCfg.isReuseAddress());
        Collection<String> outboundPortDefinitions = netCfg.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            child.put("outbound-ports", new ArrayList<String>(outboundPortDefinitions));
        }
        JoinConfig join = netCfg.getJoin();
        LinkedHashMap<String, Object> joinSubConfig = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.autoDetectionConfigYamlGenerator(joinSubConfig, join);
        DynamicConfigYamlGenerator.multicastConfigYamlGenerator(joinSubConfig, join);
        DynamicConfigYamlGenerator.tcpIpConfigYamlGenerator(joinSubConfig, config);
        DynamicConfigYamlGenerator.aliasedDiscoveryConfigsYamlGenerator(joinSubConfig, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        DynamicConfigYamlGenerator.discoveryStrategyConfigYamlGenerator(joinSubConfig, join.getDiscoveryConfig());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "join", joinSubConfig);
        DynamicConfigYamlGenerator.interfacesConfigYamlGenerator(child, netCfg.getInterfaces());
        DynamicConfigYamlGenerator.sslConfigYamlGenerator(child, netCfg.getSSLConfig());
        DynamicConfigYamlGenerator.socketInterceptorConfigYamlGenerator(child, netCfg.getSocketInterceptorConfig());
        DynamicConfigYamlGenerator.symmetricEncInterceptorConfigYamlGenerator(child, netCfg.getSymmetricEncryptionConfig());
        DynamicConfigYamlGenerator.memberAddressProviderConfigYamlGenerator(child, netCfg.getMemberAddressProviderConfig());
        DynamicConfigYamlGenerator.failureDetectorConfigYamlGenerator(child, netCfg.getIcmpFailureDetectorConfig());
        DynamicConfigYamlGenerator.restApiYamlGenerator(child, netCfg.getRestApiConfig());
        DynamicConfigYamlGenerator.memcacheProtocolYamlGenerator(child, netCfg.getMemcacheProtocolConfig());
        parent.put("network", child);
    }

    private void advancedNetworkConfigYamlGenerator(Map<String, Object> parent, Config config) {
        AdvancedNetworkConfig netCfg = config.getAdvancedNetworkConfig();
        if (!netCfg.isEnabled()) {
            return;
        }
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        child.put("enabled", netCfg.isEnabled());
        JoinConfig join = netCfg.getJoin();
        LinkedHashMap<String, Object> joinSubConfig = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.autoDetectionConfigYamlGenerator(joinSubConfig, join);
        DynamicConfigYamlGenerator.multicastConfigYamlGenerator(joinSubConfig, join);
        DynamicConfigYamlGenerator.tcpIpConfigYamlGenerator(joinSubConfig, config);
        DynamicConfigYamlGenerator.aliasedDiscoveryConfigsYamlGenerator(joinSubConfig, AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(join));
        DynamicConfigYamlGenerator.discoveryStrategyConfigYamlGenerator(joinSubConfig, join.getDiscoveryConfig());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "join", joinSubConfig);
        DynamicConfigYamlGenerator.failureDetectorConfigYamlGenerator(child, netCfg.getIcmpFailureDetectorConfig());
        DynamicConfigYamlGenerator.memberAddressProviderConfigYamlGenerator(child, netCfg.getMemberAddressProviderConfig());
        for (EndpointConfig endpointConfig : netCfg.getEndpointConfigs().values()) {
            DynamicConfigYamlGenerator.endpointConfigYamlGenerator(child, endpointConfig);
        }
        parent.put("advanced-network", child);
    }

    public static void tcpIpConfigYamlGenerator(Map<String, Object> parent, Config config) {
        TcpIpConfig tcpIpConfig = ConfigAccessor.getActiveMemberNetworkConfig(config).getJoin().getTcpIpConfig();
        LinkedHashMap<String, Comparable<Boolean>> child = new LinkedHashMap<String, Comparable<Boolean>>();
        child.put("enabled", Boolean.valueOf(tcpIpConfig.isEnabled()));
        child.put("connection-timeout-seconds", Integer.valueOf(tcpIpConfig.getConnectionTimeoutSeconds()));
        DynamicConfigYamlGenerator.addNonNullToMap(child, "member-list", tcpIpConfig.getMembers());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "required-member", tcpIpConfig.getRequiredMember());
        parent.put("tcp-ip", child);
    }

    private static void autoDetectionConfigYamlGenerator(Map<String, Object> parent, JoinConfig joinConfig) {
        LinkedHashMap<String, Boolean> child = new LinkedHashMap<String, Boolean>();
        child.put("enabled", joinConfig.getAutoDetectionConfig().isEnabled());
        parent.put("auto-detection", child);
    }

    private static void multicastConfigYamlGenerator(Map<String, Object> parent, JoinConfig joinConfig) {
        LinkedHashMap child = new LinkedHashMap();
        MulticastConfig multicastCfg = joinConfig.getMulticastConfig();
        if (multicastCfg == null) {
            return;
        }
        DynamicConfigYamlGenerator.addNonNullToMap(child, "enabled", multicastCfg.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "loopback-mode-enabled", multicastCfg.getLoopbackModeEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "multicast-group", multicastCfg.getMulticastGroup());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "multicast-port", multicastCfg.getMulticastPort());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "multicast-timeout-seconds", multicastCfg.getMulticastTimeoutSeconds());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "multicast-time-to-live", multicastCfg.getMulticastTimeToLive());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "trusted-interfaces", new ArrayList<String>(multicastCfg.getTrustedInterfaces()));
        parent.put("multicast", child);
    }

    private static void aliasedDiscoveryConfigsYamlGenerator(Map<String, Object> parent, List<AliasedDiscoveryConfig<?>> configs) {
        if (configs == null) {
            return;
        }
        for (AliasedDiscoveryConfig<?> c : configs) {
            LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
            child.put("enabled", c.isEnabled());
            if (c.isUsePublicIp()) {
                child.put("use-public-ip", "true");
            }
            if (!c.getProperties().isEmpty()) {
                child.put("properties", c.getProperties());
            }
            parent.put(AliasedDiscoveryConfigUtils.tagFor(c), child);
        }
    }

    private static void discoveryStrategyConfigYamlGenerator(Map<String, Object> parent, DiscoveryConfig discoveryConfig) {
        Collection<DiscoveryStrategyConfig> configs;
        if (discoveryConfig == null) {
            return;
        }
        LinkedHashMap<String, Map<String, Object>> child = new LinkedHashMap<String, Map<String, Object>>();
        String nodeFilterClass = DynamicConfigXmlGenerator.classNameOrImplClass(discoveryConfig.getNodeFilterClass(), discoveryConfig.getNodeFilter());
        if (nodeFilterClass != null) {
            child.put("node-filter", DynamicConfigYamlGenerator.wrapObjectWithMap("class", nodeFilterClass));
        }
        if (CollectionUtil.isNotEmpty(configs = discoveryConfig.getDiscoveryStrategyConfigs())) {
            for (DiscoveryStrategyConfig config : configs) {
                LinkedHashMap discoveryStrategySubConfig = new LinkedHashMap();
                DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategySubConfig, "class", DynamicConfigXmlGenerator.classNameOrImplClass(config.getClassName(), config.getDiscoveryStrategyFactory()));
                DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategySubConfig, "enabled", DynamicConfigXmlGenerator.classNameOrImplClass(config.getClassName(), config.getDiscoveryStrategyFactory()));
                DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategySubConfig, "properties", config.getProperties());
                child.put("discovery-strategy", discoveryStrategySubConfig);
            }
        }
        parent.put("discovery-strategies", child);
    }

    private static void sslConfigYamlGenerator(Map<String, Object> parent, SSLConfig sslConfig) {
        if (sslConfig == null) {
            return;
        }
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        sslConfig = new SSLConfig(sslConfig);
        child.put("enabled", sslConfig.isEnabled());
        String factoryClassName = DynamicConfigXmlGenerator.classNameOrImplClass(sslConfig.getFactoryClassName(), sslConfig.getFactoryImplementation());
        if (factoryClassName != null) {
            sslConfig.setFactoryClassName(factoryClassName);
            child.put("factory-class-name", factoryClassName);
        }
        Properties props = sslConfig.getProperties();
        if (maskSensitiveFields && props.containsKey("trustStorePassword")) {
            props.setProperty("trustStorePassword", "****");
        }
        if (maskSensitiveFields && props.containsKey("keyStorePassword")) {
            props.setProperty("keyStorePassword", "****");
        }
        DynamicConfigYamlGenerator.addNonNullToMap(child, "properties", props);
        parent.put("ssl", child);
    }

    private static void interfacesConfigYamlGenerator(Map<String, Object> parent, InterfacesConfig interfaces) {
        if (interfaces.getInterfaces() == null || interfaces.getInterfaces().isEmpty()) {
            return;
        }
        LinkedHashMap<String, Serializable> child = new LinkedHashMap<String, Serializable>();
        child.put("enabled", Boolean.valueOf(interfaces.isEnabled()));
        child.put("interfaces", new ArrayList<String>(interfaces.getInterfaces()));
        parent.put("interfaces", child);
    }

    private static void socketInterceptorConfigYamlGenerator(Map<String, Object> parent, SocketInterceptorConfig socketInterceptorCfg) {
        if (socketInterceptorCfg == null) {
            return;
        }
        LinkedHashMap<String, Boolean> child = new LinkedHashMap<String, Boolean>();
        child.put("enabled", socketInterceptorCfg.isEnabled());
        String className = DynamicConfigXmlGenerator.classNameOrImplClass(socketInterceptorCfg.getClassName(), socketInterceptorCfg.getImplementation());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "class-name", className);
        DynamicConfigYamlGenerator.addNonNullToMap(child, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(socketInterceptorCfg.getProperties()));
        parent.put("socket-interceptor", child);
    }

    private static void symmetricEncInterceptorConfigYamlGenerator(Map<String, Object> parent, SymmetricEncryptionConfig sec) {
        if (sec == null) {
            return;
        }
        LinkedHashMap<String, Boolean> child = new LinkedHashMap<String, Boolean>();
        child.put("enabled", sec.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "algorithm", sec.getAlgorithm());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "salt", DynamicConfigYamlGenerator.getOrMaskValue(sec.getSalt()));
        DynamicConfigYamlGenerator.addNonNullToMap(child, "password", DynamicConfigYamlGenerator.getOrMaskValue(sec.getPassword()));
        DynamicConfigYamlGenerator.addNonNullToMap(child, "iteration-count", sec.getIterationCount());
        parent.put("symmetric-encryption", child);
    }

    private static void memberAddressProviderConfigYamlGenerator(Map<String, Object> parent, MemberAddressProviderConfig memberAddressProviderConfig) {
        if (memberAddressProviderConfig == null) {
            return;
        }
        String className = DynamicConfigXmlGenerator.classNameOrImplClass(memberAddressProviderConfig.getClassName(), memberAddressProviderConfig.getImplementation());
        if (StringUtil.isNullOrEmpty(className)) {
            return;
        }
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        child.put("enabled", memberAddressProviderConfig.isEnabled());
        child.put("class-name", className);
        DynamicConfigYamlGenerator.addNonNullToMap(child, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(memberAddressProviderConfig.getProperties()));
        parent.put("member-address-provider", child);
    }

    private static void failureDetectorConfigYamlGenerator(Map<String, Object> parent, IcmpFailureDetectorConfig icmpFailureDetectorConfig) {
        if (icmpFailureDetectorConfig == null) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        DynamicConfigYamlGenerator.addNonNullToMap(child, "enabled", icmpFailureDetectorConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "timeout-milliseconds", icmpFailureDetectorConfig.getTimeoutMilliseconds());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "fail-fast-on-startup", icmpFailureDetectorConfig.isFailFastOnStartup());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "interval-milliseconds", icmpFailureDetectorConfig.getIntervalMilliseconds());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "max-attempts", icmpFailureDetectorConfig.getMaxAttempts());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "parallel-mode", icmpFailureDetectorConfig.isParallelMode());
        DynamicConfigYamlGenerator.addNonNullToMap(child, "ttl", icmpFailureDetectorConfig.getTtl());
        parent.put("failure-detector", DynamicConfigYamlGenerator.wrapObjectWithMap("icmp", child));
    }

    private static void restApiYamlGenerator(Map<String, Object> parent, RestApiConfig restApiConfig) {
        if (restApiConfig == null) {
            return;
        }
        LinkedHashMap<String, Serializable> child = new LinkedHashMap<String, Serializable>();
        child.put("enabled", Boolean.valueOf(restApiConfig.isEnabled()));
        LinkedHashMap<String, Map<String, Object>> endpointGroupsAsMap = new LinkedHashMap<String, Map<String, Object>>();
        Set<RestEndpointGroup> enabledGroups = restApiConfig.getEnabledGroups();
        for (RestEndpointGroup endpointGroup : RestEndpointGroup.getAllEndpointGroups()) {
            endpointGroupsAsMap.put(endpointGroup.name(), DynamicConfigYamlGenerator.wrapObjectWithMap("enabled", enabledGroups.stream().anyMatch(enabledGroup -> enabledGroup.getCode() == endpointGroup.getCode())));
        }
        child.put("endpoint-groups", endpointGroupsAsMap);
        parent.put("rest-api", child);
    }

    private static void memcacheProtocolYamlGenerator(Map<String, Object> parent, MemcacheProtocolConfig memcacheProtocolConfig) {
        if (memcacheProtocolConfig == null) {
            return;
        }
        parent.put("memcache-protocol", DynamicConfigYamlGenerator.wrapObjectWithMap("enabled", memcacheProtocolConfig.isEnabled()));
    }

    private static void endpointConfigYamlGenerator(Map<String, Object> parent, EndpointConfig endpointConfig) {
        Collection<String> outboundPortDefinitions;
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        if (endpointConfig.getName() != null && endpointConfig.getProtocolType() != ProtocolType.WAN) {
            child.put("name", endpointConfig.getName());
        }
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions = endpointConfig.getOutboundPortDefinitions())) {
            DynamicConfigYamlGenerator.addNonNullToMap(child, "outbound-ports", new ArrayList<String>(outboundPortDefinitions));
        }
        DynamicConfigYamlGenerator.interfacesConfigYamlGenerator(child, endpointConfig.getInterfaces());
        DynamicConfigYamlGenerator.sslConfigYamlGenerator(child, endpointConfig.getSSLConfig());
        DynamicConfigYamlGenerator.socketInterceptorConfigYamlGenerator(child, endpointConfig.getSocketInterceptorConfig());
        DynamicConfigYamlGenerator.symmetricEncInterceptorConfigYamlGenerator(child, endpointConfig.getSymmetricEncryptionConfig());
        if (endpointConfig instanceof RestServerEndpointConfig) {
            RestServerEndpointConfig restServerEndpointConfig = (RestServerEndpointConfig)endpointConfig;
            LinkedHashMap<String, Map<String, Object>> endpointGroupsAsMap = new LinkedHashMap<String, Map<String, Object>>();
            Set<RestEndpointGroup> enabledGroups = restServerEndpointConfig.getEnabledGroups();
            for (RestEndpointGroup endpointGroup : RestEndpointGroup.getAllEndpointGroups()) {
                endpointGroupsAsMap.put(endpointGroup.name(), DynamicConfigYamlGenerator.wrapObjectWithMap("enabled", enabledGroups.stream().anyMatch(enabledGroup -> enabledGroup.getCode() == endpointGroup.getCode())));
            }
            child.put("endpoint-groups", endpointGroupsAsMap);
        }
        LinkedHashMap socketOptions = new LinkedHashMap();
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "buffer-direct", endpointConfig.isSocketBufferDirect());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "tcp-no-delay", endpointConfig.isSocketTcpNoDelay());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "keep-alive", endpointConfig.isSocketKeepAlive());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "connect-timeout-seconds", endpointConfig.getSocketConnectTimeoutSeconds());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "send-buffer-size-kb", endpointConfig.getSocketSendBufferSizeKb());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "receive-buffer-size-kb", endpointConfig.getSocketRcvBufferSizeKb());
        DynamicConfigYamlGenerator.addNonNullToMap(socketOptions, "linger-seconds", endpointConfig.getSocketLingerSeconds());
        if (!socketOptions.isEmpty()) {
            DynamicConfigYamlGenerator.addNonNullToMap(child, "socket-options", socketOptions);
        }
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            ServerSocketEndpointConfig serverSocketEndpointConfig = (ServerSocketEndpointConfig)endpointConfig;
            LinkedHashMap portCfg = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "port", serverSocketEndpointConfig.getPort());
            DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "port-count", serverSocketEndpointConfig.getPortCount());
            DynamicConfigYamlGenerator.addNonNullToMap(portCfg, "auto-increment", serverSocketEndpointConfig.isPortAutoIncrement());
            DynamicConfigYamlGenerator.addNonNullToMap(child, "public-address", serverSocketEndpointConfig.getPublicAddress());
            DynamicConfigYamlGenerator.addNonNullToMap(child, "reuse-address", serverSocketEndpointConfig.isReuseAddress());
            DynamicConfigYamlGenerator.addNonNullToMap(child, "port", portCfg);
        }
        if (endpointConfig.getName() != null && endpointConfig.getProtocolType() == ProtocolType.WAN) {
            parent.put(ConfigXmlGenerator.endpointConfigElementName(endpointConfig), DynamicConfigYamlGenerator.wrapObjectWithMap(endpointConfig.getName(), child));
        } else {
            parent.put(ConfigXmlGenerator.endpointConfigElementName(endpointConfig), child);
        }
    }

    static Map<String, Object> javaSerializationFilterGenerator(JavaSerializationFilterConfig jsfConfig) {
        LinkedHashMap<String, Object> javaSerializationFilterCfg = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(javaSerializationFilterCfg, "defaults-disabled", jsfConfig.isDefaultsDisabled());
        Map<String, Object> whiteListAsMap = DynamicConfigYamlGenerator.classFilterGenerator(jsfConfig.getWhitelist());
        Map<String, Object> blackListAsMap = DynamicConfigYamlGenerator.classFilterGenerator(jsfConfig.getBlacklist());
        javaSerializationFilterCfg.put("blacklist", blackListAsMap);
        javaSerializationFilterCfg.put("whitelist", whiteListAsMap);
        return javaSerializationFilterCfg;
    }

    static Map<String, Object> classFilterGenerator(ClassFilter classFilter) {
        if (classFilter == null || classFilter.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> classFilterMap = new LinkedHashMap<String, Object>();
        ArrayList<String> packagesAsList = new ArrayList<String>();
        ArrayList<String> classesAsList = new ArrayList<String>();
        ArrayList<String> prefixesAsList = new ArrayList<String>();
        for (String p : classFilter.getPackages()) {
            packagesAsList.add(p);
        }
        for (String c : classFilter.getClasses()) {
            classesAsList.add(c);
        }
        for (String p : classFilter.getPrefixes()) {
            prefixesAsList.add(p);
        }
        classFilterMap.put("package", packagesAsList);
        classFilterMap.put("class", classesAsList);
        classFilterMap.put("prefix", prefixesAsList);
        return classFilterMap;
    }

    public static void namespacesConfigGenerator(Map<String, Object> parent, Config config) {
        LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
        UserCodeNamespacesConfig userCodeNamespacesConfig = config.getNamespacesConfig();
        DynamicConfigYamlGenerator.addNonNullToMap(child, "enabled", userCodeNamespacesConfig.isEnabled());
        parent.put("user-code-namespaces", child);
        if (userCodeNamespacesConfig.getClassFilterConfig() != null) {
            Map<String, Object> javaSerializationFilterCfg = DynamicConfigYamlGenerator.javaSerializationFilterGenerator(userCodeNamespacesConfig.getClassFilterConfig());
            DynamicConfigYamlGenerator.addNonNullToMap(child, "class-filter", javaSerializationFilterCfg);
        }
        DynamicConfigYamlGenerator.namespaceConfigGenerator(child, config);
    }

    public static void namespaceConfigGenerator(Map<String, Object> parent, Config config) {
        ConfigAccessor.getNamespaceConfigs(config.getNamespacesConfig()).forEach((namespaceName, namespaceConfig) -> {
            ArrayList items = new ArrayList();
            for (ResourceDefinition resourceDefinition : ConfigAccessor.getResourceDefinitions(namespaceConfig)) {
                LinkedHashMap<String, String> subConfigAsMap = new LinkedHashMap<String, String>();
                subConfigAsMap.put("id", resourceDefinition.id());
                subConfigAsMap.put("resource-type", resourceDefinition.type().toString());
                subConfigAsMap.put("url", resourceDefinition.url());
                items.add(subConfigAsMap);
            }
            parent.put((String)namespaceName, items);
        });
    }

    private static void metricsConfigGenerator(Map<String, Object> parent, Config config) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        LinkedHashMap<String, Serializable> child = new LinkedHashMap<String, Serializable>();
        parent.put("metrics", child);
        child.put("enabled", Boolean.valueOf(metricsConfig.isEnabled()));
        if (!metricsConfig.isEnabled()) {
            return;
        }
        DynamicConfigYamlGenerator.addNonNullToMap(child, "collection-frequency-seconds", metricsConfig.getCollectionFrequencySeconds());
        if (metricsConfig.getJmxConfig().isEnabled()) {
            LinkedHashMap<String, Boolean> jmxMap = new LinkedHashMap<String, Boolean>(1);
            jmxMap.put("enabled", metricsConfig.getJmxConfig().isEnabled());
            child.put("jmx", jmxMap);
        }
        if (metricsConfig.getManagementCenterConfig().isEnabled()) {
            LinkedHashMap<String, Boolean> mcMap = new LinkedHashMap<String, Boolean>(1);
            mcMap.put("enabled", metricsConfig.getManagementCenterConfig().isEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(mcMap, "retention-seconds", metricsConfig.getManagementCenterConfig().getRetentionSeconds());
            child.put("management-center", mcMap);
        }
    }

    private static void splitBrainProtectionConfigsGenerator(Map<String, Object> parent, Config config) {
        Map<String, SplitBrainProtectionConfig> splitBrainProtectionConfigs = config.getSplitBrainProtectionConfigs();
        if (splitBrainProtectionConfigs.isEmpty()) {
            return;
        }
        LinkedHashMap child = new LinkedHashMap();
        parent.put("split-brain-protection", child);
        for (Map.Entry<String, SplitBrainProtectionConfig> entry : splitBrainProtectionConfigs.entrySet()) {
            LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
            child.put(entry.getKey(), configMap);
            DynamicConfigYamlGenerator.addNonNullToMap(configMap, "enabled", entry.getValue().isEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(configMap, "minimum-cluster-size", entry.getValue().getMinimumClusterSize());
            if (entry.getValue().getProtectOn() != null) {
                configMap.put("protect-on", entry.getValue().getProtectOn().name());
            }
            DynamicConfigYamlGenerator.addNonNullToMap(configMap, "function-class-name", entry.getValue().getFunctionClassName());
            if (entry.getValue().getListenerConfigs().isEmpty()) continue;
            ArrayList<String> listenersList = new ArrayList<String>(entry.getValue().getListenerConfigs().size());
            for (SplitBrainProtectionListenerConfig listenerConfig : entry.getValue().getListenerConfigs()) {
                listenersList.add(listenerConfig.getClassName());
            }
            configMap.put("listeners", listenersList);
        }
    }

    public static void vectorCollectionYamlGenerator(Map<String, Object> parent, Config config) {
        Map<String, Map> vectorsConfigAsMap = config.getVectorCollectionConfigs().values().stream().collect(Collectors.toMap(VectorCollectionConfig::getName, entry -> {
            LinkedHashMap vectorConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "backup-count", entry.getBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "async-backup-count", entry.getAsyncBackupCount());
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "user-code-namespace", entry.getUserCodeNamespace());
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "split-brain-protection-ref", entry.getSplitBrainProtectionName());
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(entry.getMergePolicyConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(vectorConfigAsMap, "indexes", DynamicConfigYamlGenerator.vectorIndexesToList(entry.getVectorIndexConfigs()));
            return vectorConfigAsMap;
        }));
        parent.put("vector-collection", vectorsConfigAsMap);
    }

    private static List<Map<String, Object>> vectorIndexesToList(List<VectorIndexConfig> vectorIndexesConfigs) {
        return vectorIndexesConfigs.stream().map(entry -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("metric", entry.getMetric().name());
            map.put("dimension", entry.getDimension());
            DynamicConfigYamlGenerator.addNonNullToMap(map, "name", entry.getName());
            DynamicConfigYamlGenerator.addNonNullToMap(map, "max-degree", entry.getMaxDegree());
            DynamicConfigYamlGenerator.addNonNullToMap(map, "ef-construction", entry.getEfConstruction());
            DynamicConfigYamlGenerator.addNonNullToMap(map, "use-deduplication", entry.isUseDeduplication());
            return map;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> getWanConsumerConfigsAsMap(WanConsumerConfig wanConsumerConfig) {
        if (wanConsumerConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> wanConsumerConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(wanConsumerConfigAsMap, "class-name", DynamicConfigXmlGenerator.classNameOrImplClass(wanConsumerConfig.getClassName(), wanConsumerConfig.getImplementation()));
        DynamicConfigYamlGenerator.addNonNullToMap(wanConsumerConfigAsMap, "persist-wan-replicated-data", wanConsumerConfig.isPersistWanReplicatedData());
        DynamicConfigYamlGenerator.addNonNullToMap(wanConsumerConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(wanConsumerConfig.getProperties()));
        return wanConsumerConfigAsMap;
    }

    private static Map<String, Object> getWanCustomPublisherConfigsAsMap(List<WanCustomPublisherConfig> wanCustomPublisherConfigs) {
        if (wanCustomPublisherConfigs == null || wanCustomPublisherConfigs.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> wanBatchPublisherConfigsAsMap = new LinkedHashMap<String, Object>();
        for (WanCustomPublisherConfig wanCustomPublisherConfig : wanCustomPublisherConfigs) {
            LinkedHashMap wanCustomPublisherConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(wanCustomPublisherConfigAsMap, "class-name", wanCustomPublisherConfig.getClassName());
            DynamicConfigYamlGenerator.addNonNullToMap(wanCustomPublisherConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(wanCustomPublisherConfig.getProperties()));
            wanBatchPublisherConfigsAsMap.put(wanCustomPublisherConfig.getPublisherId(), wanCustomPublisherConfigAsMap);
        }
        return wanBatchPublisherConfigsAsMap;
    }

    private static Map<String, Object> getWanBatchPublisherConfigsAsMap(List<WanBatchPublisherConfig> wanBatchPublisherConfigs) {
        if (wanBatchPublisherConfigs == null || wanBatchPublisherConfigs.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> wanBatchPublisherConfigsAsMap = new LinkedHashMap<String, Object>();
        for (WanBatchPublisherConfig wanBatchPublisherConfig : wanBatchPublisherConfigs) {
            LinkedHashMap wanBatchPublisherConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "cluster-name", wanBatchPublisherConfig.getClusterName());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "publisher-id", wanBatchPublisherConfig.getPublisherId());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "batch-size", wanBatchPublisherConfig.getBatchSize());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "batch-max-delay-millis", wanBatchPublisherConfig.getBatchMaxDelayMillis());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "response-timeout-millis", wanBatchPublisherConfig.getResponseTimeoutMillis());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "acknowledge-type", wanBatchPublisherConfig.getAcknowledgeType().name());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "initial-publisher-state", wanBatchPublisherConfig.getInitialPublisherState().name());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "snapshot-enabled", wanBatchPublisherConfig.isSnapshotEnabled());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "idle-max-park-ns", wanBatchPublisherConfig.getIdleMaxParkNs());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "idle-min-park-ns", wanBatchPublisherConfig.getIdleMinParkNs());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "max-concurrent-invocations", wanBatchPublisherConfig.getMaxConcurrentInvocations());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "discovery-period-seconds", wanBatchPublisherConfig.getDiscoveryPeriodSeconds());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "use-endpoint-private-address", wanBatchPublisherConfig.isUseEndpointPrivateAddress());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "queue-full-behavior", wanBatchPublisherConfig.getQueueFullBehavior().name());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "max-target-endpoints", wanBatchPublisherConfig.getMaxTargetEndpoints());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "queue-capacity", wanBatchPublisherConfig.getQueueCapacity());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(wanBatchPublisherConfig.getProperties()));
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "target-endpoints", wanBatchPublisherConfig.getTargetEndpoints());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "endpoint", wanBatchPublisherConfig.getEndpoint());
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "sync", DynamicConfigYamlGenerator.wrapObjectWithMap("consistency-check-strategy", wanBatchPublisherConfig.getSyncConfig().getConsistencyCheckStrategy().name()));
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "discovery-strategies", DynamicConfigYamlGenerator.getDiscoveryConfigAsMap(wanBatchPublisherConfig.getDiscoveryConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, "discovery-strategies", DynamicConfigYamlGenerator.getDiscoveryConfigAsMap(wanBatchPublisherConfig.getDiscoveryConfig()));
            for (AliasedDiscoveryConfig<?> aliasedDiscoveryConfig : AliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(wanBatchPublisherConfig)) {
                DynamicConfigYamlGenerator.addNonNullToMap(wanBatchPublisherConfigAsMap, aliasedDiscoveryConfig.getTag(), DynamicConfigYamlGenerator.getAliasedDiscoveryConfigAsMap(aliasedDiscoveryConfig));
            }
            wanBatchPublisherConfigsAsMap.put(wanBatchPublisherConfig.getPublisherId(), wanBatchPublisherConfigAsMap);
        }
        return wanBatchPublisherConfigsAsMap;
    }

    private static Map<String, Object> getAliasedDiscoveryConfigAsMap(AliasedDiscoveryConfig<?> aliasedDiscoveryConfig) {
        if (aliasedDiscoveryConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> aliasedDiscoveryConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(aliasedDiscoveryConfigAsMap, "enabled", aliasedDiscoveryConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(aliasedDiscoveryConfigAsMap, "use-public-ip", aliasedDiscoveryConfig.isUsePublicIp());
        for (String key : aliasedDiscoveryConfig.getProperties().keySet()) {
            DynamicConfigYamlGenerator.addNonNullToMap(aliasedDiscoveryConfigAsMap, key, aliasedDiscoveryConfig.getProperties().get(key));
        }
        return aliasedDiscoveryConfigAsMap;
    }

    private static Map<String, Object> getDiscoveryConfigAsMap(DiscoveryConfig discoveryConfig) {
        if (discoveryConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> discoveryConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(discoveryConfigAsMap, "node-filter", DynamicConfigYamlGenerator.wrapObjectWithMap("class", DynamicConfigXmlGenerator.classNameOrImplClass(discoveryConfig.getNodeFilterClass(), discoveryConfig.getNodeFilter())));
        LinkedList discoveryStrategyConfigsAsList = new LinkedList();
        for (DiscoveryStrategyConfig discoveryStrategyConfig : discoveryConfig.getDiscoveryStrategyConfigs()) {
            LinkedHashMap discoveryStrategyConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategyConfigAsMap, "enabled", "true");
            DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategyConfigAsMap, "class", DynamicConfigXmlGenerator.classNameOrImplClass(discoveryStrategyConfig.getClassName(), discoveryStrategyConfig.getDiscoveryStrategyFactory()));
            DynamicConfigYamlGenerator.addNonNullToMap(discoveryStrategyConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(discoveryStrategyConfig.getProperties()));
            discoveryStrategyConfigsAsList.add(discoveryStrategyConfigAsMap);
        }
        DynamicConfigYamlGenerator.addNonNullToMap(discoveryConfigAsMap, "discovery-strategies", discoveryStrategyConfigsAsList);
        return discoveryConfigAsMap;
    }

    private static Map<String, Object> getTieredStoreConfigAsMap(TieredStoreConfig tieredStoreConfig) {
        if (tieredStoreConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> tieredStoreConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(tieredStoreConfigAsMap, "enabled", tieredStoreConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(tieredStoreConfigAsMap, "memory-tier", DynamicConfigYamlGenerator.getMemoryTierConfigAsMap(tieredStoreConfig.getMemoryTierConfig()));
        DynamicConfigYamlGenerator.addNonNullToMap(tieredStoreConfigAsMap, "disk-tier", DynamicConfigYamlGenerator.getDiskTierConfigAsMap(tieredStoreConfig.getDiskTierConfig()));
        return tieredStoreConfigAsMap;
    }

    private static Map<String, Object> getMemoryTierConfigAsMap(MemoryTierConfig memoryTierConfig) {
        if (memoryTierConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> memoryTierConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(memoryTierConfigAsMap, "capacity", DynamicConfigYamlGenerator.getCapacityAsMap(memoryTierConfig.getCapacity()));
        return memoryTierConfigAsMap;
    }

    private static Map<String, Object> getCapacityAsMap(Capacity capacity) {
        if (capacity == null) {
            return null;
        }
        LinkedHashMap<String, Object> capacityAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(capacityAsMap, "unit", capacity.getUnit().toString());
        DynamicConfigYamlGenerator.addNonNullToMap(capacityAsMap, "value", String.valueOf(capacity.getValue()));
        return capacityAsMap;
    }

    private static Map<String, Object> getDiskTierConfigAsMap(DiskTierConfig diskTierConfig) {
        if (diskTierConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> diskTierConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(diskTierConfigAsMap, "enabled", diskTierConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(diskTierConfigAsMap, "device-name", diskTierConfig.getDeviceName());
        return diskTierConfigAsMap;
    }

    private static String getPartitioningStrategyAsString(PartitioningStrategyConfig partitioningStrategyConfig) {
        if (partitioningStrategyConfig == null) {
            return null;
        }
        return DynamicConfigXmlGenerator.classNameOrImplClass(partitioningStrategyConfig.getPartitioningStrategyClass(), partitioningStrategyConfig.getPartitioningStrategy());
    }

    private static List<Map<String, Object>> getPartitioningAttributesAsList(List<PartitioningAttributeConfig> attributeConfigs) {
        if (attributeConfigs == null || attributeConfigs.isEmpty()) {
            return null;
        }
        return attributeConfigs.stream().map(DynamicConfigYamlGenerator::getPartitionAttributeAsMap).collect(Collectors.toList());
    }

    private static Map<String, Object> getPartitionAttributeAsMap(PartitioningAttributeConfig config) {
        LinkedHashMap<String, Object> configAsMap = new LinkedHashMap<String, Object>();
        configAsMap.put("name", config.getAttributeName());
        return configAsMap;
    }

    private static Map<String, Object> getPredicateConfigAsMap(PredicateConfig predicateConfig) {
        if (predicateConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> predicateConfigAsMap = new LinkedHashMap<String, Object>();
        String type = predicateConfig.getClassName() != null ? "class-name" : "sql";
        String content = predicateConfig.getClassName() != null ? predicateConfig.getClassName() : predicateConfig.getSql();
        DynamicConfigYamlGenerator.addNonNullToMap(predicateConfigAsMap, type, content);
        return predicateConfigAsMap;
    }

    private static Map<String, Object> getQueryCacheConfigsAsMap(List<QueryCacheConfig> queryCacheConfigs) {
        if (queryCacheConfigs == null || queryCacheConfigs.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> queryCacheConfigsAsMap = new LinkedHashMap<String, Object>();
        for (QueryCacheConfig queryCacheConfig : queryCacheConfigs) {
            LinkedHashMap queryCacheConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "include-value", queryCacheConfig.isIncludeValue());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "in-memory-format", queryCacheConfig.getInMemoryFormat().name());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "populate", queryCacheConfig.isPopulate());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "coalesce", queryCacheConfig.isCoalesce());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "delay-seconds", queryCacheConfig.getDelaySeconds());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "batch-size", queryCacheConfig.getBatchSize());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "buffer-size", queryCacheConfig.getBufferSize());
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "eviction", DynamicConfigYamlGenerator.getEvictionConfigAsMap(queryCacheConfig.getEvictionConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "indexes", DynamicConfigYamlGenerator.getIndexConfigsAsList(queryCacheConfig.getIndexConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "predicate", DynamicConfigYamlGenerator.getPredicateConfigAsMap(queryCacheConfig.getPredicateConfig()));
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "entry-listeners", DynamicConfigYamlGenerator.getEntryListenerConfigsAsList(queryCacheConfig.getEntryListenerConfigs()));
            DynamicConfigYamlGenerator.addNonNullToMap(queryCacheConfigAsMap, "serialize-keys", queryCacheConfig.isSerializeKeys());
            queryCacheConfigsAsMap.put(queryCacheConfig.getName(), queryCacheConfigAsMap);
        }
        return queryCacheConfigsAsMap;
    }

    private static Map<String, Object> getAttributeConfigsAsMap(List<AttributeConfig> attributeConfigs) {
        if (attributeConfigs == null || attributeConfigs.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> attributeConfigsAsMap = new LinkedHashMap<String, Object>();
        for (AttributeConfig attributeConfig : attributeConfigs) {
            DynamicConfigYamlGenerator.addNonNullToMap(attributeConfigsAsMap, attributeConfig.getName(), DynamicConfigYamlGenerator.wrapObjectWithMap("extractor-class-name", attributeConfig.getExtractorClassName()));
        }
        return attributeConfigsAsMap;
    }

    private static List<Map<String, Object>> getIndexConfigsAsList(List<IndexConfig> indexConfigs) {
        if (indexConfigs == null || indexConfigs.isEmpty()) {
            return null;
        }
        LinkedList<Map<String, Object>> indexConfigsAsList = new LinkedList<Map<String, Object>>();
        for (IndexConfig indexConfig : indexConfigs) {
            LinkedHashMap indexConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(indexConfigAsMap, "name", indexConfig.getName());
            DynamicConfigYamlGenerator.addNonNullToMap(indexConfigAsMap, "type", indexConfig.getType().name());
            DynamicConfigYamlGenerator.addNonNullToMap(indexConfigAsMap, "attributes", indexConfig.getAttributes());
            if (indexConfig.getType() == IndexType.BITMAP) {
                LinkedHashMap bitmapIndexOptionsAsMap = new LinkedHashMap();
                DynamicConfigYamlGenerator.addNonNullToMap(bitmapIndexOptionsAsMap, "unique-key", indexConfig.getBitmapIndexOptions().getUniqueKey());
                DynamicConfigYamlGenerator.addNonNullToMap(bitmapIndexOptionsAsMap, "unique-key-transformation", indexConfig.getBitmapIndexOptions().getUniqueKeyTransformation().name());
                indexConfigAsMap.put("bitmap-index-options", bitmapIndexOptionsAsMap);
            } else if (indexConfig.getType() == IndexType.SORTED) {
                BTreeIndexConfig bTreeConf = indexConfig.getBTreeIndexConfig();
                LinkedHashMap btreeOptionsAsMap = new LinkedHashMap();
                DynamicConfigYamlGenerator.addNonNullToMap(btreeOptionsAsMap, "page-size", DynamicConfigYamlGenerator.getCapacityAsMap(bTreeConf.getPageSize()));
                LinkedHashMap memoryTierAsMap = new LinkedHashMap();
                DynamicConfigYamlGenerator.addNonNullToMap(memoryTierAsMap, "capacity", DynamicConfigYamlGenerator.getCapacityAsMap(bTreeConf.getMemoryTierConfig().getCapacity()));
                DynamicConfigYamlGenerator.addNonNullToMap(btreeOptionsAsMap, "memory-tier", memoryTierAsMap);
                indexConfigAsMap.put("btree-index", btreeOptionsAsMap);
            }
            DynamicConfigYamlGenerator.addNonNullToList(indexConfigsAsList, indexConfigAsMap);
        }
        return indexConfigsAsList;
    }

    private static Map<String, Object> getNearCacheConfigAsMap(NearCacheConfig nearCacheConfig) {
        if (nearCacheConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> nearCacheConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "name", nearCacheConfig.getName());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "in-memory-format", nearCacheConfig.getInMemoryFormat().name());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "invalidate-on-change", nearCacheConfig.isInvalidateOnChange());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "time-to-live-seconds", nearCacheConfig.getTimeToLiveSeconds());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "max-idle-seconds", nearCacheConfig.getMaxIdleSeconds());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "serialize-keys", nearCacheConfig.isSerializeKeys());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "cache-local-entries", nearCacheConfig.isCacheLocalEntries());
        DynamicConfigYamlGenerator.addNonNullToMap(nearCacheConfigAsMap, "eviction", DynamicConfigYamlGenerator.getEvictionConfigAsMap(nearCacheConfig.getEvictionConfig()));
        return nearCacheConfigAsMap;
    }

    private static Map<String, Object> getMerkleTreeConfigAsMap(MerkleTreeConfig merkleTreeConfig) {
        if (merkleTreeConfig == null || merkleTreeConfig.getEnabled() == null) {
            return null;
        }
        LinkedHashMap<String, Object> merkleTreeConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(merkleTreeConfigAsMap, "enabled", Boolean.TRUE.equals(merkleTreeConfig.getEnabled()));
        DynamicConfigYamlGenerator.addNonNullToMap(merkleTreeConfigAsMap, "depth", merkleTreeConfig.getDepth());
        return merkleTreeConfigAsMap;
    }

    private static Map<String, Object> getDataPersistenceConfigAsMap(DataPersistenceConfig dataPersistenceConfig) {
        if (dataPersistenceConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> dataPersistenceConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(dataPersistenceConfigAsMap, "enabled", dataPersistenceConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(dataPersistenceConfigAsMap, "fsync", dataPersistenceConfig.isFsync());
        return dataPersistenceConfigAsMap;
    }

    private static Map<String, Object> getEventJournalConfigAsMap(EventJournalConfig eventJournalConfig) {
        if (eventJournalConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> eventJournalConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(eventJournalConfigAsMap, "enabled", eventJournalConfig.isEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(eventJournalConfigAsMap, "capacity", eventJournalConfig.getCapacity());
        DynamicConfigYamlGenerator.addNonNullToMap(eventJournalConfigAsMap, "time-to-live-seconds", eventJournalConfig.getTimeToLiveSeconds());
        return eventJournalConfigAsMap;
    }

    private static Map<String, Object> getWanReplicationRefAsMap(WanReplicationRef wanReplicationRef, boolean isMap) {
        if (wanReplicationRef == null) {
            return null;
        }
        LinkedHashMap<String, Object> wanReplicationRefAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(wanReplicationRefAsMap, "merge-policy-class-name", wanReplicationRef.getMergePolicyClassName());
        DynamicConfigYamlGenerator.addNonNullToMap(wanReplicationRefAsMap, "republishing-enabled", wanReplicationRef.isRepublishingEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(wanReplicationRefAsMap, "filters", wanReplicationRef.getFilters());
        if (isMap) {
            return DynamicConfigYamlGenerator.wrapObjectWithMap(wanReplicationRef.getName(), wanReplicationRefAsMap);
        }
        DynamicConfigYamlGenerator.addNonNullToMap(wanReplicationRefAsMap, "name", wanReplicationRef.getName());
        return wanReplicationRefAsMap;
    }

    private static Map<String, Object> getEvictionConfigAsMap(EvictionConfig evictionConfig) {
        if (evictionConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> evictionConfigAsMap = new LinkedHashMap<String, Object>();
        String comparatorClassName = !StringUtil.isNullOrEmpty(evictionConfig.getComparatorClassName()) ? evictionConfig.getComparatorClassName() : null;
        DynamicConfigYamlGenerator.addNonNullToMap(evictionConfigAsMap, "size", evictionConfig.getSize());
        DynamicConfigYamlGenerator.addNonNullToMap(evictionConfigAsMap, "max-size-policy", evictionConfig.getMaxSizePolicy().name());
        DynamicConfigYamlGenerator.addNonNullToMap(evictionConfigAsMap, "eviction-policy", evictionConfig.getEvictionPolicy().name());
        DynamicConfigYamlGenerator.addNonNullToMap(evictionConfigAsMap, "comparator-class-name", comparatorClassName);
        return evictionConfigAsMap;
    }

    private static List<Map<String, Object>> getCacheSimpleEntryListenerConfigsAsList(List<CacheSimpleEntryListenerConfig> cacheSimpleEntryListenerConfigs) {
        if (cacheSimpleEntryListenerConfigs == null || cacheSimpleEntryListenerConfigs.isEmpty()) {
            return null;
        }
        LinkedList<Map<String, Object>> cacheSimpleEntryListenerConfigsAsList = new LinkedList<Map<String, Object>>();
        for (CacheSimpleEntryListenerConfig cacheSimpleEntryListenerConfig : cacheSimpleEntryListenerConfigs) {
            LinkedHashMap cacheSimpleEntryListenerConfigsAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(cacheSimpleEntryListenerConfigsAsMap, "old-value-required", cacheSimpleEntryListenerConfig.isOldValueRequired());
            DynamicConfigYamlGenerator.addNonNullToMap(cacheSimpleEntryListenerConfigsAsMap, "synchronous", cacheSimpleEntryListenerConfig.isSynchronous());
            DynamicConfigYamlGenerator.addNonNullToMap(cacheSimpleEntryListenerConfigsAsMap, "cache-entry-listener-factory", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", cacheSimpleEntryListenerConfig.getCacheEntryListenerFactory()));
            DynamicConfigYamlGenerator.addNonNullToMap(cacheSimpleEntryListenerConfigsAsMap, "cache-entry-event-filter-factory", DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", cacheSimpleEntryListenerConfig.getCacheEntryEventFilterFactory()));
            DynamicConfigYamlGenerator.addNonNullToList(cacheSimpleEntryListenerConfigsAsList, cacheSimpleEntryListenerConfigsAsMap);
        }
        return cacheSimpleEntryListenerConfigsAsList;
    }

    private static Map<String, Object> getExpiryPolicyFactoryConfigAsMap(CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig) {
        if (expiryPolicyFactoryConfig == null) {
            return null;
        }
        if (!StringUtil.isNullOrEmpty(expiryPolicyFactoryConfig.getClassName())) {
            return DynamicConfigYamlGenerator.wrapObjectWithMap("class-name", expiryPolicyFactoryConfig.getClassName());
        }
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedConfig = expiryPolicyFactoryConfig.getTimedExpiryPolicyFactoryConfig();
        if (timedConfig != null && timedConfig.getExpiryPolicyType() != null && timedConfig.getDurationConfig() != null) {
            LinkedHashMap timedConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(timedConfigAsMap, "expiry-policy-type", timedConfig.getExpiryPolicyType().name());
            DynamicConfigYamlGenerator.addNonNullToMap(timedConfigAsMap, "duration-amount", timedConfig.getDurationConfig().getDurationAmount());
            DynamicConfigYamlGenerator.addNonNullToMap(timedConfigAsMap, "time-unit", timedConfig.getDurationConfig().getTimeUnit().name());
            return DynamicConfigYamlGenerator.wrapObjectWithMap("timed-expiry-policy-factory", timedConfigAsMap);
        }
        return null;
    }

    private static Map<String, Object> getCollectionConfigAsMap(CollectionConfig<?> collectionConfig) {
        if (collectionConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> subConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "statistics-enabled", collectionConfig.isStatisticsEnabled());
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "max-size", collectionConfig.getMaxSize());
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "backup-count", collectionConfig.getBackupCount());
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "async-backup-count", collectionConfig.getAsyncBackupCount());
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "split-brain-protection-ref", collectionConfig.getSplitBrainProtectionName());
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "item-listeners", DynamicConfigYamlGenerator.getItemListenerConfigsAsList(collectionConfig.getItemListenerConfigs()));
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "merge-policy", DynamicConfigYamlGenerator.getMergePolicyConfigAsMap(collectionConfig.getMergePolicyConfig()));
        DynamicConfigYamlGenerator.addNonNullToMap(subConfigAsMap, "user-code-namespace", collectionConfig.getUserCodeNamespace());
        return subConfigAsMap;
    }

    private static List<Map<String, Object>> getItemListenerConfigsAsList(List<? extends ListenerConfig> listenerConfigs) {
        if (listenerConfigs == null || listenerConfigs.isEmpty()) {
            return null;
        }
        LinkedList<Map<String, Object>> listenerConfigsAsList = new LinkedList<Map<String, Object>>();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            LinkedHashMap listenerConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(listenerConfigAsMap, "class-name", DynamicConfigXmlGenerator.classNameOrImplClass(listenerConfig.getClassName(), listenerConfig.getImplementation()));
            DynamicConfigYamlGenerator.addNonNullToMap(listenerConfigAsMap, "include-value", listenerConfig.isIncludeValue());
            DynamicConfigYamlGenerator.addNonNullToList(listenerConfigsAsList, listenerConfigAsMap);
        }
        return listenerConfigsAsList;
    }

    private static List<Map<String, Object>> getEntryListenerConfigsAsList(List<? extends ListenerConfig> listenerConfigs) {
        if (listenerConfigs == null || listenerConfigs.isEmpty()) {
            return null;
        }
        LinkedList<Map<String, Object>> listenerConfigsAsList = new LinkedList<Map<String, Object>>();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            LinkedHashMap listenerConfigAsMap = new LinkedHashMap();
            DynamicConfigYamlGenerator.addNonNullToMap(listenerConfigAsMap, "class-name", DynamicConfigXmlGenerator.classNameOrImplClass(listenerConfig.getClassName(), listenerConfig.getImplementation()));
            DynamicConfigYamlGenerator.addNonNullToMap(listenerConfigAsMap, "include-value", listenerConfig.isIncludeValue());
            DynamicConfigYamlGenerator.addNonNullToMap(listenerConfigAsMap, "local", listenerConfig.isLocal());
            DynamicConfigYamlGenerator.addNonNullToList(listenerConfigsAsList, listenerConfigAsMap);
        }
        return listenerConfigsAsList;
    }

    private static Map<String, Object> getPropertiesAsMap(Map<String, Comparable> properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> propertiesAsMap = new LinkedHashMap<String, Object>();
        for (String key : properties.keySet()) {
            DynamicConfigYamlGenerator.addNonNullToMap(propertiesAsMap, key, properties.get(key));
        }
        return propertiesAsMap;
    }

    private static Map<String, Object> getPropertiesAsMap(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> propertiesAsMap = new LinkedHashMap<String, Object>();
        for (Object key : properties.keySet()) {
            DynamicConfigYamlGenerator.addNonNullToMap(propertiesAsMap, key.toString(), properties.getProperty(key.toString()));
        }
        return propertiesAsMap;
    }

    private static Map<String, Object> getStoreConfigAsMap(boolean enabled, String className, String factoryClassName, Properties properties) {
        LinkedHashMap<String, Object> storeConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(storeConfigAsMap, "enabled", enabled);
        DynamicConfigYamlGenerator.addNonNullToMap(storeConfigAsMap, "class-name", className);
        DynamicConfigYamlGenerator.addNonNullToMap(storeConfigAsMap, "factory-class-name", factoryClassName);
        DynamicConfigYamlGenerator.addNonNullToMap(storeConfigAsMap, "properties", DynamicConfigYamlGenerator.getPropertiesAsMap(properties));
        return storeConfigAsMap;
    }

    private static Map<String, Object> getMapStoreConfigAsMap(MapStoreConfig mapStoreConfig) {
        if (mapStoreConfig == null) {
            return null;
        }
        String className = mapStoreConfig.getImplementation() != null ? mapStoreConfig.getImplementation().getClass().getName() : mapStoreConfig.getClassName();
        String factoryClassName = mapStoreConfig.getFactoryImplementation() != null ? mapStoreConfig.getFactoryImplementation().getClass().getName() : mapStoreConfig.getFactoryClassName();
        Map<String, Object> mapStoreConfigAsMap = DynamicConfigYamlGenerator.getStoreConfigAsMap(mapStoreConfig.isEnabled(), className, factoryClassName, mapStoreConfig.getProperties());
        DynamicConfigYamlGenerator.addNonNullToMap(mapStoreConfigAsMap, "initial-mode", mapStoreConfig.getInitialLoadMode().name());
        DynamicConfigYamlGenerator.addNonNullToMap(mapStoreConfigAsMap, "offload", mapStoreConfig.isOffload());
        DynamicConfigYamlGenerator.addNonNullToMap(mapStoreConfigAsMap, "write-coalescing", mapStoreConfig.isWriteCoalescing());
        DynamicConfigYamlGenerator.addNonNullToMap(mapStoreConfigAsMap, "write-delay-seconds", mapStoreConfig.getWriteDelaySeconds());
        DynamicConfigYamlGenerator.addNonNullToMap(mapStoreConfigAsMap, "write-batch-size", mapStoreConfig.getWriteBatchSize());
        return mapStoreConfigAsMap;
    }

    private static Map<String, Object> getQueueStoreConfigAsMap(QueueStoreConfig queueStoreConfig) {
        if (queueStoreConfig == null) {
            return null;
        }
        return DynamicConfigYamlGenerator.getStoreConfigAsMap(queueStoreConfig.isEnabled(), DynamicConfigXmlGenerator.classNameOrImplClass(queueStoreConfig.getClassName(), queueStoreConfig.getStoreImplementation()), DynamicConfigXmlGenerator.classNameOrImplClass(queueStoreConfig.getFactoryClassName(), queueStoreConfig.getFactoryImplementation()), queueStoreConfig.getProperties());
    }

    private static Map<String, Object> getRingbufferStoreConfigAsMap(RingbufferStoreConfig ringbufferStoreConfig) {
        if (ringbufferStoreConfig == null) {
            return null;
        }
        return DynamicConfigYamlGenerator.getStoreConfigAsMap(ringbufferStoreConfig.isEnabled(), DynamicConfigXmlGenerator.classNameOrImplClass(ringbufferStoreConfig.getClassName(), ringbufferStoreConfig.getStoreImplementation()), DynamicConfigXmlGenerator.classNameOrImplClass(ringbufferStoreConfig.getFactoryClassName(), ringbufferStoreConfig.getFactoryImplementation()), ringbufferStoreConfig.getProperties());
    }

    private static List<String> getListenerConfigsAsList(List<? extends ListenerConfig> listenerConfigs) {
        if (listenerConfigs == null || listenerConfigs.isEmpty()) {
            return null;
        }
        LinkedList<String> listenerConfigsAsList = new LinkedList<String>();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            DynamicConfigYamlGenerator.addNonNullToList(listenerConfigsAsList, DynamicConfigXmlGenerator.classNameOrImplClass(listenerConfig.getClassName(), listenerConfig.getImplementation()));
        }
        return listenerConfigsAsList;
    }

    private static Map<String, Object> getMergePolicyConfigAsMap(MergePolicyConfig mergePolicyConfig) {
        if (mergePolicyConfig == null) {
            return null;
        }
        LinkedHashMap<String, Object> mergePolicyConfigAsMap = new LinkedHashMap<String, Object>();
        DynamicConfigYamlGenerator.addNonNullToMap(mergePolicyConfigAsMap, "class-name", mergePolicyConfig.getPolicy());
        DynamicConfigYamlGenerator.addNonNullToMap(mergePolicyConfigAsMap, "batch-size", mergePolicyConfig.getBatchSize());
        return mergePolicyConfigAsMap;
    }

    private static Map<String, Object> wrapObjectWithMap(String key, Object value) {
        if (value == null) {
            return null;
        }
        LinkedHashMap<String, Object> wrappedObject = new LinkedHashMap<String, Object>();
        wrappedObject.put(key, value);
        return wrappedObject;
    }

    private static <E> void addNonNullToList(List<E> list, E element) {
        if (element != null) {
            list.add(element);
        }
    }

    private static <K, V> void addNonNullToMap(Map<K, V> map, K key, V value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private static String getOrMaskValue(String value) {
        return maskSensitiveFields ? "****" : value;
    }
}

