/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipAdapter;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.ClusterVersionListener;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListenable;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.ReplicaMigrationEvent;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class SystemLogPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty ENABLED = new HazelcastProperty("hazelcast.diagnostics.systemlog.enabled", "true");
    public static final HazelcastProperty LOG_PARTITIONS = new HazelcastProperty("hazelcast.diagnostics.systemlog.partitions", "false");
    private static final long PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final Queue<Object> logQueue = new ConcurrentLinkedQueue<Object>();
    private final ConnectionListenable connectionObservable;
    private final HazelcastInstance hazelcastInstance;
    private final Address thisAddress;
    private final NodeExtension nodeExtension;
    private final HazelcastProperties properties;
    private boolean logPartitions;
    private volatile boolean enabled;
    private ClusterVersionListenerImpl clusterVersionListener;
    private ConnectionListenerImpl connectionListener;
    private MembershipListenerImpl membershipListener;
    private MigrationListenerImpl migrationListener;
    private LifecycleListenerImpl lifecycleListener;

    public SystemLogPlugin(HazelcastProperties properties, ConnectionListenable connectionObservable, HazelcastInstance hazelcastInstance, ILogger logger) {
        this(logger, properties, connectionObservable, hazelcastInstance, null);
    }

    public SystemLogPlugin(ILogger logger, HazelcastProperties properties, ConnectionListenable connectionObservable, HazelcastInstance hazelcastInstance, NodeExtension nodeExtension) {
        super(logger);
        this.connectionObservable = connectionObservable;
        this.hazelcastInstance = hazelcastInstance;
        this.thisAddress = this.getThisAddress(hazelcastInstance);
        this.nodeExtension = nodeExtension;
        this.properties = properties;
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.logPartitions = this.properties.getBoolean(this.overrideProperty(LOG_PARTITIONS));
        this.enabled = this.properties.getBoolean(this.overrideProperty(ENABLED));
    }

    private Address getThisAddress(HazelcastInstance hazelcastInstance) {
        try {
            return hazelcastInstance.getCluster().getLocalMember().getAddress();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public long getPeriodMillis() {
        if (!this.enabled) {
            return 0L;
        }
        return PERIOD_MILLIS;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active: logPartitions:" + this.logPartitions);
        if (this.connectionListener == null) {
            this.connectionListener = new ConnectionListenerImpl();
            this.connectionObservable.addConnectionListener(this.connectionListener);
        }
        if (this.membershipListener == null) {
            this.membershipListener = new MembershipListenerImpl();
            this.hazelcastInstance.getCluster().addMembershipListener(this.membershipListener);
        }
        if (this.logPartitions && this.migrationListener == null) {
            this.migrationListener = new MigrationListenerImpl();
            this.hazelcastInstance.getPartitionService().addMigrationListener(this.migrationListener);
        }
        if (this.lifecycleListener == null) {
            this.lifecycleListener = new LifecycleListenerImpl();
            this.hazelcastInstance.getLifecycleService().addLifecycleListener(this.lifecycleListener);
        }
        if (this.nodeExtension != null && this.clusterVersionListener == null) {
            this.clusterVersionListener = new ClusterVersionListenerImpl();
            this.nodeExtension.registerListener(this.clusterVersionListener);
        }
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logQueue.clear();
        this.logger.info("Plugin:inactive");
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        Object item;
        while ((item = this.logQueue.poll()) != null && this.isActive()) {
            if (item instanceof LifecycleEvent) {
                LifecycleEvent event = (LifecycleEvent)item;
                this.render(writer, event);
                continue;
            }
            if (item instanceof MembershipEvent) {
                MembershipEvent event = (MembershipEvent)item;
                this.render(writer, event);
                continue;
            }
            if (item instanceof MigrationState) {
                MigrationState state = (MigrationState)item;
                this.render(writer, state);
                continue;
            }
            if (item instanceof ReplicaMigrationEvent) {
                ReplicaMigrationEvent event = (ReplicaMigrationEvent)item;
                this.render(writer, event);
                continue;
            }
            if (item instanceof ConnectionEvent) {
                ConnectionEvent event = (ConnectionEvent)item;
                this.render(writer, event);
                continue;
            }
            if (!(item instanceof Version)) continue;
            Version version = (Version)item;
            this.render(writer, version);
        }
        return;
    }

    private boolean shouldListenersListen() {
        return this.enabled && this.isActive();
    }

    boolean getLogPartitions() {
        return this.logPartitions;
    }

    private void render(DiagnosticsLogWriter writer, LifecycleEvent event) {
        writer.startSection("Lifecycle");
        writer.writeEntry(event.getState().name());
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, MembershipEvent event) {
        switch (event.getEventType()) {
            case 1: {
                writer.startSection("MemberAdded");
                break;
            }
            case 2: {
                writer.startSection("MemberRemoved");
                break;
            }
            default: {
                return;
            }
        }
        writer.writeKeyValueEntry("member", event.getMember().getAddress().toString());
        writer.startSection("Members");
        Set<Member> members = event.getMembers();
        if (members != null) {
            boolean first = true;
            for (Member member : members) {
                Address memberAddress = member.getAddress();
                String addressStr = String.valueOf(memberAddress);
                if (memberAddress.equals(this.thisAddress)) {
                    if (first) {
                        writer.writeEntry(addressStr + ":this:master");
                    } else {
                        writer.writeEntry(addressStr + ":this");
                    }
                } else if (first) {
                    writer.writeEntry(addressStr + ":master");
                } else {
                    writer.writeEntry(addressStr);
                }
                first = false;
            }
        }
        writer.endSection();
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, MigrationState migrationState) {
        writer.startSection("MigrationState");
        writer.writeKeyValueEntryAsDateTime("startTime", migrationState.getStartTime());
        writer.writeKeyValueEntry("plannedMigrations", migrationState.getPlannedMigrations());
        writer.writeKeyValueEntry("completedMigrations", migrationState.getCompletedMigrations());
        writer.writeKeyValueEntry("remainingMigrations", migrationState.getRemainingMigrations());
        writer.writeKeyValueEntry("totalElapsedTime(ms)", migrationState.getTotalElapsedTime());
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, ReplicaMigrationEvent event) {
        if (event.isSuccess()) {
            writer.startSection("MigrationCompleted");
        } else {
            writer.startSection("MigrationFailed");
        }
        Member source = event.getSource();
        writer.writeKeyValueEntry("source", source == null ? "null" : source.getAddress().toString());
        writer.writeKeyValueEntry("destination", event.getDestination().getAddress().toString());
        writer.writeKeyValueEntry("partitionId", event.getPartitionId());
        writer.writeKeyValueEntry("replicaIndex", event.getReplicaIndex());
        writer.writeKeyValueEntry("elapsedTime(ms)", event.getReplicaIndex());
        this.render(writer, event.getMigrationState());
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, ConnectionEvent event) {
        if (event.added) {
            writer.startSection("ConnectionAdded");
        } else {
            writer.startSection("ConnectionRemoved");
        }
        Connection connection = event.connection;
        writer.writeEntry(connection.toString());
        if (connection instanceof ServerConnection) {
            ServerConnection serverConnection = (ServerConnection)connection;
            writer.writeKeyValueEntry("type", serverConnection.getConnectionType());
        }
        writer.writeKeyValueEntry("isAlive", connection.isAlive());
        if (!event.added) {
            String closeReason = connection.getCloseReason();
            Throwable closeCause = connection.getCloseCause();
            if (closeReason == null && closeCause != null) {
                closeReason = closeCause.getMessage();
            }
            writer.writeKeyValueEntry("closeReason", closeReason == null ? "Unknown" : closeReason);
            if (closeCause != null) {
                writer.startSection("CloseCause");
                String s = closeCause.getClass().getName();
                String message = closeCause.getMessage();
                writer.writeEntry((String)(message != null ? s + ": " + message : s));
                for (StackTraceElement element : closeCause.getStackTrace()) {
                    writer.writeEntry(element.toString());
                }
                writer.endSection();
            }
        }
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, Version version) {
        writer.startSection("ClusterVersionChanged");
        writer.writeEntry(version.toString());
        writer.endSection();
    }

    protected class ConnectionListenerImpl
    implements ConnectionListener {
        protected ConnectionListenerImpl() {
        }

        public void connectionAdded(Connection connection) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(new ConnectionEvent(true, connection));
            }
        }

        public void connectionRemoved(Connection connection) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(new ConnectionEvent(false, connection));
            }
        }
    }

    protected class MembershipListenerImpl
    extends MembershipAdapter {
        protected MembershipListenerImpl() {
        }

        @Override
        public void memberAdded(MembershipEvent event) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(event);
            }
        }

        @Override
        public void memberRemoved(MembershipEvent event) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(event);
            }
        }
    }

    protected class MigrationListenerImpl
    implements MigrationListener {
        protected MigrationListenerImpl() {
        }

        @Override
        public void migrationStarted(MigrationState state) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(state);
            }
        }

        @Override
        public void migrationFinished(MigrationState state) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(state);
            }
        }

        @Override
        public void replicaMigrationCompleted(ReplicaMigrationEvent event) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(event);
            }
        }

        @Override
        public void replicaMigrationFailed(ReplicaMigrationEvent event) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(event);
            }
        }
    }

    protected class LifecycleListenerImpl
    implements LifecycleListener {
        protected LifecycleListenerImpl() {
        }

        @Override
        public void stateChanged(LifecycleEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }
    }

    protected class ClusterVersionListenerImpl
    implements ClusterVersionListener {
        protected ClusterVersionListenerImpl() {
        }

        @Override
        public void onClusterVersionChange(Version newVersion) {
            if (SystemLogPlugin.this.shouldListenersListen()) {
                SystemLogPlugin.this.logQueue.add(newVersion);
            }
        }
    }

    private static final class ConnectionEvent {
        final boolean added;
        final Connection connection;

        ConnectionEvent(boolean added, Connection connection) {
            this.added = added;
            this.connection = connection;
        }
    }
}

