/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class StoreLatencyPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.storeLatency.period.seconds", 0, TimeUnit.SECONDS);
    public static final HazelcastProperty RESET_PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.storeLatency.reset.period.seconds", 0, TimeUnit.SECONDS);
    protected final ConstructorFunction<String, InstanceProbes> instanceProbesConstructorFunction = InstanceProbes::new;
    private final ConcurrentMap<String, ServiceProbes> metricsPerServiceMap = new ConcurrentHashMap<String, ServiceProbes>();
    private final ConstructorFunction<String, ServiceProbes> metricsPerServiceConstructorFunction = x$0 -> new ServiceProbes((String)x$0);
    private final HazelcastProperties properties;
    private long periodMillis;
    private long resetPeriodMillis;
    private long resetFrequency;
    private long iteration;

    public StoreLatencyPlugin(ILogger logger, HazelcastProperties properties) {
        super(logger);
        this.properties = properties;
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMillis = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
        this.resetPeriodMillis = this.properties.getMillis(this.overrideProperty(RESET_PERIOD_SECONDS));
        this.resetFrequency = this.periodMillis == 0L || this.resetPeriodMillis == 0L ? 0L : Math.max(1L, this.resetPeriodMillis / this.periodMillis);
    }

    @Override
    public boolean canBeEnabledDynamically() {
        return false;
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active: period-millis:" + this.periodMillis + " resetPeriod-millis:" + this.resetPeriodMillis);
    }

    @Override
    public void onShutdown() {
        this.resetStatisticsIfNeeded(true);
        super.onShutdown();
        this.iteration = 0L;
        this.logger.info("Plugin:inactive");
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        ++this.iteration;
        if (this.isActive()) {
            this.render(writer);
            this.resetStatisticsIfNeeded(false);
        }
    }

    private void render(DiagnosticsLogWriter writer) {
        for (ServiceProbes serviceProbes : this.metricsPerServiceMap.values()) {
            if (!this.isActive()) {
                return;
            }
            serviceProbes.render(writer);
        }
    }

    private void resetStatisticsIfNeeded(boolean force) {
        if (this.resetFrequency > 0L && this.iteration % this.resetFrequency == 0L || force) {
            for (ServiceProbes serviceProbes : this.metricsPerServiceMap.values()) {
                serviceProbes.resetStatistics();
            }
        }
    }

    public long count(String serviceName, String dataStructureName, String methodName) {
        return ((LatencyProbeImpl)this.newProbe((String)serviceName, (String)dataStructureName, (String)methodName)).distribution.count();
    }

    public LatencyProbe newProbe(String serviceName, String dataStructureName, String methodName) {
        ServiceProbes serviceProbes = ConcurrencyUtil.getOrPutIfAbsent(this.metricsPerServiceMap, serviceName, this.metricsPerServiceConstructorFunction);
        return serviceProbes.newProbe(dataStructureName, methodName);
    }

    long getResetPeriodMillis() {
        return this.resetPeriodMillis;
    }

    private final class ServiceProbes {
        private final String serviceName;
        private final ConcurrentReferenceHashMap<String, InstanceProbes> instanceProbesMap = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

        protected ServiceProbes(String serviceName) {
            this.serviceName = serviceName;
        }

        protected LatencyProbe newProbe(String dataStructureName, String methodName) {
            InstanceProbes instanceProbes = ConcurrencyUtil.getOrPutIfAbsent(this.instanceProbesMap, dataStructureName, StoreLatencyPlugin.this.instanceProbesConstructorFunction);
            return instanceProbes.newProbe(methodName);
        }

        protected void render(DiagnosticsLogWriter writer) {
            writer.startSection(this.serviceName);
            Iterator<Map.Entry<String, InstanceProbes>> it = this.instanceProbesMap.entrySet().iterator();
            while (it.hasNext()) {
                InstanceProbes instanceProbes = it.next().getValue();
                if (instanceProbes != null) {
                    instanceProbes.render(writer);
                    continue;
                }
                it.remove();
            }
            writer.endSection();
        }

        public void resetStatistics() {
            Iterator<Map.Entry<String, InstanceProbes>> it = this.instanceProbesMap.entrySet().iterator();
            while (it.hasNext()) {
                InstanceProbes instanceProbes = it.next().getValue();
                if (instanceProbes != null) {
                    instanceProbes.resetStatistics();
                    continue;
                }
                it.remove();
            }
        }
    }

    public static interface LatencyProbe {
        public void recordValue(long var1);
    }

    static final class LatencyProbeImpl
    implements LatencyProbe {
        volatile LatencyDistribution distribution = new LatencyDistribution();
        private final InstanceProbes instanceProbes;
        private final String methodName;

        protected LatencyProbeImpl(String methodName, InstanceProbes instanceProbes) {
            this.methodName = methodName;
            this.instanceProbes = instanceProbes;
        }

        @Override
        public void recordValue(long durationNanos) {
            this.distribution.recordNanos(durationNanos);
        }

        protected void render(DiagnosticsLogWriter writer) {
            LatencyDistribution stats = this.distribution;
            if (stats.count() == 0L) {
                return;
            }
            writer.startSection(this.methodName);
            writer.writeKeyValueEntry("count", stats.count());
            writer.writeKeyValueEntry("totalTime(us)", stats.totalMicros());
            writer.writeKeyValueEntry("avg(us)", this.distribution.avgMicros());
            writer.writeKeyValueEntry("max(us)", stats.maxMicros());
            writer.startSection("latency-distribution");
            for (int bucket = 0; bucket < stats.bucketCount(); ++bucket) {
                long value = stats.bucket(bucket);
                if (value <= 0L) continue;
                writer.writeKeyValueEntry(LatencyDistribution.LATENCY_KEYS[bucket], value);
            }
            writer.endSection();
            writer.endSection();
        }

        protected void resetStatistics() {
            this.distribution = new LatencyDistribution();
        }
    }

    private static final class InstanceProbes {
        private final ConcurrentMap<String, LatencyProbeImpl> probes = new ConcurrentHashMap<String, LatencyProbeImpl>();
        private final String dataStructureName;

        InstanceProbes(String dataStructureName) {
            this.dataStructureName = dataStructureName;
        }

        LatencyProbe newProbe(String methodName) {
            LatencyProbeImpl probe = (LatencyProbeImpl)this.probes.get(methodName);
            if (probe == null) {
                LatencyProbeImpl newProbe = new LatencyProbeImpl(methodName, this);
                LatencyProbeImpl found = this.probes.putIfAbsent(methodName, newProbe);
                probe = found == null ? newProbe : found;
            }
            return probe;
        }

        void render(DiagnosticsLogWriter writer) {
            writer.startSection(this.dataStructureName);
            for (LatencyProbeImpl probe : this.probes.values()) {
                probe.render(writer);
            }
            writer.endSection();
        }

        void resetStatistics() {
            for (LatencyProbeImpl probe : this.probes.values()) {
                probe.resetStatistics();
            }
        }
    }
}

