/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class OperationProfilerPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.operation-profiler.period.seconds", 5, TimeUnit.SECONDS);
    private final ConcurrentMap<Class, LatencyDistribution> opLatencyDistribution;
    private long periodMillis;
    private final HazelcastProperties props;

    public OperationProfilerPlugin(ILogger logger, ConcurrentMap<Class, LatencyDistribution> opLatencyDistribution, HazelcastProperties props) {
        super(logger);
        this.opLatencyDistribution = opLatencyDistribution;
        this.props = props;
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMillis = this.props.getMillis(this.overrideProperty(PERIOD_SECONDS));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive, period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        writer.startSection("OperationsProfiler");
        OperationProfilerPlugin.write(writer, this.opLatencyDistribution);
        writer.endSection();
    }

    static void write(DiagnosticsLogWriter writer, ConcurrentMap<Class, LatencyDistribution> opLatencyDistribution) {
        for (Map.Entry entry : opLatencyDistribution.entrySet()) {
            LatencyDistribution distribution = (LatencyDistribution)entry.getValue();
            if (distribution.count() == 0L) continue;
            writer.startSection(((Class)entry.getKey()).getName());
            writer.writeKeyValueEntry("count", distribution.count());
            writer.writeKeyValueEntry("totalTime(us)", distribution.totalMicros());
            writer.writeKeyValueEntry("avg(us)", distribution.avgMicros());
            writer.writeKeyValueEntry("max(us)", distribution.maxMicros());
            writer.startSection("latency-distribution");
            for (int bucket = 0; bucket < distribution.bucketCount(); ++bucket) {
                long value = distribution.bucket(bucket);
                if (value <= 0L) continue;
                writer.writeKeyValueEntry(LatencyDistribution.LATENCY_KEYS[bucket], value);
            }
            writer.endSection();
            writer.endSection();
        }
    }
}

