/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class MetricsPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.metrics.period.seconds", 60, TimeUnit.SECONDS);
    private final MetricsRegistry metricsRegistry;
    private final MetricsCollectorImpl metricCollector = new MetricsCollectorImpl();
    private final HazelcastProperties properties;
    private long periodMillis;

    public MetricsPlugin(ILogger logger, MetricsRegistry metricsRegistry, HazelcastProperties properties) {
        super(logger);
        this.metricsRegistry = metricsRegistry;
        this.properties = properties;
        this.readProperties();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    void readProperties() {
        this.periodMillis = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        this.metricCollector.writer = writer;
        this.metricCollector.timeMillis = System.currentTimeMillis();
        this.metricsRegistry.collect(this.metricCollector);
        this.metricCollector.writer = null;
    }

    private static class MetricsCollectorImpl
    implements MetricsCollector {
        private static final String SECTION_NAME = "Metric";
        private DiagnosticsLogWriter writer;
        private long timeMillis;

        private MetricsCollectorImpl() {
        }

        @Override
        public void collectLong(MetricDescriptor descriptor, long value) {
            if (this.writer != null && descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), value);
            }
        }

        @Override
        public void collectDouble(MetricDescriptor descriptor, double value) {
            if (this.writer != null && descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), value);
            }
        }

        @Override
        public void collectException(MetricDescriptor descriptor, Exception e) {
            if (this.writer != null && descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), e.getClass().getName() + ":" + e.getMessage());
            }
        }

        @Override
        public void collectNoValue(MetricDescriptor descriptor) {
            if (this.writer != null && descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), "NA");
            }
        }
    }
}

