/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.diagnostics.DiagnosticsOutputType;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DiagnosticsConfig
implements IdentifiedDataSerializable {
    public static final float DEFAULT_MAX_ROLLED_FILE_SIZE = 50.0f;
    public static final int DEFAULT_MAX_ROLLED_FILE_COUNT = 10;
    public static final boolean DEFAULT_INCLUDE_EPOCH_TIME = true;
    public static final DiagnosticsOutputType DEFAULT_OUTPUT_TYPE = DiagnosticsOutputType.FILE;
    public static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
    public static final int DEFAULT_AUTO_OFF_DURATION_IN_MINUTES = -1;
    private boolean enabled;
    private float maxRolledFileSizeInMB = 50.0f;
    private int maxRolledFileCount = 10;
    private boolean includeEpochTime = true;
    private String logDirectory = DEFAULT_DIRECTORY;
    private String fileNamePrefix;
    private DiagnosticsOutputType outputType = DEFAULT_OUTPUT_TYPE;
    private Map<String, String> pluginProperties = new HashMap<String, String>();
    private int autoOffDurationInMinutes = -1;

    public DiagnosticsConfig() {
    }

    public DiagnosticsConfig(boolean enabled) {
        this.enabled = enabled;
    }

    public DiagnosticsConfig(DiagnosticsConfig diagnosticsConfig) {
        this.enabled = diagnosticsConfig.isEnabled();
        this.maxRolledFileSizeInMB = diagnosticsConfig.getMaxRolledFileSizeInMB();
        this.maxRolledFileCount = diagnosticsConfig.getMaxRolledFileCount();
        this.includeEpochTime = diagnosticsConfig.isIncludeEpochTime();
        this.logDirectory = diagnosticsConfig.getLogDirectory();
        this.fileNamePrefix = diagnosticsConfig.getFileNamePrefix();
        this.outputType = diagnosticsConfig.getOutputType();
        this.pluginProperties = diagnosticsConfig.pluginProperties;
        this.autoOffDurationInMinutes = diagnosticsConfig.getAutoOffDurationInMinutes();
    }

    public int getAutoOffDurationInMinutes() {
        return this.autoOffDurationInMinutes;
    }

    public DiagnosticsConfig setAutoOffDurationInMinutes(int autoOffDurationInMinutes) {
        Preconditions.checkState(autoOffDurationInMinutes == -1 || autoOffDurationInMinutes > 0, "autoOffTimerInMinutes must be -1 or positive");
        this.autoOffDurationInMinutes = autoOffDurationInMinutes;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DiagnosticsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public float getMaxRolledFileSizeInMB() {
        return this.maxRolledFileSizeInMB;
    }

    public DiagnosticsConfig setMaxRolledFileSizeInMB(float maxRolledFileSizeInMB) {
        this.maxRolledFileSizeInMB = Preconditions.checkPositive(maxRolledFileSizeInMB, "maxRolledFileSizeInMB must be positive");
        return this;
    }

    public int getMaxRolledFileCount() {
        return this.maxRolledFileCount;
    }

    public DiagnosticsConfig setMaxRolledFileCount(int maxRolledFileCount) {
        this.maxRolledFileCount = Preconditions.checkPositive("maxRolledFileCount must be positive", maxRolledFileCount);
        return this;
    }

    public boolean isIncludeEpochTime() {
        return this.includeEpochTime;
    }

    public DiagnosticsConfig setIncludeEpochTime(boolean includeEpochTime) {
        this.includeEpochTime = includeEpochTime;
        return this;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public DiagnosticsConfig setLogDirectory(@Nonnull String logDirectory) {
        this.logDirectory = Preconditions.checkHasText(logDirectory, "logDirectory must not be null");
        return this;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public DiagnosticsConfig setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    public DiagnosticsOutputType getOutputType() {
        return this.outputType;
    }

    public DiagnosticsConfig setOutputType(@Nonnull DiagnosticsOutputType outputType) {
        this.outputType = Preconditions.checkNotNull(outputType, "outputType must not be null");
        return this;
    }

    public Map<String, String> getPluginProperties() {
        return this.pluginProperties;
    }

    public DiagnosticsConfig setProperty(String name, String value) {
        this.pluginProperties.put(Preconditions.checkNotNull(name), Preconditions.checkNotNull(value));
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 74;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeFloat(this.maxRolledFileSizeInMB);
        out.writeInt(this.maxRolledFileCount);
        out.writeBoolean(this.includeEpochTime);
        out.writeString(this.logDirectory);
        out.writeString(this.fileNamePrefix);
        out.writeString(this.outputType.name());
        SerializationUtil.writeMapStringKey(this.pluginProperties, out);
        out.writeInt(this.autoOffDurationInMinutes);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.maxRolledFileSizeInMB = in.readFloat();
        this.maxRolledFileCount = in.readInt();
        this.includeEpochTime = in.readBoolean();
        this.logDirectory = in.readString();
        this.fileNamePrefix = in.readString();
        this.outputType = DiagnosticsOutputType.valueOf(in.readString());
        this.pluginProperties = SerializationUtil.readMapStringKey(in);
        this.autoOffDurationInMinutes = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiagnosticsConfig)) {
            return false;
        }
        DiagnosticsConfig that = (DiagnosticsConfig)o;
        return this.enabled == that.enabled && Float.compare(this.maxRolledFileSizeInMB, that.maxRolledFileSizeInMB) == 0 && this.maxRolledFileCount == that.maxRolledFileCount && this.includeEpochTime == that.includeEpochTime && Objects.equals(this.logDirectory, that.logDirectory) && Objects.equals(this.fileNamePrefix, that.fileNamePrefix) && Objects.equals((Object)this.outputType, (Object)that.outputType) && Objects.equals(this.pluginProperties, that.pluginProperties) && this.autoOffDurationInMinutes == that.autoOffDurationInMinutes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, Float.valueOf(this.maxRolledFileSizeInMB), this.maxRolledFileCount, this.includeEpochTime, this.logDirectory, this.fileNamePrefix, this.outputType, this.pluginProperties, this.autoOffDurationInMinutes});
    }

    public String toString() {
        String properties = "";
        if (this.pluginProperties != null) {
            properties = this.pluginProperties.keySet().stream().map(key -> key + "=" + this.pluginProperties.get(key)).collect(Collectors.joining(", ", "{", "}"));
        }
        return "DiagnosticsConfig{enabled=" + this.enabled + ", maxRolledFileSizeInMB=" + this.maxRolledFileSizeInMB + ", maxRolledFileCount=" + this.maxRolledFileCount + ", includeEpochTime=" + this.includeEpochTime + ", logDirectory='" + this.logDirectory + "', fileNamePrefix='" + this.fileNamePrefix + "', outputType=" + String.valueOf((Object)this.outputType) + ", autoOffDurationInMinutes=" + this.autoOffDurationInMinutes + ", properties='" + properties + "'}";
    }
}

