/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.spi.merge.MergingCreationTime;
import com.hazelcast.spi.merge.MergingHits;
import com.hazelcast.spi.merge.MergingLastAccessTime;
import com.hazelcast.spi.merge.MergingLastStoredTime;
import com.hazelcast.spi.merge.MergingLastUpdateTime;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.MergingView;
import com.hazelcast.spi.merge.NamespaceAwareSplitBrainMergePolicyProvider;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public final class MergePolicyValidator {
    private MergePolicyValidator() {
    }

    public static void checkMapMergePolicy(MapConfig mapConfig, String mergePolicyClassName, SplitBrainMergePolicyProvider mergePolicyProvider) {
        SplitBrainMergePolicy mergePolicyInstance = mergePolicyProvider.getMergePolicy(mergePolicyClassName, mapConfig.getUserCodeNamespace());
        List<Class> requiredMergeTypes = MergePolicyValidator.checkSplitBrainMergePolicy(SplitBrainMergeTypes.MapMergeTypes.class, mergePolicyInstance);
        if (!mapConfig.isPerEntryStatsEnabled() && requiredMergeTypes != null) {
            MergePolicyValidator.checkMapMergePolicyWhenStatisticsAreDisabled(mergePolicyClassName, requiredMergeTypes);
        }
    }

    public static void checkVectorCollectionMergePolicy(VectorCollectionConfig vectorCollectionConfig, String mergePolicyClassName, SplitBrainMergePolicyProvider mergePolicyProvider) {
        String namespace = vectorCollectionConfig.getUserCodeNamespace();
        SplitBrainMergePolicy mergePolicyInstance = mergePolicyProvider.getMergePolicy(mergePolicyClassName, namespace);
        MergePolicyValidator.checkSplitBrainMergePolicy(SplitBrainMergeTypes.VectorCollectionMergeTypes.class, mergePolicyInstance);
    }

    private static void checkMapMergePolicyWhenStatisticsAreDisabled(String mergePolicyClass, List<Class> requiredMergeTypes) {
        for (Class requiredMergeType : requiredMergeTypes) {
            if (!MergingLastStoredTime.class.isAssignableFrom(requiredMergeType) && !MergingCreationTime.class.isAssignableFrom(requiredMergeType) && !MergingHits.class.isAssignableFrom(requiredMergeType) && !MergingLastUpdateTime.class.isAssignableFrom(requiredMergeType) && !MergingLastAccessTime.class.isAssignableFrom(requiredMergeType)) continue;
            throw new InvalidConfigurationException("The merge policy " + mergePolicyClass + " requires the merge type " + requiredMergeType.getName() + ", which is just provided if perEntryStatsEnabled field of map-config is true.");
        }
    }

    static void checkMergeTypeProviderHasRequiredTypes(Class<? extends MergingValue> mergeTypes, SplitBrainMergePolicyProvider mergePolicyProvider, String mergePolicyClassName, String namespace) {
        if (mergePolicyProvider == null) {
            return;
        }
        SplitBrainMergePolicy mergePolicy = MergePolicyValidator.getMergePolicyInstance(mergePolicyProvider, mergePolicyClassName, namespace);
        MergePolicyValidator.checkSplitBrainMergePolicy(mergeTypes, mergePolicy);
    }

    private static SplitBrainMergePolicy getMergePolicyInstance(SplitBrainMergePolicyProvider mergePolicyProvider, String mergePolicyClassName, String namespace) {
        try {
            return MergePolicyValidator.isUCNAwareVersion(mergePolicyProvider) ? mergePolicyProvider.getMergePolicy(mergePolicyClassName, namespace) : mergePolicyProvider.getMergePolicy(mergePolicyClassName);
        }
        catch (InvalidConfigurationException e) {
            throw new InvalidConfigurationException("Merge policy must be an instance of SplitBrainMergePolicy, but was " + mergePolicyClassName, e.getCause());
        }
    }

    private static boolean isUCNAwareVersion(SplitBrainMergePolicyProvider provider) {
        return provider instanceof NamespaceAwareSplitBrainMergePolicyProvider;
    }

    private static List<Class> checkSplitBrainMergePolicy(Class<? extends MergingValue> mergeTypes, SplitBrainMergePolicy mergePolicyInstance) {
        ArrayList<Class> requiredMergeTypes = new ArrayList<Class>();
        Class<?> mergePolicyClass = mergePolicyInstance.getClass();
        String mergePolicyClassName = mergePolicyClass.getName();
        do {
            MergePolicyValidator.checkSplitBrainMergePolicyGenerics(requiredMergeTypes, mergeTypes, mergePolicyClassName, mergePolicyClass);
        } while ((mergePolicyClass = mergePolicyClass.getSuperclass()) != null);
        return requiredMergeTypes;
    }

    private static void checkSplitBrainMergePolicyGenerics(List<Class> requiredMergeTypes, Class providedMergeTypes, String mergePolicyClassName, Class<?> mergePolicyClass) {
        for (TypeVariable<Class<?>> classTypeVariable : mergePolicyClass.getTypeParameters()) {
            for (Type requireMergeType : classTypeVariable.getBounds()) {
                MergePolicyValidator.checkRequiredMergeType(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, requireMergeType);
            }
        }
        for (Type type : mergePolicyClass.getGenericInterfaces()) {
            MergePolicyValidator.checkRequiredGenericType(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, type);
        }
        Type type = mergePolicyClass.getGenericSuperclass();
        MergePolicyValidator.checkRequiredGenericType(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, type);
    }

    private static void checkRequiredGenericType(List<Class> requiredMergeTypes, Class providedMergeTypes, String mergePolicyClassName, Type requiredMergeType) {
        if (requiredMergeType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType type = (ParameterizedType)requiredMergeType;
            for (Type requireMergeType : actualTypeArguments = type.getActualTypeArguments()) {
                MergePolicyValidator.checkRequiredMergeType(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, requireMergeType);
            }
        }
    }

    private static void checkRequiredMergeType(List<Class> requiredMergeTypes, Class providedMergeTypes, String mergePolicyClassName, Type requireMergeType) {
        if (requireMergeType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)requireMergeType;
            Class requiredMergeType = (Class)type.getRawType();
            MergePolicyValidator.checkRequiredMergeTypeClass(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, requiredMergeType);
        } else if (requireMergeType instanceof Class) {
            Class requiredMergeType = (Class)requireMergeType;
            MergePolicyValidator.checkRequiredMergeTypeClass(requiredMergeTypes, providedMergeTypes, mergePolicyClassName, requiredMergeType);
        }
    }

    private static void checkRequiredMergeTypeClass(List<Class> requiredMergeTypes, Class providedMergeTypes, String mergePolicyClassName, Class<?> requiredMergeTypeClass) {
        if (!MergingView.class.isAssignableFrom(requiredMergeTypeClass)) {
            return;
        }
        if (!requiredMergeTypeClass.isAssignableFrom(providedMergeTypes)) {
            throw new InvalidConfigurationException("The merge policy " + mergePolicyClassName + " can just be configured on data structures which provide the merging type " + requiredMergeTypeClass.getName() + ". See SplitBrainMergeTypes for supported merging types.");
        }
        requiredMergeTypes.add(requiredMergeTypeClass);
    }
}

