/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.AutoDetectionConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.config.DataConnectionConfigValidator;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.DynamicConfigurationConfig;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.MetricsManagementCenterConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PersistenceClusterDataRecoveryPolicy;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.ProbabilisticSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.RecentlyActiveSplitBrainProtectionConfigBuilder;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.RestServerEndpointConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionConfigBuilder;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.SqlConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.TrustedInterfacesConfigurable;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.config.cp.CPMapConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.rest.RestConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import com.hazelcast.config.security.AccessControlServiceConfig;
import com.hazelcast.config.security.KerberosAuthenticationConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.LdapRoleMappingMode;
import com.hazelcast.config.security.LdapSearchScope;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.SimpleAuthenticationConfig;
import com.hazelcast.config.security.TlsAuthenticationConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.tpc.TpcConfig;
import com.hazelcast.config.tpc.TpcSocketConfig;
import com.hazelcast.config.vector.Metric;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.wan.WanPublisherState;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MemberDomConfigProcessor
extends AbstractDomConfigProcessor {
    private static final ILogger LOGGER = Logger.getLogger(MemberDomConfigProcessor.class);
    protected final Config config;

    public MemberDomConfigProcessor(boolean domLevel3, Config config, boolean strict) {
        super(domLevel3, strict);
        this.config = config;
    }

    public MemberDomConfigProcessor(boolean domLevel3, Config config) {
        super(domLevel3);
        this.config = config;
    }

    @Override
    public void buildConfig(Node rootNode) throws Exception {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration.");
            }
            if (this.handleNode(node) || ConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
        this.validateNetworkConfig();
    }

    private boolean handleNode(Node node) throws Exception {
        String nodeName = DomConfigHelper.cleanNodeName(node);
        if (this.matches(ConfigSections.INSTANCE_NAME.getName(), nodeName)) {
            this.config.setInstanceName(this.getNonEmptyText(node, "Instance name"));
        } else if (this.matches(ConfigSections.NETWORK.getName(), nodeName)) {
            this.handleNetwork(node);
        } else {
            if (this.matches(ConfigSections.IMPORT.getName(), nodeName)) {
                throw new HazelcastException("Non-expanded <import> element found");
            }
            if (this.matches(ConfigSections.CLUSTER_NAME.getName(), nodeName)) {
                this.config.setClusterName(this.getNonEmptyText(node, "Clustername"));
            } else if (this.matches(ConfigSections.PROPERTIES.getName(), nodeName)) {
                this.fillProperties(node, this.config.getProperties());
            } else if (this.matches(ConfigSections.WAN_REPLICATION.getName(), nodeName)) {
                this.handleWanReplication(node);
            } else if (this.matches(ConfigSections.EXECUTOR_SERVICE.getName(), nodeName)) {
                this.handleExecutor(node);
            } else if (this.matches(ConfigSections.DURABLE_EXECUTOR_SERVICE.getName(), nodeName)) {
                this.handleDurableExecutor(node);
            } else if (this.matches(ConfigSections.SCHEDULED_EXECUTOR_SERVICE.getName(), nodeName)) {
                this.handleScheduledExecutor(node);
            } else if (this.matches(ConfigSections.QUEUE.getName(), nodeName)) {
                this.handleQueue(node);
            } else if (this.matches(ConfigSections.MAP.getName(), nodeName)) {
                this.handleMap(node);
            } else if (this.matches(ConfigSections.MULTIMAP.getName(), nodeName)) {
                this.handleMultiMap(node);
            } else if (this.matches(ConfigSections.REPLICATED_MAP.getName(), nodeName)) {
                this.handleReplicatedMap(node);
            } else if (this.matches(ConfigSections.LIST.getName(), nodeName)) {
                this.handleList(node);
            } else if (this.matches(ConfigSections.SET.getName(), nodeName)) {
                this.handleSet(node);
            } else if (this.matches(ConfigSections.TOPIC.getName(), nodeName)) {
                this.handleTopic(node);
            } else if (this.matches(ConfigSections.RELIABLE_TOPIC.getName(), nodeName)) {
                this.handleReliableTopic(node);
            } else if (this.matches(ConfigSections.CACHE.getName(), nodeName)) {
                this.handleCache(node);
            } else if (this.matches(ConfigSections.NATIVE_MEMORY.getName(), nodeName)) {
                this.fillNativeMemoryConfig(node, this.config.getNativeMemoryConfig());
            } else if (this.matches(ConfigSections.RINGBUFFER.getName(), nodeName)) {
                this.handleRingbuffer(node);
            } else if (this.matches(ConfigSections.LISTENERS.getName(), nodeName)) {
                this.handleListeners(node);
            } else if (this.matches(ConfigSections.PARTITION_GROUP.getName(), nodeName)) {
                this.handlePartitionGroup(node);
            } else if (this.matches(ConfigSections.SERIALIZATION.getName(), nodeName)) {
                this.handleSerialization(node);
            } else if (this.matches(ConfigSections.SECURITY.getName(), nodeName)) {
                this.handleSecurity(node);
            } else if (this.matches(ConfigSections.MEMBER_ATTRIBUTES.getName(), nodeName)) {
                this.handleMemberAttributes(node);
            } else if (this.matches(ConfigSections.LICENSE_KEY.getName(), nodeName)) {
                this.config.setLicenseKey(this.getTextContent(node));
            } else if (this.matches(ConfigSections.MANAGEMENT_CENTER.getName(), nodeName)) {
                this.handleManagementCenterConfig(node);
            } else if (this.matches(ConfigSections.SPLIT_BRAIN_PROTECTION.getName(), nodeName)) {
                this.handleSplitBrainProtection(node);
            } else if (this.matches(ConfigSections.LITE_MEMBER.getName(), nodeName)) {
                this.handleLiteMember(node);
            } else if (this.matches(ConfigSections.HOT_RESTART_PERSISTENCE.getName(), nodeName)) {
                this.handleHotRestartPersistence(node);
            } else if (this.matches(ConfigSections.PERSISTENCE.getName(), nodeName)) {
                this.handlePersistence(node);
            } else if (this.matches(ConfigSections.USER_CODE_DEPLOYMENT.getName(), nodeName)) {
                this.handleUserCodeDeployment(node);
            } else if (this.matches(ConfigSections.CARDINALITY_ESTIMATOR.getName(), nodeName)) {
                this.handleCardinalityEstimator(node);
            } else if (this.matches(ConfigSections.FLAKE_ID_GENERATOR.getName(), nodeName)) {
                this.handleFlakeIdGenerator(node);
            } else if (this.matches(ConfigSections.CRDT_REPLICATION.getName(), nodeName)) {
                this.handleCRDTReplication(node);
            } else if (this.matches(ConfigSections.PN_COUNTER.getName(), nodeName)) {
                this.handlePNCounter(node);
            } else if (this.matches(ConfigSections.ADVANCED_NETWORK.getName(), nodeName)) {
                this.handleAdvancedNetwork(node);
            } else if (this.matches(ConfigSections.CP_SUBSYSTEM.getName(), nodeName)) {
                this.handleCPSubsystem(node);
            } else if (this.matches(ConfigSections.AUDITLOG.getName(), nodeName)) {
                this.fillFactoryWithPropertiesConfig(node, this.config.getAuditlogConfig());
            } else if (this.matches(ConfigSections.METRICS.getName(), nodeName)) {
                this.handleMetrics(node);
            } else if (this.matches(ConfigSections.INSTANCE_TRACKING.getName(), nodeName)) {
                this.handleInstanceTracking(node, this.config.getInstanceTrackingConfig());
            } else if (this.matches(ConfigSections.SQL.getName(), nodeName)) {
                this.handleSql(node);
            } else if (this.matches(ConfigSections.JET.getName(), nodeName)) {
                this.handleJet(node);
            } else if (this.matches(ConfigSections.LOCAL_DEVICE.getName(), nodeName)) {
                this.handleLocalDevice(node);
            } else if (this.matches(ConfigSections.DYNAMIC_CONFIGURATION.getName(), nodeName)) {
                this.handleDynamicConfiguration(node);
            } else if (this.matches(ConfigSections.INTEGRITY_CHECKER.getName(), nodeName)) {
                this.handleIntegrityChecker(node);
            } else if (this.matches(ConfigSections.DATA_CONNECTION.getName(), nodeName)) {
                this.handleDataConnections(node);
            } else if (this.matches(ConfigSections.TPC.getName(), nodeName)) {
                this.handleTpc(node);
            } else if (this.matches(ConfigSections.USER_CODE_NAMESPACES.getName(), nodeName)) {
                this.handleNamespaces(node);
            } else if (this.matches(ConfigSections.REST.getName(), nodeName)) {
                this.handleRest(node);
            } else if (this.matches(ConfigSections.VECTOR.getName(), nodeName)) {
                this.handleVector(node);
            } else {
                return true;
            }
        }
        return false;
    }

    private String getNonEmptyText(Node node, String configName) throws InvalidConfigurationException {
        String val = this.getTextContent(node);
        if (val == null || val.isEmpty()) {
            throw new InvalidConfigurationException("XML configuration is empty: " + configName);
        }
        return val;
    }

    private void handleUserCodeDeployment(Node dcRoot) {
        UserCodeDeploymentConfig dcConfig = this.config.getUserCodeDeploymentConfig();
        Node attrEnabled = this.getNamedItemNode(dcRoot, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        dcConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(dcRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("class-cache-mode", name)) {
                UserCodeDeploymentConfig.ClassCacheMode classCacheMode = UserCodeDeploymentConfig.ClassCacheMode.valueOf(this.getTextContent(n));
                dcConfig.setClassCacheMode(classCacheMode);
                continue;
            }
            if (this.matches("provider-mode", name)) {
                UserCodeDeploymentConfig.ProviderMode providerMode = UserCodeDeploymentConfig.ProviderMode.valueOf(this.getTextContent(n));
                dcConfig.setProviderMode(providerMode);
                continue;
            }
            if (this.matches("blacklist-prefixes", name)) {
                dcConfig.setBlacklistedPrefixes(this.getTextContent(n));
                continue;
            }
            if (this.matches("whitelist-prefixes", name)) {
                dcConfig.setWhitelistedPrefixes(this.getTextContent(n));
                continue;
            }
            if (!this.matches("provider-filter", name)) continue;
            dcConfig.setProviderFilter(this.getTextContent(n));
        }
        this.config.setUserCodeDeploymentConfig(dcConfig);
    }

    private void handleHotRestartPersistence(Node hrRoot) throws Exception {
        HotRestartPersistenceConfig hrConfig = this.config.getHotRestartPersistenceConfig().setEnabled(DomConfigHelper.getBooleanValue(this.getAttribute(hrRoot, "enabled")));
        String parallelismName = "parallelism";
        String validationTimeoutName = "validation-timeout-seconds";
        String dataLoadTimeoutName = "data-load-timeout-seconds";
        for (Node n : DomConfigHelper.childElements(hrRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("encryption-at-rest", name)) {
                this.handleEncryptionAtRest(n, hrConfig);
                continue;
            }
            if (this.matches("base-dir", name)) {
                hrConfig.setBaseDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (this.matches("backup-dir", name)) {
                hrConfig.setBackupDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (this.matches(parallelismName, name)) {
                hrConfig.setParallelism(DomConfigHelper.getIntegerValue(parallelismName, this.getTextContent(n)));
                continue;
            }
            if (this.matches(validationTimeoutName, name)) {
                hrConfig.setValidationTimeoutSeconds(DomConfigHelper.getIntegerValue(validationTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (this.matches(dataLoadTimeoutName, name)) {
                hrConfig.setDataLoadTimeoutSeconds(DomConfigHelper.getIntegerValue(dataLoadTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (this.matches("cluster-data-recovery-policy", name)) {
                hrConfig.setClusterDataRecoveryPolicy(HotRestartClusterDataRecoveryPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
                continue;
            }
            if (!this.matches("auto-remove-stale-data", name)) continue;
            hrConfig.setAutoRemoveStaleData(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
        }
        this.config.setHotRestartPersistenceConfig(hrConfig);
    }

    private void handlePersistence(Node prRoot) throws Exception {
        PersistenceConfig prConfig = this.config.getPersistenceConfig().setEnabled(DomConfigHelper.getBooleanValue(this.getAttribute(prRoot, "enabled")));
        String parallelismName = "parallelism";
        String validationTimeoutName = "validation-timeout-seconds";
        String dataLoadTimeoutName = "data-load-timeout-seconds";
        String rebalanceDelaySecondsName = "rebalance-delay-seconds";
        for (Node n : DomConfigHelper.childElements(prRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("encryption-at-rest", name)) {
                this.handleEncryptionAtRest(n, prConfig);
                continue;
            }
            if (this.matches("base-dir", name)) {
                prConfig.setBaseDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (this.matches("backup-dir", name)) {
                prConfig.setBackupDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (this.matches(parallelismName, name)) {
                prConfig.setParallelism(DomConfigHelper.getIntegerValue(parallelismName, this.getTextContent(n)));
                continue;
            }
            if (this.matches(validationTimeoutName, name)) {
                prConfig.setValidationTimeoutSeconds(DomConfigHelper.getIntegerValue(validationTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (this.matches(dataLoadTimeoutName, name)) {
                prConfig.setDataLoadTimeoutSeconds(DomConfigHelper.getIntegerValue(dataLoadTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (this.matches("cluster-data-recovery-policy", name)) {
                prConfig.setClusterDataRecoveryPolicy(PersistenceClusterDataRecoveryPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
                continue;
            }
            if (this.matches("auto-remove-stale-data", name)) {
                prConfig.setAutoRemoveStaleData(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (!this.matches("rebalance-delay-seconds", name)) continue;
            prConfig.setRebalanceDelaySeconds(DomConfigHelper.getIntegerValue(rebalanceDelaySecondsName, this.getTextContent(n)));
        }
        this.config.setPersistenceConfig(prConfig);
    }

    private void handleDynamicConfiguration(Node node) {
        DynamicConfigurationConfig dynamicConfigurationConfig = this.config.getDynamicConfigurationConfig();
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("persistence-enabled", name)) {
                dynamicConfigurationConfig.setPersistenceEnabled(Boolean.parseBoolean(this.getTextContent(n)));
                continue;
            }
            if (this.matches("backup-dir", name)) {
                dynamicConfigurationConfig.setBackupDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (!this.matches("backup-count", name)) continue;
            dynamicConfigurationConfig.setBackupCount(Integer.parseInt(this.getTextContent(n)));
        }
    }

    protected void handleLocalDevice(Node parentNode) {
        String name = this.getAttribute(parentNode, "name");
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)ConfigUtils.getByNameOrNew(this.config.getDeviceConfigs(), name, LocalDeviceConfig.class);
        this.handleLocalDeviceNode(parentNode, localDeviceConfig);
    }

    protected void handleLocalDeviceNode(Node deviceNode, LocalDeviceConfig localDeviceConfig) {
        String blockSizeName = "block-size";
        String readIOThreadCountName = "read-io-thread-count";
        String writeIOThreadCountName = "write-io-thread-count";
        for (Node n : DomConfigHelper.childElements(deviceNode)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("base-dir", name)) {
                localDeviceConfig.setBaseDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (this.matches("capacity", name)) {
                localDeviceConfig.setCapacity(this.createCapacity(n));
                continue;
            }
            if (this.matches(blockSizeName, name)) {
                localDeviceConfig.setBlockSize(DomConfigHelper.getIntegerValue(blockSizeName, this.getTextContent(n)));
                continue;
            }
            if (this.matches(readIOThreadCountName, name)) {
                localDeviceConfig.setReadIOThreadCount(DomConfigHelper.getIntegerValue(readIOThreadCountName, this.getTextContent(n)));
                continue;
            }
            if (!this.matches(writeIOThreadCountName, name)) continue;
            localDeviceConfig.setWriteIOThreadCount(DomConfigHelper.getIntegerValue(writeIOThreadCountName, this.getTextContent(n)));
        }
        this.config.addDeviceConfig(localDeviceConfig);
    }

    private TieredStoreConfig createTieredStoreConfig(Node tsRoot) {
        TieredStoreConfig tieredStoreConfig = new TieredStoreConfig();
        Node attrEnabled = this.getNamedItemNode(tsRoot, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        tieredStoreConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(tsRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("memory-tier", name)) {
                tieredStoreConfig.setMemoryTierConfig(this.createMemoryTierConfig(n));
                continue;
            }
            if (!this.matches("disk-tier", name)) continue;
            tieredStoreConfig.setDiskTierConfig(this.createDiskTierConfig(n));
        }
        return tieredStoreConfig;
    }

    private MemoryTierConfig createMemoryTierConfig(Node node) {
        MemoryTierConfig memoryTierConfig = new MemoryTierConfig();
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("capacity", name)) continue;
            return memoryTierConfig.setCapacity(this.createCapacity(n));
        }
        return memoryTierConfig;
    }

    private DiskTierConfig createDiskTierConfig(Node node) {
        DiskTierConfig diskTierConfig = new DiskTierConfig();
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        diskTierConfig.setEnabled(enabled);
        Node attrDeviceName = this.getNamedItemNode(node, "device-name");
        if (attrDeviceName != null) {
            diskTierConfig.setDeviceName(this.getTextContent(attrDeviceName));
        }
        return diskTierConfig;
    }

    private void handleEncryptionAtRest(Node encryptionAtRestRoot, HotRestartPersistenceConfig hrConfig) throws Exception {
        EncryptionAtRestConfig encryptionAtRestConfig = new EncryptionAtRestConfig();
        this.handleViaReflection(encryptionAtRestRoot, hrConfig, encryptionAtRestConfig, "secure-store");
        for (Node secureStore : DomConfigHelper.childElementsWithName(encryptionAtRestRoot, "secure-store", this.strict)) {
            this.handleSecureStore(secureStore, encryptionAtRestConfig);
        }
        hrConfig.setEncryptionAtRestConfig(encryptionAtRestConfig);
    }

    private void handleEncryptionAtRest(Node encryptionAtRestRoot, PersistenceConfig prConfig) throws Exception {
        EncryptionAtRestConfig encryptionAtRestConfig = new EncryptionAtRestConfig();
        this.handleViaReflection(encryptionAtRestRoot, prConfig, encryptionAtRestConfig, "secure-store");
        for (Node secureStore : DomConfigHelper.childElementsWithName(encryptionAtRestRoot, "secure-store", this.strict)) {
            this.handleSecureStore(secureStore, encryptionAtRestConfig);
        }
        prConfig.setEncryptionAtRestConfig(encryptionAtRestConfig);
    }

    private void handleSecureStore(Node secureStoreRoot, EncryptionAtRestConfig encryptionAtRestConfig) {
        Node n = DomConfigHelper.firstChildElement(secureStoreRoot);
        if (n != null) {
            SecureStoreConfig secureStoreConfig;
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("keystore", name)) {
                secureStoreConfig = this.handleJavaKeyStore(n);
            } else if (this.matches("vault", name)) {
                secureStoreConfig = this.handleVault(n);
            } else {
                throw new InvalidConfigurationException("Unrecognized Secure Store type: " + name);
            }
            encryptionAtRestConfig.setSecureStoreConfig(secureStoreConfig);
        }
    }

    private SecureStoreConfig handleJavaKeyStore(Node keyStoreRoot) {
        File path = null;
        String password = null;
        String type = null;
        String currentKeyAlias = null;
        int pollingInterval = 0;
        for (Node n : DomConfigHelper.childElements(keyStoreRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("path", name)) {
                path = new File(this.getTextContent(n)).getAbsoluteFile();
                continue;
            }
            if (this.matches("type", name)) {
                type = this.getTextContent(n);
                continue;
            }
            if (this.matches("password", name)) {
                password = this.getTextContent(n);
                continue;
            }
            if (this.matches("current-key-alias", name)) {
                currentKeyAlias = this.getTextContent(n);
                continue;
            }
            if (!this.matches("polling-interval", name)) continue;
            pollingInterval = Integer.parseInt(this.getTextContent(n));
        }
        JavaKeyStoreSecureStoreConfig keyStoreSecureStoreConfig = new JavaKeyStoreSecureStoreConfig(path).setPassword(password).setPollingInterval(pollingInterval).setCurrentKeyAlias(currentKeyAlias);
        if (type != null) {
            keyStoreSecureStoreConfig.setType(type);
        }
        return keyStoreSecureStoreConfig;
    }

    private SecureStoreConfig handleVault(Node vaultRoot) {
        String address = null;
        String secretPath = null;
        String token = null;
        SSLConfig sslConfig = null;
        int pollingInterval = 0;
        for (Node n : DomConfigHelper.childElements(vaultRoot)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("address", name)) {
                address = this.getTextContent(n);
                continue;
            }
            if (this.matches("secret-path", name)) {
                secretPath = this.getTextContent(n);
                continue;
            }
            if (this.matches("token", name)) {
                token = this.getTextContent(n);
                continue;
            }
            if (this.matches("ssl", name)) {
                sslConfig = this.parseSslConfig(n);
                continue;
            }
            if (!this.matches("polling-interval", name)) continue;
            pollingInterval = Integer.parseInt(this.getTextContent(n));
        }
        return new VaultSecureStoreConfig(address, secretPath, token).setSSLConfig(sslConfig).setPollingInterval(pollingInterval);
    }

    private void handleCRDTReplication(Node root) {
        CRDTReplicationConfig replicationConfig = new CRDTReplicationConfig();
        String replicationPeriodMillisName = "replication-period-millis";
        String maxConcurrentReplicationTargetsName = "max-concurrent-replication-targets";
        for (Node n : DomConfigHelper.childElements(root)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("replication-period-millis", name)) {
                replicationConfig.setReplicationPeriodMillis(DomConfigHelper.getIntegerValue("replication-period-millis", this.getTextContent(n)));
                continue;
            }
            if (!this.matches("max-concurrent-replication-targets", name)) continue;
            replicationConfig.setMaxConcurrentReplicationTargets(DomConfigHelper.getIntegerValue("max-concurrent-replication-targets", this.getTextContent(n)));
        }
        this.config.setCRDTReplicationConfig(replicationConfig);
    }

    private void handleLiteMember(Node node) {
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean liteMember = attrEnabled != null && DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        this.config.setLiteMember(liteMember);
    }

    protected void handleSplitBrainProtection(Node node) {
        String name = this.getAttribute(node, "name");
        SplitBrainProtectionConfig splitBrainProtectionConfig = ConfigUtils.getByNameOrNew(this.config.getSplitBrainProtectionConfigs(), name, SplitBrainProtectionConfig.class);
        this.handleSplitBrainProtectionNode(node, splitBrainProtectionConfig, name);
    }

    protected void handleSplitBrainProtectionNode(Node node, SplitBrainProtectionConfig splitBrainProtectionConfig, String name) {
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        SplitBrainProtectionConfigBuilder splitBrainProtectionConfigBuilder = null;
        splitBrainProtectionConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("minimum-cluster-size", nodeName)) {
                splitBrainProtectionConfig.setMinimumClusterSize(DomConfigHelper.getIntegerValue("minimum-cluster-size", this.getTextContent(n)));
                continue;
            }
            if (this.matches("listeners", nodeName)) {
                this.handleSplitBrainProtectionListeners(splitBrainProtectionConfig, n);
                continue;
            }
            if (this.matches("protect-on", nodeName)) {
                splitBrainProtectionConfig.setProtectOn(SplitBrainProtectionOn.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
                continue;
            }
            if (this.matches("function-class-name", nodeName)) {
                splitBrainProtectionConfig.setFunctionClassName(this.getTextContent(n));
                continue;
            }
            if (this.matches("recently-active-split-brain-protection", nodeName)) {
                splitBrainProtectionConfigBuilder = this.handleRecentlyActiveSplitBrainProtection(name, n, splitBrainProtectionConfig.getMinimumClusterSize());
                continue;
            }
            if (!this.matches("probabilistic-split-brain-protection", nodeName)) continue;
            splitBrainProtectionConfigBuilder = this.handleProbabilisticSplitBrainProtection(name, n, splitBrainProtectionConfig.getMinimumClusterSize());
        }
        if (splitBrainProtectionConfigBuilder != null) {
            boolean splitBrainProtectionFunctionDefinedByClassName;
            boolean bl = splitBrainProtectionFunctionDefinedByClassName = !StringUtil.isNullOrEmpty(splitBrainProtectionConfig.getFunctionClassName());
            if (splitBrainProtectionFunctionDefinedByClassName) {
                throw new InvalidConfigurationException("A split brain protection cannot simultaneously define probabilistic-split-brain-protection or recently-active-split-brain-protection and a split brain protection function class name.");
            }
            SplitBrainProtectionConfig constructedConfig = splitBrainProtectionConfigBuilder.build();
            constructedConfig.setMinimumClusterSize(splitBrainProtectionConfig.getMinimumClusterSize());
            constructedConfig.setProtectOn(splitBrainProtectionConfig.getProtectOn());
            constructedConfig.setListenerConfigs(splitBrainProtectionConfig.getListenerConfigs());
            splitBrainProtectionConfig = constructedConfig;
        }
        this.config.addSplitBrainProtectionConfig(splitBrainProtectionConfig);
    }

    protected void handleSplitBrainProtectionListeners(SplitBrainProtectionConfig splitBrainProtectionConfig, Node n) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            String listenerClass = this.getTextContent(listenerNode);
            splitBrainProtectionConfig.addListenerConfig(new SplitBrainProtectionListenerConfig(listenerClass));
        }
    }

    private SplitBrainProtectionConfigBuilder handleRecentlyActiveSplitBrainProtection(String name, Node node, int splitBrainProtectionSize) {
        int heartbeatToleranceMillis = DomConfigHelper.getIntegerValue("heartbeat-tolerance-millis", this.getAttribute(node, "heartbeat-tolerance-millis"), RecentlyActiveSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_TOLERANCE_MILLIS);
        RecentlyActiveSplitBrainProtectionConfigBuilder splitBrainProtectionConfigBuilder = SplitBrainProtectionConfig.newRecentlyActiveSplitBrainProtectionConfigBuilder(name, splitBrainProtectionSize, heartbeatToleranceMillis);
        return splitBrainProtectionConfigBuilder;
    }

    private SplitBrainProtectionConfigBuilder handleProbabilisticSplitBrainProtection(String name, Node node, int splitBrainProtectionSize) {
        long acceptableHeartPause = DomConfigHelper.getLongValue("acceptable-heartbeat-pause-millis", this.getAttribute(node, "acceptable-heartbeat-pause-millis"), ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_PAUSE_MILLIS);
        double threshold = DomConfigHelper.getDoubleValue("suspicion-threshold", this.getAttribute(node, "suspicion-threshold"), ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_PHI_THRESHOLD);
        int maxSampleSize = DomConfigHelper.getIntegerValue("max-sample-size", this.getAttribute(node, "max-sample-size"), ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_SAMPLE_SIZE);
        long minStdDeviation = DomConfigHelper.getLongValue("min-std-deviation-millis", this.getAttribute(node, "min-std-deviation-millis"), ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_MIN_STD_DEVIATION);
        long heartbeatIntervalMillis = DomConfigHelper.getLongValue("heartbeat-interval-millis", this.getAttribute(node, "heartbeat-interval-millis"), ProbabilisticSplitBrainProtectionConfigBuilder.DEFAULT_HEARTBEAT_INTERVAL_MILLIS);
        ProbabilisticSplitBrainProtectionConfigBuilder splitBrainProtectionConfigBuilder = SplitBrainProtectionConfig.newProbabilisticSplitBrainProtectionConfigBuilder(name, splitBrainProtectionSize).withAcceptableHeartbeatPauseMillis(acceptableHeartPause).withSuspicionThreshold(threshold).withHeartbeatIntervalMillis(heartbeatIntervalMillis).withMinStdDeviationMillis(minStdDeviation).withMaxSampleSize(maxSampleSize);
        return splitBrainProtectionConfigBuilder;
    }

    protected void handleWanReplication(Node node) {
        Node attName = this.getNamedItemNode(node, "name");
        String name = this.getTextContent(attName);
        WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
        wanReplicationConfig.setName(name);
        this.handleWanReplicationNode(node, wanReplicationConfig);
    }

    void handleWanReplicationNode(Node node, WanReplicationConfig wanReplicationConfig) {
        for (Node nodeTarget : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(nodeTarget);
            this.handleWanReplicationChild(wanReplicationConfig, nodeTarget, nodeName);
        }
        this.config.addWanReplicationConfig(wanReplicationConfig);
    }

    protected void handleWanReplicationChild(WanReplicationConfig wanReplicationConfig, Node nodeTarget, String nodeName) {
        if (this.matches("batch-publisher", nodeName)) {
            WanBatchPublisherConfig config = new WanBatchPublisherConfig();
            this.handleBatchWanPublisherNode(wanReplicationConfig, nodeTarget, config);
        } else if (this.matches("custom-publisher", nodeName)) {
            WanCustomPublisherConfig config = new WanCustomPublisherConfig();
            this.handleCustomWanPublisherNode(wanReplicationConfig, nodeTarget, config);
        } else if (this.matches("consumer", nodeName)) {
            this.handleWanConsumerNode(wanReplicationConfig, nodeTarget);
        }
    }

    void handleCustomWanPublisherNode(WanReplicationConfig wanReplicationConfig, Node nodeTarget, WanCustomPublisherConfig config) {
        for (Node targetChild : DomConfigHelper.childElements(nodeTarget)) {
            String targetChildName = DomConfigHelper.cleanNodeName(targetChild);
            if (this.matches("properties", targetChildName)) {
                this.fillProperties(targetChild, config.getProperties());
                continue;
            }
            if (this.matches("publisher-id", targetChildName)) {
                config.setPublisherId(this.getTextContent(targetChild));
                continue;
            }
            if (!this.matches("class-name", targetChildName)) continue;
            config.setClassName(this.getTextContent(targetChild));
        }
        wanReplicationConfig.addCustomPublisherConfig(config);
    }

    void handleBatchWanPublisherNode(WanReplicationConfig wanReplicationConfig, Node nodeTarget, WanBatchPublisherConfig config) {
        for (Node targetChild : DomConfigHelper.childElements(nodeTarget)) {
            String targetChildName = DomConfigHelper.cleanNodeName(targetChild);
            if (this.matches("cluster-name", targetChildName)) {
                config.setClusterName(this.getTextContent(targetChild));
                continue;
            }
            if (this.matches("publisher-id", targetChildName)) {
                config.setPublisherId(this.getTextContent(targetChild));
                continue;
            }
            if (this.matches("target-endpoints", targetChildName)) {
                config.setTargetEndpoints(this.getTextContent(targetChild));
                continue;
            }
            if (this.matches("snapshot-enabled", targetChildName)) {
                config.setSnapshotEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("initial-publisher-state", targetChildName)) {
                config.setInitialPublisherState(WanPublisherState.valueOf(StringUtil.upperCaseInternal(this.getTextContent(targetChild))));
                continue;
            }
            if (this.matches("queue-capacity", targetChildName)) {
                config.setQueueCapacity(DomConfigHelper.getIntegerValue("queue-capacity", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("batch-size", targetChildName)) {
                config.setBatchSize(DomConfigHelper.getIntegerValue("batch-size", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("batch-max-delay-millis", targetChildName)) {
                config.setBatchMaxDelayMillis(DomConfigHelper.getIntegerValue("batch-max-delay-millis", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("response-timeout-millis", targetChildName)) {
                config.setResponseTimeoutMillis(DomConfigHelper.getIntegerValue("response-timeout-millis", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("queue-full-behavior", targetChildName)) {
                config.setQueueFullBehavior(WanQueueFullBehavior.valueOf(StringUtil.upperCaseInternal(this.getTextContent(targetChild))));
                continue;
            }
            if (this.matches("acknowledge-type", targetChildName)) {
                config.setAcknowledgeType(WanAcknowledgeType.valueOf(StringUtil.upperCaseInternal(this.getTextContent(targetChild))));
                continue;
            }
            if (this.matches("discovery-period-seconds", targetChildName)) {
                config.setDiscoveryPeriodSeconds(DomConfigHelper.getIntegerValue("discovery-period-seconds", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("max-target-endpoints", targetChildName)) {
                config.setMaxTargetEndpoints(DomConfigHelper.getIntegerValue("max-target-endpoints", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("max-concurrent-invocations", targetChildName)) {
                config.setMaxConcurrentInvocations(DomConfigHelper.getIntegerValue("max-concurrent-invocations", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("use-endpoint-private-address", targetChildName)) {
                config.setUseEndpointPrivateAddress(DomConfigHelper.getBooleanValue(this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("idle-min-park-ns", targetChildName)) {
                config.setIdleMinParkNs(DomConfigHelper.getIntegerValue("idle-min-park-ns", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("idle-max-park-ns", targetChildName)) {
                config.setIdleMaxParkNs(DomConfigHelper.getIntegerValue("idle-max-park-ns", this.getTextContent(targetChild)));
                continue;
            }
            if (this.matches("properties", targetChildName)) {
                this.fillProperties(targetChild, config.getProperties());
                continue;
            }
            if (AliasedDiscoveryConfigUtils.supports(targetChildName)) {
                this.handleAliasedDiscoveryStrategy(config, targetChild, targetChildName);
                continue;
            }
            if (this.matches("discovery-strategies", targetChildName)) {
                this.handleDiscoveryStrategies(config.getDiscoveryConfig(), targetChild);
                continue;
            }
            if (this.matches("sync", targetChildName)) {
                this.handleWanSync(config.getSyncConfig(), targetChild);
                continue;
            }
            if (!this.matches("endpoint", targetChildName)) continue;
            config.setEndpoint(this.getTextContent(targetChild));
        }
        wanReplicationConfig.addBatchReplicationPublisherConfig(config);
    }

    void handleWanConsumerNode(WanReplicationConfig wanReplicationConfig, Node nodeTarget) {
        WanConsumerConfig consumerConfig = new WanConsumerConfig();
        for (Node targetChild : DomConfigHelper.childElements(nodeTarget)) {
            this.handleWanConsumerConfig(consumerConfig, targetChild);
        }
        wanReplicationConfig.setConsumerConfig(consumerConfig);
    }

    private void handleWanSync(WanSyncConfig wanSyncConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("consistency-check-strategy", nodeName)) continue;
            String strategy = this.getTextContent(child);
            wanSyncConfig.setConsistencyCheckStrategy(ConsistencyCheckStrategy.valueOf(StringUtil.upperCaseInternal(strategy)));
        }
    }

    private void handleWanConsumerConfig(WanConsumerConfig consumerConfig, Node targetChild) {
        String targetChildName = DomConfigHelper.cleanNodeName(targetChild);
        if (this.matches("class-name", targetChildName)) {
            consumerConfig.setClassName(this.getTextContent(targetChild));
        } else if (this.matches("properties", targetChildName)) {
            this.fillProperties(targetChild, consumerConfig.getProperties());
        } else if (this.matches("persist-wan-replicated-data", targetChildName)) {
            consumerConfig.setPersistWanReplicatedData(DomConfigHelper.getBooleanValue(this.getTextContent(targetChild)));
        }
    }

    private void handleNetwork(Node node) throws Exception {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("reuse-address", nodeName)) {
                this.config.getNetworkConfig().setReuseAddress(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("port", nodeName)) {
                this.handlePort(child, this.config);
                continue;
            }
            if (this.matches("outbound-ports", nodeName)) {
                this.handleOutboundPorts(child);
                continue;
            }
            if (this.matches("public-address", nodeName)) {
                this.config.getNetworkConfig().setPublicAddress(this.getTextContent(child));
                continue;
            }
            if (this.matches("join", nodeName)) {
                this.handleJoin(child, false);
                continue;
            }
            if (this.matches("interfaces", nodeName)) {
                this.handleInterfaces(child);
                continue;
            }
            if (this.matches("symmetric-encryption", nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new SymmetricEncryptionConfig(), new String[0]);
                continue;
            }
            if (this.matches("ssl", nodeName)) {
                this.handleSSLConfig(child);
                continue;
            }
            if (this.matches("socket-interceptor", nodeName)) {
                this.handleSocketInterceptorConfig(child);
                continue;
            }
            if (this.matches("member-address-provider", nodeName)) {
                this.handleMemberAddressProvider(child, false);
                continue;
            }
            if (this.matches("failure-detector", nodeName)) {
                this.handleFailureDetector(child, false);
                continue;
            }
            if (this.matches("rest-api", nodeName)) {
                this.handleRestApi(child);
                continue;
            }
            if (this.matches("memcache-protocol", nodeName)) {
                this.handleMemcacheProtocol(child);
                continue;
            }
            if (!this.matches("tpc-socket", nodeName)) continue;
            this.handleTpcSocketConfig(child, this.config.getNetworkConfig().getTpcSocketConfig());
        }
    }

    private void handleAdvancedNetwork(Node node) throws Exception {
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            this.config.getAdvancedNetworkConfig().setEnabled(DomConfigHelper.getBooleanValue(att.getNodeValue()));
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("join", nodeName)) {
                this.handleJoin(child, true);
                continue;
            }
            if (this.matches("wan-endpoint-config", nodeName)) {
                this.handleWanEndpointConfig(child);
                continue;
            }
            if (this.matches("member-server-socket-endpoint-config", nodeName)) {
                this.handleMemberServerSocketEndpointConfig(child);
                continue;
            }
            if (this.matches("client-server-socket-endpoint-config", nodeName)) {
                this.handleClientServerSocketEndpointConfig(child);
                continue;
            }
            if (this.matches("wan-server-socket-endpoint-config", nodeName)) {
                this.handleWanServerSocketEndpointConfig(child);
                continue;
            }
            if (this.matches("rest-server-socket-endpoint-config", nodeName)) {
                this.handleRestServerSocketEndpointConfig(child);
                continue;
            }
            if (this.matches("memcache-server-socket-endpoint-config", nodeName)) {
                this.handleMemcacheServerSocketEndpointConfig(child);
                continue;
            }
            if (this.matches("member-address-provider", nodeName)) {
                this.handleMemberAddressProvider(child, true);
                continue;
            }
            if (!this.matches("failure-detector", nodeName)) continue;
            this.handleFailureDetector(child, true);
        }
    }

    private void handleEndpointConfig(EndpointConfig endpointConfig, Node node) throws Exception {
        String endpointName = this.getAttribute(node, "name");
        this.handleEndpointConfig(endpointConfig, node, endpointName);
    }

    protected void handleEndpointConfig(EndpointConfig endpointConfig, Node node, String endpointName) throws Exception {
        endpointConfig.setName(endpointName);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            this.handleEndpointConfigCommons(child, nodeName, endpointConfig);
        }
        this.config.getAdvancedNetworkConfig().addWanEndpointConfig(endpointConfig);
    }

    private void handleMemberServerSocketEndpointConfig(Node node) throws Exception {
        ServerSocketEndpointConfig config = (ServerSocketEndpointConfig)this.config.getAdvancedNetworkConfig().getEndpointConfigs().getOrDefault(EndpointQualifier.MEMBER, new ServerSocketEndpointConfig());
        config.setProtocolType(ProtocolType.MEMBER);
        this.handleServerSocketEndpointConfig(config, node);
    }

    private void handleClientServerSocketEndpointConfig(Node node) throws Exception {
        ServerSocketEndpointConfig config = (ServerSocketEndpointConfig)this.config.getAdvancedNetworkConfig().getEndpointConfigs().getOrDefault(EndpointQualifier.CLIENT, new ServerSocketEndpointConfig());
        config.setProtocolType(ProtocolType.CLIENT);
        this.handleServerSocketEndpointConfig(config, node);
    }

    protected void handleWanServerSocketEndpointConfig(Node node) throws Exception {
        ServerSocketEndpointConfig config = new ServerSocketEndpointConfig();
        config.setProtocolType(ProtocolType.WAN);
        this.handleServerSocketEndpointConfig(config, node);
    }

    private void handleRestServerSocketEndpointConfig(Node node) throws Exception {
        RestServerEndpointConfig config = (RestServerEndpointConfig)this.config.getAdvancedNetworkConfig().getEndpointConfigs().getOrDefault(EndpointQualifier.REST, new RestServerEndpointConfig());
        this.handleServerSocketEndpointConfig(config, node);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("endpoint-groups", nodeName)) continue;
            for (Node endpointGroup : DomConfigHelper.childElements(child)) {
                this.handleRestEndpointGroup(config, endpointGroup);
            }
        }
    }

    private void handleMemcacheServerSocketEndpointConfig(Node node) throws Exception {
        ServerSocketEndpointConfig config = (ServerSocketEndpointConfig)this.config.getAdvancedNetworkConfig().getEndpointConfigs().getOrDefault(EndpointQualifier.MEMCACHE, new ServerSocketEndpointConfig());
        config.setProtocolType(ProtocolType.MEMCACHE);
        this.handleServerSocketEndpointConfig(config, node);
    }

    protected void handleWanEndpointConfig(Node node) throws Exception {
        EndpointConfig config = new EndpointConfig();
        config.setProtocolType(ProtocolType.WAN);
        this.handleEndpointConfig(config, node);
    }

    private void handleServerSocketEndpointConfig(ServerSocketEndpointConfig endpointConfig, Node node) throws Exception {
        String name = this.getAttribute(node, "name");
        this.handleServerSocketEndpointConfig(endpointConfig, node, name);
    }

    protected void handleServerSocketEndpointConfig(ServerSocketEndpointConfig endpointConfig, Node node, String name) throws Exception {
        endpointConfig.setName(name);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("port", nodeName)) {
                this.handlePort(child, endpointConfig);
                continue;
            }
            if (this.matches("public-address", nodeName)) {
                String address = this.getTextContent(child);
                endpointConfig.setPublicAddress(address);
                continue;
            }
            if (this.matches("reuse-address", nodeName)) {
                endpointConfig.setReuseAddress(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            this.handleEndpointConfigCommons(child, nodeName, endpointConfig);
        }
        switch (endpointConfig.getProtocolType()) {
            case MEMBER: {
                this.ensureServerSocketEndpointConfig(endpointConfig);
                this.config.getAdvancedNetworkConfig().setMemberEndpointConfig(endpointConfig);
                break;
            }
            case CLIENT: {
                this.ensureServerSocketEndpointConfig(endpointConfig);
                this.config.getAdvancedNetworkConfig().setClientEndpointConfig(endpointConfig);
                break;
            }
            case REST: {
                this.ensureServerSocketEndpointConfig(endpointConfig);
                this.config.getAdvancedNetworkConfig().setRestEndpointConfig((RestServerEndpointConfig)endpointConfig);
                break;
            }
            case WAN: {
                this.config.getAdvancedNetworkConfig().addWanEndpointConfig(endpointConfig);
                break;
            }
            case MEMCACHE: {
                this.config.getAdvancedNetworkConfig().setMemcacheEndpointConfig(endpointConfig);
                break;
            }
            default: {
                throw new InvalidConfigurationException("Endpoint config has invalid protocol type " + String.valueOf((Object)endpointConfig.getProtocolType()));
            }
        }
    }

    private void ensureServerSocketEndpointConfig(EndpointConfig endpointConfig) {
        if (endpointConfig instanceof ServerSocketEndpointConfig) {
            return;
        }
        throw new InvalidConfigurationException("Endpoint configuration of protocol type " + String.valueOf((Object)endpointConfig.getProtocolType()) + " must be defined in a <server-socket-endpoint-config> element");
    }

    private void handleEndpointConfigCommons(Node node, String nodeName, EndpointConfig endpointConfig) throws Exception {
        if (this.matches("outbound-ports", nodeName)) {
            this.handleOutboundPorts(node, endpointConfig);
        } else if (this.matches("interfaces", nodeName)) {
            this.handleInterfaces(node, endpointConfig);
        } else if (this.matches("ssl", nodeName)) {
            this.handleSSLConfig(node, endpointConfig);
        } else if (this.matches("socket-interceptor", nodeName)) {
            this.handleSocketInterceptorConfig(node, endpointConfig);
        } else if (this.matches("socket-options", nodeName)) {
            this.handleSocketOptions(node, endpointConfig);
        } else if (this.matches("symmetric-encryption", nodeName)) {
            this.handleViaReflection(node, endpointConfig, new SymmetricEncryptionConfig(), new String[0]);
        } else if (this.matches("tpc-socket", nodeName)) {
            this.handleTpcSocketConfig(node, endpointConfig.getTpcSocketConfig());
        }
    }

    private void handleTpcSocketConfig(Node node, TpcSocketConfig tpcSocketConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("port-range", nodeName)) {
                tpcSocketConfig.setPortRange(this.getTextContent(child));
                continue;
            }
            if (this.matches("receive-buffer-size-kb", nodeName)) {
                tpcSocketConfig.setReceiveBufferSizeKB(DomConfigHelper.getIntegerValue("receive-buffer-size-kb", this.getTextContent(child)));
                continue;
            }
            if (!this.matches("send-buffer-size-kb", nodeName)) continue;
            tpcSocketConfig.setSendBufferSizeKB(DomConfigHelper.getIntegerValue("send-buffer-size-kb", this.getTextContent(child)));
        }
    }

    private void handleSocketOptions(Node node, EndpointConfig endpointConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("buffer-direct", nodeName)) {
                endpointConfig.setSocketBufferDirect(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("tcp-no-delay", nodeName)) {
                endpointConfig.setSocketTcpNoDelay(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("keep-alive", nodeName)) {
                endpointConfig.setSocketKeepAlive(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("connect-timeout-seconds", nodeName)) {
                endpointConfig.setSocketConnectTimeoutSeconds(DomConfigHelper.getIntegerValue("connect-timeout-seconds", this.getTextContent(child), 0));
                continue;
            }
            if (this.matches("send-buffer-size-kb", nodeName)) {
                endpointConfig.setSocketSendBufferSizeKb(DomConfigHelper.getIntegerValue("send-buffer-size-kb", this.getTextContent(child), 128));
                continue;
            }
            if (this.matches("receive-buffer-size-kb", nodeName)) {
                endpointConfig.setSocketRcvBufferSizeKb(DomConfigHelper.getIntegerValue("receive-buffer-size-kb", this.getTextContent(child), 128));
                continue;
            }
            if (this.matches("linger-seconds", nodeName)) {
                endpointConfig.setSocketLingerSeconds(DomConfigHelper.getIntegerValue("linger-seconds", this.getTextContent(child), 0));
                continue;
            }
            if (this.matches("keep-idle-seconds", nodeName)) {
                endpointConfig.setSocketKeepIdleSeconds(DomConfigHelper.getIntegerValue("keep-idle-seconds", this.getTextContent(child), 7200));
                continue;
            }
            if (this.matches("keep-interval-seconds", nodeName)) {
                endpointConfig.setSocketKeepIntervalSeconds(DomConfigHelper.getIntegerValue("keep-interval-seconds", this.getTextContent(child), 75));
                continue;
            }
            if (!this.matches("keep-count", nodeName)) continue;
            endpointConfig.setSocketKeepCount(DomConfigHelper.getIntegerValue("keep-count", this.getTextContent(child), 8));
        }
    }

    protected void handleExecutor(Node node) throws Exception {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        ExecutorConfig executorConfig = ConfigUtils.getByNameOrNew(this.config.getExecutorConfigs(), name, ExecutorConfig.class);
        this.handleViaReflection(node, this.config, executorConfig, new String[0]);
    }

    protected void handleDurableExecutor(Node node) throws Exception {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        DurableExecutorConfig durableExecutorConfig = ConfigUtils.getByNameOrNew(this.config.getDurableExecutorConfigs(), name, DurableExecutorConfig.class);
        this.handleViaReflection(node, this.config, durableExecutorConfig, new String[0]);
    }

    protected void handleScheduledExecutor(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        ScheduledExecutorConfig scheduledExecutorConfig = ConfigUtils.getByNameOrNew(this.config.getScheduledExecutorConfigs(), name, ScheduledExecutorConfig.class);
        this.handleScheduledExecutorNode(node, scheduledExecutorConfig);
    }

    void handleScheduledExecutorNode(Node node, ScheduledExecutorConfig scheduledExecutorConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(child, scheduledExecutorConfig.getMergePolicyConfig());
                scheduledExecutorConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("capacity", nodeName)) {
                scheduledExecutorConfig.setCapacity(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("capacity-policy", nodeName)) {
                scheduledExecutorConfig.setCapacityPolicy(ScheduledExecutorConfig.CapacityPolicy.valueOf(this.getTextContent(child)));
                continue;
            }
            if (this.matches("durability", nodeName)) {
                scheduledExecutorConfig.setDurability(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("pool-size", nodeName)) {
                scheduledExecutorConfig.setPoolSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                scheduledExecutorConfig.setSplitBrainProtectionName(this.getTextContent(child));
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                scheduledExecutorConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            scheduledExecutorConfig.setUserCodeNamespace(this.getTextContent(child));
        }
        this.config.addScheduledExecutorConfig(scheduledExecutorConfig);
    }

    protected void handleCardinalityEstimator(Node node) {
        CardinalityEstimatorConfig cardinalityEstimatorConfig = ConfigUtils.getByNameOrNew(this.config.getCardinalityEstimatorConfigs(), this.getTextContent(this.getNamedItemNode(node, "name")), CardinalityEstimatorConfig.class);
        this.handleCardinalityEstimatorNode(node, cardinalityEstimatorConfig);
    }

    void handleCardinalityEstimatorNode(Node node, CardinalityEstimatorConfig cardinalityEstimatorConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(child, cardinalityEstimatorConfig.getMergePolicyConfig());
                cardinalityEstimatorConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                cardinalityEstimatorConfig.setBackupCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                cardinalityEstimatorConfig.setAsyncBackupCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("split-brain-protection-ref", nodeName)) continue;
            cardinalityEstimatorConfig.setSplitBrainProtectionName(this.getTextContent(child));
        }
        this.config.addCardinalityEstimatorConfig(cardinalityEstimatorConfig);
    }

    protected void handlePNCounter(Node node) throws Exception {
        String name = this.getAttribute(node, "name");
        PNCounterConfig pnCounterConfig = ConfigUtils.getByNameOrNew(this.config.getPNCounterConfigs(), name, PNCounterConfig.class);
        this.handleViaReflection(node, this.config, pnCounterConfig, new String[0]);
    }

    protected void handleFlakeIdGenerator(Node node) {
        String name = this.getAttribute(node, "name");
        FlakeIdGeneratorConfig generatorConfig = ConfigUtils.getByNameOrNew(this.config.getFlakeIdGeneratorConfigs(), name, FlakeIdGeneratorConfig.class);
        this.handleFlakeIdGeneratorNode(node, generatorConfig);
    }

    void handleFlakeIdGeneratorNode(Node node, FlakeIdGeneratorConfig generatorConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("prefetch-count", nodeName)) {
                generatorConfig.setPrefetchCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("prefetch-validity-millis", nodeName)) {
                generatorConfig.setPrefetchValidityMillis(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (this.matches("epoch-start", nodeName)) {
                generatorConfig.setEpochStart(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (this.matches("node-id-offset", nodeName)) {
                generatorConfig.setNodeIdOffset(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (this.matches("bits-sequence", nodeName)) {
                generatorConfig.setBitsSequence(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("bits-node-id", nodeName)) {
                generatorConfig.setBitsNodeId(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allowed-future-millis", nodeName)) {
                generatorConfig.setAllowedFutureMillis(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("statistics-enabled", nodeName)) continue;
            generatorConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
        this.config.addFlakeIdGeneratorConfig(generatorConfig);
    }

    private void handleInterfaces(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        InterfacesConfig interfaces = this.config.getNetworkConfig().getInterfaces();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            interfaces.setEnabled(DomConfigHelper.getBooleanValue(att.getNodeValue()));
        }
        this.handleInterfacesList(node, interfaces);
    }

    protected void handleInterfacesList(Node node, InterfacesConfig interfaces) {
        for (Node n : DomConfigHelper.childElements(node)) {
            if (!this.matches("interface", StringUtil.lowerCaseInternal(DomConfigHelper.cleanNodeName(n)))) continue;
            interfaces.addInterface(this.getTextContent(n));
        }
    }

    private void handleInterfaces(Node node, EndpointConfig endpointConfig) {
        NamedNodeMap attributes = node.getAttributes();
        InterfacesConfig interfaces = endpointConfig.getInterfaces();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            interfaces.setEnabled(DomConfigHelper.getBooleanValue(att.getNodeValue()));
        }
        this.handleInterfacesList(node, interfaces);
    }

    protected void handleViaReflection(Node node, Object parent, Object child, String ... nodeExclusions) throws Exception {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int a = 0; a < attributes.getLength(); ++a) {
                Node att = attributes.item(a);
                if (this.excludeNode(att, nodeExclusions)) continue;
                this.invokeSetter(child, att, att.getNodeValue());
            }
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            if (!(n instanceof Element) || this.excludeNode(n, nodeExclusions)) continue;
            this.invokeSetter(child, n, this.getTextContent(n));
        }
        MemberDomConfigProcessor.attachChildConfig(parent, child);
    }

    private boolean excludeNode(Node n, String ... nodeExclusions) {
        if (nodeExclusions.length > 0) {
            String name = DomConfigHelper.cleanNodeName(n);
            for (String exclusion : nodeExclusions) {
                if (!this.matches(name, exclusion)) continue;
                return true;
            }
        }
        return false;
    }

    private void invokeSetter(Object target, Node node, String argument) {
        String coercedArg;
        Method method = MemberDomConfigProcessor.getMethod(target, "set" + this.toPropertyName(DomConfigHelper.cleanNodeName(node)), true);
        if (method == null) {
            throw new InvalidConfigurationException("Invalid element/attribute name in the configuration: " + DomConfigHelper.cleanNodeName(node));
        }
        Class<?> arg = method.getParameterTypes()[0];
        Object object = arg == String.class ? argument : (arg == Integer.TYPE ? Integer.valueOf(argument) : (arg == Long.TYPE ? Long.valueOf(argument) : (coercedArg = arg == Boolean.TYPE ? Boolean.valueOf(DomConfigHelper.getBooleanValue(argument)) : null)));
        if (coercedArg == null) {
            throw new HazelcastException(String.format("Method %s has unsupported argument type %s", method.getName(), arg.getSimpleName()));
        }
        try {
            method.invoke(target, coercedArg);
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    private static void attachChildConfig(Object parent, Object child) throws Exception {
        String targetName = child.getClass().getSimpleName();
        Method attacher = MemberDomConfigProcessor.getMethod(parent, "set" + targetName, false);
        if (attacher == null) {
            attacher = MemberDomConfigProcessor.getMethod(parent, "add" + targetName, false);
        }
        if (attacher == null) {
            throw new HazelcastException(String.format("%s doesn't accept %s as child", parent.getClass().getSimpleName(), targetName));
        }
        attacher.invoke(parent, child);
    }

    private static Method getMethod(Object target, String methodName, boolean requiresArg) {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            Class<?> arg;
            if (!StringUtil.equalsIgnoreCase(method.getName(), methodName)) continue;
            if (!requiresArg) {
                return method;
            }
            if (method.getParameterCount() != 1 || (arg = method.getParameterTypes()[0]) != String.class && arg != Integer.TYPE && arg != Long.TYPE && arg != Boolean.TYPE) continue;
            return method;
        }
        return null;
    }

    private String toPropertyName(String element) {
        String refPropertyName = this.handleRefProperty(element);
        if (refPropertyName != null) {
            return refPropertyName;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = element.toCharArray();
        boolean upper = true;
        for (char c : chars) {
            if (c == '_' || c == '-' || c == '.') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String handleRefProperty(String element) {
        if (this.matches(element, "split-brain-protection-ref")) {
            return "SplitBrainProtectionName";
        }
        return null;
    }

    private void handleJoin(Node node, boolean advancedNetworkConfig) {
        JoinConfig joinConfig = this.joinConfig(advancedNetworkConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("multicast", name)) {
                this.handleMulticast(child, advancedNetworkConfig);
                continue;
            }
            if (this.matches("tcp-ip", name)) {
                this.handleTcpIp(child, advancedNetworkConfig);
                continue;
            }
            if (AliasedDiscoveryConfigUtils.supports(name)) {
                this.handleAliasedDiscoveryStrategy(joinConfig, child, name);
                continue;
            }
            if (this.matches("discovery-strategies", name)) {
                this.handleDiscoveryStrategies(joinConfig.getDiscoveryConfig(), child);
                continue;
            }
            if (!this.matches("auto-detection", name)) continue;
            this.handleAutoDetection(child, advancedNetworkConfig);
        }
        joinConfig.verify();
    }

    protected JoinConfig joinConfig(boolean advancedNetworkConfig) {
        return advancedNetworkConfig ? this.config.getAdvancedNetworkConfig().getJoin() : this.config.getNetworkConfig().getJoin();
    }

    private void handleDiscoveryStrategies(DiscoveryConfig discoveryConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleDiscoveryStrategiesChild(discoveryConfig, child);
        }
    }

    protected void handleDiscoveryStrategiesChild(DiscoveryConfig discoveryConfig, Node child) {
        String name = DomConfigHelper.cleanNodeName(child);
        if (this.matches("discovery-strategy", name)) {
            this.handleDiscoveryStrategy(child, discoveryConfig);
        } else if (this.matches("node-filter", name)) {
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    void handleDiscoveryNodeFilter(Node node, DiscoveryConfig discoveryConfig) {
        Node att = this.getNamedItemNode(node, "class");
        if (att != null) {
            discoveryConfig.setNodeFilterClass(this.getTextContent(att));
        }
    }

    void handleDiscoveryStrategy(Node node, DiscoveryConfig discoveryConfig) {
        boolean enabled = false;
        String clazz = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) {
                enabled = DomConfigHelper.getBooleanValue(this.getTextContent(att));
                continue;
            }
            if (!this.matches("class", att.getNodeName())) continue;
            clazz = this.getTextContent(att);
        }
        if (!enabled || clazz == null) {
            return;
        }
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", name)) continue;
            this.fillProperties(child, properties);
        }
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(clazz, properties));
    }

    private void handleAliasedDiscoveryStrategy(JoinConfig joinConfig, Node node, String tag) {
        AliasedDiscoveryConfig aliasedDiscoveryConfig = AliasedDiscoveryConfigUtils.getConfigByTag(joinConfig, tag);
        this.updateConfig(aliasedDiscoveryConfig, node);
    }

    private void handleAliasedDiscoveryStrategy(WanBatchPublisherConfig publisherConfig, Node node, String tag) {
        AliasedDiscoveryConfig aliasedDiscoveryConfig = AliasedDiscoveryConfigUtils.getConfigByTag(publisherConfig, tag);
        this.updateConfig(aliasedDiscoveryConfig, node);
    }

    private void updateConfig(AliasedDiscoveryConfig config, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) {
                config.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches(att.getNodeName(), "connection-timeout-seconds")) continue;
            config.setProperty("connection-timeout-seconds", this.getTextContent(att));
        }
        Iterator<Node> iterator = DomConfigHelper.childElements(node).iterator();
        while (iterator.hasNext()) {
            Node n;
            String key = DomConfigHelper.cleanNodeName(n, !this.matches("eureka", (n = iterator.next()).getParentNode().getLocalName()));
            String value = this.getTextContent(n);
            config.setProperty(key, value);
        }
    }

    private void handleMulticast(Node node, boolean advancedNetworkConfig) {
        JoinConfig join = this.joinConfig(advancedNetworkConfig);
        MulticastConfig multicastConfig = join.getMulticastConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) {
                multicastConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches("loopbackmodeenabled", StringUtil.lowerCaseInternal(att.getNodeName())) && !this.matches("loopback-mode-enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) continue;
            multicastConfig.setLoopbackModeEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            if (this.matches("multicast-group", DomConfigHelper.cleanNodeName(n))) {
                multicastConfig.setMulticastGroup(this.getTextContent(n));
                continue;
            }
            if (this.matches("multicast-port", DomConfigHelper.cleanNodeName(n))) {
                multicastConfig.setMulticastPort(Integer.parseInt(this.getTextContent(n)));
                continue;
            }
            if (this.matches("multicast-timeout-seconds", DomConfigHelper.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeoutSeconds(Integer.parseInt(this.getTextContent(n)));
                continue;
            }
            if (this.matches("multicast-time-to-live-seconds", DomConfigHelper.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(this.getTextContent(n)));
                continue;
            }
            if (this.matches("multicast-time-to-live", DomConfigHelper.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(this.getTextContent(n)));
                continue;
            }
            if (!this.matches("trusted-interfaces", DomConfigHelper.cleanNodeName(n))) continue;
            this.handleTrustedInterfaces(multicastConfig, n);
        }
    }

    private void handleAutoDetection(Node node, boolean advancedNetworkConfig) {
        JoinConfig join = this.joinConfig(advancedNetworkConfig);
        AutoDetectionConfig autoDetectionConfig = join.getAutoDetectionConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) continue;
            autoDetectionConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
        }
    }

    protected void handleTrustedInterfaces(TrustedInterfacesConfigurable<?> tiConfig, Node n) {
        for (Node child : DomConfigHelper.childElements(n)) {
            if (!this.matches("interface", StringUtil.lowerCaseInternal(DomConfigHelper.cleanNodeName(child)))) continue;
            tiConfig.addTrustedInterface(this.getTextContent(child));
        }
    }

    private void handleTcpIp(Node node, boolean advancedNetworkConfig) {
        NamedNodeMap attributes = node.getAttributes();
        JoinConfig join = this.joinConfig(advancedNetworkConfig);
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches(att.getNodeName(), "enabled")) {
                tcpIpConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches(att.getNodeName(), "connection-timeout-seconds")) continue;
            tcpIpConfig.setConnectionTimeoutSeconds(DomConfigHelper.getIntegerValue("connection-timeout-seconds", this.getTextContent(att)));
        }
        Set<String> memberTags = Set.of("interface", "member", "members");
        for (Node n : DomConfigHelper.childElements(node)) {
            if (this.matches(DomConfigHelper.cleanNodeName(n), "member-list")) {
                this.handleMemberList(n, advancedNetworkConfig);
                continue;
            }
            if (this.matches(DomConfigHelper.cleanNodeName(n), "required-member")) {
                if (tcpIpConfig.getRequiredMember() != null) {
                    throw new InvalidConfigurationException("Duplicate required-member definition found in the configuration. ");
                }
                tcpIpConfig.setRequiredMember(this.getTextContent(n));
                continue;
            }
            if (!memberTags.contains(DomConfigHelper.cleanNodeName(n))) continue;
            tcpIpConfig.addMember(this.getTextContent(n));
        }
    }

    protected void handleMemberList(Node node, boolean advancedNetworkConfig) {
        JoinConfig join = this.joinConfig(advancedNetworkConfig);
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("member", nodeName)) continue;
            tcpIpConfig.addMember(this.getTextContent(n));
        }
    }

    protected void handlePort(Node node, Config config) {
        String portStr = this.getTextContent(node);
        NetworkConfig networkConfig = config.getNetworkConfig();
        if (portStr.length() > 0) {
            networkConfig.setPort(Integer.parseInt(portStr));
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("auto-increment", att.getNodeName())) {
                networkConfig.setPortAutoIncrement(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches("port-count", att.getNodeName())) continue;
            int portCount = Integer.parseInt(this.getTextContent(att));
            networkConfig.setPortCount(portCount);
        }
    }

    protected void handlePort(Node node, ServerSocketEndpointConfig endpointConfig) {
        String portStr = this.getTextContent(node);
        if (portStr.length() > 0) {
            endpointConfig.setPort(Integer.parseInt(portStr));
        }
        this.handlePortAttributes(node, endpointConfig);
    }

    protected void handlePortAttributes(Node node, ServerSocketEndpointConfig endpointConfig) {
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("auto-increment", att.getNodeName())) {
                endpointConfig.setPortAutoIncrement(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches("port-count", att.getNodeName())) continue;
            int portCount = Integer.parseInt(this.getTextContent(att));
            endpointConfig.setPortCount(portCount);
        }
    }

    protected void handleOutboundPorts(Node child) {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (Node n : DomConfigHelper.childElements(child)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("ports", nodeName)) continue;
            networkConfig.addOutboundPortDefinition(this.getTextContent(n));
        }
    }

    protected void handleOutboundPorts(Node child, EndpointConfig endpointConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("ports", nodeName)) continue;
            endpointConfig.addOutboundPortDefinition(this.getTextContent(n));
        }
    }

    protected void handleQueue(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        QueueConfig qConfig = ConfigUtils.getByNameOrNew(this.config.getQueueConfigs(), name, QueueConfig.class);
        this.handleQueueNode(node, qConfig);
    }

    void handleQueueNode(Node node, QueueConfig qConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("max-size", nodeName)) {
                qConfig.setMaxSize(DomConfigHelper.getIntegerValue("max-size", this.getTextContent(n)));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                qConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                qConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("item-listeners", nodeName)) {
                this.handleItemListeners(n, qConfig::addItemListenerConfig);
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                qConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("queue-store", nodeName)) {
                QueueStoreConfig queueStoreConfig = this.createQueueStoreConfig(n);
                qConfig.setQueueStoreConfig(queueStoreConfig);
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                qConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("empty-queue-ttl", nodeName)) {
                qConfig.setEmptyQueueTtl(DomConfigHelper.getIntegerValue("empty-queue-ttl", this.getTextContent(n)));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, qConfig.getMergePolicyConfig());
                qConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("priority-comparator-class-name", nodeName)) {
                qConfig.setPriorityComparatorClassName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            qConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addQueueConfig(qConfig);
    }

    protected void handleItemListeners(Node n, Consumer<ItemListenerConfig> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("item-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
            String listenerClass = this.getTextContent(listenerNode);
            configAddFunction.accept(new ItemListenerConfig(listenerClass, incValue));
        }
    }

    protected void handleList(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        ListConfig lConfig = ConfigUtils.getByNameOrNew(this.config.getListConfigs(), name, ListConfig.class);
        this.handleListNode(node, lConfig);
    }

    void handleListNode(Node node, ListConfig lConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("max-size", nodeName)) {
                lConfig.setMaxSize(DomConfigHelper.getIntegerValue("max-size", this.getTextContent(n)));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                lConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                lConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("item-listeners", nodeName)) {
                this.handleItemListeners(n, lConfig::addItemListenerConfig);
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                lConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                lConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, lConfig.getMergePolicyConfig());
                lConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            lConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addListConfig(lConfig);
    }

    protected void handleSet(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        SetConfig sConfig = ConfigUtils.getByNameOrNew(this.config.getSetConfigs(), name, SetConfig.class);
        this.handleSetNode(node, sConfig);
    }

    void handleSetNode(Node node, SetConfig sConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("max-size", nodeName)) {
                sConfig.setMaxSize(DomConfigHelper.getIntegerValue("max-size", this.getTextContent(n)));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                sConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                sConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("item-listeners", nodeName)) {
                this.handleItemListeners(n, sConfig::addItemListenerConfig);
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                sConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                sConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, sConfig.getMergePolicyConfig());
                sConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            sConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addSetConfig(sConfig);
    }

    protected void handleMultiMap(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        MultiMapConfig multiMapConfig = ConfigUtils.getByNameOrNew(this.config.getMultiMapConfigs(), name, MultiMapConfig.class);
        this.handleMultiMapNode(node, multiMapConfig);
    }

    void handleMultiMapNode(Node node, MultiMapConfig multiMapConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("value-collection-type", nodeName)) {
                multiMapConfig.setValueCollectionType(this.getTextContent(n));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                multiMapConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                multiMapConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("entry-listeners", nodeName)) {
                this.handleEntryListeners(n, multiMapConfig::addEntryListenerConfig);
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                multiMapConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("binary", nodeName)) {
                multiMapConfig.setBinary(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                multiMapConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, multiMapConfig.getMergePolicyConfig());
                multiMapConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            multiMapConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addMultiMapConfig(multiMapConfig);
    }

    protected void handleEntryListeners(Node n, Consumer<EntryListenerConfig> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("entry-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
            boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "local")));
            String listenerClass = this.getTextContent(listenerNode);
            configAddFunction.accept(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    protected void handleReplicatedMap(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        ReplicatedMapConfig replicatedMapConfig = ConfigUtils.getByNameOrNew(this.config.getReplicatedMapConfigs(), name, ReplicatedMapConfig.class);
        this.handleReplicatedMapNode(node, replicatedMapConfig);
    }

    void handleReplicatedMapNode(Node node, ReplicatedMapConfig replicatedMapConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("in-memory-format", nodeName)) {
                replicatedMapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
                continue;
            }
            if (this.matches("async-fillup", nodeName)) {
                replicatedMapConfig.setAsyncFillup(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                replicatedMapConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("entry-listeners", nodeName)) {
                this.handleEntryListeners(n, replicatedMapConfig::addEntryListenerConfig);
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, replicatedMapConfig.getMergePolicyConfig());
                replicatedMapConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                replicatedMapConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            replicatedMapConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addReplicatedMapConfig(replicatedMapConfig);
    }

    protected void handleMap(Node parentNode) throws Exception {
        String name = this.getAttribute(parentNode, "name");
        MapConfig mapConfig = ConfigUtils.getByNameOrNew(this.config.getMapConfigs(), name, MapConfig.class);
        this.handleMapNode(parentNode, mapConfig);
    }

    void handleMapNode(Node parentNode, MapConfig mapConfig) throws Exception {
        for (Node node : DomConfigHelper.childElements(parentNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.matches("backup-count", nodeName)) {
                mapConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(node)));
                continue;
            }
            if (this.matches("metadata-policy", nodeName)) {
                mapConfig.setMetadataPolicy(MetadataPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(node))));
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                mapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(node))));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                mapConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(node)));
                continue;
            }
            if (this.matches("eviction", nodeName)) {
                mapConfig.setEvictionConfig(this.getEvictionConfig(node, false, true));
                continue;
            }
            if (this.matches("time-to-live-seconds", nodeName)) {
                mapConfig.setTimeToLiveSeconds(DomConfigHelper.getIntegerValue("time-to-live-seconds", this.getTextContent(node)));
                continue;
            }
            if (this.matches("max-idle-seconds", nodeName)) {
                mapConfig.setMaxIdleSeconds(DomConfigHelper.getIntegerValue("max-idle-seconds", this.getTextContent(node)));
                continue;
            }
            if (this.matches("map-store", nodeName)) {
                this.handleMapStoreConfig(node, mapConfig.getMapStoreConfig());
                continue;
            }
            if (this.matches("near-cache", nodeName)) {
                mapConfig.setNearCacheConfig(this.handleNearCacheConfig(node, mapConfig.getNearCacheConfig()));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(node, mapConfig.getMergePolicyConfig());
                mapConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("merkle-tree", nodeName)) {
                this.handleViaReflection(node, mapConfig, mapConfig.getMerkleTreeConfig(), new String[0]);
                continue;
            }
            if (this.matches("event-journal", nodeName)) {
                this.handleViaReflection(node, mapConfig, mapConfig.getEventJournalConfig(), new String[0]);
                continue;
            }
            if (this.matches("hot-restart", nodeName)) {
                mapConfig.setHotRestartConfig(this.createHotRestartConfig(node));
                continue;
            }
            if (this.matches("data-persistence", nodeName)) {
                mapConfig.setDataPersistenceConfig(this.createDataPersistenceConfig(node));
                continue;
            }
            if (this.matches("read-backup-data", nodeName)) {
                mapConfig.setReadBackupData(DomConfigHelper.getBooleanValue(this.getTextContent(node)));
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                mapConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(node)));
                continue;
            }
            if (this.matches("per-entry-stats-enabled", nodeName)) {
                mapConfig.setPerEntryStatsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(node)));
                continue;
            }
            if (this.matches("cache-deserialized-values", nodeName)) {
                CacheDeserializedValues cacheDeserializedValues = CacheDeserializedValues.parseString(this.getTextContent(node));
                mapConfig.setCacheDeserializedValues(cacheDeserializedValues);
                continue;
            }
            if (this.matches("wan-replication-ref", nodeName)) {
                this.mapWanReplicationRefHandle(node, mapConfig);
                continue;
            }
            if (this.matches("indexes", nodeName)) {
                this.mapIndexesHandle(node, mapConfig);
                continue;
            }
            if (this.matches("attributes", nodeName)) {
                this.attributesHandle(node, mapConfig);
                continue;
            }
            if (this.matches("entry-listeners", nodeName)) {
                this.handleEntryListeners(node, mapConfig::addEntryListenerConfig);
                continue;
            }
            if (this.matches("partition-lost-listeners", nodeName)) {
                this.mapPartitionLostListenerHandle(node, mapConfig);
                continue;
            }
            if (this.matches("partition-strategy", nodeName)) {
                mapConfig.setPartitioningStrategyConfig(new PartitioningStrategyConfig(this.getTextContent(node)));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                mapConfig.setSplitBrainProtectionName(this.getTextContent(node));
                continue;
            }
            if (this.matches("query-caches", nodeName)) {
                this.mapQueryCacheHandler(node, mapConfig);
                continue;
            }
            if (this.matches("tiered-store", nodeName)) {
                mapConfig.setTieredStoreConfig(this.createTieredStoreConfig(node));
                continue;
            }
            if (this.matches("partition-attributes", nodeName)) {
                this.handlePartitionAttributes(node, mapConfig);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            mapConfig.setUserCodeNamespace(this.getTextContent(node));
        }
        this.config.addMapConfig(mapConfig);
    }

    private NearCacheConfig handleNearCacheConfig(Node node, NearCacheConfig existingNearCacheConfig) {
        String name = this.getAttribute(node, "name");
        name = name == null ? "default" : name;
        NearCacheConfig nearCacheConfig = existingNearCacheConfig != null ? existingNearCacheConfig : new NearCacheConfig(name);
        Boolean serializeKeys = null;
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("time-to-live-seconds", nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("max-idle-seconds", nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(child))));
                continue;
            }
            if (this.matches("serialize-keys", nodeName)) {
                serializeKeys = Boolean.parseBoolean(this.getTextContent(child));
                nearCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if (this.matches("invalidate-on-change", nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("cache-local-entries", nodeName)) {
                nearCacheConfig.setCacheLocalEntries(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("local-update-policy", nodeName)) {
                NearCacheConfig.LocalUpdatePolicy policy = NearCacheConfig.LocalUpdatePolicy.valueOf(this.getTextContent(child));
                nearCacheConfig.setLocalUpdatePolicy(policy);
                continue;
            }
            if (!this.matches("eviction", nodeName)) continue;
            nearCacheConfig.setEvictionConfig(this.getEvictionConfig(child, true, false));
        }
        if (serializeKeys != null && !serializeKeys.booleanValue() && nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            LOGGER.warning("The Near Cache doesn't support keys by-reference with NATIVE in-memory-format. This setting will have no effect!");
        }
        return nearCacheConfig;
    }

    private HotRestartConfig createHotRestartConfig(Node node) {
        HotRestartConfig hotRestartConfig = new HotRestartConfig();
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        hotRestartConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("fsync", name)) continue;
            hotRestartConfig.setFsync(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
        }
        return hotRestartConfig;
    }

    private DataPersistenceConfig createDataPersistenceConfig(Node node) {
        DataPersistenceConfig dataPersistenceConfig = new DataPersistenceConfig();
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        dataPersistenceConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("fsync", name)) continue;
            dataPersistenceConfig.setFsync(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
        }
        return dataPersistenceConfig;
    }

    protected void handleCache(Node node) throws Exception {
        CacheSimpleConfig cacheConfig = ConfigUtils.getByNameOrNew(this.config.getCacheConfigs(), this.getAttribute(node, "name"), CacheSimpleConfig.class);
        this.handleCacheNode(node, cacheConfig);
    }

    void handleCacheNode(Node node, CacheSimpleConfig cacheConfig) throws Exception {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("key-type", nodeName)) {
                cacheConfig.setKeyType(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("value-type", nodeName)) {
                cacheConfig.setValueType(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                cacheConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("management-enabled", nodeName)) {
                cacheConfig.setManagementEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("read-through", nodeName)) {
                cacheConfig.setReadThrough(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("write-through", nodeName)) {
                cacheConfig.setWriteThrough(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("cache-loader-factory", nodeName)) {
                cacheConfig.setCacheLoaderFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("cache-loader", nodeName)) {
                cacheConfig.setCacheLoader(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("cache-writer-factory", nodeName)) {
                cacheConfig.setCacheWriterFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("cache-writer", nodeName)) {
                cacheConfig.setCacheWriter(this.getAttribute(n, "class-name"));
                continue;
            }
            if (this.matches("expiry-policy-factory", nodeName)) {
                cacheConfig.setExpiryPolicyFactoryConfig(this.getExpiryPolicyFactoryConfig(n));
                continue;
            }
            if (this.matches("cache-entry-listeners", nodeName)) {
                this.cacheListenerHandle(n, cacheConfig);
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                cacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                cacheConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                cacheConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n)));
                continue;
            }
            if (this.matches("wan-replication-ref", nodeName)) {
                this.cacheWanReplicationRefHandle(n, cacheConfig);
                continue;
            }
            if (this.matches("eviction", nodeName)) {
                cacheConfig.setEvictionConfig(this.getEvictionConfig(n, false, false));
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                cacheConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("partition-lost-listeners", nodeName)) {
                this.cachePartitionLostListenerHandle(n, cacheConfig);
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, cacheConfig.getMergePolicyConfig());
                cacheConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("event-journal", nodeName)) {
                EventJournalConfig eventJournalConfig = new EventJournalConfig();
                this.handleViaReflection(n, cacheConfig, eventJournalConfig, new String[0]);
                continue;
            }
            if (this.matches("hot-restart", nodeName)) {
                cacheConfig.setHotRestartConfig(this.createHotRestartConfig(n));
                continue;
            }
            if (this.matches("data-persistence", nodeName)) {
                cacheConfig.setDataPersistenceConfig(this.createDataPersistenceConfig(n));
                continue;
            }
            if (this.matches("disable-per-entry-invalidation-events", nodeName)) {
                cacheConfig.setDisablePerEntryInvalidationEvents(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("merkle-tree", nodeName)) {
                this.handleViaReflection(n, cacheConfig, cacheConfig.getMerkleTreeConfig(), new String[0]);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            cacheConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        try {
            ConfigValidator.checkCacheConfig(cacheConfig, null);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        this.config.addCacheConfig(cacheConfig);
    }

    private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
        String className = this.getAttribute(node, "class-name");
        if (!StringUtil.isNullOrEmpty(className)) {
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
        }
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("timed-expiry-policy-factory", nodeName)) continue;
            timedExpiryPolicyFactoryConfig = this.getTimedExpiryPolicyFactoryConfig(n);
        }
        if (timedExpiryPolicyFactoryConfig == null) {
            throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
        }
        return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
    }

    private CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig getTimedExpiryPolicyFactoryConfig(Node node) {
        String expiryPolicyTypeStr = this.getAttribute(node, "expiry-policy-type");
        String durationAmountStr = this.getAttribute(node, "duration-amount");
        String timeUnitStr = this.getAttribute(node, "time-unit");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf(StringUtil.upperCaseInternal(expiryPolicyTypeStr));
        if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty(durationAmountStr) || StringUtil.isNullOrEmpty(timeUnitStr))) {
            throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
        }
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
        if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
            TimeUnit timeUnit;
            long durationAmount;
            try {
                durationAmount = Long.parseLong(durationAmountStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Invalid value for duration amount: " + durationAmountStr, e);
            }
            if (durationAmount <= 0L) {
                throw new InvalidConfigurationException("Duration amount must be positive: " + durationAmount);
            }
            try {
                timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal(timeUnitStr));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid value for time unit: " + timeUnitStr, e);
            }
            durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
        }
        return new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
    }

    private EvictionConfig getEvictionConfig(Node node, boolean isNearCache, boolean isIMap) {
        String className;
        EvictionConfig evictionConfig = new EvictionConfig();
        if (isIMap) {
            evictionConfig.setEvictionPolicy(MapConfig.DEFAULT_EVICTION_POLICY).setMaxSizePolicy(MapConfig.DEFAULT_MAX_SIZE_POLICY).setSize(Integer.MAX_VALUE);
        }
        Node size = this.getNamedItemNode(node, "size");
        Node maxSizePolicy = this.getNamedItemNode(node, "max-size-policy");
        Node evictionPolicy = this.getNamedItemNode(node, "eviction-policy");
        Node comparatorClassName = this.getNamedItemNode(node, "comparator-class-name");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
            if (isIMap && evictionConfig.getSize() == 0) {
                evictionConfig.setSize(Integer.MAX_VALUE);
            }
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaxSizePolicy(MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null && !StringUtil.isNullOrEmptyAfterTrim(className = this.getTextContent(comparatorClassName))) {
            evictionConfig.setComparatorClassName(className);
        }
        try {
            MemberDomConfigProcessor.doEvictionConfigChecks(evictionConfig, isIMap, isNearCache);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        return evictionConfig;
    }

    private static void doEvictionConfigChecks(EvictionConfig evictionConfig, boolean isIMap, boolean isNearCache) {
        if (isIMap) {
            ConfigValidator.checkMapEvictionConfig(evictionConfig);
            return;
        }
        if (isNearCache) {
            ConfigValidator.checkNearCacheEvictionConfig(evictionConfig.getEvictionPolicy(), evictionConfig.getComparatorClassName(), evictionConfig.getComparator());
            return;
        }
        ConfigValidator.checkCacheEvictionConfig(evictionConfig);
    }

    private void cacheWanReplicationRefHandle(Node n, CacheSimpleConfig cacheConfig) {
        WanReplicationRef wanReplicationRef = new WanReplicationRef();
        String wanName = this.getAttribute(n, "name");
        wanReplicationRef.setName(wanName);
        for (Node wanChild : DomConfigHelper.childElements(n)) {
            String wanChildName = DomConfigHelper.cleanNodeName(wanChild);
            String wanChildValue = this.getTextContent(wanChild);
            if (this.matches("merge-policy-class-name", wanChildName)) {
                wanReplicationRef.setMergePolicyClassName(wanChildValue);
                continue;
            }
            if (this.matches("filters", wanChildName)) {
                this.handleWanFilters(wanChild, wanReplicationRef);
                continue;
            }
            if (!this.matches("republishing-enabled", wanChildName)) continue;
            wanReplicationRef.setRepublishingEnabled(DomConfigHelper.getBooleanValue(wanChildValue));
        }
        cacheConfig.setWanReplicationRef(wanReplicationRef);
    }

    protected void handleWanFilters(Node wanChild, WanReplicationRef wanReplicationRef) {
        for (Node filter : DomConfigHelper.childElements(wanChild)) {
            if (!this.matches("filter-impl", DomConfigHelper.cleanNodeName(filter))) continue;
            wanReplicationRef.addFilter(this.getTextContent(filter));
        }
    }

    protected void cachePartitionLostListenerHandle(Node n, CacheSimpleConfig cacheConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("partition-lost-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            String listenerClass = this.getTextContent(listenerNode);
            cacheConfig.addCachePartitionLostListenerConfig(new CachePartitionLostListenerConfig(listenerClass));
        }
    }

    protected void cacheListenerHandle(Node n, CacheSimpleConfig cacheSimpleConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("cache-entry-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            this.handleCacheEntryListenerNode(cacheSimpleConfig, listenerNode);
        }
    }

    protected void handleCacheEntryListenerNode(CacheSimpleConfig cacheSimpleConfig, Node listenerNode) {
        CacheSimpleEntryListenerConfig listenerConfig = new CacheSimpleEntryListenerConfig();
        for (Node listenerChildNode : DomConfigHelper.childElements(listenerNode)) {
            if (this.matches("cache-entry-listener-factory", DomConfigHelper.cleanNodeName(listenerChildNode))) {
                listenerConfig.setCacheEntryListenerFactory(this.getAttribute(listenerChildNode, "class-name"));
            }
            if (!this.matches("cache-entry-event-filter-factory", DomConfigHelper.cleanNodeName(listenerChildNode))) continue;
            listenerConfig.setCacheEntryEventFilterFactory(this.getAttribute(listenerChildNode, "class-name"));
        }
        listenerConfig.setOldValueRequired(DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "old-value-required"))));
        listenerConfig.setSynchronous(DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "synchronous"))));
        cacheSimpleConfig.addEntryListenerConfig(listenerConfig);
    }

    protected void mapWanReplicationRefHandle(Node n, MapConfig mapConfig) {
        WanReplicationRef wanReplicationRef = new WanReplicationRef();
        String wanName = this.getAttribute(n, "name");
        wanReplicationRef.setName(wanName);
        this.handleMapWanReplicationRefNode(n, mapConfig, wanReplicationRef);
    }

    void handleMapWanReplicationRefNode(Node n, MapConfig mapConfig, WanReplicationRef wanReplicationRef) {
        for (Node wanChild : DomConfigHelper.childElements(n)) {
            String wanChildName = DomConfigHelper.cleanNodeName(wanChild);
            String wanChildValue = this.getTextContent(wanChild);
            if (this.matches("merge-policy-class-name", wanChildName)) {
                wanReplicationRef.setMergePolicyClassName(wanChildValue);
                continue;
            }
            if (this.matches("republishing-enabled", wanChildName)) {
                wanReplicationRef.setRepublishingEnabled(DomConfigHelper.getBooleanValue(wanChildValue));
                continue;
            }
            if (!this.matches("filters", wanChildName)) continue;
            this.handleWanFilters(wanChild, wanReplicationRef);
        }
        mapConfig.setWanReplicationRef(wanReplicationRef);
    }

    protected void mapIndexesHandle(Node n, MapConfig mapConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("index", DomConfigHelper.cleanNodeName(indexNode))) continue;
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromXml(indexNode, this.domLevel3, this.strict);
            mapConfig.addIndexConfig(indexConfig);
        }
    }

    protected void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("index", DomConfigHelper.cleanNodeName(indexNode))) continue;
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromXml(indexNode, this.domLevel3, this.strict);
            queryCacheConfig.addIndexConfig(indexConfig);
        }
    }

    protected void attributesHandle(Node n, MapConfig mapConfig) {
        for (Node extractorNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("attribute", DomConfigHelper.cleanNodeName(extractorNode))) continue;
            String extractor = this.getTextContent(this.getNamedItemNode(extractorNode, "extractor-class-name"));
            String name = this.getTextContent(extractorNode);
            mapConfig.addAttributeConfig(new AttributeConfig(name, extractor));
        }
    }

    protected void mapPartitionLostListenerHandle(Node n, MapConfig mapConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("partition-lost-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            String listenerClass = this.getTextContent(listenerNode);
            mapConfig.addMapPartitionLostListenerConfig(new MapPartitionLostListenerConfig(listenerClass));
        }
    }

    protected void mapQueryCacheHandler(Node n, MapConfig mapConfig) {
        for (Node queryCacheNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("query-cache", DomConfigHelper.cleanNodeName(queryCacheNode))) continue;
            String cacheName = this.getTextContent(this.getNamedItemNode(queryCacheNode, "name"));
            QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
            this.handleMapQueryCacheNode(mapConfig, queryCacheNode, queryCacheConfig);
        }
    }

    void handleMapQueryCacheNode(MapConfig mapConfig, Node queryCacheNode, QueryCacheConfig queryCacheConfig) {
        for (Node childNode : DomConfigHelper.childElements(queryCacheNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(childNode);
            if (this.matches("entry-listeners", nodeName)) {
                this.handleEntryListeners(childNode, queryCacheConfig::addEntryListenerConfig);
                continue;
            }
            if (this.matches("include-value", nodeName)) {
                boolean includeValue = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
                queryCacheConfig.setIncludeValue(includeValue);
                continue;
            }
            if (this.matches("batch-size", nodeName)) {
                int batchSize = DomConfigHelper.getIntegerValue("batch-size", this.getTextContent(childNode));
                queryCacheConfig.setBatchSize(batchSize);
                continue;
            }
            if (this.matches("buffer-size", nodeName)) {
                int bufferSize = DomConfigHelper.getIntegerValue("buffer-size", this.getTextContent(childNode));
                queryCacheConfig.setBufferSize(bufferSize);
                continue;
            }
            if (this.matches("delay-seconds", nodeName)) {
                int delaySeconds = DomConfigHelper.getIntegerValue("delay-seconds", this.getTextContent(childNode));
                queryCacheConfig.setDelaySeconds(delaySeconds);
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(childNode))));
                continue;
            }
            if (this.matches("coalesce", nodeName)) {
                boolean coalesce = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
                queryCacheConfig.setCoalesce(coalesce);
                continue;
            }
            if (this.matches("populate", nodeName)) {
                boolean populate = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
                queryCacheConfig.setPopulate(populate);
                continue;
            }
            if (this.matches("serialize-keys", nodeName)) {
                boolean serializeKeys = DomConfigHelper.getBooleanValue(this.getTextContent(childNode));
                queryCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if (this.matches("indexes", nodeName)) {
                this.queryCacheIndexesHandle(childNode, queryCacheConfig);
                continue;
            }
            if (this.matches("predicate", nodeName)) {
                this.queryCachePredicateHandler(childNode, queryCacheConfig);
                continue;
            }
            if (!this.matches("eviction", nodeName)) continue;
            queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode, false, false));
        }
        mapConfig.addQueryCacheConfig(queryCacheConfig);
    }

    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        String predicateType = this.getTextContent(this.getNamedItemNode(childNode, "type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if (this.matches("class-name", predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if (this.matches("sql", predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    private MapStoreConfig handleMapStoreConfig(Node node, MapStoreConfig mapStoreConfig) {
        NamedNodeMap attributes = node.getAttributes();
        boolean enabled = true;
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("enabled", att.getNodeName())) {
                enabled = DomConfigHelper.getBooleanValue(this.getTextContent(att));
                continue;
            }
            if (!this.matches("initial-mode", att.getNodeName())) continue;
            MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf(StringUtil.upperCaseInternal(this.getTextContent(att)));
            mapStoreConfig.setInitialLoadMode(mode);
        }
        mapStoreConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("class-name", nodeName)) {
                mapStoreConfig.setClassName(this.getTextContent(n));
                continue;
            }
            if (this.matches("factory-class-name", nodeName)) {
                mapStoreConfig.setFactoryClassName(this.getTextContent(n));
                continue;
            }
            if (this.matches("write-delay-seconds", nodeName)) {
                mapStoreConfig.setWriteDelaySeconds(DomConfigHelper.getIntegerValue("write-delay-seconds", this.getTextContent(n)));
                continue;
            }
            if (this.matches("write-batch-size", nodeName)) {
                mapStoreConfig.setWriteBatchSize(DomConfigHelper.getIntegerValue("write-batch-size", this.getTextContent(n)));
                continue;
            }
            if (this.matches("write-coalescing", nodeName)) {
                String writeCoalescing = this.getTextContent(n);
                if (StringUtil.isNullOrEmpty(writeCoalescing)) {
                    mapStoreConfig.setWriteCoalescing(true);
                    continue;
                }
                mapStoreConfig.setWriteCoalescing(DomConfigHelper.getBooleanValue(writeCoalescing));
                continue;
            }
            if (this.matches("offload", nodeName)) {
                String offload = this.getTextContent(n);
                if (StringUtil.isNullOrEmpty(offload)) {
                    mapStoreConfig.setOffload(true);
                    continue;
                }
                mapStoreConfig.setOffload(DomConfigHelper.getBooleanValue(offload));
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, mapStoreConfig.getProperties());
        }
        return mapStoreConfig;
    }

    private RingbufferStoreConfig createRingbufferStoreConfig(Node node) {
        RingbufferStoreConfig config = new RingbufferStoreConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches(att.getNodeName(), "enabled")) continue;
            config.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("class-name", nodeName)) {
                config.setClassName(this.getTextContent(n));
                continue;
            }
            if (this.matches("factory-class-name", nodeName)) {
                config.setFactoryClassName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, config.getProperties());
        }
        return config;
    }

    protected MergePolicyConfig createMergePolicyConfig(Node node, MergePolicyConfig baseMergePolicyConfig) {
        String policyString = this.getTextContent(node);
        baseMergePolicyConfig.setPolicy(policyString);
        String att = this.getAttribute(node, "batch-size");
        if (att != null) {
            baseMergePolicyConfig.setBatchSize(DomConfigHelper.getIntegerValue("batch-size", att));
        }
        return baseMergePolicyConfig;
    }

    private QueueStoreConfig createQueueStoreConfig(Node node) {
        QueueStoreConfig queueStoreConfig = new QueueStoreConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches(att.getNodeName(), "enabled")) continue;
            queueStoreConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("class-name", nodeName)) {
                queueStoreConfig.setClassName(this.getTextContent(n));
                continue;
            }
            if (this.matches("factory-class-name", nodeName)) {
                queueStoreConfig.setFactoryClassName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, queueStoreConfig.getProperties());
        }
        return queueStoreConfig;
    }

    private void handleSSLConfig(Node node) {
        SSLConfig sslConfig = this.parseSslConfig(node);
        this.config.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private void handleSSLConfig(Node node, EndpointConfig endpointConfig) {
        SSLConfig sslConfig = this.parseSslConfig(node);
        endpointConfig.setSSLConfig(sslConfig);
    }

    private void handleMemberAddressProvider(Node node, boolean advancedNetworkConfig) {
        MemberAddressProviderConfig memberAddressProviderConfig = this.memberAddressProviderConfig(advancedNetworkConfig);
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        memberAddressProviderConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches(nodeName, "class-name")) {
                String className = this.getTextContent(n);
                memberAddressProviderConfig.setClassName(className);
                continue;
            }
            if (!this.matches(nodeName, "properties")) continue;
            this.fillProperties(n, memberAddressProviderConfig.getProperties());
        }
    }

    private MemberAddressProviderConfig memberAddressProviderConfig(boolean advancedNetworkConfig) {
        return advancedNetworkConfig ? this.config.getAdvancedNetworkConfig().getMemberAddressProviderConfig() : this.config.getNetworkConfig().getMemberAddressProviderConfig();
    }

    private void handleFailureDetector(Node node, boolean advancedNetworkConfig) {
        if (!node.hasChildNodes()) {
            return;
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches(DomConfigHelper.cleanNodeName(child), "icmp")) {
                throw new IllegalStateException("Unsupported child under failure-detector");
            }
            Node enabledNode = this.getNamedItemNode(child, "enabled");
            boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
            IcmpFailureDetectorConfig icmpFailureDetectorConfig = new IcmpFailureDetectorConfig();
            icmpFailureDetectorConfig.setEnabled(enabled);
            for (Node n : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(n);
                if (this.matches(nodeName, "ttl")) {
                    int ttl = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setTtl(ttl);
                    continue;
                }
                if (this.matches(nodeName, "timeout-milliseconds")) {
                    int timeout = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setTimeoutMilliseconds(timeout);
                    continue;
                }
                if (this.matches(nodeName, "parallel-mode")) {
                    boolean mode = Boolean.parseBoolean(this.getTextContent(n));
                    icmpFailureDetectorConfig.setParallelMode(mode);
                    continue;
                }
                if (this.matches(nodeName, "fail-fast-on-startup")) {
                    boolean failOnStartup = Boolean.parseBoolean(this.getTextContent(n));
                    icmpFailureDetectorConfig.setFailFastOnStartup(failOnStartup);
                    continue;
                }
                if (this.matches(nodeName, "max-attempts")) {
                    int attempts = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setMaxAttempts(attempts);
                    continue;
                }
                if (!this.matches(nodeName, "interval-milliseconds")) continue;
                int interval = Integer.parseInt(this.getTextContent(n));
                icmpFailureDetectorConfig.setIntervalMilliseconds(interval);
            }
            if (advancedNetworkConfig) {
                this.config.getAdvancedNetworkConfig().setIcmpFailureDetectorConfig(icmpFailureDetectorConfig);
                continue;
            }
            this.config.getNetworkConfig().setIcmpFailureDetectorConfig(icmpFailureDetectorConfig);
        }
    }

    private void handleSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        this.config.getNetworkConfig().setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleSocketInterceptorConfig(Node node, EndpointConfig endpointConfig) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        endpointConfig.setSocketInterceptorConfig(socketInterceptorConfig);
    }

    protected void handleTopic(Node node) {
        Node attName = this.getNamedItemNode(node, "name");
        String name = this.getTextContent(attName);
        TopicConfig tConfig = new TopicConfig();
        tConfig.setName(name);
        this.handleTopicNode(node, tConfig);
    }

    void handleTopicNode(Node node, TopicConfig tConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches(nodeName, "global-ordering-enabled")) {
                tConfig.setGlobalOrderingEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("message-listeners", nodeName)) {
                this.handleMessageListeners(n, listenerConfig -> {
                    tConfig.addMessageListenerConfig((ListenerConfig)listenerConfig);
                    return null;
                });
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                tConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("multi-threading-enabled", nodeName)) {
                tConfig.setMultiThreadingEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            tConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addTopicConfig(tConfig);
    }

    protected void handleNamespaces(Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        this.config.getNamespacesConfig().setEnabled(enabled);
        if (enabled) {
            this.handleNamespacesNode(node);
        }
    }

    void handleNamespacesNode(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches(nodeName, "namespace")) {
                Node attName = this.getNamedItemNode(n, "name");
                String name = this.getTextContent(attName);
                UserCodeNamespaceConfig nsConfig = new UserCodeNamespaceConfig(name);
                this.handleResources(n, nsConfig);
                this.config.getNamespacesConfig().addNamespaceConfig(nsConfig);
                continue;
            }
            if (!this.matches(nodeName, "class-filter")) continue;
            this.fillJavaSerializationFilter(n, this.config.getNamespacesConfig());
        }
    }

    void handleResources(Node node, UserCodeNamespaceConfig nsConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches(nodeName, "jar")) {
                this.handleJarNode(n, nsConfig);
            }
            if (this.matches(nodeName, "jars-in-zip")) {
                this.handleJarsInZipNode(n, nsConfig);
            }
            if (!this.matches(nodeName, "class")) continue;
            this.handleClassNode(n, nsConfig);
        }
    }

    void handleClassNode(Node node, UserCodeNamespaceConfig nsConfig) {
        URL url = this.getNamespaceResourceUrl(node);
        String id = this.getAttribute(node, "id");
        if (url != null) {
            nsConfig.addClass(url, id);
        }
    }

    void handleJarNode(Node node, UserCodeNamespaceConfig nsConfig) {
        URL url = this.getNamespaceResourceUrl(node);
        String id = this.getAttribute(node, "id");
        if (url != null) {
            nsConfig.addJar(url, id);
        }
    }

    void handleJarsInZipNode(Node node, UserCodeNamespaceConfig nsConfig) {
        URL url = this.getNamespaceResourceUrl(node);
        String id = this.getAttribute(node, "id");
        if (url != null) {
            nsConfig.addJarsInZip(url, id);
        }
    }

    private URL getNamespaceResourceUrl(Node node) {
        URL url = null;
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches(nodeName, "url")) continue;
            try {
                url = new URI(this.getTextContent(n)).toURL();
                break;
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new InvalidConfigurationException("Malformed resource URL", e);
            }
        }
        return url;
    }

    protected void handleReliableTopic(Node node) {
        Node attName = this.getNamedItemNode(node, "name");
        String name = this.getTextContent(attName);
        ReliableTopicConfig topicConfig = new ReliableTopicConfig(name);
        this.handleReliableTopicNode(node, topicConfig);
    }

    void handleReliableTopicNode(Node node, ReliableTopicConfig topicConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("read-batch-size", nodeName)) {
                String batchSize = this.getTextContent(n);
                topicConfig.setReadBatchSize(DomConfigHelper.getIntegerValue("read-batch-size", batchSize));
                continue;
            }
            if (this.matches("statistics-enabled", nodeName)) {
                topicConfig.setStatisticsEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (this.matches("topic-overload-policy", nodeName)) {
                TopicOverloadPolicy topicOverloadPolicy = TopicOverloadPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n)));
                topicConfig.setTopicOverloadPolicy(topicOverloadPolicy);
                continue;
            }
            if (this.matches("message-listeners", nodeName)) {
                this.handleMessageListeners(n, listenerConfig -> {
                    topicConfig.addMessageListenerConfig((ListenerConfig)listenerConfig);
                    return null;
                });
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            topicConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addReliableTopicConfig(topicConfig);
    }

    void handleMessageListeners(Node n, Function<ListenerConfig, Void> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("message-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            configAddFunction.apply(new ListenerConfig(this.getTextContent(listenerNode)));
        }
    }

    protected void handleRingbuffer(Node node) {
        String name = this.getTextContent(this.getNamedItemNode(node, "name"));
        this.handleRingBufferNode(node, ConfigUtils.getByNameOrNew(this.config.getRingbufferConfigs(), name, RingbufferConfig.class));
    }

    void handleRingBufferNode(Node node, RingbufferConfig rbConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("capacity", nodeName)) {
                int capacity = DomConfigHelper.getIntegerValue("capacity", this.getTextContent(n));
                rbConfig.setCapacity(capacity);
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                int backupCount = DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(n));
                rbConfig.setBackupCount(backupCount);
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                int asyncBackupCount = DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(n));
                rbConfig.setAsyncBackupCount(asyncBackupCount);
                continue;
            }
            if (this.matches("time-to-live-seconds", nodeName)) {
                int timeToLiveSeconds = DomConfigHelper.getIntegerValue("time-to-live-seconds", this.getTextContent(n));
                rbConfig.setTimeToLiveSeconds(timeToLiveSeconds);
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                InMemoryFormat inMemoryFormat = InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n)));
                rbConfig.setInMemoryFormat(inMemoryFormat);
                continue;
            }
            if (this.matches("ringbuffer-store", nodeName)) {
                RingbufferStoreConfig ringbufferStoreConfig = this.createRingbufferStoreConfig(n);
                rbConfig.setRingbufferStoreConfig(ringbufferStoreConfig);
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                rbConfig.setSplitBrainProtectionName(this.getTextContent(n));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(n, rbConfig.getMergePolicyConfig());
                rbConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            rbConfig.setUserCodeNamespace(this.getTextContent(n));
        }
        this.config.addRingBufferConfig(rbConfig);
    }

    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("listener", DomConfigHelper.cleanNodeName(child))) continue;
            String listenerClass = this.getTextContent(child);
            this.config.addListenerConfig(new ListenerConfig(listenerClass));
        }
    }

    private void handlePartitionGroup(Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        this.config.getPartitionGroupConfig().setEnabled(enabled);
        Node groupTypeNode = this.getNamedItemNode(node, "group-type");
        PartitionGroupConfig.MemberGroupType groupType = groupTypeNode != null ? PartitionGroupConfig.MemberGroupType.valueOf(StringUtil.upperCaseInternal(this.getTextContent(groupTypeNode))) : PartitionGroupConfig.MemberGroupType.PER_MEMBER;
        this.config.getPartitionGroupConfig().setGroupType(groupType);
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("member-group", DomConfigHelper.cleanNodeName(child))) continue;
            this.handleMemberGroup(child, this.config);
        }
    }

    protected void handleMemberGroup(Node node, Config config) {
        MemberGroupConfig memberGroupConfig = new MemberGroupConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("interface", DomConfigHelper.cleanNodeName(child))) continue;
            memberGroupConfig.addInterface(this.getTextContent(child));
        }
        config.getPartitionGroupConfig().addMemberGroupConfig(memberGroupConfig);
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.config.setSerializationConfig(serializationConfig);
    }

    private void handleManagementCenterConfig(Node node) {
        Node dataAccessEnabledNode;
        Node consoleEnabledNode;
        ManagementCenterConfig managementCenterConfig = this.config.getManagementCenterConfig();
        Node scriptingEnabledNode = this.getNamedItemNode(node, "scripting-enabled");
        if (scriptingEnabledNode != null) {
            managementCenterConfig.setScriptingEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(scriptingEnabledNode)));
        }
        if ((consoleEnabledNode = this.getNamedItemNode(node, "console-enabled")) != null) {
            managementCenterConfig.setConsoleEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(consoleEnabledNode)));
        }
        if ((dataAccessEnabledNode = this.getNamedItemNode(node, "data-access-enabled")) != null) {
            managementCenterConfig.setDataAccessEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(dataAccessEnabledNode)));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            if (!this.matches("trusted-interfaces", DomConfigHelper.cleanNodeName(n))) continue;
            this.handleTrustedInterfaces(managementCenterConfig, n);
        }
    }

    private void handleSecurity(Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        this.config.getSecurityConfig().setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("realms", nodeName)) {
                this.handleRealms(child);
                continue;
            }
            if (this.matches("member-authentication", nodeName)) {
                this.config.getSecurityConfig().setMemberRealm(this.getAttribute(child, "realm"));
                continue;
            }
            if (this.matches("client-authentication", nodeName)) {
                this.config.getSecurityConfig().setClientRealm(this.getAttribute(child, "realm"));
                continue;
            }
            if (this.matches("client-permission-policy", nodeName)) {
                this.handlePermissionPolicy(child);
                continue;
            }
            if (this.matches("client-permissions", nodeName)) {
                this.handleSecurityPermissions(child);
                continue;
            }
            if (this.matches("security-interceptors", nodeName)) {
                this.handleSecurityInterceptors(child);
                continue;
            }
            if (!this.matches("client-block-unmapped-actions", nodeName)) continue;
            this.config.getSecurityConfig().setClientBlockUnmappedActions(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
    }

    protected void handleRealms(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("realm", DomConfigHelper.cleanNodeName(child))) continue;
            this.handleRealm(child);
        }
    }

    private void handleSecurityInterceptors(Node node) {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleSecurityInterceptorsChild(cfg, child);
        }
    }

    protected void handleSecurityInterceptorsChild(SecurityConfig cfg, Node child) {
        String nodeName = DomConfigHelper.cleanNodeName(child);
        if (this.matches("interceptor", nodeName)) {
            Node classNameNode = this.getNamedItemNode(child, "class-name");
            String className = this.getTextContent(classNameNode);
            cfg.addSecurityInterceptorConfig(new SecurityInterceptorConfig(className));
        }
    }

    protected void handleMemberAttributes(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("attribute", name)) continue;
            String value = this.getTextContent(n);
            String attributeName = this.getTextContent(this.getNamedItemNode(n, "name"));
            this.handleMemberAttributesNode(attributeName, value);
        }
    }

    void handleMemberAttributesNode(String attributeName, String value) {
        this.config.getMemberAttributeConfig().setAttribute(attributeName, value);
    }

    private void handlePermissionPolicy(Node node) {
        Node classNameNode = this.getNamedItemNode(node, "class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        PermissionPolicyConfig policyConfig = new PermissionPolicyConfig(className);
        cfg.setClientPolicyConfig(policyConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(child, policyConfig.getProperties());
            break;
        }
    }

    protected void handleSecurityPermissions(Node node) {
        String onJoinOp = this.getAttribute(node, "on-join-operation");
        if (onJoinOp != null) {
            OnJoinPermissionOperationName onJoinPermissionOperation = OnJoinPermissionOperationName.valueOf(StringUtil.upperCaseInternal(onJoinOp));
            this.config.getSecurityConfig().setOnJoinPermissionOperation(onJoinPermissionOperation);
        }
        this.config.getSecurityConfig().setPermissionPriorityGrant(DomConfigHelper.getBooleanValue(this.getAttribute(node, "priority-grant")));
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType(nodeName);
            if (type == null) {
                throw new InvalidConfigurationException("Security permission type is not valid " + nodeName);
            }
            this.handleSecurityPermission(child, type);
        }
    }

    void handleSecurityPermission(Node node, PermissionConfig.PermissionType type) {
        SecurityConfig cfg = this.config.getSecurityConfig();
        Node nameNode = this.getNamedItemNode(node, "name");
        String name = nameNode != null ? this.getTextContent(nameNode) : null;
        Node principalNode = this.getNamedItemNode(node, "principal");
        String principal = principalNode != null ? this.getTextContent(principalNode) : null;
        PermissionConfig permConfig = new PermissionConfig(type, name, principal);
        permConfig.setDeny(DomConfigHelper.getBooleanValue(this.getAttribute(node, "deny")));
        cfg.addClientPermissionConfig(permConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("endpoints", nodeName)) {
                this.handleSecurityPermissionEndpoints(child, permConfig);
                continue;
            }
            if (!this.matches("actions", nodeName)) continue;
            this.handleSecurityPermissionActions(child, permConfig);
        }
    }

    void handleSecurityPermissionEndpoints(Node node, PermissionConfig permConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("endpoint", nodeName)) continue;
            permConfig.addEndpoint(this.getTextContent(child));
        }
    }

    void handleSecurityPermissionActions(Node node, PermissionConfig permConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("action", nodeName)) continue;
            permConfig.addAction(this.getTextContent(child));
        }
    }

    private void handleMemcacheProtocol(Node node) {
        this.config.getNetworkConfig().getMemcacheProtocolConfig().setEnabled(DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled")));
    }

    private void handleRestApi(Node node) {
        RestApiConfig restApiConfig = this.config.getNetworkConfig().getRestApiConfig();
        boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
        restApiConfig.setEnabled(enabled);
        this.handleRestApiEndpointGroups(node);
    }

    protected void handleRestApiEndpointGroups(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("endpoint-group", nodeName)) continue;
            String name = this.getAttribute(child, "name");
            this.handleEndpointGroup(child, name);
        }
    }

    private void handleRestEndpointGroup(RestServerEndpointConfig config, Node node) {
        RestEndpointGroup endpointGroup;
        boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
        String name = this.extractName(node);
        try {
            endpointGroup = RestEndpointGroup.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Wrong name attribute value was provided in endpoint-group element: " + name + "\nAllowed values: " + Arrays.toString((Object[])RestEndpointGroup.values()));
        }
        if (enabled) {
            config.enableGroups(endpointGroup);
        } else {
            config.disableGroups(endpointGroup);
        }
    }

    protected String extractName(Node node) {
        return this.getAttribute(node, "name");
    }

    void handleEndpointGroup(Node node, String name) {
        boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
        RestEndpointGroup endpointGroup = this.lookupEndpointGroup(name);
        RestApiConfig restApiConfig = this.config.getNetworkConfig().getRestApiConfig();
        if (enabled) {
            restApiConfig.enableGroups(endpointGroup);
        } else {
            restApiConfig.disableGroups(endpointGroup);
        }
    }

    private RestEndpointGroup lookupEndpointGroup(String name) {
        return Arrays.stream(RestEndpointGroup.values()).filter(value -> value.toString().replace("_", "").equals(name.toUpperCase().replace("_", ""))).findAny().orElseThrow(() -> new InvalidConfigurationException("Wrong name attribute value was provided in endpoint-group element: " + name + "\nAllowed values: " + Arrays.toString((Object[])RestEndpointGroup.values())));
    }

    private void handleCPSubsystem(Node node) {
        CPSubsystemConfig cpSubsystemConfig = this.config.getCPSubsystemConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("raft-algorithm", nodeName)) {
                this.handleRaftAlgorithm(cpSubsystemConfig.getRaftAlgorithmConfig(), child);
                continue;
            }
            if (this.matches("semaphores", nodeName)) {
                this.handleSemaphores(cpSubsystemConfig, child);
                continue;
            }
            if (this.matches("locks", nodeName)) {
                this.handleFencedLocks(cpSubsystemConfig, child);
                continue;
            }
            if (this.matches("maps", nodeName)) {
                this.handleCPMaps(cpSubsystemConfig, child);
                continue;
            }
            if (this.matches("cp-member-count", nodeName)) {
                cpSubsystemConfig.setCPMemberCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("group-size", nodeName)) {
                cpSubsystemConfig.setGroupSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("session-time-to-live-seconds", nodeName)) {
                cpSubsystemConfig.setSessionTimeToLiveSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("session-heartbeat-interval-seconds", nodeName)) {
                cpSubsystemConfig.setSessionHeartbeatIntervalSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("missing-cp-member-auto-removal-seconds", nodeName)) {
                cpSubsystemConfig.setMissingCPMemberAutoRemovalSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("fail-on-indeterminate-operation-state", nodeName)) {
                cpSubsystemConfig.setFailOnIndeterminateOperationState(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("persistence-enabled", nodeName)) {
                cpSubsystemConfig.setPersistenceEnabled(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("base-dir", nodeName)) {
                cpSubsystemConfig.setBaseDir(new File(this.getTextContent(child)).getAbsoluteFile());
                continue;
            }
            if (this.matches("data-load-timeout-seconds", nodeName)) {
                cpSubsystemConfig.setDataLoadTimeoutSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("cp-member-priority", nodeName)) {
                cpSubsystemConfig.setCPMemberPriority(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("map-limit", nodeName)) continue;
            cpSubsystemConfig.setCPMapLimit(Integer.parseInt(this.getTextContent(child)));
        }
    }

    void handleCPMaps(CPSubsystemConfig cpSubsystemConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            CPMapConfig cpMapConfig = new CPMapConfig();
            for (Node subChild : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(subChild);
                if (this.matches("name", nodeName)) {
                    cpMapConfig.setName(this.getTextContent(subChild));
                    continue;
                }
                if (!this.matches("max-size-mb", nodeName)) continue;
                cpMapConfig.setMaxSizeMb(Integer.parseInt(this.getTextContent(subChild)));
            }
            cpSubsystemConfig.addCPMapConfig(cpMapConfig);
        }
    }

    private void handleRaftAlgorithm(RaftAlgorithmConfig raftAlgorithmConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("leader-election-timeout-in-millis", nodeName)) {
                raftAlgorithmConfig.setLeaderElectionTimeoutInMillis(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (this.matches("leader-heartbeat-period-in-millis", nodeName)) {
                raftAlgorithmConfig.setLeaderHeartbeatPeriodInMillis(Long.parseLong(this.getTextContent(child)));
                continue;
            }
            if (this.matches("max-missed-leader-heartbeat-count", nodeName)) {
                raftAlgorithmConfig.setMaxMissedLeaderHeartbeatCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("append-request-max-entry-count", nodeName)) {
                raftAlgorithmConfig.setAppendRequestMaxEntryCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("commit-index-advance-count-to-snapshot", nodeName)) {
                raftAlgorithmConfig.setCommitIndexAdvanceCountToSnapshot(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("uncommitted-entry-count-to-reject-new-appends", nodeName)) {
                raftAlgorithmConfig.setUncommittedEntryCountToRejectNewAppends(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("append-request-backoff-timeout-in-millis", nodeName)) continue;
            raftAlgorithmConfig.setAppendRequestBackoffTimeoutInMillis(Long.parseLong(this.getTextContent(child)));
        }
    }

    void handleSemaphores(CPSubsystemConfig cpSubsystemConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            SemaphoreConfig semaphoreConfig = new SemaphoreConfig();
            for (Node subChild : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(subChild);
                if (this.matches("name", nodeName)) {
                    semaphoreConfig.setName(this.getTextContent(subChild));
                    continue;
                }
                if (this.matches("jdk-compatible", nodeName)) {
                    semaphoreConfig.setJDKCompatible(Boolean.parseBoolean(this.getTextContent(subChild)));
                    continue;
                }
                if (!this.matches("initial-permits", nodeName)) continue;
                semaphoreConfig.setInitialPermits(Integer.parseInt(this.getTextContent(subChild)));
            }
            cpSubsystemConfig.addSemaphoreConfig(semaphoreConfig);
        }
    }

    void handleFencedLocks(CPSubsystemConfig cpSubsystemConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            FencedLockConfig lockConfig = new FencedLockConfig();
            for (Node subChild : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(subChild);
                if (this.matches("name", nodeName)) {
                    lockConfig.setName(this.getTextContent(subChild));
                    continue;
                }
                if (!this.matches("lock-acquire-limit", nodeName)) continue;
                lockConfig.setLockAcquireLimit(Integer.parseInt(this.getTextContent(subChild)));
            }
            cpSubsystemConfig.addLockConfig(lockConfig);
        }
    }

    private void handleMetrics(Node node) {
        MetricsConfig metricsConfig = this.config.getMetricsConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
            metricsConfig.setEnabled(enabled);
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("management-center", nodeName)) {
                this.handleMetricsManagementCenter(child);
                continue;
            }
            if (this.matches("jmx", nodeName)) {
                this.handleMetricsJmx(child);
                continue;
            }
            if (!this.matches("collection-frequency-seconds", nodeName)) continue;
            metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(this.getTextContent(child)));
        }
    }

    private void handleMetricsManagementCenter(Node node) {
        MetricsManagementCenterConfig managementCenterConfig = this.config.getMetricsConfig().getManagementCenterConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (this.matches("enabled", att.getNodeName())) {
                boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
                managementCenterConfig.setEnabled(enabled);
            }
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if (!this.matches("retention-seconds", nodeName)) continue;
                managementCenterConfig.setRetentionSeconds(Integer.parseInt(this.getTextContent(child)));
            }
        }
    }

    private void handleMetricsJmx(Node node) {
        MetricsJmxConfig jmxConfig = this.config.getMetricsConfig().getJmxConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
            jmxConfig.setEnabled(enabled);
        }
    }

    private void handleJet(Node node) {
        JetConfig jetConfig = this.config.getJetConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node attribute = attributes.item(a);
            if (this.matches("enabled", attribute.getNodeName())) {
                boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
                jetConfig.setEnabled(enabled);
                continue;
            }
            if (!this.matches("resource-upload-enabled", attribute.getNodeName())) continue;
            boolean resourceUploadEnabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "resource-upload-enabled"));
            jetConfig.setResourceUploadEnabled(resourceUploadEnabled);
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("cooperative-thread-count", nodeName)) {
                jetConfig.setCooperativeThreadCount(DomConfigHelper.getIntegerValue("cooperative-thread-count", this.getTextContent(child)));
                continue;
            }
            if (this.matches("flow-control-period", nodeName)) {
                jetConfig.setFlowControlPeriodMs(DomConfigHelper.getIntegerValue("flow-control-period", this.getTextContent(child)));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                jetConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(child)));
                continue;
            }
            if (this.matches("scale-up-delay-millis", nodeName)) {
                jetConfig.setScaleUpDelayMillis(DomConfigHelper.getLongValue("scale-up-delay-millis", this.getTextContent(child)));
                continue;
            }
            if (this.matches("lossless-restart-enabled", nodeName)) {
                jetConfig.setLosslessRestartEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("max-processor-accumulated-records", nodeName)) {
                jetConfig.setMaxProcessorAccumulatedRecords(DomConfigHelper.getLongValue("max-processor-accumulated-records", this.getTextContent(child)));
                continue;
            }
            if (this.matches("edge-defaults", nodeName)) {
                this.handleEdgeDefaults(jetConfig, child);
                continue;
            }
            if (!this.matches("instance", nodeName)) continue;
            if (this.jetConfigContainsInstanceConfigFields(node)) {
                LOGGER.warning("<instance> tag will be ignored since <jet> tag already contains the instance fields.");
                continue;
            }
            LOGGER.warning("<instance> tag is deprecated, use <jet> tag directly for configuration.");
            this.handleInstance(jetConfig, child);
        }
    }

    private boolean jetConfigContainsInstanceConfigFields(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!"cooperative-thread-count".equals(nodeName) && !"flow-control-period".equals(nodeName) && !"backup-count".equals(nodeName) && !"scale-up-delay-millis".equals(nodeName) && !"lossless-restart-enabled".equals(nodeName) && !"max-processor-accumulated-records".equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    private void handleInstance(JetConfig jetConfig, Node node) {
        InstanceConfig instanceConfig = jetConfig.getInstanceConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("cooperative-thread-count", nodeName)) {
                instanceConfig.setCooperativeThreadCount(DomConfigHelper.getIntegerValue("cooperative-thread-count", this.getTextContent(child)));
                continue;
            }
            if (this.matches("flow-control-period", nodeName)) {
                instanceConfig.setFlowControlPeriodMs(DomConfigHelper.getIntegerValue("flow-control-period", this.getTextContent(child)));
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                instanceConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(child)));
                continue;
            }
            if (this.matches("scale-up-delay-millis", nodeName)) {
                instanceConfig.setScaleUpDelayMillis(DomConfigHelper.getLongValue("scale-up-delay-millis", this.getTextContent(child)));
                continue;
            }
            if (this.matches("lossless-restart-enabled", nodeName)) {
                instanceConfig.setLosslessRestartEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("max-processor-accumulated-records", nodeName)) continue;
            instanceConfig.setMaxProcessorAccumulatedRecords(DomConfigHelper.getLongValue("max-processor-accumulated-records", this.getTextContent(child)));
        }
    }

    private void handleEdgeDefaults(JetConfig jetConfig, Node node) {
        EdgeConfig edgeConfig = jetConfig.getDefaultEdgeConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("queue-size", nodeName)) {
                edgeConfig.setQueueSize(DomConfigHelper.getIntegerValue("queue-size", this.getTextContent(child)));
                continue;
            }
            if (this.matches("packet-size-limit", nodeName)) {
                edgeConfig.setPacketSizeLimit(DomConfigHelper.getIntegerValue("packet-size-limit", this.getTextContent(child)));
                continue;
            }
            if (!this.matches("receive-window-multiplier", nodeName)) continue;
            edgeConfig.setReceiveWindowMultiplier(DomConfigHelper.getIntegerValue("receive-window-multiplier", this.getTextContent(child)));
        }
    }

    private void handleSql(Node node) {
        SqlConfig sqlConfig = this.config.getSqlConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("statement-timeout-millis", nodeName)) {
                sqlConfig.setStatementTimeoutMillis(Long.parseLong(this.getTextContent(child)));
            }
            if (this.matches("catalog-persistence-enabled", nodeName)) {
                sqlConfig.setCatalogPersistenceEnabled(Boolean.parseBoolean(this.getTextContent(child)));
            }
            if (!this.matches("java-reflection-filter", nodeName)) continue;
            sqlConfig.setJavaReflectionFilterConfig(this.getJavaFilter(child));
        }
    }

    protected void handleRealm(Node node) {
        String realmName = this.getAttribute(node, "name");
        RealmConfig realmConfig = new RealmConfig();
        this.config.getSecurityConfig().addRealmConfig(realmName, realmConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("authentication", nodeName)) {
                this.handleAuthentication(realmConfig, child);
                continue;
            }
            if (this.matches("identity", nodeName)) {
                this.handleIdentity(realmConfig, child);
                continue;
            }
            if (!this.matches("access-control-service", nodeName)) continue;
            this.handleAccessControlService(realmConfig, child);
        }
    }

    private void handleAuthentication(RealmConfig realmConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("jaas", nodeName)) {
                this.handleJaasAuthentication(realmConfig, child);
                continue;
            }
            if (this.matches("tls", nodeName)) {
                this.handleTlsAuthentication(realmConfig, child);
                continue;
            }
            if (this.matches("ldap", nodeName)) {
                realmConfig.setLdapAuthenticationConfig(this.createLdapAuthentication(child));
                continue;
            }
            if (this.matches("kerberos", nodeName)) {
                this.handleKerberosAuthentication(realmConfig, child);
                continue;
            }
            if (!this.matches("simple", nodeName)) continue;
            this.handleSimpleAuthentication(realmConfig, child);
        }
    }

    private void handleIdentity(RealmConfig realmConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("username-password", nodeName)) {
                realmConfig.setUsernamePasswordIdentityConfig(this.getAttribute(child, "username"), this.getAttribute(child, "password"));
                continue;
            }
            if (this.matches("credentials-factory", nodeName)) {
                this.handleCredentialsFactory(realmConfig, child);
                continue;
            }
            if (this.matches("token", nodeName)) {
                this.handleToken(realmConfig, child);
                continue;
            }
            if (!this.matches("kerberos", nodeName)) continue;
            this.handleKerberosIdentity(realmConfig, child);
        }
    }

    private void handleAccessControlService(RealmConfig realmConfig, Node node) {
        AccessControlServiceConfig acs = new AccessControlServiceConfig();
        realmConfig.setAccessControlServiceConfig(acs);
        this.fillBaseFactoryWithPropertiesConfig(node, acs);
    }

    protected void handleToken(RealmConfig realmConfig, Node node) {
        TokenEncoding encoding = TokenEncoding.getTokenEncoding(this.getAttribute(node, "encoding"));
        TokenIdentityConfig tic = new TokenIdentityConfig(encoding, this.getTextContent(node));
        realmConfig.setTokenIdentityConfig(tic);
    }

    protected void handleKerberosIdentity(RealmConfig realmConfig, Node node) {
        KerberosIdentityConfig kerbIdentity = new KerberosIdentityConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("realm", nodeName)) {
                kerbIdentity.setRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("security-realm", nodeName)) {
                kerbIdentity.setSecurityRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("principal", nodeName)) {
                kerbIdentity.setPrincipal(this.getTextContent(child));
                continue;
            }
            if (this.matches("keytab-file", nodeName)) {
                kerbIdentity.setKeytabFile(this.getTextContent(child));
                continue;
            }
            if (this.matches("service-name-prefix", nodeName)) {
                kerbIdentity.setServiceNamePrefix(this.getTextContent(child));
                continue;
            }
            if (this.matches("spn", nodeName)) {
                kerbIdentity.setSpn(this.getTextContent(child));
                continue;
            }
            if (!this.matches("use-canonical-hostname", nodeName)) continue;
            kerbIdentity.setUseCanonicalHostname(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
        realmConfig.setKerberosIdentityConfig(kerbIdentity);
    }

    protected void handleTlsAuthentication(RealmConfig realmConfig, Node node) {
        String roleAttribute = this.getAttribute(node, "roleAttribute");
        TlsAuthenticationConfig tlsCfg = new TlsAuthenticationConfig();
        this.fillClusterLoginConfig(tlsCfg, node);
        if (roleAttribute != null) {
            tlsCfg.setRoleAttribute(roleAttribute);
        }
        realmConfig.setTlsAuthenticationConfig(tlsCfg);
    }

    protected LdapAuthenticationConfig createLdapAuthentication(Node node) {
        LdapAuthenticationConfig ldapCfg = new LdapAuthenticationConfig();
        this.fillClusterLoginConfig(ldapCfg, node);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("url", nodeName)) {
                ldapCfg.setUrl(this.getTextContent(child));
                continue;
            }
            if (this.matches("socket-factory-class-name", nodeName)) {
                ldapCfg.setSocketFactoryClassName(this.getTextContent(child));
                continue;
            }
            if (this.matches("parse-dn", nodeName)) {
                ldapCfg.setParseDn(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("role-context", nodeName)) {
                ldapCfg.setRoleContext(this.getTextContent(child));
                continue;
            }
            if (this.matches("role-filter", nodeName)) {
                ldapCfg.setRoleFilter(this.getTextContent(child));
                continue;
            }
            if (this.matches("role-mapping-attribute", nodeName)) {
                ldapCfg.setRoleMappingAttribute(this.getTextContent(child));
                continue;
            }
            if (this.matches("role-mapping-mode", nodeName)) {
                ldapCfg.setRoleMappingMode(LdapRoleMappingMode.getRoleMappingMode(this.getTextContent(child)));
                continue;
            }
            if (this.matches("role-name-attribute", nodeName)) {
                ldapCfg.setRoleNameAttribute(this.getTextContent(child));
                continue;
            }
            if (this.matches("role-recursion-max-depth", nodeName)) {
                ldapCfg.setRoleRecursionMaxDepth(DomConfigHelper.getIntegerValue("role-recursion-max-depth", this.getTextContent(child)));
                continue;
            }
            if (this.matches("role-search-scope", nodeName)) {
                ldapCfg.setRoleSearchScope(LdapSearchScope.getSearchScope(this.getTextContent(child)));
                continue;
            }
            if (this.matches("user-name-attribute", nodeName)) {
                ldapCfg.setUserNameAttribute(this.getTextContent(child));
                continue;
            }
            if (this.matches("system-user-dn", nodeName)) {
                ldapCfg.setSystemUserDn(this.getTextContent(child));
                continue;
            }
            if (this.matches("system-user-password", nodeName)) {
                ldapCfg.setSystemUserPassword(this.getTextContent(child));
                continue;
            }
            if (this.matches("system-authentication", nodeName)) {
                ldapCfg.setSystemAuthentication(this.getTextContent(child));
                continue;
            }
            if (this.matches("security-realm", nodeName)) {
                ldapCfg.setSecurityRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("password-attribute", nodeName)) {
                ldapCfg.setPasswordAttribute(this.getTextContent(child));
                continue;
            }
            if (this.matches("user-context", nodeName)) {
                ldapCfg.setUserContext(this.getTextContent(child));
                continue;
            }
            if (this.matches("user-filter", nodeName)) {
                ldapCfg.setUserFilter(this.getTextContent(child));
                continue;
            }
            if (this.matches("user-search-scope", nodeName)) {
                ldapCfg.setUserSearchScope(LdapSearchScope.getSearchScope(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("skip-authentication", nodeName)) continue;
            ldapCfg.setSkipAuthentication(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
        return ldapCfg;
    }

    protected void handleKerberosAuthentication(RealmConfig realmConfig, Node node) {
        KerberosAuthenticationConfig krbCfg = new KerberosAuthenticationConfig();
        this.fillClusterLoginConfig(krbCfg, node);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("relax-flags-check", nodeName)) {
                krbCfg.setRelaxFlagsCheck(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("use-name-without-realm", nodeName)) {
                krbCfg.setUseNameWithoutRealm(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("security-realm", nodeName)) {
                krbCfg.setSecurityRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("principal", nodeName)) {
                krbCfg.setPrincipal(this.getTextContent(child));
                continue;
            }
            if (this.matches("keytab-file", nodeName)) {
                krbCfg.setKeytabFile(this.getTextContent(child));
                continue;
            }
            if (!this.matches("ldap", nodeName)) continue;
            krbCfg.setLdapAuthenticationConfig(this.createLdapAuthentication(child));
        }
        realmConfig.setKerberosAuthenticationConfig(krbCfg);
    }

    protected void handleSimpleAuthentication(RealmConfig realmConfig, Node node) {
        SimpleAuthenticationConfig simpleCfg = new SimpleAuthenticationConfig();
        this.fillClusterLoginConfig(simpleCfg, node);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("user", nodeName)) {
                this.addSimpleUser(simpleCfg, child);
                continue;
            }
            if (!this.matches("role-separator", nodeName)) continue;
            simpleCfg.setRoleSeparator(this.getTextContent(child));
        }
        realmConfig.setSimpleAuthenticationConfig(simpleCfg);
    }

    private void addSimpleUser(SimpleAuthenticationConfig simpleCfg, Node node) {
        String username = this.getAttribute(node, "username");
        ArrayList<String> roles = new ArrayList<String>();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("role", nodeName)) continue;
            roles.add(this.getTextContent(child));
        }
        SimpleAuthenticationConfig.UserDto userDto = new SimpleAuthenticationConfig.UserDto(this.getAttribute(node, "password"), roles.toArray(new String[roles.size()]));
        simpleCfg.addUser(username, userDto);
    }

    private void handleCredentialsFactory(RealmConfig realmConfig, Node node) {
        String className = this.getAttribute(node, "class-name");
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        realmConfig.setCredentialsFactoryConfig(credentialsFactoryConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(child, credentialsFactoryConfig.getProperties());
        }
    }

    private void handleIntegrityChecker(Node node) {
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        this.config.getIntegrityCheckerConfig().setEnabled(enabled);
    }

    private void handleTpc(Node node) {
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        TpcConfig tpcConfig = this.config.getTpcConfig();
        tpcConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String childName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("eventloop-count", childName)) continue;
            tpcConfig.setEventloopCount(DomConfigHelper.getIntegerValue("eventloop-count", this.getTextContent(child)));
        }
    }

    protected void handleDataConnections(Node node) {
        String name = this.getAttribute(node, "name");
        DataConnectionConfig dataConnectionConfig = ConfigUtils.getByNameOrNew(this.config.getDataConnectionConfigs(), name, DataConnectionConfig.class);
        this.handleDataConnection(node, dataConnectionConfig);
        DataConnectionConfigValidator.validate(dataConnectionConfig);
    }

    protected void handleDataConnection(Node node, DataConnectionConfig dataConnectionConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String childName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("type", childName)) {
                dataConnectionConfig.setType(this.getTextContent(child));
                continue;
            }
            if (this.matches("properties", childName)) {
                this.fillProperties(child, dataConnectionConfig.getProperties());
                continue;
            }
            if (!this.matches("shared", childName)) continue;
            dataConnectionConfig.setShared(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
    }

    private void handleRest(Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        RestConfig restConfig = this.config.getRestConfig();
        restConfig.setEnabled(enabled);
        String portName = "port";
        String securityRealmName = "security-realm";
        String tokenValiditySecondsName = "token-validity-seconds";
        String requestTimeoutSecondsName = "request-timeout-seconds";
        String maxLoginAttempts = "max-login-attempts";
        String lockoutDuration = "lockout-duration-seconds";
        for (Node child : DomConfigHelper.childElements(node)) {
            int durationSeconds;
            String childName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("port", childName)) {
                restConfig.setPort(DomConfigHelper.getIntegerValue("port", this.getTextContent(child)));
                continue;
            }
            if (this.matches("security-realm", childName)) {
                restConfig.setSecurityRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("token-validity-seconds", childName)) {
                durationSeconds = DomConfigHelper.getIntegerValue("token-validity-seconds", this.getTextContent(child));
                restConfig.setTokenValidityDuration(Duration.of(durationSeconds, ChronoUnit.SECONDS));
                continue;
            }
            if (this.matches("ssl", childName)) {
                this.handleRestSsl(restConfig.getSsl(), child);
                continue;
            }
            if (this.matches("request-timeout-seconds", childName)) {
                restConfig.setRequestTimeoutDuration(Duration.ofSeconds(DomConfigHelper.getIntegerValue("request-timeout-seconds", this.getTextContent(child))));
                continue;
            }
            if (this.matches("max-login-attempts", childName)) {
                restConfig.setMaxLoginAttempts(DomConfigHelper.getIntegerValue("max-login-attempts", this.getTextContent(child)));
                continue;
            }
            if (!this.matches("lockout-duration-seconds", childName)) continue;
            durationSeconds = DomConfigHelper.getIntegerValue("lockout-duration-seconds", this.getTextContent(child));
            restConfig.setLockoutDuration(Duration.of(durationSeconds, ChronoUnit.SECONDS));
        }
    }

    private void handleRestSsl(RestConfig.Ssl ssl, Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        ssl.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String childName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("client-auth", childName)) {
                ssl.setClientAuth(RestConfig.Ssl.ClientAuth.valueOf(this.getTextContent(child)));
                continue;
            }
            if (this.matches("ciphers", childName)) {
                ssl.setCiphers(this.getTextContent(child));
                continue;
            }
            if (this.matches("enabled-protocols", childName)) {
                ssl.setEnabledProtocols(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-alias", childName)) {
                ssl.setKeyAlias(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-password", childName)) {
                ssl.setKeyPassword(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-store", childName)) {
                ssl.setKeyStore(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-store-password", childName)) {
                ssl.setKeyStorePassword(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-store-type", childName)) {
                ssl.setKeyStoreType(this.getTextContent(child));
                continue;
            }
            if (this.matches("key-store-provider", childName)) {
                ssl.setKeyStoreProvider(this.getTextContent(child));
                continue;
            }
            if (this.matches("trust-store", childName)) {
                ssl.setTrustStore(this.getTextContent(child));
                continue;
            }
            if (this.matches("trust-store-password", childName)) {
                ssl.setTrustStorePassword(this.getTextContent(child));
                continue;
            }
            if (this.matches("trust-store-type", childName)) {
                ssl.setTrustStoreType(this.getTextContent(child));
                continue;
            }
            if (this.matches("trust-store-provider", childName)) {
                ssl.setTrustStoreProvider(this.getTextContent(child));
                continue;
            }
            if (this.matches("protocol", childName)) {
                ssl.setProtocol(this.getTextContent(child));
                continue;
            }
            if (this.matches("certificate", childName)) {
                ssl.setCertificate(this.getTextContent(child));
                continue;
            }
            if (this.matches("certificate-key", childName)) {
                ssl.setCertificatePrivateKey(this.getTextContent(child));
                continue;
            }
            if (this.matches("trust-certificate", childName)) {
                ssl.setTrustCertificate(this.getTextContent(child));
                continue;
            }
            if (!this.matches("trust-certificate-key", childName)) continue;
            ssl.setTrustCertificatePrivateKey(this.getTextContent(child));
        }
    }

    protected void handlePartitionAttributes(Node node, MapConfig mapConfig) {
        for (Node childElement : DomConfigHelper.childElements(node)) {
            PartitioningAttributeConfig attributeConfig = new PartitioningAttributeConfig();
            this.handlePartitioningAttributeConfig(childElement, attributeConfig);
            mapConfig.getPartitioningAttributeConfigs().add(attributeConfig);
        }
    }

    protected void handlePartitioningAttributeConfig(Node node, PartitioningAttributeConfig config) {
        config.setAttributeName(this.getTextContent(node));
    }

    protected void handleVector(Node node) {
        String name = this.getAttribute(node, "name");
        VectorCollectionConfig collectionConfig = ConfigUtils.getByNameOrNew(this.config.getVectorCollectionConfigs(), name, VectorCollectionConfig.class);
        this.handleVectorNode(node, collectionConfig);
    }

    protected void handleVectorNode(Node parentNode, VectorCollectionConfig collectionConfig) {
        for (Node node : DomConfigHelper.childElements(parentNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.matches("indexes", nodeName)) {
                this.handleVectorIndexesNode(node, collectionConfig);
                continue;
            }
            if (this.matches("backup-count", nodeName)) {
                collectionConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(node)));
                continue;
            }
            if (this.matches("async-backup-count", nodeName)) {
                collectionConfig.setAsyncBackupCount(DomConfigHelper.getIntegerValue("async-backup-count", this.getTextContent(node)));
                continue;
            }
            if (this.matches("merge-policy", nodeName)) {
                MergePolicyConfig mpConfig = this.createMergePolicyConfig(node, collectionConfig.getMergePolicyConfig());
                collectionConfig.setMergePolicyConfig(mpConfig);
                continue;
            }
            if (this.matches("split-brain-protection-ref", nodeName)) {
                collectionConfig.setSplitBrainProtectionName(this.getTextContent(node));
                continue;
            }
            if (!this.matches("user-code-namespace", nodeName)) continue;
            collectionConfig.setUserCodeNamespace(this.getTextContent(node));
        }
        this.config.addVectorCollectionConfig(collectionConfig);
    }

    protected void handleVectorIndexesNode(Node indexesNode, VectorCollectionConfig collectionConfig) {
        for (Node n : DomConfigHelper.childElements(indexesNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("index", nodeName)) continue;
            this.handleVectorIndex(n, collectionConfig);
        }
    }

    protected void handleVectorIndex(Node node, VectorCollectionConfig collectionConfig) {
        VectorIndexConfig indexConfig = new VectorIndexConfig();
        String name = this.getAttribute(node, "name");
        if (name != null) {
            indexConfig.setName(name);
        }
        this.handleVectorIndexNode(node, indexConfig);
        collectionConfig.addVectorIndexConfig(indexConfig);
    }

    protected void handleVectorIndexNode(Node node, VectorIndexConfig indexConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("name", nodeName)) {
                indexConfig.setName(this.getTextContent(n));
                continue;
            }
            if (this.matches("dimension", nodeName)) {
                indexConfig.setDimension(DomConfigHelper.getIntegerValue("dimension", this.getTextContent(n)));
                continue;
            }
            if (this.matches("metric", nodeName)) {
                indexConfig.setMetric(Metric.valueOf(this.getTextContent(n)));
                continue;
            }
            if (this.matches("max-degree", nodeName)) {
                indexConfig.setMaxDegree(DomConfigHelper.getIntegerValue("max-degree", this.getTextContent(n)));
                continue;
            }
            if (this.matches("ef-construction", nodeName)) {
                indexConfig.setEfConstruction(DomConfigHelper.getIntegerValue("ef-construction", this.getTextContent(n)));
                continue;
            }
            if (!this.matches("use-deduplication", nodeName)) continue;
            indexConfig.setUseDeduplication(DomConfigHelper.getBooleanValue(this.getTextContent(n)));
        }
    }

    protected void fillClusterLoginConfig(AbstractClusterLoginConfig<?> config, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("skip-identity", nodeName)) {
                config.setSkipIdentity(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("skip-endpoint", nodeName)) {
                config.setSkipEndpoint(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("skip-role", nodeName)) continue;
            config.setSkipRole(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
    }

    private void validateNetworkConfig() {
        if (this.occurrenceSet.contains("network") && this.occurrenceSet.stream().anyMatch(c -> this.matches("advanced-network", (String)c)) && this.config.getAdvancedNetworkConfig().isEnabled()) {
            throw new InvalidConfigurationException("Ambiguous configuration: cannot include both <network> and an enabled <advanced-network> element. Configure network using one of <network> or <advanced-network enabled=\"true\">.");
        }
    }
}

