/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersViewMetadata;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;

public final class HeartbeatOp
extends AbstractClusterOperation
implements Versioned {
    private MembersViewMetadata senderMembersViewMetadata;
    private UUID targetUuid;
    private long timestamp;
    private Collection<MemberInfo> suspectedMembers;

    public HeartbeatOp() {
    }

    public HeartbeatOp(MembersViewMetadata senderMembersViewMetadata, UUID targetUuid, long timestamp, Collection<MemberInfo> suspectedMembers) {
        this.senderMembersViewMetadata = senderMembersViewMetadata;
        this.targetUuid = targetUuid;
        this.timestamp = timestamp;
        this.suspectedMembers = suspectedMembers;
    }

    @Override
    public void run() {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterHeartbeatManager heartbeatManager = service.getClusterHeartbeatManager();
        heartbeatManager.handleHeartbeat(this.senderMembersViewMetadata, this.targetUuid, this.timestamp, this.suspectedMembers);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.senderMembersViewMetadata);
        UUIDSerializationUtil.writeUUID(out, this.targetUuid);
        out.writeLong(this.timestamp);
        SerializationUtil.writeCollection(this.suspectedMembers, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.senderMembersViewMetadata = (MembersViewMetadata)in.readObject();
        this.targetUuid = UUIDSerializationUtil.readUUID(in);
        this.timestamp = in.readLong();
        int suspectedMemberCount = in.readInt();
        this.suspectedMembers = new HashSet<MemberInfo>(suspectedMemberCount);
        for (int i = 0; i < suspectedMemberCount; ++i) {
            MemberInfo m = (MemberInfo)in.readObject();
            this.suspectedMembers.add(m);
        }
    }
}

