/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.impl.ConfigCheck;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.MemberVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;

public class JoinMessage
implements IdentifiedDataSerializable {
    protected byte packetVersion;
    protected int buildNumber;
    protected MemberVersion memberVersion;
    protected Address address;
    protected UUID uuid;
    protected boolean liteMember;
    protected ConfigCheck configCheck;
    protected Collection<Address> memberAddresses;
    protected int dataMemberCount;

    public JoinMessage() {
    }

    public JoinMessage(int buildNumber, MemberVersion memberVersion, Address address, UUID uuid, boolean liteMember, ConfigCheck configCheck) {
        this(buildNumber, memberVersion, address, uuid, liteMember, configCheck, Collections.emptySet(), 0);
    }

    public JoinMessage(int buildNumber, MemberVersion memberVersion, Address address, UUID uuid, boolean liteMember, ConfigCheck configCheck, Collection<Address> memberAddresses, int dataMemberCount) {
        this.packetVersion = (byte)4;
        this.buildNumber = buildNumber;
        this.memberVersion = memberVersion;
        this.address = address;
        this.uuid = uuid;
        this.liteMember = liteMember;
        this.configCheck = configCheck;
        this.memberAddresses = memberAddresses;
        this.dataMemberCount = dataMemberCount;
    }

    public byte getPacketVersion() {
        return this.packetVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public MemberVersion getMemberVersion() {
        return this.memberVersion;
    }

    public Address getAddress() {
        return this.address;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public ConfigCheck getConfigCheck() {
        return this.configCheck;
    }

    public int getMemberCount() {
        return this.memberAddresses != null ? this.memberAddresses.size() : 0;
    }

    public Collection<Address> getMemberAddresses() {
        return this.memberAddresses != null ? this.memberAddresses : Collections.emptySet();
    }

    public int getDataMemberCount() {
        return this.dataMemberCount;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.packetVersion = in.readByte();
        this.buildNumber = in.readInt();
        this.memberVersion = (MemberVersion)in.readObject();
        this.address = (Address)in.readObject();
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.configCheck = (ConfigCheck)in.readObject();
        this.liteMember = in.readBoolean();
        int memberCount = in.readInt();
        this.memberAddresses = new ArrayList<Address>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            Address address = (Address)in.readObject();
            this.memberAddresses.add(address);
        }
        this.dataMemberCount = in.readInt();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.packetVersion);
        out.writeInt(this.buildNumber);
        out.writeObject(this.memberVersion);
        out.writeObject(this.address);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeObject(this.configCheck);
        out.writeBoolean(this.liteMember);
        int memberCount = this.getMemberCount();
        out.writeInt(memberCount);
        if (memberCount > 0) {
            for (Address address : this.memberAddresses) {
                out.writeObject(address);
            }
        }
        out.writeInt(this.dataMemberCount);
    }

    public String toString() {
        return "JoinMessage{packetVersion=" + this.packetVersion + ", buildNumber=" + this.buildNumber + ", memberVersion=" + String.valueOf(this.memberVersion) + ", address=" + String.valueOf(this.address) + ", uuid='" + String.valueOf(this.uuid) + "', liteMember=" + this.liteMember + ", memberCount=" + this.getMemberCount() + ", dataMemberCount=" + this.dataMemberCount + "}";
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 26;
    }
}

