/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.util.StringUtil;

public enum HttpStatusCode {
    SC_100(100, "Continue"),
    SC_200(200, "OK"),
    SC_204(204, "No Content"),
    SC_400(400, "Bad Request"),
    SC_403(403, "Forbidden"),
    SC_404(404, "Not Found"),
    SC_409(409, "Conflict"),
    SC_500(500, "Internal Server Error"),
    SC_503(503, "Service Unavailable");

    final int code;
    final byte[] statusLine;

    private HttpStatusCode(int code, String statusLine) {
        this.code = code;
        this.statusLine = StringUtil.stringToBytes(String.format("HTTP/1.1 %d %s\r\n", code, statusLine));
    }
}

