/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.cp;

import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.cp.CPMapConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.annotation.PrivateApi;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CPSubsystemConfig {
    public static final int DEFAULT_SESSION_TTL_SECONDS = (int)TimeUnit.MINUTES.toSeconds(5L);
    public static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 5;
    public static final int MIN_GROUP_SIZE = 3;
    public static final int MAX_GROUP_SIZE = 7;
    public static final int DEFAULT_MISSING_CP_MEMBER_AUTO_REMOVAL_SECONDS = (int)TimeUnit.HOURS.toSeconds(4L);
    public static final String CP_BASE_DIR_DEFAULT = "cp-data";
    public static final int DEFAULT_DATA_LOAD_TIMEOUT_SECONDS = 120;
    public static final int DEFAULT_CP_MAP_LIMIT = 10;
    private int cpMemberCount;
    private int groupSize;
    private int sessionTimeToLiveSeconds = DEFAULT_SESSION_TTL_SECONDS;
    private int sessionHeartbeatIntervalSeconds = 5;
    private int missingCPMemberAutoRemovalSeconds = DEFAULT_MISSING_CP_MEMBER_AUTO_REMOVAL_SECONDS;
    private boolean failOnIndeterminateOperationState;
    private boolean persistenceEnabled;
    private File baseDir = new File("cp-data");
    private int dataLoadTimeoutSeconds = 120;
    private int cpMemberPriority;
    private RaftAlgorithmConfig raftAlgorithmConfig = new RaftAlgorithmConfig();
    private final Map<String, SemaphoreConfig> semaphoreConfigs = new ConcurrentHashMap<String, SemaphoreConfig>();
    private final Map<String, FencedLockConfig> lockConfigs = new ConcurrentHashMap<String, FencedLockConfig>();
    private final ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private Map<String, CPMapConfig> cpMapConfigs = new ConcurrentHashMap<String, CPMapConfig>();
    private int cpMapLimit = 10;

    public CPSubsystemConfig() {
    }

    public CPSubsystemConfig(CPSubsystemConfig config) {
        this.cpMemberCount = config.cpMemberCount;
        this.groupSize = config.groupSize;
        this.raftAlgorithmConfig = new RaftAlgorithmConfig(config.raftAlgorithmConfig);
        this.sessionTimeToLiveSeconds = config.sessionTimeToLiveSeconds;
        this.sessionHeartbeatIntervalSeconds = config.sessionHeartbeatIntervalSeconds;
        this.failOnIndeterminateOperationState = config.failOnIndeterminateOperationState;
        this.missingCPMemberAutoRemovalSeconds = config.missingCPMemberAutoRemovalSeconds;
        this.persistenceEnabled = config.persistenceEnabled;
        this.baseDir = config.baseDir;
        this.dataLoadTimeoutSeconds = config.dataLoadTimeoutSeconds;
        this.cpMemberPriority = config.cpMemberPriority;
        for (SemaphoreConfig semaphoreConfig : config.semaphoreConfigs.values()) {
            this.semaphoreConfigs.put(semaphoreConfig.getName(), new SemaphoreConfig(semaphoreConfig));
        }
        for (FencedLockConfig lockConfig : config.lockConfigs.values()) {
            this.lockConfigs.put(lockConfig.getName(), new FencedLockConfig(lockConfig));
        }
        for (CPMapConfig cpMapConfig : config.cpMapConfigs.values()) {
            this.cpMapConfigs.put(cpMapConfig.getName(), new CPMapConfig(cpMapConfig));
        }
        this.cpMapLimit = config.cpMapLimit;
    }

    public int getCPMemberCount() {
        return this.cpMemberCount;
    }

    public CPSubsystemConfig setCPMemberCount(int cpMemberCount) {
        Preconditions.checkTrue(cpMemberCount == 0 || cpMemberCount >= 3, "CP Subsystem must have at least 3 CP members");
        this.cpMemberCount = cpMemberCount;
        return this;
    }

    public int getGroupSize() {
        if (this.groupSize > 0 || this.cpMemberCount == 0) {
            return this.groupSize;
        }
        int groupSize = this.cpMemberCount;
        if (groupSize % 2 == 0) {
            --groupSize;
        }
        return Math.min(groupSize, 7);
    }

    @SuppressFBWarnings(value={"IM_BAD_CHECK_FOR_ODD"}, justification="It's obvious that groupSize is not negative.")
    public CPSubsystemConfig setGroupSize(int groupSize) {
        Preconditions.checkTrue(groupSize == 0 || groupSize >= 3 && groupSize <= 7 && groupSize % 2 == 1, "Group size must be an odd value between 3 and 7");
        this.groupSize = groupSize;
        return this;
    }

    public int getSessionTimeToLiveSeconds() {
        return this.sessionTimeToLiveSeconds;
    }

    public CPSubsystemConfig setSessionTimeToLiveSeconds(int sessionTimeToLiveSeconds) {
        Preconditions.checkPositive(sessionTimeToLiveSeconds, "Session TTL must be a positive value!");
        this.sessionTimeToLiveSeconds = sessionTimeToLiveSeconds;
        return this;
    }

    public int getSessionHeartbeatIntervalSeconds() {
        return this.sessionHeartbeatIntervalSeconds;
    }

    public CPSubsystemConfig setSessionHeartbeatIntervalSeconds(int sessionHeartbeatIntervalSeconds) {
        Preconditions.checkPositive(this.sessionTimeToLiveSeconds, "Session heartbeat interval must be a positive value!");
        this.sessionHeartbeatIntervalSeconds = sessionHeartbeatIntervalSeconds;
        return this;
    }

    public int getMissingCPMemberAutoRemovalSeconds() {
        return this.missingCPMemberAutoRemovalSeconds;
    }

    public CPSubsystemConfig setMissingCPMemberAutoRemovalSeconds(int missingCPMemberAutoRemovalSeconds) {
        Preconditions.checkTrue(missingCPMemberAutoRemovalSeconds >= 0, "missing cp member auto-removal seconds must be non-negative");
        this.missingCPMemberAutoRemovalSeconds = missingCPMemberAutoRemovalSeconds;
        return this;
    }

    public boolean isFailOnIndeterminateOperationState() {
        return this.failOnIndeterminateOperationState;
    }

    public CPSubsystemConfig setFailOnIndeterminateOperationState(boolean failOnIndeterminateOperationState) {
        this.failOnIndeterminateOperationState = failOnIndeterminateOperationState;
        return this;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public CPSubsystemConfig setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public CPSubsystemConfig setBaseDir(File baseDir) {
        Preconditions.checkNotNull(baseDir);
        this.baseDir = baseDir;
        return this;
    }

    public int getDataLoadTimeoutSeconds() {
        return this.dataLoadTimeoutSeconds;
    }

    public CPSubsystemConfig setDataLoadTimeoutSeconds(int dataLoadTimeoutSeconds) {
        Preconditions.checkPositive(dataLoadTimeoutSeconds, "data load timeout seconds must be positive");
        this.dataLoadTimeoutSeconds = dataLoadTimeoutSeconds;
        return this;
    }

    public CPSubsystemConfig setCPMemberPriority(int cpMemberPriority) {
        this.cpMemberPriority = cpMemberPriority;
        return this;
    }

    public int getCPMemberPriority() {
        return this.cpMemberPriority;
    }

    public RaftAlgorithmConfig getRaftAlgorithmConfig() {
        return this.raftAlgorithmConfig;
    }

    public CPSubsystemConfig setRaftAlgorithmConfig(RaftAlgorithmConfig raftAlgorithmConfig) {
        Preconditions.checkNotNull(raftAlgorithmConfig);
        this.raftAlgorithmConfig = raftAlgorithmConfig;
        return this;
    }

    public Map<String, SemaphoreConfig> getSemaphoreConfigs() {
        return this.semaphoreConfigs;
    }

    public SemaphoreConfig findSemaphoreConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.semaphoreConfigs, StringPartitioningStrategy.getBaseName(name));
    }

    public CPSubsystemConfig addSemaphoreConfig(SemaphoreConfig semaphoreConfig) {
        this.semaphoreConfigs.put(semaphoreConfig.getName(), semaphoreConfig);
        return this;
    }

    public CPSubsystemConfig setSemaphoreConfigs(Map<String, SemaphoreConfig> semaphoreConfigs) {
        this.semaphoreConfigs.clear();
        this.semaphoreConfigs.putAll(semaphoreConfigs);
        for (Map.Entry<String, SemaphoreConfig> entry : this.semaphoreConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, FencedLockConfig> getLockConfigs() {
        return this.lockConfigs;
    }

    public FencedLockConfig findLockConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.lockConfigs, StringPartitioningStrategy.getBaseName(name));
    }

    public CPSubsystemConfig addLockConfig(FencedLockConfig lockConfig) {
        this.lockConfigs.put(lockConfig.getName(), lockConfig);
        return this;
    }

    public CPSubsystemConfig setLockConfigs(Map<String, FencedLockConfig> lockConfigs) {
        this.lockConfigs.clear();
        this.lockConfigs.putAll(lockConfigs);
        for (Map.Entry<String, FencedLockConfig> entry : this.lockConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    @PrivateApi
    public CPSubsystemConfig setCpMapConfigs(Map<String, CPMapConfig> cpMapConfigs) {
        this.cpMapConfigs.clear();
        this.cpMapConfigs.putAll(cpMapConfigs);
        for (Map.Entry<String, CPMapConfig> entry : this.cpMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, CPMapConfig> getCpMapConfigs() {
        return this.cpMapConfigs;
    }

    public CPMapConfig findCPMapConfig(String name) {
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cpMapConfigs, StringPartitioningStrategy.getBaseName(name));
    }

    public CPSubsystemConfig addCPMapConfig(CPMapConfig cpMapConfig) {
        this.cpMapConfigs.put(cpMapConfig.getName(), cpMapConfig);
        return this;
    }

    public CPSubsystemConfig setCPMapConfigs(Map<String, CPMapConfig> cpMapConfigs) {
        this.cpMapConfigs.clear();
        this.cpMapConfigs.putAll(cpMapConfigs);
        for (Map.Entry<String, CPMapConfig> entry : this.cpMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public CPSubsystemConfig setCPMapLimit(int cpMapLimit) {
        Preconditions.checkPositive("cpMapLimit", cpMapLimit);
        this.cpMapLimit = cpMapLimit;
        return this;
    }

    public int getCPMapLimit() {
        return this.cpMapLimit;
    }

    @PrivateApi
    public CPSubsystemConfig setMapLimit(int cpMapLimit) {
        return this.setCPMapLimit(cpMapLimit);
    }

    public String toString() {
        return "CPSubsystemConfig{cpMemberCount=" + this.cpMemberCount + ", groupSize=" + this.groupSize + ", sessionTimeToLiveSeconds=" + this.sessionTimeToLiveSeconds + ", sessionHeartbeatIntervalSeconds=" + this.sessionHeartbeatIntervalSeconds + ", missingCPMemberAutoRemovalSeconds=" + this.missingCPMemberAutoRemovalSeconds + ", failOnIndeterminateOperationState=" + this.failOnIndeterminateOperationState + ", cpMemberPriority=" + this.cpMemberPriority + ", raftAlgorithmConfig=" + String.valueOf(this.raftAlgorithmConfig) + ", semaphoreConfigs=" + String.valueOf(this.semaphoreConfigs) + ", lockConfigs=" + String.valueOf(this.lockConfigs) + ", cpMapConfigs=" + String.valueOf(this.cpMapConfigs) + ", cpMapLimit=" + this.cpMapLimit + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPSubsystemConfig that = (CPSubsystemConfig)o;
        return this.cpMemberCount == that.cpMemberCount && this.groupSize == that.groupSize && this.sessionTimeToLiveSeconds == that.sessionTimeToLiveSeconds && this.sessionHeartbeatIntervalSeconds == that.sessionHeartbeatIntervalSeconds && this.missingCPMemberAutoRemovalSeconds == that.missingCPMemberAutoRemovalSeconds && this.failOnIndeterminateOperationState == that.failOnIndeterminateOperationState && this.persistenceEnabled == that.persistenceEnabled && this.dataLoadTimeoutSeconds == that.dataLoadTimeoutSeconds && this.cpMemberPriority == that.cpMemberPriority && this.cpMapLimit == that.cpMapLimit && Objects.equals(this.baseDir, that.baseDir) && Objects.equals(this.raftAlgorithmConfig, that.raftAlgorithmConfig) && Objects.equals(this.semaphoreConfigs, that.semaphoreConfigs) && Objects.equals(this.lockConfigs, that.lockConfigs) && Objects.equals(this.configPatternMatcher, that.configPatternMatcher) && Objects.equals(this.cpMapConfigs, that.cpMapConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.cpMemberCount, this.groupSize, this.sessionTimeToLiveSeconds, this.sessionHeartbeatIntervalSeconds, this.missingCPMemberAutoRemovalSeconds, this.failOnIndeterminateOperationState, this.persistenceEnabled, this.cpMemberPriority, this.baseDir, this.dataLoadTimeoutSeconds, this.raftAlgorithmConfig, this.semaphoreConfigs, this.lockConfigs, this.configPatternMatcher, this.cpMapConfigs, this.cpMapLimit);
    }
}

