/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.StringUtil;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoginModuleConfig {
    private String className;
    private LoginModuleUsage usage;
    private Properties properties = new Properties();

    public LoginModuleConfig() {
    }

    public LoginModuleConfig(String className, LoginModuleUsage usage) {
        this.className = className;
        this.usage = usage;
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LoginModuleUsage getUsage() {
        return this.usage;
    }

    public LoginModuleConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public LoginModuleConfig setUsage(LoginModuleUsage usage) {
        this.usage = usage;
        return this;
    }

    public LoginModuleConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public LoginModuleConfig setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public LoginModuleConfig setOrClear(@Nonnull String key, @Nullable String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        } else {
            this.properties.remove(key);
        }
        return this;
    }

    public String toString() {
        return "LoginModuleConfig{className='" + this.className + "', usage=" + String.valueOf((Object)this.usage) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoginModuleConfig)) {
            return false;
        }
        LoginModuleConfig that = (LoginModuleConfig)o;
        return Objects.equals(this.className, that.className) && this.usage == that.usage && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.usage, this.properties});
    }

    public static enum LoginModuleUsage {
        REQUIRED,
        REQUISITE,
        SUFFICIENT,
        OPTIONAL;


        public static LoginModuleUsage get(String v) {
            try {
                return LoginModuleUsage.valueOf(StringUtil.upperCaseInternal(v));
            }
            catch (Exception exception) {
                return REQUIRED;
            }
        }
    }
}

