/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class LocalDeviceConfig
implements DeviceConfig {
    public static final String DEFAULT_DEVICE_NAME = "default-tiered-store-device";
    public static final String DEFAULT_DEVICE_BASE_DIR = "tiered-store";
    public static final int DEFAULT_BLOCK_SIZE_IN_BYTES = 4096;
    public static final int DEFAULT_READ_IO_THREAD_COUNT = 4;
    public static final int DEFAULT_WRITE_IO_THREAD_COUNT = 4;
    public static final Capacity DEFAULT_CAPACITY = Capacity.of(256L, MemoryUnit.GIGABYTES);
    private String name = "default-tiered-store-device";
    private File baseDir = new File("tiered-store").getAbsoluteFile();
    private Capacity capacity = DEFAULT_CAPACITY;
    private int blockSize = 4096;
    private int readIOThreadCount = 4;
    private int writeIOThreadCount = 4;

    public LocalDeviceConfig() {
    }

    public LocalDeviceConfig(LocalDeviceConfig localDeviceConfig) {
        this.name = localDeviceConfig.getName();
        this.baseDir = localDeviceConfig.getBaseDir();
        this.capacity = localDeviceConfig.getCapacity();
        this.blockSize = localDeviceConfig.getBlockSize();
        this.readIOThreadCount = localDeviceConfig.getReadIOThreadCount();
        this.writeIOThreadCount = localDeviceConfig.getWriteIOThreadCount();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDeviceConfig setName(@Nonnull String name) {
        this.name = Preconditions.checkNotNull(name, "Device name must not be null");
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public LocalDeviceConfig setBaseDir(@Nonnull File baseDir) {
        this.baseDir = Preconditions.checkNotNull(baseDir, "Base directory must not be null");
        return this;
    }

    @Override
    public Capacity getCapacity() {
        return this.capacity;
    }

    public LocalDeviceConfig setCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public LocalDeviceConfig setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public int getReadIOThreadCount() {
        return this.readIOThreadCount;
    }

    public LocalDeviceConfig setReadIOThreadCount(int readIOThreadCount) {
        this.readIOThreadCount = readIOThreadCount;
        return this;
    }

    public int getWriteIOThreadCount() {
        return this.writeIOThreadCount;
    }

    public LocalDeviceConfig setWriteIOThreadCount(int writeIOThreadCount) {
        this.writeIOThreadCount = writeIOThreadCount;
        return this;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDeviceConfig that = (LocalDeviceConfig)o;
        if (this.blockSize != that.blockSize) {
            return false;
        }
        if (this.readIOThreadCount != that.readIOThreadCount) {
            return false;
        }
        if (this.writeIOThreadCount != that.writeIOThreadCount) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.baseDir, that.baseDir)) {
            return false;
        }
        return Objects.equals(this.capacity, that.capacity);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.baseDir != null ? this.baseDir.hashCode() : 0);
        result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
        result = 31 * result + this.blockSize;
        result = 31 * result + this.readIOThreadCount;
        result = 31 * result + this.writeIOThreadCount;
        return result;
    }

    public String toString() {
        return "LocalDeviceConfig{name='" + this.name + "', baseDir=" + String.valueOf(this.baseDir) + ", capacity=" + String.valueOf(this.capacity) + ", blockSize=" + this.blockSize + ", readIOThreadCount=" + this.readIOThreadCount + ", writeIOThreadCount=" + this.writeIOThreadCount + "}";
    }
}

