/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public class CompactSerializationConfig {
    final Map<String, TriTuple<Class, String, CompactSerializer>> typeNameToRegistration;
    final Map<Class, TriTuple<Class, String, CompactSerializer>> classToRegistration;
    final List<String> serializerClassNames;
    final List<String> compactSerializableClassNames;

    public CompactSerializationConfig() {
        this.typeNameToRegistration = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>();
        this.classToRegistration = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>();
        this.serializerClassNames = new CopyOnWriteArrayList<String>();
        this.compactSerializableClassNames = new CopyOnWriteArrayList<String>();
    }

    public CompactSerializationConfig(CompactSerializationConfig config) {
        this.typeNameToRegistration = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>(config.typeNameToRegistration);
        this.classToRegistration = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>(config.classToRegistration);
        this.serializerClassNames = new CopyOnWriteArrayList<String>(config.serializerClassNames);
        this.compactSerializableClassNames = new CopyOnWriteArrayList<String>(config.compactSerializableClassNames);
    }

    public <T> CompactSerializationConfig addClass(@Nonnull Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        this.register0(clazz, clazz.getName(), null);
        return this;
    }

    public CompactSerializationConfig setClasses(Class<?> ... classes) {
        this.clearClassRegistrations();
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public <T> CompactSerializationConfig addSerializer(@Nonnull CompactSerializer<T> serializer) {
        Preconditions.checkNotNull(serializer, "Serializer cannot be null");
        this.register0(serializer.getCompactClass(), serializer.getTypeName(), serializer);
        return this;
    }

    public CompactSerializationConfig setSerializers(CompactSerializer<?> ... serializers) {
        this.clearSerializerRegistrations();
        for (CompactSerializer<?> serializer : serializers) {
            this.addSerializer(serializer);
        }
        return this;
    }

    private void register0(Class clazz, String typeName, CompactSerializer explicitSerializer) {
        TriTuple<Class, String, CompactSerializer> registration = TriTuple.of(clazz, typeName, explicitSerializer);
        TriTuple<Class, String, CompactSerializer> oldRegistration = this.typeNameToRegistration.putIfAbsent(typeName, registration);
        if (oldRegistration != null) {
            throw new InvalidConfigurationException("Duplicate serializer registrations are found for the type name '" + typeName + "'. Make sure only one Compact serializer is registered for the same type name. Existing serializer: " + String.valueOf(oldRegistration.element3) + ", new serializer: " + String.valueOf(registration.element3));
        }
        oldRegistration = this.classToRegistration.putIfAbsent(clazz, registration);
        if (oldRegistration != null) {
            throw new InvalidConfigurationException("Duplicate serializer registrations are found for the class '" + String.valueOf(clazz) + "'. Make sure only one Compact serializer is registered for the same class. Existing serializer: " + String.valueOf(oldRegistration.element3) + ", new serializer: " + String.valueOf(registration.element3));
        }
    }

    private void clearClassRegistrations() {
        this.typeNameToRegistration.entrySet().removeIf(entry -> ((TriTuple)entry.getValue()).element3 == null);
        this.classToRegistration.entrySet().removeIf(entry -> ((TriTuple)entry.getValue()).element3 == null);
    }

    private void clearSerializerRegistrations() {
        this.typeNameToRegistration.entrySet().removeIf(entry -> ((TriTuple)entry.getValue()).element3 != null);
        this.classToRegistration.entrySet().removeIf(entry -> ((TriTuple)entry.getValue()).element3 != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactSerializationConfig that = (CompactSerializationConfig)o;
        return Objects.equals(this.typeNameToRegistration, that.typeNameToRegistration) && Objects.equals(this.classToRegistration, that.classToRegistration) && Objects.equals(this.serializerClassNames, that.serializerClassNames) && Objects.equals(this.compactSerializableClassNames, that.compactSerializableClassNames);
    }

    public int hashCode() {
        return Objects.hash(this.typeNameToRegistration, this.classToRegistration, this.serializerClassNames, this.compactSerializableClassNames);
    }
}

