/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.SubsetMembers;
import com.hazelcast.client.impl.proxy.ClientClusterProxy;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.impl.MemberListSnapshot;
import com.hazelcast.client.util.ClientConnectivityLogger;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ClientClusterServiceImpl
implements ClientClusterService {
    public static final int INITIAL_MEMBER_LIST_VERSION = -1;
    protected final AtomicReference<Version> clusterVersion = new AtomicReference<Version>(Version.UNKNOWN);
    protected final AtomicReference<MemberListSnapshot> memberListSnapshot = new AtomicReference<MemberListSnapshot>(new MemberListSnapshot(-1, new LinkedHashMap<UUID, Member>(), null));
    protected volatile UUID clusterId;
    protected final HazelcastClientInstanceImpl clientInstance;
    private final ClientConnectivityLogger connectivityLogger;
    private final ConcurrentMap<UUID, MembershipListener> listeners = new ConcurrentHashMap<UUID, MembershipListener>();
    private final ILogger logger;
    private final Object clusterViewLock = new Object();

    public ClientClusterServiceImpl(HazelcastClientInstanceImpl client) {
        this.logger = client.getLoggingService().getLogger(ClientClusterService.class);
        this.clientInstance = client;
        this.connectivityLogger = new ClientConnectivityLogger(client.getLoggingService(), client.getTaskScheduler(), client.getProperties());
    }

    @Override
    public UUID getClusterId() {
        return this.clusterId;
    }

    @Override
    public void onClusterConnect(UUID newClusterId) {
        this.clusterId = newClusterId;
    }

    @Override
    public Cluster getCluster() {
        return new ClientClusterProxy(this);
    }

    @Override
    public Member getMember(@Nonnull UUID uuid) {
        Preconditions.checkNotNull(uuid, "UUID must not be null");
        return this.memberListSnapshot.get().members().get(uuid);
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.memberListSnapshot.get().members().values();
    }

    @Override
    @Nonnull
    public Collection<Member> getEffectiveMemberList() {
        MemberListSnapshot snapshot = this.memberListSnapshot.get();
        if (snapshot.version() == -1) {
            return Collections.emptyList();
        }
        if (this.clientInstance.getConnectionManager().getRoutingMode() == RoutingMode.SINGLE_MEMBER) {
            UUID activeConnection = this.clientInstance.getConnectionManager().getActiveConnections().stream().findFirst().map(Connection::getRemoteUuid).orElse(null);
            if (activeConnection == null || !snapshot.members().containsKey(activeConnection)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(snapshot.members().get(activeConnection));
        }
        return snapshot.members().values();
    }

    @Override
    public Collection<Member> getMembers(@Nonnull MemberSelector selector) {
        Preconditions.checkNotNull(selector, "selector must not be null");
        return new MemberSelectingCollection<Member>(this.getMemberList(), selector);
    }

    @Override
    public Member getMasterMember() {
        Collection<Member> memberList = this.getMemberList();
        Iterator<Member> iterator = memberList.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public UUID addMembershipListener(@Nonnull MembershipListener listener) {
        Preconditions.checkNotNull(listener, "Listener can't be null");
        Object object = this.clusterViewLock;
        synchronized (object) {
            UUID id = this.addMembershipListenerWithoutInit(listener);
            if (listener instanceof InitialMembershipListener) {
                InitialMembershipListener membershipListener = (InitialMembershipListener)listener;
                Cluster cluster = this.getCluster();
                Collection<Member> members = this.memberListSnapshot.get().members().values();
                if (!members.isEmpty()) {
                    InitialMembershipEvent event = new InitialMembershipEvent(cluster, this.toUnmodifiableHasSet(members));
                    membershipListener.init(event);
                }
            }
            return id;
        }
    }

    private UUID addMembershipListenerWithoutInit(@Nonnull MembershipListener listener) {
        UUID id = UuidUtil.newUnsecureUUID();
        this.listeners.put(id, listener);
        return id;
    }

    @Override
    public boolean removeMembershipListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        return this.listeners.remove(registrationId) != null;
    }

    @Override
    public void start(Collection<EventListener> configuredListeners) {
        configuredListeners.stream().filter(MembershipListener.class::isInstance).forEach(listener -> this.addMembershipListener((MembershipListener)listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClusterConnect() {
        Object object = this.clusterViewLock;
        synchronized (object) {
            MemberListSnapshot clusterViewSnapshot;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the member list version ");
            }
            if ((clusterViewSnapshot = this.memberListSnapshot.get()).version() != -1) {
                this.memberListSnapshot.set(new MemberListSnapshot(0, clusterViewSnapshot.members(), clusterViewSnapshot.clusterUuid()));
                this.submitConnectivityLoggingTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTryToConnectNextCluster() {
        Object object = this.clusterViewLock;
        synchronized (object) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the cluster snapshot");
            }
            MemberListSnapshot clusterViewSnapshot = this.memberListSnapshot.get();
            this.memberListSnapshot.set(new MemberListSnapshot(-1, clusterViewSnapshot.members(), clusterViewSnapshot.clusterUuid()));
        }
    }

    @Override
    public int getMemberListVersion() {
        return this.memberListSnapshot.get().version();
    }

    private void applyInitialState(int version, Collection<MemberInfo> memberInfos, UUID clusterUuid) {
        MemberListSnapshot snapshot = this.createSnapshot(version, memberInfos, clusterUuid);
        this.memberListSnapshot.set(snapshot);
        this.logger.info(ClientClusterServiceImpl.membersString(snapshot));
        this.submitConnectivityLoggingTask();
        Set<Member> members = this.toUnmodifiableHasSet(snapshot.members().values());
        InitialMembershipEvent event = new InitialMembershipEvent(this.getCluster(), members);
        for (MembershipListener listener : this.listeners.values()) {
            if (!(listener instanceof InitialMembershipListener)) continue;
            InitialMembershipListener membershipListener = (InitialMembershipListener)listener;
            membershipListener.init(event);
        }
    }

    private MemberListSnapshot createSnapshot(int memberListVersion, Collection<MemberInfo> memberInfos, UUID clusterUuid) {
        LinkedHashMap<UUID, Member> newMembers = new LinkedHashMap<UUID, Member>();
        for (MemberInfo memberInfo : memberInfos) {
            Map<EndpointQualifier, Address> addressMap = memberInfo.getAddressMap();
            MemberImpl.Builder memberBuilder = addressMap == null || addressMap.isEmpty() ? new MemberImpl.Builder(memberInfo.getAddress()) : new MemberImpl.Builder(addressMap).address(addressMap.getOrDefault(EndpointQualifier.CLIENT, addressMap.get(EndpointQualifier.MEMBER)));
            memberBuilder.version(memberInfo.getVersion()).uuid(memberInfo.getUuid()).attributes(memberInfo.getAttributes()).liteMember(memberInfo.isLiteMember()).memberListJoinVersion(memberInfo.getMemberListJoinVersion());
            newMembers.put(memberInfo.getUuid(), memberBuilder.build());
        }
        return new MemberListSnapshot(memberListVersion, newMembers, clusterUuid);
    }

    private Set<Member> toUnmodifiableHasSet(Collection<Member> members) {
        return Set.copyOf(members);
    }

    private List<MembershipEvent> detectMembershipEvents(Collection<Member> prevMembers, Set<Member> currentMembers, UUID clusterUuid) {
        MemberListSnapshot memberListSnapshot;
        LinkedList<Member> newMembers = new LinkedList<Member>();
        HashSet<Member> deadMembers = new HashSet<Member>(prevMembers);
        if (clusterUuid.equals(this.memberListSnapshot.get().clusterUuid())) {
            for (Member member : currentMembers) {
                if (deadMembers.remove(member)) continue;
                newMembers.add(member);
            }
        } else {
            newMembers.addAll(currentMembers);
        }
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        for (Member member : deadMembers) {
            events.add(new MembershipEvent(this.getCluster(), member, 2, currentMembers));
        }
        for (Member member : newMembers) {
            events.add(new MembershipEvent(this.getCluster(), member, 1, currentMembers));
        }
        if (!events.isEmpty() && !(memberListSnapshot = this.memberListSnapshot.get()).members().values().isEmpty()) {
            this.logger.info(ClientClusterServiceImpl.membersString(memberListSnapshot));
        }
        return events;
    }

    private static String membersString(MemberListSnapshot snapshot) {
        Collection<Member> members = snapshot.members().values();
        return "Members [%s] {%n%s%n}%n".formatted(members.size(), members.stream().map(member -> "\t" + String.valueOf(member)).collect(Collectors.joining(System.lineSeparator())));
    }

    @Override
    public SubsetMembers getSubsetMembers() {
        return SubsetMembers.NOOP;
    }

    @Override
    @Nonnull
    public Version getClusterVersion() {
        return this.clusterVersion.get();
    }

    @Override
    public void updateOnAuth(UUID clusterUuid, UUID authMemberUuid, Map<String, String> keyValuePairs) {
        String clusterVersionStr = keyValuePairs.get("clusterVersion");
        if (clusterVersionStr != null) {
            this.clusterVersion.set(Version.of(clusterVersionStr));
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Cluster version is not received during authentication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMembersViewEvent(int memberListVersion, Collection<MemberInfo> memberInfos, UUID clusterUuid) {
        MemberListSnapshot clusterViewSnapshot;
        if (this.logger.isFinestEnabled()) {
            MemberListSnapshot snapshot = this.createSnapshot(memberListVersion, memberInfos, clusterUuid);
            this.logger.finest("Handling new snapshot with membership version: %s, membersString %s", memberListVersion, ClientClusterServiceImpl.membersString(snapshot));
        }
        if ((clusterViewSnapshot = this.memberListSnapshot.get()).version() == -1) {
            Object object = this.clusterViewLock;
            synchronized (object) {
                clusterViewSnapshot = this.memberListSnapshot.get();
                if (clusterViewSnapshot.version() == -1) {
                    this.applyInitialState(memberListVersion, memberInfos, clusterUuid);
                    return;
                }
            }
        }
        List<MembershipEvent> events = Collections.emptyList();
        if (memberListVersion > clusterViewSnapshot.version()) {
            Object object = this.clusterViewLock;
            synchronized (object) {
                clusterViewSnapshot = this.memberListSnapshot.get();
                if (memberListVersion > clusterViewSnapshot.version()) {
                    Collection<Member> prevMembers = clusterViewSnapshot.members().values();
                    UUID previousClusterUuid = clusterViewSnapshot.clusterUuid();
                    MemberListSnapshot snapshot = this.createSnapshot(memberListVersion, memberInfos, clusterUuid);
                    this.memberListSnapshot.set(snapshot);
                    Set<Member> currentMembers = this.toUnmodifiableHasSet(snapshot.members().values());
                    events = this.detectMembershipEvents(prevMembers, currentMembers, previousClusterUuid);
                    if (!events.isEmpty()) {
                        this.submitConnectivityLoggingTask();
                    }
                }
            }
        }
        this.fireEvents(events);
    }

    @Override
    public void handleClusterVersionEvent(Version version) {
        this.clusterVersion.set(version);
    }

    private void fireEvents(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            for (MembershipListener listener : this.listeners.values()) {
                if (event.getEventType() == 1) {
                    listener.memberAdded(event);
                    continue;
                }
                listener.memberRemoved(event);
            }
        }
    }

    private void submitConnectivityLoggingTask() {
        this.connectivityLogger.submitLoggingTask(this.getEffectiveMemberList(), this.getMemberList());
    }

    @Override
    public void terminateClientConnectivityLogging() {
        this.connectivityLogger.terminate();
    }
}

