/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.TpcToken;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AuthenticationMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCodec.RequestParameters> {
    public AuthenticationMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientAuthenticationCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCodec.RequestParameters parameters = ClientAuthenticationCodec.decodeRequest(clientMessage);
        assert (parameters.uuid != null);
        this.clientUuid = parameters.uuid;
        this.clusterName = parameters.clusterName;
        this.credentials = new UsernamePasswordCredentials(parameters.username, parameters.password);
        this.clientSerializationVersion = parameters.serializationVersion;
        this.clientVersion = parameters.clientHazelcastVersion;
        this.clientName = parameters.clientName;
        this.labels = Set.copyOf(parameters.labels);
        this.routingMode = (byte)(parameters.isRoutingModeExists ? (int)parameters.routingMode : -1);
        this.cpDirectToLeaderRouting = parameters.isCpDirectToLeaderRoutingExists && parameters.cpDirectToLeaderRouting;
        return parameters;
    }

    @Override
    protected ClientMessage encodeAuthenticationResponse(byte status, Address thisAddress, UUID uuid, byte serializationVersion, String serverVersion, int partitionCount, UUID clusterId, boolean clientFailoverSupported, List<Integer> tpcPorts, byte[] tpcToken, int memberListVersion, List<MemberInfo> members, int partitionsVersion, List<Map.Entry<UUID, List<Integer>>> partitions, Map<String, String> keyValuePairs) {
        return ClientAuthenticationCodec.encodeResponse(status, thisAddress, uuid, serializationVersion, serverVersion, partitionCount, clusterId, clientFailoverSupported, tpcPorts, tpcToken, memberListVersion, members, partitionsVersion, partitions, keyValuePairs);
    }

    @Override
    protected void setTpcTokenToEndpoint() {
        if (!this.nodeEngine.getTpcServerBootstrap().isEnabled()) {
            return;
        }
        TpcToken token = new TpcToken();
        this.endpoint.setTpcToken(token);
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCodec.RequestParameters)this.parameters).clientType;
    }
}

