/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddReliableTopicConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1772800;
    public static final int RESPONSE_MESSAGE_TYPE = 1772801;
    private static final int REQUEST_READ_BATCH_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 21;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddReliableTopicConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, @Nullable Collection<ListenerConfigHolder> listenerConfigs, int readBatchSize, boolean statisticsEnabled, String topicOverloadPolicy, @Nullable Data executor, @Nullable String userCodeNamespace) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddReliableTopicConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772800);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, readBatchSize);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 20, statisticsEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        StringCodec.encode(clientMessage, topicOverloadPolicy);
        DataCodec.encodeNullable(clientMessage, executor);
        CodecUtil.encodeNullable(clientMessage, userCodeNamespace, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.readBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 20);
        request.name = StringCodec.decode(iterator);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.topicOverloadPolicy = StringCodec.decode(iterator);
        request.executor = DataCodec.decodeNullable(iterator);
        if (iterator.hasNext()) {
            request.userCodeNamespace = CodecUtil.decodeNullable(iterator, StringCodec::decode);
            request.isUserCodeNamespaceExists = true;
        } else {
            request.isUserCodeNamespaceExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772801);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
        public int readBatchSize;
        public boolean statisticsEnabled;
        public String topicOverloadPolicy;
        @Nullable
        public Data executor;
        @Nullable
        public String userCodeNamespace;
        public boolean isUserCodeNamespaceExists;
    }
}

