/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AttributeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DataPersistenceConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EventJournalConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EvictionConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.HotRestartConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.IndexConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MapStoreConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MerkleTreeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.NearCacheConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.PartitioningAttributeConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.QueryCacheConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.TieredStoreConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanReplicationRefCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.MapStoreConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.NearCacheConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueryCacheConfigHolder;
import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1772544;
    public static final int RESPONSE_MESSAGE_TYPE = 1772545;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 24;
    private static final int REQUEST_MAX_IDLE_SECONDS_FIELD_OFFSET = 28;
    private static final int REQUEST_READ_BACKUP_DATA_FIELD_OFFSET = 32;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 33;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 37;
    private static final int REQUEST_METADATA_POLICY_FIELD_OFFSET = 38;
    private static final int REQUEST_PER_ENTRY_STATS_ENABLED_FIELD_OFFSET = 42;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 43;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int backupCount, int asyncBackupCount, int timeToLiveSeconds, int maxIdleSeconds, @Nullable EvictionConfigHolder evictionConfig, boolean readBackupData, String cacheDeserializedValues, String mergePolicy, int mergeBatchSize, String inMemoryFormat, @Nullable Collection<ListenerConfigHolder> listenerConfigs, @Nullable Collection<ListenerConfigHolder> partitionLostListenerConfigs, boolean statisticsEnabled, @Nullable String splitBrainProtectionName, @Nullable MapStoreConfigHolder mapStoreConfig, @Nullable NearCacheConfigHolder nearCacheConfig, @Nullable WanReplicationRef wanReplicationRef, @Nullable Collection<IndexConfig> indexConfigs, @Nullable Collection<AttributeConfig> attributeConfigs, @Nullable Collection<QueryCacheConfigHolder> queryCacheConfigs, @Nullable String partitioningStrategyClassName, @Nullable Data partitioningStrategyImplementation, @Nullable HotRestartConfig hotRestartConfig, @Nullable EventJournalConfig eventJournalConfig, @Nullable MerkleTreeConfig merkleTreeConfig, int metadataPolicy, boolean perEntryStatsEnabled, DataPersistenceConfig dataPersistenceConfig, TieredStoreConfig tieredStoreConfig, @Nullable Collection<PartitioningAttributeConfig> partitioningAttributeConfigs, @Nullable String userCodeNamespace) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[43], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772544);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, maxIdleSeconds);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 32, readBackupData);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, mergeBatchSize);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 37, statisticsEnabled);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 38, metadataPolicy);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 42, perEntryStatsEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, evictionConfig, EvictionConfigHolderCodec::encode);
        StringCodec.encode(clientMessage, cacheDeserializedValues);
        StringCodec.encode(clientMessage, mergePolicy);
        StringCodec.encode(clientMessage, inMemoryFormat);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, partitionLostListenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfig, MapStoreConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, nearCacheConfig, NearCacheConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, wanReplicationRef, WanReplicationRefCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, indexConfigs, IndexConfigCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, attributeConfigs, AttributeConfigCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, queryCacheConfigs, QueryCacheConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, partitioningStrategyClassName, StringCodec::encode);
        DataCodec.encodeNullable(clientMessage, partitioningStrategyImplementation);
        CodecUtil.encodeNullable(clientMessage, hotRestartConfig, HotRestartConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, eventJournalConfig, EventJournalConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, merkleTreeConfig, MerkleTreeConfigCodec::encode);
        DataPersistenceConfigCodec.encode(clientMessage, dataPersistenceConfig);
        TieredStoreConfigCodec.encode(clientMessage, tieredStoreConfig);
        ListMultiFrameCodec.encodeNullable(clientMessage, partitioningAttributeConfigs, PartitioningAttributeConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, userCodeNamespace, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.readBackupData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 32);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 37);
        request.metadataPolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 38);
        if (initialFrame.content.length >= 43) {
            request.perEntryStatsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 42);
            request.isPerEntryStatsEnabledExists = true;
        } else {
            request.isPerEntryStatsEnabledExists = false;
        }
        request.name = StringCodec.decode(iterator);
        request.evictionConfig = CodecUtil.decodeNullable(iterator, EvictionConfigHolderCodec::decode);
        request.cacheDeserializedValues = StringCodec.decode(iterator);
        request.mergePolicy = StringCodec.decode(iterator);
        request.inMemoryFormat = StringCodec.decode(iterator);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.partitionLostListenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mapStoreConfig = CodecUtil.decodeNullable(iterator, MapStoreConfigHolderCodec::decode);
        request.nearCacheConfig = CodecUtil.decodeNullable(iterator, NearCacheConfigHolderCodec::decode);
        request.wanReplicationRef = CodecUtil.decodeNullable(iterator, WanReplicationRefCodec::decode);
        request.indexConfigs = ListMultiFrameCodec.decodeNullable(iterator, IndexConfigCodec::decode);
        request.attributeConfigs = ListMultiFrameCodec.decodeNullable(iterator, AttributeConfigCodec::decode);
        request.queryCacheConfigs = ListMultiFrameCodec.decodeNullable(iterator, QueryCacheConfigHolderCodec::decode);
        request.partitioningStrategyClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.partitioningStrategyImplementation = DataCodec.decodeNullable(iterator);
        request.hotRestartConfig = CodecUtil.decodeNullable(iterator, HotRestartConfigCodec::decode);
        request.eventJournalConfig = CodecUtil.decodeNullable(iterator, EventJournalConfigCodec::decode);
        request.merkleTreeConfig = CodecUtil.decodeNullable(iterator, MerkleTreeConfigCodec::decode);
        if (iterator.hasNext()) {
            request.dataPersistenceConfig = DataPersistenceConfigCodec.decode(iterator);
            request.isDataPersistenceConfigExists = true;
        } else {
            request.isDataPersistenceConfigExists = false;
        }
        if (iterator.hasNext()) {
            request.tieredStoreConfig = TieredStoreConfigCodec.decode(iterator);
            request.isTieredStoreConfigExists = true;
        } else {
            request.isTieredStoreConfigExists = false;
        }
        if (iterator.hasNext()) {
            request.partitioningAttributeConfigs = ListMultiFrameCodec.decodeNullable(iterator, PartitioningAttributeConfigCodec::decode);
            request.isPartitioningAttributeConfigsExists = true;
        } else {
            request.isPartitioningAttributeConfigsExists = false;
        }
        if (iterator.hasNext()) {
            request.userCodeNamespace = CodecUtil.decodeNullable(iterator, StringCodec::decode);
            request.isUserCodeNamespaceExists = true;
        } else {
            request.isUserCodeNamespaceExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772545);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int backupCount;
        public int asyncBackupCount;
        public int timeToLiveSeconds;
        public int maxIdleSeconds;
        @Nullable
        public EvictionConfigHolder evictionConfig;
        public boolean readBackupData;
        public String cacheDeserializedValues;
        public String mergePolicy;
        public int mergeBatchSize;
        public String inMemoryFormat;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
        @Nullable
        public List<ListenerConfigHolder> partitionLostListenerConfigs;
        public boolean statisticsEnabled;
        @Nullable
        public String splitBrainProtectionName;
        @Nullable
        public MapStoreConfigHolder mapStoreConfig;
        @Nullable
        public NearCacheConfigHolder nearCacheConfig;
        @Nullable
        public WanReplicationRef wanReplicationRef;
        @Nullable
        public List<IndexConfig> indexConfigs;
        @Nullable
        public List<AttributeConfig> attributeConfigs;
        @Nullable
        public List<QueryCacheConfigHolder> queryCacheConfigs;
        @Nullable
        public String partitioningStrategyClassName;
        @Nullable
        public Data partitioningStrategyImplementation;
        @Nullable
        public HotRestartConfig hotRestartConfig;
        @Nullable
        public EventJournalConfig eventJournalConfig;
        @Nullable
        public MerkleTreeConfig merkleTreeConfig;
        public int metadataPolicy;
        public boolean perEntryStatsEnabled;
        public DataPersistenceConfig dataPersistenceConfig;
        public TieredStoreConfig tieredStoreConfig;
        @Nullable
        public List<PartitioningAttributeConfig> partitioningAttributeConfigs;
        @Nullable
        public String userCodeNamespace;
        public boolean isPerEntryStatsEnabledExists;
        public boolean isDataPersistenceConfigExists;
        public boolean isTieredStoreConfigExists;
        public boolean isPartitioningAttributeConfigsExists;
        public boolean isUserCodeNamespaceExists;
    }
}

