/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.internal.services.ClientAwareService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ClientLifecycleMonitor
implements Runnable {
    private final long checkMillis;
    private final long timeoutMillis;
    private final ClientEndpointManager clientEndpointManager;
    private final ExecutionService executionService;
    private final NodeEngine nodeEngine;
    private final ClientEngineImpl clientEngine;
    private final ILogger logger;
    private final Map<UUID, Long> lastLiveTime = new ConcurrentHashMap<UUID, Long>();

    ClientLifecycleMonitor(ClientEndpointManager clientEndpointManager, ClientEngineImpl clientEngine, ILogger logger, NodeEngine nodeEngine, ExecutionService executionService, HazelcastProperties hazelcastProperties) {
        this.clientEndpointManager = clientEndpointManager;
        this.logger = logger;
        this.executionService = executionService;
        this.nodeEngine = nodeEngine;
        this.clientEngine = clientEngine;
        this.checkMillis = hazelcastProperties.getPositiveMillisOrDefault(ClusterProperty.CLIENT_CLEANUP_PERIOD);
        this.timeoutMillis = hazelcastProperties.getSeconds(ClusterProperty.CLIENT_CLEANUP_TIMEOUT);
    }

    public void start() {
        this.executionService.scheduleWithRepetition(this, this.checkMillis, this.checkMillis, TimeUnit.MILLISECONDS);
    }

    void addClientToMonitor(UUID uuid) {
        this.lastLiveTime.put(uuid, System.currentTimeMillis());
    }

    @Override
    public void run() {
        Set<UUID> allClients = null;
        Set<UUID> localClients = this.clientEndpointManager.getLocalClientUuids();
        for (Map.Entry<UUID, Long> entry : this.lastLiveTime.entrySet()) {
            UUID clientUuid = entry.getKey();
            if (localClients.contains(clientUuid)) {
                this.lastLiveTime.put(clientUuid, System.currentTimeMillis());
                continue;
            }
            long millisSinceLastLive = System.currentTimeMillis() - entry.getValue();
            if (millisSinceLastLive <= this.timeoutMillis) continue;
            if (allClients == null) {
                allClients = this.clientEngine.getClientsInCluster().keySet();
            }
            if (allClients.contains(clientUuid)) {
                this.lastLiveTime.put(clientUuid, System.currentTimeMillis());
                continue;
            }
            this.logger.warning("No connection left to client cluster wide " + String.valueOf(entry.getKey()) + " for " + millisSinceLastLive + " millis, cleaning resources of the client");
            this.lastLiveTime.remove(entry.getKey(), entry.getValue());
            Collection<ClientAwareService> services = this.nodeEngine.getServices(ClientAwareService.class);
            for (ClientAwareService service : services) {
                service.clientDisconnected(clientUuid);
            }
        }
    }
}

