/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.nio.channels.CancelledKeyException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractListenerService {
    protected static final HazelcastProperty PUSH_PERIOD_IN_SECONDS = new HazelcastProperty("hazelcast.client.internal.push.period.seconds", 30, TimeUnit.SECONDS);
    protected final Map<ClientEndpoint, Long> clientListeningEndpoints = new ConcurrentHashMap<ClientEndpoint, Long>();
    protected final AtomicBoolean pushScheduled = new AtomicBoolean();
    protected final NodeEngine nodeEngine;
    protected final String executorName;
    protected final ILogger logger;

    public AbstractListenerService(NodeEngine nodeEngine, ILogger logger, String executorName) {
        this.logger = logger;
        this.nodeEngine = nodeEngine;
        this.executorName = executorName;
    }

    protected void schedulePeriodicPush() {
        ExecutionService executor = this.nodeEngine.getExecutionService();
        int pushPeriodInSeconds = this.nodeEngine.getProperties().getSeconds(PUSH_PERIOD_IN_SECONDS);
        this.logger.finest("Scheduling periodic data push, on executor %s with period: %,d", this.executorName, pushPeriodInSeconds);
        if (this.executorName != null) {
            executor.scheduleWithRepetition(this.executorName, this::pushView, pushPeriodInSeconds, pushPeriodInSeconds, TimeUnit.SECONDS);
        } else {
            executor.scheduleWithRepetition(this::pushView, pushPeriodInSeconds, pushPeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    protected abstract void pushView();

    protected void sendToListeningEndpoints(ClientMessage clientMessage) {
        for (Map.Entry<ClientEndpoint, Long> entry : this.clientListeningEndpoints.entrySet()) {
            Long correlationId = entry.getValue();
            ClientMessage message = clientMessage.copyWithNewCorrelationId(correlationId);
            ClientEndpoint clientEndpoint = entry.getKey();
            ServerConnection connection = clientEndpoint.getConnection();
            this.write(message, connection);
        }
    }

    public void registerListener(ClientEndpoint clientEndpoint, long correlationId) {
        if (this.pushScheduled.compareAndSet(false, true)) {
            this.schedulePeriodicPush();
        }
        this.clientListeningEndpoints.put(clientEndpoint, correlationId);
        ServerConnection connection = clientEndpoint.getConnection();
        this.logger.finest("Registered listener with endpoint: %s", clientEndpoint);
        this.sendUpdate(clientEndpoint, connection, correlationId);
    }

    protected abstract void sendUpdate(ClientEndpoint var1, Connection var2, long var3);

    public void deregisterListener(ClientEndpoint clientEndpoint) {
        this.clientListeningEndpoints.remove(clientEndpoint);
        this.logger.finest("Deregistered listener with endpoint: %s", clientEndpoint);
    }

    public Map<ClientEndpoint, Long> getClusterListeningEndpoints() {
        return this.clientListeningEndpoints;
    }

    protected void write(ClientMessage message, Connection connection) {
        try {
            connection.write(message);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }
}

