/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class XmlNode {
    private final Node node;

    private XmlNode(Node node) {
        this.node = node;
    }

    static XmlNode create(String xmlString) {
        XmlNode xmlNode;
        ByteArrayInputStream stream = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
        try {
            DocumentBuilderFactory dbf = XmlUtil.getNsAwareDocumentBuilderFactory();
            Document doc = dbf.newDocumentBuilder().parse(stream);
            xmlNode = new XmlNode(doc.getDocumentElement());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)stream).close();
        return xmlNode;
    }

    Node getNode() {
        return this.node;
    }

    List<XmlNode> getSubNodes(String name) {
        return StreamSupport.stream(DomConfigHelper.childElements(this.node).spliterator(), false).filter(e -> name.equals(DomConfigHelper.cleanNodeName(e))).map(XmlNode::new).collect(Collectors.toList());
    }

    String getValue(String name) {
        return this.getSubNodes(name).stream().map(XmlNode::getNode).map(Node::getFirstChild).map(Node::getNodeValue).findFirst().orElse(null);
    }
}

