/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsConfig;
import com.hazelcast.spi.utils.RestClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

final class AwsRequestUtils {
    private AwsRequestUtils() {
    }

    static String currentTimestamp(Clock clock) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(Instant.now(clock).toEpochMilli());
    }

    static RestClient createRestClient(String url, AwsConfig awsConfig) {
        return RestClient.create(url, awsConfig.getConnectionTimeoutSeconds()).withRequestTimeoutSeconds(awsConfig.getReadTimeoutSeconds()).withRetries(awsConfig.getConnectionRetries());
    }

    static String canonicalQueryString(Map<String, String> attributes) {
        List<String> components = AwsRequestUtils.getListOfEntries(attributes);
        Collections.sort(components);
        return AwsRequestUtils.canonicalQueryString(components);
    }

    private static List<String> getListOfEntries(Map<String, String> entries) {
        ArrayList<String> components = new ArrayList<String>();
        for (String key : entries.keySet()) {
            AwsRequestUtils.addComponents(components, entries, key);
        }
        return components;
    }

    private static String canonicalQueryString(List<String> list) {
        return String.join((CharSequence)"&", list);
    }

    private static void addComponents(List<String> components, Map<String, String> attributes, String key) {
        components.add(AwsRequestUtils.urlEncode(key) + "=" + AwsRequestUtils.urlEncode(attributes.get(key)));
    }

    private static String urlEncode(String string) {
        String encoded = URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("*", "%2A");
        return encoded;
    }

    static String urlFor(String endpoint) {
        if (endpoint.startsWith("http")) {
            return endpoint;
        }
        return "https://" + endpoint;
    }
}

