/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsRequestSigner;
import com.hazelcast.aws.AwsRequestUtils;
import com.hazelcast.aws.Filter;
import com.hazelcast.aws.Tag;
import com.hazelcast.aws.XmlNode;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Node;

class AwsEc2Api {
    private static final ILogger LOGGER = Logger.getLogger(AwsEc2Api.class);
    private final String endpoint;
    private final AwsConfig awsConfig;
    private final AwsRequestSigner requestSigner;
    private final Clock clock;
    private boolean isNoPublicIpAlreadyLogged;

    AwsEc2Api(String endpoint, AwsConfig awsConfig, AwsRequestSigner requestSigner, Clock clock) {
        this.endpoint = endpoint;
        this.awsConfig = awsConfig;
        this.requestSigner = requestSigner;
        this.clock = clock;
    }

    Map<String, String> describeInstances(AwsCredentials credentials) {
        Map<String, String> attributes = this.createAttributesDescribeInstances();
        Map<String, String> headers = this.createHeaders(attributes, credentials);
        String response = this.callAwsService(attributes, headers);
        return AwsEc2Api.parseDescribeInstances(response);
    }

    private Map<String, String> createAttributesDescribeInstances() {
        Map<String, String> attributes = AwsEc2Api.createSharedAttributes();
        attributes.put("Action", "DescribeInstances");
        attributes.putAll(this.filterAttributesDescribeInstances());
        return attributes;
    }

    private Map<String, String> filterAttributesDescribeInstances() {
        Filter filter = new Filter();
        for (Tag tag : this.awsConfig.getTags()) {
            this.addTagFilter(filter, tag);
        }
        if (!StringUtil.isNullOrEmptyAfterTrim(this.awsConfig.getSecurityGroupName())) {
            filter.add("instance.group-name", this.awsConfig.getSecurityGroupName());
        }
        filter.add("instance-state-name", "running");
        return filter.getFilterAttributes();
    }

    private void addTagFilter(Filter filter, Tag tag) {
        if (!StringUtil.isNullOrEmptyAfterTrim(tag.getKey()) && !StringUtil.isNullOrEmptyAfterTrim(tag.getValue())) {
            filter.add("tag:" + tag.getKey(), tag.getValue());
        } else if (!StringUtil.isNullOrEmptyAfterTrim(tag.getKey())) {
            filter.add("tag-key", tag.getKey());
        } else if (!StringUtil.isNullOrEmptyAfterTrim(tag.getValue())) {
            filter.add("tag-value", tag.getValue());
        }
    }

    private static Map<String, String> parseDescribeInstances(String xmlResponse) {
        HashMap<String, String> result = new HashMap<String, String>();
        XmlNode.create(xmlResponse).getSubNodes("reservationset").stream().flatMap(e -> e.getSubNodes("item").stream()).flatMap(e -> e.getSubNodes("instancesset").stream()).flatMap(e -> e.getSubNodes("item").stream()).filter(e -> e.getValue("privateipaddress") != null).peek(AwsEc2Api::logInstanceName).forEach(e -> {
            result.put(e.getValue("privateipaddress"), e.getValue("ipaddress"));
            String ipv6address = e.getValue("ipv6address");
            if (ipv6address != null) {
                result.put(ipv6address, ipv6address);
            }
        });
        return result;
    }

    private static void logInstanceName(XmlNode item) {
        LOGGER.fine("Accepting EC2 instance [%s][%s]", AwsEc2Api.parseInstanceName(item).orElse("<unknown>"), item.getValue("privateipaddress"));
    }

    private static Optional<String> parseInstanceName(XmlNode nodeHolder) {
        return nodeHolder.getSubNodes("tagset").stream().flatMap(e -> e.getSubNodes("item").stream()).filter(AwsEc2Api::isNameField).flatMap(e -> e.getSubNodes("value").stream()).map(XmlNode::getNode).map(Node::getFirstChild).map(Node::getNodeValue).findFirst();
    }

    private static boolean isNameField(XmlNode item) {
        return item.getSubNodes("key").stream().map(XmlNode::getNode).map(Node::getFirstChild).map(Node::getNodeValue).map("Name"::equals).findFirst().orElse(false);
    }

    Map<String, String> describeNetworkInterfaces(List<String> privateAddresses, AwsCredentials credentials) {
        if (privateAddresses.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            Map<String, String> attributes = this.createAttributesDescribeNetworkInterfaces(privateAddresses);
            Map<String, String> headers = this.createHeaders(attributes, credentials);
            String response = this.callAwsService(attributes, headers);
            return AwsEc2Api.parseDescribeNetworkInterfaces(response);
        }
        catch (Exception e) {
            LOGGER.finest(e);
            if (!this.isNoPublicIpAlreadyLogged) {
                LOGGER.warning("Cannot fetch the public IPs of ECS Tasks. You won't be able to use Hazelcast Smart Client from outside of this VPC.");
                this.isNoPublicIpAlreadyLogged = true;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            privateAddresses.forEach(k -> map.put((String)k, (String)null));
            return map;
        }
    }

    private Map<String, String> createAttributesDescribeNetworkInterfaces(List<String> privateAddresses) {
        Map<String, String> attributes = AwsEc2Api.createSharedAttributes();
        attributes.put("Action", "DescribeNetworkInterfaces");
        attributes.putAll(this.filterAttributesDescribeNetworkInterfaces(privateAddresses));
        return attributes;
    }

    private Map<String, String> filterAttributesDescribeNetworkInterfaces(List<String> privateAddresses) {
        Filter filter = new Filter();
        filter.addMulti("addresses.private-ip-address", privateAddresses);
        return filter.getFilterAttributes();
    }

    private static Map<String, String> parseDescribeNetworkInterfaces(String xmlResponse) {
        HashMap<String, String> result = new HashMap<String, String>();
        XmlNode.create(xmlResponse).getSubNodes("networkinterfaceset").stream().flatMap(e -> e.getSubNodes("item").stream()).filter(e -> e.getValue("privateipaddress") != null).forEach(e -> {
            String privateIp = e.getValue("privateipaddress");
            String publicIp = e.getSubNodes("association").stream().map(a -> a.getValue("publicip")).findFirst().orElse(null);
            result.put(privateIp, publicIp);
            e.getSubNodes("ipv6addressesset").forEach(as -> as.getSubNodes("item").forEach(a -> {
                String ipv6address = a.getValue("ipv6address");
                if (ipv6address != null) {
                    result.put(ipv6address, ipv6address);
                }
            }));
        });
        return result;
    }

    private static Map<String, String> createSharedAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("Version", "2016-11-15");
        return attributes;
    }

    private Map<String, String> createHeaders(Map<String, String> attributes, AwsCredentials credentials) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!StringUtil.isNullOrEmptyAfterTrim(credentials.getToken())) {
            headers.put("X-Amz-Security-Token", credentials.getToken());
        }
        headers.put("Host", this.endpoint);
        String timestamp = AwsRequestUtils.currentTimestamp(this.clock);
        headers.put("X-Amz-Date", timestamp);
        headers.put("Authorization", this.requestSigner.authHeader(attributes, headers, "", credentials, timestamp, "GET"));
        return headers;
    }

    private String callAwsService(Map<String, String> attributes, Map<String, String> headers) {
        String query = AwsRequestUtils.canonicalQueryString(attributes);
        return AwsRequestUtils.createRestClient(AwsEc2Api.urlFor(this.endpoint, query), this.awsConfig).withHeaders(headers).get().getBody();
    }

    private static String urlFor(String endpoint, String query) {
        return AwsRequestUtils.urlFor(endpoint) + "/?" + query;
    }
}

