/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.spi.partitiongroup;

import com.hazelcast.cluster.Member;

import java.util.Collection;
import java.util.Iterator;

/**
 * A collection of members to which a single partition replica can be assigned.
 */
public interface MemberGroup {

    void addMember(Member member);

    void addMembers(Collection<Member> members);

    void removeMember(Member member);

    boolean hasMember(Member member);

    Iterator<Member> iterator();

    int size();
}
