/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * Allows iteration over ReplicatedMapEntryViewHolder objects. The changes happened during the iteration may not be included in the iterated EntryViews. This method
 * will throw an exception if there is no replicated record store with the given replicated map name and partition id. This method will consume some memory in the 
 * member with the default timeout of 300 seconds that is reset after each fetch. Sending endEntryViewIteration or timing out will release the resource.
 */
@SuppressWarnings("unused")
@Generated("ed312865d0067c8a7025baba1769635e")
public final class ReplicatedMapFetchEntryViewsCodec {
    //hex: 0x0D1400
    public static final int REQUEST_MESSAGE_TYPE = 857088;
    //hex: 0x0D1401
    public static final int RESPONSE_MESSAGE_TYPE = 857089;
    private static final int REQUEST_CURSOR_ID_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_NEW_ITERATION_FIELD_OFFSET = REQUEST_CURSOR_ID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int REQUEST_PARTITION_ID_FIELD_OFFSET = REQUEST_NEW_ITERATION_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int REQUEST_BATCH_SIZE_FIELD_OFFSET = REQUEST_PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_BATCH_SIZE_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_CURSOR_ID_FIELD_OFFSET = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_CURSOR_ID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;

    private ReplicatedMapFetchEntryViewsCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class RequestParameters {

        /**
         * Name of the ReplicatedMap
         */
        public java.lang.String name;

        /**
         * The identifier of the last fetched page. Send a random UUID while sending the first fetchEntryViews
         * request to start iteration. Also don't forget to set newIteration to true. Then, use the returned
         * UUIDs in response to feed this parameter and progress iteration.
         */
        public java.util.UUID cursorId;

        /**
         * Set this true if you are creating a new iteration via fetchEntryViews. fetchEntryViews can also be 
         * used to fetch new pages of an existing iteration. In that case, set this to false. 
         */
        public boolean newIteration;

        /**
         * The partition ID of the partition that the EntryViews belong to.
         */
        public int partitionId;

        /**
         * The maximum number of EntryViews to be returned.
         */
        public int batchSize;
    }

    public static ClientMessage encodeRequest(java.lang.String name, java.util.UUID cursorId, boolean newIteration, int partitionId, int batchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ReplicatedMap.FetchEntryViews");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeUUID(initialFrame.content, REQUEST_CURSOR_ID_FIELD_OFFSET, cursorId);
        encodeBoolean(initialFrame.content, REQUEST_NEW_ITERATION_FIELD_OFFSET, newIteration);
        encodeInt(initialFrame.content, REQUEST_PARTITION_ID_FIELD_OFFSET, partitionId);
        encodeInt(initialFrame.content, REQUEST_BATCH_SIZE_FIELD_OFFSET, batchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static ReplicatedMapFetchEntryViewsCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.cursorId = decodeUUID(initialFrame.content, REQUEST_CURSOR_ID_FIELD_OFFSET);
        request.newIteration = decodeBoolean(initialFrame.content, REQUEST_NEW_ITERATION_FIELD_OFFSET);
        request.partitionId = decodeInt(initialFrame.content, REQUEST_PARTITION_ID_FIELD_OFFSET);
        request.batchSize = decodeInt(initialFrame.content, REQUEST_BATCH_SIZE_FIELD_OFFSET);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class ResponseParameters {

        /**
         * A UUID which is used to fetch new pages.
         */
        public java.util.UUID cursorId;

        /**
         * A list of EntryViews. If the page includes less items than the batchSize, it means the iteration has ended.
         */
        public java.util.List<com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder> entryViews;
    }

    public static ClientMessage encodeResponse(java.util.UUID cursorId, java.util.Collection<com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder> entryViews) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        encodeUUID(initialFrame.content, RESPONSE_CURSOR_ID_FIELD_OFFSET, cursorId);
        clientMessage.add(initialFrame);

        ListMultiFrameCodec.encode(clientMessage, entryViews, ReplicatedMapEntryViewHolderCodec::encode);
        return clientMessage;
    }

    public static ReplicatedMapFetchEntryViewsCodec.ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.cursorId = decodeUUID(initialFrame.content, RESPONSE_CURSOR_ID_FIELD_OFFSET);
        response.entryViews = ListMultiFrameCodec.decode(iterator, ReplicatedMapEntryViewHolderCodec::decode);
        return response;
    }
}
