/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * The message is used to transfer the declarative pipeline definition and the related resource files from client to the server.
 */
@SuppressWarnings("unused")
@Generated("34e3628f150d272e665bcc971be9990e")
public final class ExperimentalPipelineSubmitCodec {
    //hex: 0xFD0100
    public static final int REQUEST_MESSAGE_TYPE = 16580864;
    //hex: 0xFD0101
    public static final int RESPONSE_MESSAGE_TYPE = 16580865;
    private static final int REQUEST_RESOURCE_BUNDLE_CHECKSUM_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_RESOURCE_BUNDLE_CHECKSUM_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_JOB_ID_FIELD_OFFSET = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_JOB_ID_FIELD_OFFSET + LONG_SIZE_IN_BYTES;

    private ExperimentalPipelineSubmitCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class RequestParameters {

        /**
         * The name of the submitted Job using this pipeline.
         */
        public @Nullable java.lang.String jobName;

        /**
         * The definition of the pipeline steps. It currently uses the YAML format.
         */
        public java.lang.String pipelineDefinition;

        /**
         * This is the zipped file which contains the user project folders and files. For Python project, it is the Python project files. It is optional in the sense that if the user likes to use a user docker image with all the resources and project files included, this parameter can be null.
         */
        public @Nullable byte[] resourceBundle;

        /**
         * This is the CRC32 checksum over the resource bundle bytes.
         */
        public int resourceBundleChecksum;
    }

    public static ClientMessage encodeRequest(@Nullable java.lang.String jobName, java.lang.String pipelineDefinition, @Nullable byte[] resourceBundle, int resourceBundleChecksum) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Experimental.PipelineSubmit");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeInt(initialFrame.content, REQUEST_RESOURCE_BUNDLE_CHECKSUM_FIELD_OFFSET, resourceBundleChecksum);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, jobName, StringCodec::encode);
        StringCodec.encode(clientMessage, pipelineDefinition);
        CodecUtil.encodeNullable(clientMessage, resourceBundle, ByteArrayCodec::encode);
        return clientMessage;
    }

    public static ExperimentalPipelineSubmitCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.resourceBundleChecksum = decodeInt(initialFrame.content, REQUEST_RESOURCE_BUNDLE_CHECKSUM_FIELD_OFFSET);
        request.jobName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.pipelineDefinition = StringCodec.decode(iterator);
        request.resourceBundle = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(long jobId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        encodeLong(initialFrame.content, RESPONSE_JOB_ID_FIELD_OFFSET, jobId);
        clientMessage.add(initialFrame);

        return clientMessage;
    }

    /**
     * This is the unique identifier for the job which is created for this pipeline
     */
    public static long decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return decodeLong(initialFrame.content, RESPONSE_JOB_ID_FIELD_OFFSET);
    }
}
