/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * Adds a data connection configuration.
 * If a data connection configuration with the given {@code name} already exists, then
 * the new configuration is ignored and the existing one is preserved.
 */
@SuppressWarnings("unused")
@Generated("a20539ebe1739c691a53b0fd1b7c4de8")
public final class DynamicConfigAddDataConnectionConfigCodec {
    //hex: 0x1B1100
    public static final int REQUEST_MESSAGE_TYPE = 1773824;
    //hex: 0x1B1101
    public static final int RESPONSE_MESSAGE_TYPE = 1773825;
    private static final int REQUEST_SHARED_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_SHARED_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;

    private DynamicConfigAddDataConnectionConfigCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class RequestParameters {

        /**
         * Name of this data connection, must be unique.
         */
        public java.lang.String name;

        /**
         * Type of the data connection as specified in the DataConnectionRegistration.
         */
        public java.lang.String type;

        /**
         * {@code true} if an instance of the data connection will be shared. 
         * Depending on the implementation of the data connection the shared instance may be 
         * single a thread-safe instance, or not thread-safe, but a pooled instance. 
         * {@code false} when on each usage a new instance of the underlying resource
         * should be created.
         * The default is {@code true}.
         */
        public boolean shared;

        /**
         * Properties of the data connection configuration.
         */
        public java.util.Map<java.lang.String, java.lang.String> properties;
    }

    public static ClientMessage encodeRequest(java.lang.String name, java.lang.String type, boolean shared, java.util.Map<java.lang.String, java.lang.String> properties) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddDataConnectionConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeBoolean(initialFrame.content, REQUEST_SHARED_FIELD_OFFSET, shared);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        StringCodec.encode(clientMessage, type);
        MapCodec.encode(clientMessage, properties, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static DynamicConfigAddDataConnectionConfigCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.shared = decodeBoolean(initialFrame.content, REQUEST_SHARED_FIELD_OFFSET);
        request.name = StringCodec.decode(iterator);
        request.type = StringCodec.decode(iterator);
        request.properties = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        clientMessage.add(initialFrame);

        return clientMessage;
    }
}
