/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * Makes an authentication request to the cluster using custom credentials.
 */
@SuppressWarnings("unused")
@Generated("33c4c6e8b6bb4910822ba0f139bfd38d")
public final class ClientAuthenticationCustomCodec {
    //hex: 0x000200
    public static final int REQUEST_MESSAGE_TYPE = 512;
    //hex: 0x000201
    public static final int RESPONSE_MESSAGE_TYPE = 513;
    private static final int REQUEST_UUID_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET = REQUEST_UUID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int REQUEST_ROUTING_MODE_FIELD_OFFSET = REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET = REQUEST_ROUTING_MODE_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_STATUS_FIELD_OFFSET = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_MEMBER_UUID_FIELD_OFFSET = RESPONSE_STATUS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET = RESPONSE_MEMBER_UUID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int RESPONSE_PARTITION_COUNT_FIELD_OFFSET = RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_CLUSTER_ID_FIELD_OFFSET = RESPONSE_PARTITION_COUNT_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET = RESPONSE_CLUSTER_ID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET = RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET = RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET + INT_SIZE_IN_BYTES;

    private ClientAuthenticationCustomCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class RequestParameters {

        /**
         * Cluster name that client will connect to.
         */
        public java.lang.String clusterName;

        /**
         * Secret byte array for authentication.
         */
        public byte[] credentials;

        /**
         * Unique string identifying the connected client uniquely.
         */
        public @Nullable java.util.UUID uuid;

        /**
         * The type of the client. E.g. JAVA, CPP, CSHARP, etc.
         */
        public java.lang.String clientType;

        /**
         * client side supported version to inform server side
         */
        public byte serializationVersion;

        /**
         * The Hazelcast version of the client. (e.g. 3.7.2)
         */
        public java.lang.String clientHazelcastVersion;

        /**
         * the name of the client instance
         */
        public java.lang.String clientName;

        /**
         * User defined labels of the client instance
         */
        public java.util.List<java.lang.String> labels;

        /**
         * Identifies the routing mode of the client. It can be UNISCOKET(0), SMART(1) or SUBSET(2).
         */
        public byte routingMode;

        /**
         * The client's CP direct-to-leader routing setting (enabled or disabled)
         */
        public boolean cpDirectToLeaderRouting;

        /**
         * True if the routingMode is received from the client, false otherwise.
         * If this is false, routingMode has the default value for its type.
         */
        public boolean isRoutingModeExists;

        /**
         * True if the cpDirectToLeaderRouting is received from the client, false otherwise.
         * If this is false, cpDirectToLeaderRouting has the default value for its type.
         */
        public boolean isCpDirectToLeaderRoutingExists;
    }

    public static ClientMessage encodeRequest(java.lang.String clusterName, byte[] credentials, @Nullable java.util.UUID uuid, java.lang.String clientType, byte serializationVersion, java.lang.String clientHazelcastVersion, java.lang.String clientName, java.util.Collection<java.lang.String> labels, byte routingMode, boolean cpDirectToLeaderRouting) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Client.AuthenticationCustom");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeUUID(initialFrame.content, REQUEST_UUID_FIELD_OFFSET, uuid);
        encodeByte(initialFrame.content, REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET, serializationVersion);
        encodeByte(initialFrame.content, REQUEST_ROUTING_MODE_FIELD_OFFSET, routingMode);
        encodeBoolean(initialFrame.content, REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET, cpDirectToLeaderRouting);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, clusterName);
        ByteArrayCodec.encode(clientMessage, credentials);
        StringCodec.encode(clientMessage, clientType);
        StringCodec.encode(clientMessage, clientHazelcastVersion);
        StringCodec.encode(clientMessage, clientName);
        ListMultiFrameCodec.encode(clientMessage, labels, StringCodec::encode);
        return clientMessage;
    }

    public static ClientAuthenticationCustomCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = decodeUUID(initialFrame.content, REQUEST_UUID_FIELD_OFFSET);
        request.serializationVersion = decodeByte(initialFrame.content, REQUEST_SERIALIZATION_VERSION_FIELD_OFFSET);
        if (initialFrame.content.length >= REQUEST_ROUTING_MODE_FIELD_OFFSET + BYTE_SIZE_IN_BYTES) {
            request.routingMode = decodeByte(initialFrame.content, REQUEST_ROUTING_MODE_FIELD_OFFSET);
            request.isRoutingModeExists = true;
        } else {
            request.isRoutingModeExists = false;
        }
        if (initialFrame.content.length >= REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES) {
            request.cpDirectToLeaderRouting = decodeBoolean(initialFrame.content, REQUEST_CP_DIRECT_TO_LEADER_ROUTING_FIELD_OFFSET);
            request.isCpDirectToLeaderRoutingExists = true;
        } else {
            request.isCpDirectToLeaderRoutingExists = false;
        }
        request.clusterName = StringCodec.decode(iterator);
        request.credentials = ByteArrayCodec.decode(iterator);
        request.clientType = StringCodec.decode(iterator);
        request.clientHazelcastVersion = StringCodec.decode(iterator);
        request.clientName = StringCodec.decode(iterator);
        request.labels = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class ResponseParameters {

        /**
         * A byte that represents the authentication status. It can be AUTHENTICATED(0), CREDENTIALS_FAILED(1),
         * SERIALIZATION_VERSION_MISMATCH(2) or NOT_ALLOWED_IN_CLUSTER(3).
         */
        public byte status;

        /**
         * Address of the Hazelcast member which sends the authentication response.
         */
        public @Nullable com.hazelcast.cluster.Address address;

        /**
         * UUID of the Hazelcast member which sends the authentication response.
         */
        public @Nullable java.util.UUID memberUuid;

        /**
         * client side supported version to inform server side
         */
        public byte serializationVersion;

        /**
         * Version of the Hazelcast member which sends the authentication response.
         */
        public java.lang.String serverHazelcastVersion;

        /**
         * Partition count of the cluster.
         */
        public int partitionCount;

        /**
         * The cluster id of the cluster.
         */
        public java.util.UUID clusterId;

        /**
         * Returns true if server supports clients with failover feature.
         */
        public boolean failoverSupported;

        /**
         * Returns the list of TPC ports or null if TPC is disabled.
         */
        public @Nullable java.util.List<java.lang.Integer> tpcPorts;

        /**
         * Returns the token to use while authenticating TPC channels 
         * or null if TPC is disabled.
         */
        public @Nullable byte[] tpcToken;

        /**
         * Incremental member list version
         */
        public int memberListVersion;

        /**
         * List of member infos  at the cluster associated with the given version
         */
        public @Nullable java.util.List<com.hazelcast.internal.cluster.MemberInfo> memberInfos;

        /**
         * Incremental state version of the partition table
         */
        public int partitionListVersion;

        /**
         * The partition table. In each entry, it has uuid of the member and list of partitions belonging to that member
         */
        public @Nullable java.util.List<java.util.Map.Entry<java.util.UUID, java.util.List<java.lang.Integer>>> partitions;

        /**
         * Server/Member metadata represented as in key value pairs
         */
        public java.util.Map<java.lang.String, java.lang.String> keyValuePairs;

        /**
         * True if the tpcPorts is received from the member, false otherwise.
         * If this is false, tpcPorts has the default value for its type.
         */
        public boolean isTpcPortsExists;

        /**
         * True if the tpcToken is received from the member, false otherwise.
         * If this is false, tpcToken has the default value for its type.
         */
        public boolean isTpcTokenExists;

        /**
         * True if the memberListVersion is received from the member, false otherwise.
         * If this is false, memberListVersion has the default value for its type.
         */
        public boolean isMemberListVersionExists;

        /**
         * True if the memberInfos is received from the member, false otherwise.
         * If this is false, memberInfos has the default value for its type.
         */
        public boolean isMemberInfosExists;

        /**
         * True if the partitionListVersion is received from the member, false otherwise.
         * If this is false, partitionListVersion has the default value for its type.
         */
        public boolean isPartitionListVersionExists;

        /**
         * True if the partitions is received from the member, false otherwise.
         * If this is false, partitions has the default value for its type.
         */
        public boolean isPartitionsExists;

        /**
         * True if the keyValuePairs is received from the member, false otherwise.
         * If this is false, keyValuePairs has the default value for its type.
         */
        public boolean isKeyValuePairsExists;
    }

    public static ClientMessage encodeResponse(byte status, @Nullable com.hazelcast.cluster.Address address, @Nullable java.util.UUID memberUuid, byte serializationVersion, java.lang.String serverHazelcastVersion, int partitionCount, java.util.UUID clusterId, boolean failoverSupported, @Nullable java.util.Collection<java.lang.Integer> tpcPorts, @Nullable byte[] tpcToken, int memberListVersion, @Nullable java.util.Collection<com.hazelcast.internal.cluster.MemberInfo> memberInfos, int partitionListVersion, @Nullable java.util.Collection<java.util.Map.Entry<java.util.UUID, java.util.List<java.lang.Integer>>> partitions, java.util.Map<java.lang.String, java.lang.String> keyValuePairs) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        encodeByte(initialFrame.content, RESPONSE_STATUS_FIELD_OFFSET, status);
        encodeUUID(initialFrame.content, RESPONSE_MEMBER_UUID_FIELD_OFFSET, memberUuid);
        encodeByte(initialFrame.content, RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET, serializationVersion);
        encodeInt(initialFrame.content, RESPONSE_PARTITION_COUNT_FIELD_OFFSET, partitionCount);
        encodeUUID(initialFrame.content, RESPONSE_CLUSTER_ID_FIELD_OFFSET, clusterId);
        encodeBoolean(initialFrame.content, RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET, failoverSupported);
        encodeInt(initialFrame.content, RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET, memberListVersion);
        encodeInt(initialFrame.content, RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET, partitionListVersion);
        clientMessage.add(initialFrame);

        CodecUtil.encodeNullable(clientMessage, address, AddressCodec::encode);
        StringCodec.encode(clientMessage, serverHazelcastVersion);
        CodecUtil.encodeNullable(clientMessage, tpcPorts, ListIntegerCodec::encode);
        CodecUtil.encodeNullable(clientMessage, tpcToken, ByteArrayCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, memberInfos, MemberInfoCodec::encode);
        CodecUtil.encodeNullable(clientMessage, partitions, EntryListUUIDListIntegerCodec::encode);
        MapCodec.encode(clientMessage, keyValuePairs, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static ClientAuthenticationCustomCodec.ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.status = decodeByte(initialFrame.content, RESPONSE_STATUS_FIELD_OFFSET);
        response.memberUuid = decodeUUID(initialFrame.content, RESPONSE_MEMBER_UUID_FIELD_OFFSET);
        response.serializationVersion = decodeByte(initialFrame.content, RESPONSE_SERIALIZATION_VERSION_FIELD_OFFSET);
        response.partitionCount = decodeInt(initialFrame.content, RESPONSE_PARTITION_COUNT_FIELD_OFFSET);
        response.clusterId = decodeUUID(initialFrame.content, RESPONSE_CLUSTER_ID_FIELD_OFFSET);
        response.failoverSupported = decodeBoolean(initialFrame.content, RESPONSE_FAILOVER_SUPPORTED_FIELD_OFFSET);
        if (initialFrame.content.length >= RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET + INT_SIZE_IN_BYTES) {
            response.memberListVersion = decodeInt(initialFrame.content, RESPONSE_MEMBER_LIST_VERSION_FIELD_OFFSET);
            response.isMemberListVersionExists = true;
        } else {
            response.isMemberListVersionExists = false;
        }
        if (initialFrame.content.length >= RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET + INT_SIZE_IN_BYTES) {
            response.partitionListVersion = decodeInt(initialFrame.content, RESPONSE_PARTITION_LIST_VERSION_FIELD_OFFSET);
            response.isPartitionListVersionExists = true;
        } else {
            response.isPartitionListVersionExists = false;
        }
        response.address = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
        response.serverHazelcastVersion = StringCodec.decode(iterator);
        if (iterator.hasNext()) {
            response.tpcPorts = CodecUtil.decodeNullable(iterator, ListIntegerCodec::decode);
            response.isTpcPortsExists = true;
        } else {
            response.isTpcPortsExists = false;
        }
        if (iterator.hasNext()) {
            response.tpcToken = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
            response.isTpcTokenExists = true;
        } else {
            response.isTpcTokenExists = false;
        }
        if (iterator.hasNext()) {
            response.memberInfos = ListMultiFrameCodec.decodeNullable(iterator, MemberInfoCodec::decode);
            response.isMemberInfosExists = true;
        } else {
            response.isMemberInfosExists = false;
        }
        if (iterator.hasNext()) {
            response.partitions = CodecUtil.decodeNullable(iterator, EntryListUUIDListIntegerCodec::decode);
            response.isPartitionsExists = true;
        } else {
            response.isPartitionsExists = false;
        }
        if (iterator.hasNext()) {
            response.keyValuePairs = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
            response.isKeyValuePairsExists = true;
        } else {
            response.isKeyValuePairsExists = false;
        }
        return response;
    }
}
