/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.internal.serialization.BinaryInterface;

final class ComparatorsEx {
    static final ComparatorEx<Comparable<Object>> NATURAL_ORDER = new NaturalOrderComparator();
    static final ComparatorEx<Comparable<Object>> REVERSE_ORDER = new ReverseOrderComparator();

    private ComparatorsEx() {
    }

    @BinaryInterface
    private static final class NaturalOrderComparator
    implements ComparatorEx<Comparable<Object>> {
        private static final long serialVersionUID = 1L;

        private NaturalOrderComparator() {
        }

        @Override
        public int compareEx(Comparable<Object> left, Comparable<Object> right) {
            return left.compareTo(right);
        }

        @Override
        public ComparatorEx<Comparable<Object>> reversed() {
            return REVERSE_ORDER;
        }

        private Object readResolve() {
            return NATURAL_ORDER;
        }
    }

    @BinaryInterface
    private static final class ReverseOrderComparator
    implements ComparatorEx<Comparable<Object>> {
        private static final long serialVersionUID = 1L;

        private ReverseOrderComparator() {
        }

        @Override
        public int compareEx(Comparable<Object> left, Comparable<Object> right) {
            return right.compareTo(left);
        }

        @Override
        public ComparatorEx<Comparable<Object>> reversed() {
            return NATURAL_ORDER;
        }

        private Object readResolve() {
            return REVERSE_ORDER;
        }
    }

    @BinaryInterface
    public static final class NullComparator<T>
    implements ComparatorEx<T> {
        private static final long serialVersionUID = 1L;
        private final boolean isNullFirst;

        NullComparator(boolean isNullFirst) {
            this.isNullFirst = isNullFirst;
        }

        @Override
        public int compareEx(T left, T right) {
            if (left == null) {
                return right == null ? 0 : (this.isNullFirst ? -1 : 1);
            }
            if (right == null) {
                return this.isNullFirst ? 1 : -1;
            }
            return 0;
        }
    }
}

