/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.impl.merge.entry.DefaultCacheEntryView;
import com.hazelcast.cache.impl.merge.entry.LazyCacheEntryView;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;

public final class CacheEntryViews {
    private CacheEntryViews() {
    }

    public static CacheEntryView<Data, Data> createDefaultEntryView(Data key, Data value, Data expiryPolicy, CacheRecord<Object, Data> record) {
        return new DefaultCacheEntryView(key, value, record.getCreationTime(), record.getExpirationTime(), record.getLastAccessTime(), record.getHits(), expiryPolicy);
    }

    public static CacheEntryView<Data, Data> createEntryView(Data key, Data expiryPolicy, CacheRecord<Object, Data> record) {
        if (record == null) {
            throw new IllegalArgumentException("Empty record");
        }
        return CacheEntryViews.createDefaultEntryView(key, (Data)record.getValue(), expiryPolicy, record);
    }

    public static CacheEntryView<Data, Data> toLazyCacheEntryView(Data key, Data value, Data expiryPolicy, CacheRecord record) {
        return new LazyCacheEntryView<Data, Data>(key, value, record.getCreationTime(), record.getExpirationTime(), record.getLastAccessTime(), record.getHits(), expiryPolicy);
    }

    public static <K, V> CacheEntryView<K, V> toLazyCacheEntryView(CacheEntryView<K, V> entryView, SerializationService serializationService) {
        return new LazyCacheEntryView(entryView.getKey(), entryView.getValue(), entryView.getCreationTime(), entryView.getExpirationTime(), entryView.getLastAccessTime(), entryView.getHits(), entryView.getExpiryPolicy(), serializationService);
    }

    public static CacheEntryView<Data, Data> createEntryView(Data key, Data value, Data expiryPolicy, CacheRecord record, CacheEntryViewType cacheEntryViewType) {
        if (cacheEntryViewType == null) {
            throw new IllegalArgumentException("Empty cache entry view type");
        }
        switch (cacheEntryViewType) {
            case DEFAULT: {
                return CacheEntryViews.createDefaultEntryView(key, value, expiryPolicy, record);
            }
            case LAZY: {
                return CacheEntryViews.toLazyCacheEntryView(key, value, expiryPolicy, record);
            }
        }
        throw new IllegalArgumentException("Invalid cache entry view type: " + cacheEntryViewType);
    }

    public static enum CacheEntryViewType {
        DEFAULT,
        LAZY;

    }
}

