/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareFactoryAccessor;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;

final class InvokeOnPartitions {
    private static final int TRY_COUNT = 10;
    private static final int TRY_PAUSE_MILLIS = 300;
    private static final Object NULL_RESULT = new Object(){

        public String toString() {
            return "NULL_RESULT";
        }
    };
    private final OperationServiceImpl operationService;
    private final String serviceName;
    private final OperationFactory operationFactory;
    private final Map<Address, List<Integer>> memberPartitions;
    private final ILogger logger;
    private final AtomicReferenceArray<Object> partitionResults;
    private final AtomicInteger latch;
    private final CompletableFuture future;
    private final Executor internalAsyncExecutor;
    private boolean invoked;

    InvokeOnPartitions(OperationServiceImpl operationService, String serviceName, OperationFactory operationFactory, Map<Address, List<Integer>> memberPartitions) {
        this.operationService = operationService;
        this.serviceName = serviceName;
        this.operationFactory = operationFactory;
        this.memberPartitions = memberPartitions;
        this.logger = operationService.node.loggingService.getLogger(this.getClass());
        int partitionCount = operationService.nodeEngine.getPartitionService().getPartitionCount();
        int actualPartitionCount = 0;
        for (List<Integer> mp : memberPartitions.values()) {
            actualPartitionCount += mp.size();
        }
        this.partitionResults = new AtomicReferenceArray(partitionCount);
        this.latch = new AtomicInteger(actualPartitionCount);
        this.future = new CompletableFuture();
        this.internalAsyncExecutor = operationService.nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    <T> Map<Integer, T> invoke() throws Exception {
        return this.invokeAsync().get();
    }

    <T> CompletableFuture<Map<Integer, T>> invokeAsync() {
        assert (!this.invoked) : "already invoked";
        this.invoked = true;
        this.ensureNotCallingFromPartitionOperationThread();
        this.invokeOnAllPartitions();
        return this.future;
    }

    private void ensureNotCallingFromPartitionOperationThread() {
        if (Thread.currentThread() instanceof PartitionOperationThread) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot make invocation on multiple partitions!");
        }
    }

    private void invokeOnAllPartitions() {
        if (this.memberPartitions.isEmpty()) {
            this.future.complete(Collections.EMPTY_MAP);
            return;
        }
        for (Map.Entry<Address, List<Integer>> mp : this.memberPartitions.entrySet()) {
            Address address = mp.getKey();
            List<Integer> partitions = mp.getValue();
            PartitionIteratingOperation op = new PartitionIteratingOperation(this.operationFactory, CollectionUtil.toIntArray(partitions));
            this.operationService.createInvocationBuilder(this.serviceName, (Operation)op, address).setTryCount(10).setTryPauseMillis(300L).invoke().whenCompleteAsync((BiConsumer)new FirstAttemptExecutionCallback(partitions), this.internalAsyncExecutor);
        }
    }

    private void retryPartition(int partitionId) {
        PartitionAwareOperationFactory partitionAwareFactory = PartitionAwareFactoryAccessor.extractPartitionAware(this.operationFactory);
        Operation operation = partitionAwareFactory != null ? partitionAwareFactory.createPartitionOperation(partitionId) : this.operationFactory.createOperation();
        this.operationService.createInvocationBuilder(this.serviceName, operation, partitionId).invoke().whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                this.setPartitionResult(partitionId, response);
                this.decrementLatchAndHandle(1);
            } else {
                this.setPartitionResult(partitionId, throwable);
                this.decrementLatchAndHandle(1);
            }
        }, this.internalAsyncExecutor);
    }

    private void decrementLatchAndHandle(int count) {
        if (this.latch.addAndGet(-count) > 0) {
            return;
        }
        Map<Integer, Object> result = MapUtil.createHashMap(this.partitionResults.length());
        for (int partitionId = 0; partitionId < this.partitionResults.length(); ++partitionId) {
            Object partitionResult = this.partitionResults.get(partitionId);
            if (partitionResult instanceof Throwable) {
                this.future.completeExceptionally((Throwable)partitionResult);
                return;
            }
            if (partitionResult == null) continue;
            result.put(partitionId, partitionResult == NULL_RESULT ? null : partitionResult);
        }
        this.future.complete(result);
    }

    private void setPartitionResult(int partition, Object result) {
        if (result == null) {
            result = NULL_RESULT;
        }
        boolean success = this.partitionResults.compareAndSet(partition, null, result);
        assert (success) : "two results for same partition: old=" + this.partitionResults.get(partition) + ", new=" + result;
    }

    private class FirstAttemptExecutionCallback
    implements BiConsumer<Object, Throwable> {
        private final List<Integer> requestedPartitions;

        FirstAttemptExecutionCallback(List<Integer> partitions) {
            this.requestedPartitions = partitions;
        }

        @Override
        public void accept(Object response, Throwable throwable) {
            if (throwable == null) {
                PartitionIteratingOperation.PartitionResponse result = (PartitionIteratingOperation.PartitionResponse)InvokeOnPartitions.this.operationService.nodeEngine.toObject(response);
                Object[] results = result.getResults();
                int[] responsePartitions = result.getPartitions();
                assert (results.length == responsePartitions.length) : "results.length=" + results.length + ", responsePartitions.length=" + responsePartitions.length;
                assert (results.length <= this.requestedPartitions.size()) : "results.length=" + results.length + ", but was sent to just " + this.requestedPartitions.size() + " partitions";
                if (results.length != this.requestedPartitions.size()) {
                    InvokeOnPartitions.this.logger.fine("Responses received for " + responsePartitions.length + " partitions, but " + this.requestedPartitions.size() + " partitions were requested");
                }
                int failedPartitionsCnt = 0;
                for (int i = 0; i < responsePartitions.length; ++i) {
                    assert (this.requestedPartitions.contains(responsePartitions[i])) : "Response received for partition " + responsePartitions[i] + ", but that partition wasn't requested";
                    if (results[i] instanceof Throwable) {
                        InvokeOnPartitions.this.retryPartition(responsePartitions[i]);
                        ++failedPartitionsCnt;
                        continue;
                    }
                    InvokeOnPartitions.this.setPartitionResult(responsePartitions[i], results[i]);
                }
                InvokeOnPartitions.this.decrementLatchAndHandle(this.requestedPartitions.size() - failedPartitionsCnt);
            } else {
                if (InvokeOnPartitions.this.operationService.logger.isFinestEnabled()) {
                    InvokeOnPartitions.this.operationService.logger.finest(throwable);
                } else {
                    InvokeOnPartitions.this.operationService.logger.warning(throwable.getMessage());
                }
                for (Integer partition : this.requestedPartitions) {
                    InvokeOnPartitions.this.retryPartition(partition);
                }
            }
        }
    }
}

